


#ifndef BYTE_ARRAY_WRITER_H
#define BYTE_ARRAY_WRITER_H

#define OSAL_S_IMPORT_INTERFACE_TYPES
#include "osal_if.h"

class ByteArrayWriter
{
   private:
      unsigned char *m_pucByteArray;
      tU32  m_u32ArraySize;

      /** 
       *  aktuelle Schreibposition relativ zum Anfang des Arrays 
       *  Wertebereich: 0...u32ArraySize
       */
      tU32 m_u32Pos;
   public:
      ByteArrayWriter (unsigned char *pucByteArray, tU32 u32ArraySize);
      tU32 u32GetActualDataSize();

      bool bWriteU32 (tU32 u32Value);
      bool bWriteS32 (int s32Value);
      
      /** Writes NULL-Terminated String */
      bool bWriteString (const char *pcString);

      bool bWriteRaw (unsigned char *data, tU32 size);

};



#endif      // BYTE_ARRAY_WRITER_H
