


#ifndef BYTE_ARRAY_READER_H
#define BYTE_ARRAY_READER_H

#define OSAL_S_IMPORT_INTERFACE_TYPES
#include "osal_if.h"

class ByteArrayReader
{
   private:
      tU8 *m_pucByteArray;
      tU32  m_u32ArraySize;

      /** 
       *  aktuelle Schreibposition relativ zum Anfang des Arrays 
       *  Wertebereich: 0...u32ArraySize
       */
      tU32 m_u32Pos;
   public:
      ByteArrayReader (tU8 *pucByteArray, tU32 u32ArraySize);
      tU32 u32GetBytesLeft();

      bool bReadU32 (tU32 *u32Value);
      bool bReadS32 (tS32 *s32Value);
      
      /** 
       *  Angenommen, jetzt kommt ein NULL-Terminierter String
       *  im Datenstrom - mit dieser Funktion kann man
       *  seinen Laenge bestimmen!
       *
       *  @return Laenge des Strings incl. Null-Byte am Ende
       *          oder '0', falls kein NULL-terminierter
       *          String gefunden wurde!
       */
      tU32 bPeekUpcomingStringLength ();

      /** 
       *  liest einen String ein. Die Laenge sollte vorher mit
       *  der Funktion bPeekUpcomingStringLength() abgefragt werden,
       *  damit in "data" genuegend Platz zur Verfuegung steht!
       */
      bool bReadString (char *data);

      bool bReadRaw (tU8 *data, tU32 size);
};



#endif      // BYTE_ARRAY_READER_H
