/*****************************************************************************
| FILE:         MstRecv.cpp
| PROJECT:      platform
| SW-COMPONENT: OSAL CORE
|-----------------------------------------------------------------------------
| DESCRIPTION:  This is the implementation file for the OSAL 
|               MST test main function of the receiver process.
|                
|-----------------------------------------------------------------------------
| COPYRIGHT:    (c) 2005 Blaupunkt GmbH
| HISTORY:      
| Date      | Modification               | Author
| 09.02.18  | Initial revision           | MRK2HI
| --.--.--  | ----------------           | -------, -----
|
|*****************************************************************************/

/************************************************************************ 
| includes of component-internal interfaces
| (scope: component-local)
|-----------------------------------------------------------------------*/

#include "OsalConf.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "Linux_osal.h"
#include "ostrace.h"

/************************************************************************ 
|defines and macros (scope: module-local) 
|-----------------------------------------------------------------------*/
#define MSG_LEN   64

/************************************************************************ 
|typedefs (scope: module-local) 
|-----------------------------------------------------------------------*/

/************************************************************************
| variable definition (scope: module-local)
|-----------------------------------------------------------------------*/

/************************************************************************ 
| variable definition (scope: global)
|-----------------------------------------------------------------------*/

/************************************************************************
|function prototype (scope: module-local)
|-----------------------------------------------------------------------*/

/************************************************************************
|function prototype (scope: global)
|-----------------------------------------------------------------------*/


#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************
 *
 * FUNCTION:    vReadRegistryConf
 *
 * DESCRIPTION: This function reads runtime configuration from registry
 *
 * PARAMETER:    char*  TCP/IP address
 *               int*    Port number 
 *               char* Reception Queue name
 *
 * RETURNVALUE: none
 *
 * HISTORY:
 * Date      |   Modification                         | Authors
 * 09.02.18  | Initial revision                       | MRK2HI
 * --.--.--  | ----------------                       | -----
 *
 *****************************************************************************/
void vReadRegistryConf(char* pAddress, int* Port, char* RecMqName)
{
   OSAL_tIODescriptor s32DevDesc = 0;
   OSAL_trIOCtrlRegistry hReg;

   if((s32DevDesc = OSAL_IOOpen(OSAL_C_STRING_DEVICE_REGISTRY"/"REGISTRY_BASE_PATH"/VERSIONS/OSAL",OSAL_EN_READWRITE)) != OSAL_ERROR )
   {
	  if(*pAddress == 0)
	  {
         hReg.pcos8Name =  (tPCS8)"SOCKET";
         hReg.s32Type   =  OSAL_C_S32_VALUE_STRING;
         hReg.ps8Value  =  (tPU8)pAddress;
         hReg.u32Size   =  32;
         if(OSAL_s32IOControl(s32DevDesc,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&hReg) == OSAL_OK)
         {
           TraceString("MST REC Take TCP/IP adress %s from registry ",pAddress);
         }
	  }
	  if(*Port == -1)
	  {
         hReg.pcos8Name =  (tPCS8)"PORT";
         hReg.s32Type   =  OSAL_C_S32_VALUE_S32;
         hReg.ps8Value  =  (tPU8)Port;
         hReg.u32Size   =  sizeof(tU32);
         if(OSAL_s32IOControl(s32DevDesc,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&hReg) == OSAL_OK)
         {
           TraceString("MST REC Take Port number %d from registry ",*Port);
         }
	  }
	  if(*RecMqName == 0)
	  {
         hReg.pcos8Name =  (tPCS8)"MST_REC_MQ";
         hReg.s32Type   =  OSAL_C_S32_VALUE_STRING;
         hReg.ps8Value  =  (tPU8)RecMqName;
         hReg.u32Size   =  32;
         if(OSAL_s32IOControl(s32DevDesc,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&hReg) == OSAL_OK)
         {
           TraceString("MST REC Take MQ name from registry Socket %s ",RecMqName);
         }
	  }
      OSAL_s32IOClose(s32DevDesc);
   }
}


void TestPingPong(char* pRecMqName, int msecs)
{
   OSAL_tMQueueHandle  hMq1 = OSAL_C_INVALID_HANDLE;
   OSAL_tMQueueHandle  hMq2 = OSAL_C_INVALID_HANDLE;
   char  szRecBuffer[MSG_LEN];
   memset(szRecBuffer,0,MSG_LEN);
   if(OSAL_s32MessageQueueCreate(pRecMqName,10, MSG_LEN, OSAL_EN_READWRITE, &hMq1) == OSAL_ERROR)
   {
 /*     if(OSAL_u32ErrorCode() == OSAL_E_ALREADYEXISTS)
      {
        if(OSAL_s32MessageQueueOpen(pRecMqName,OSAL_EN_READWRITE,&hMq1) == OSAL_ERROR)	
        {						  
          TraceString("MST REC Cannot open MQ %s",pRecMqName);
        }
      }
      else*/
      {
         NORMAL_M_ASSERT_ALWAYS();
      }
   }
   else
   {
      TraceString("Process will stay alive for %d msec if no message received",msecs);
      if(OSAL_s32MessageQueueWait(hMq1,(tPU8)szRecBuffer, MSG_LEN, 0, msecs ) > 0)
      {
	     char Buffer[64];
         if(OSAL_s32MessageQueueOpen(szRecBuffer,OSAL_EN_READWRITE,&hMq2) == OSAL_ERROR)	
         {						  
            TraceString("MST REC Cannot open MQ %s",Buffer);
         }
         snprintf(Buffer,64,"This_is_the_answer");
  	     OSAL_s32MessageQueuePost(hMq2,(tPCU8)&Buffer,(tU32)strlen(Buffer),0);
	     OSAL_s32MessageQueueClose(hMq1);
	     OSAL_s32MessageQueueClose(hMq2);
         OSAL_s32MessageQueueDelete(pRecMqName);	  
	  }
   }
}

/*****************************************************************************
 *
 * FUNCTION:    main
 *
 * DESCRIPTION: This function implements the process
 *
 * PARAMETER:    int argc
 *               char** argv
 *
 * RETURNVALUE: none
 *
 * HISTORY:
 * Date      |   Modification                         | Authors
 * 09.02.18  | Initial revision                       | MRK2HI
 * --.--.--  | ----------------                       | -----
 *
 *****************************************************************************/
int main(int argc,char** argv)
{
   int opt,msecs = OSAL_C_TIMEOUT_FOREVER;
   char  szIpAddress[32] = {0};
   char  szRecMqName[32] = {0};
   tS32  s32Port = -1;

   vReadRegistryConf(szIpAddress,&s32Port,szRecMqName);

   /* check for timeout option ./osalprc.out -t 1000 */
   while ((opt = getopt (argc, argv, "t:p:a:h")) != -1)
   {
      switch (opt)
      {
         case 't':// check timeout for process living
              msecs = atoi(optarg);
            break;
         case 'p':
              s32Port = atoi(optarg);
            break;
         case 'a':
              if(strlen(optarg) < 32)strncpy(szIpAddress,(char*)optarg,strlen(optarg));
            break;
         case 'q':
		      if(strlen(optarg) < 32)strncpy(szRecMqName,(char*)optarg,strlen(optarg));
            break;
         case 'h':// print help output
              TraceString("Usage: %s [-t msecs] [-a 127.0.0.1] [-p 123000] [-q MST_TEST_QUEUE] ",argv[0]);
              TraceString("       [-t msecs] lifetime of the process in msec default is 0");
              TraceString("       [-a] tcp/ip adress like 127.0.0.1");
              TraceString("       [-p] prot number to be used");
              TraceString("       [-q] Message queue name used by in receiver application");
             break;
         default:
              TraceString("Check command option with %s -h ",argv[0]);
             break;
      }
   }
   
   TestPingPong(&szRecMqName[0],msecs);
   
   OSAL_vProcessExit();
}


#ifdef __cplusplus
}
#endif

/************************************************************************
|end of fileMAin.cpp
|-----------------------------------------------------------------------*/
