#include "OsalConf.h"
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "osal_public.h"
#include "osalio_public.h"

#include "errorlogger.h"
#include "errorlog_if.h"
#include "osalrpc_if.h"
#include "socketconnection.h"
#include "socketgroup.h"

#define DYN_MEM_ALLOC_SIZE 255

tS32 WOS_s32IOEngineeringFct   ( const char *device, tS32 fun, tS32 arg )
{ 
   ((void)device);
   ((void)fun);
   ((void)arg);
   return OSAL_ERROR; 
}

#ifdef __cplusplus
extern "C" {
#endif


// Dummy Function for OSAL_PURE Compatibility
void  vTerminateCcaApplications(void){};

void tclSocketThread::ThreadEntry( void* pvArg )
{
   tclSocketThread *ptr = (tclSocketThread*) pvArg;
  (ptr->m_pThreadEntry)(ptr->m_pvArg);
}

bool tclSocketThread::bStartThread(fpThreadEntry ThreadFunction,void* ThreadArg)
{
   static tU16 u16ctSocketThreads = 0;
   char Name[32];
   m_pThreadEntry = ThreadFunction;
   m_pvArg = ThreadArg;
   OSAL_trThreadAttribute  attr;
   u16ctSocketThreads++; //avoid same names if created at same time
   snprintf(Name,32,"Test_%u_%d", u16ctSocketThreads, (int)OSAL_ClockGetElapsedTime());
   attr.szName = (tString)Name;/*lint !e1773 */  /*otherwise linker warning */
   attr.u32Priority = OSAL_C_U32_THREAD_PRIORITY_NORMAL;
   attr.s32StackSize = 4096;
   attr.pfEntry = (OSAL_tpfThreadEntry)ThreadFunction;
   attr.pvArg = ThreadArg;
   if(OSAL_ThreadSpawn(&attr) != OSAL_ERROR)return TRUE;
   else return FALSE;
}


OSAL_tclErrorLogger *pel;
tclSocketGroup *g_poSocketGroup;
char  szIpAddress[32] = {0};

void vReadRegistryConf(char* pAddress,int* Port)
{
   OSAL_tIODescriptor s32DevDesc = 0;
   OSAL_trIOCtrlRegistry hReg;

   if((s32DevDesc = OSAL_IOOpen(OSAL_C_STRING_DEVICE_REGISTRY"/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/VERSIONS/OSAL",OSAL_EN_READWRITE)) != OSAL_ERROR )
   {
	  if(*pAddress == 0)
	  {
         hReg.pcos8Name =  (tPCS8)"SOCKET";
         hReg.s32Type   =  OSAL_C_S32_VALUE_STRING;
         hReg.ps8Value  =  (tPU8)pAddress;
         hReg.u32Size   =  32;
         if(OSAL_s32IOControl(s32DevDesc,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&hReg) == OSAL_OK)
         {
           TraceString("MST REC Take TCP/IP adress %s from registry ",pAddress);
         }
	  }
	  if(*Port == -1)
	  {
         hReg.pcos8Name =  (tPCS8)"PORT";
         hReg.s32Type   =  OSAL_C_S32_VALUE_S32;
         hReg.ps8Value  =  (tPU8)Port;
         hReg.u32Size   =  sizeof(tU32);
         if(OSAL_s32IOControl(s32DevDesc,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&hReg) == OSAL_OK)
         {
           TraceString("MST REC Take Port number %d from registry ",*Port);
         }
	  }
      OSAL_s32IOClose(s32DevDesc);
   }
}



int main(int argc,char** argv)
{
   OSAL_tIODescriptor s32DevDesc = 0;
   tS32 s32Port = -1;
   OSAL_trIOCtrlRegistry hReg;
   int opt,msecs = OSAL_C_TIMEOUT_FOREVER;

     /* check for timeout option ./osalprc.out -t 1000 */
   while ((opt = getopt (argc, argv, "t:p:a:h")) != -1)
   {
      switch (opt)
      {
         case 't':// check timeout for process living
              msecs = atoi(optarg);
            break;
         case 'p':
              s32Port = atoi(optarg);
            break;
         case 'a':
              if(strlen(optarg) < 32)strncpy(szIpAddress,(char*)optarg,strlen(optarg));
            break;
         case 'h':// print help output
              TraceString("Usage: %s [-t msecs] [-a 127.0.0.1] [-p 123000] ",argv[0]);
              TraceString("       [-t msecs] lifetime of the process in msec");
              TraceString("       [-a] tcp/ip adress like 127.0.0.1");
              TraceString("       [-p] prot number to be used");
             break;
          default:
              TraceString("Usage: %s [-t msecs]",argv[0]);
            break;
      }
   }

    
   TraceString("Process will stay alive for %d msec",msecs);
 
   if((s32Port != -1)&&(szIpAddress[0] != 0)) 
   {
      TraceString("Start Socket Server for %s Port %d ",szIpAddress,s32Port);
   }
   else
   {
      /* check for socket configuration in registry*/
      if((s32DevDesc = OSAL_IOOpen(OSAL_C_STRING_DEVICE_REGISTRY"/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/VERSIONS/OSAL",OSAL_EN_READWRITE)) != OSAL_ERROR )
      {
         hReg.pcos8Name =  (tPCS8)"SOCKET";
         hReg.s32Type   =  OSAL_C_S32_VALUE_STRING;
         hReg.ps8Value  =  (tPU8)szIpAddress;
         hReg.u32Size   =  32;
         if(OSAL_s32IOControl(s32DevDesc,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&hReg) == OSAL_OK)
         {
            hReg.pcos8Name =  (tPCS8)"PORT";
            hReg.s32Type   =  OSAL_C_S32_VALUE_S32;
            hReg.ps8Value  =  (tPU8)&s32Port;
            hReg.u32Size   =  sizeof(tU32);
            if(OSAL_s32IOControl(s32DevDesc,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&hReg) == OSAL_OK)
            {
               TraceString("Start Socket Server for %s Port %d ",szIpAddress,s32Port);
               pel = new OSAL_tclErrorLogger();
               if(pel)
               {
                 g_poSocketGroup = new tclSocketGroup( pel );
                 if(g_poSocketGroup)
                 {
                    g_poSocketGroup->vSocketServerGroupInit(s32Port);
                 }
                 else
                 {
                    TraceString("Cannot instantiate tclSocketGroup object ");
                   // delete pel;
                 }
               }
               else
               {
                  TraceString("Cannot instantiate Error Logger object ");
               }
            }
         }
         OSAL_s32IOClose(s32DevDesc);
      }
   }
   OSAL_s32ThreadWait(msecs);

   OSAL_vProcessExit();
}


#ifdef __cplusplus
}
#endif

/************************************************************************
|end of fileMAin.cpp
|-----------------------------------------------------------------------*/
