/************************************************************************
| FILE:         Devinit.c
| PROJECT:      BMW_L6
| SW-COMPONENT: OSAL IO
|------------------------------------------------------------------------
| DESCRIPTION:  This is the source for OSAL IO devices initialization
|
|
|------------------------------------------------------------------------
| COPYRIGHT:    (c) 2005 Bosch GmbH
| HISTORY:      
| Date      | Modification               | Author
| 03.10.05  | Initial revision           | MRK2HI
| 13.02.2013| NIKAI-1970, Registry       | asa5cob
|           | rereival TTFIs command
|           | blocks LSIM           
| 18.03.2013| NIKAI - 4010               | asa5cob    
| 09.04.2013| NIKAI - 3061               | sgo1cob    
| 09.04.2014| LSIM-Gen3 CD Audio and
|           | control feature enabled but  
|           | Loaded as shared object    | sgo1cob
| 22.08.17  | Coverity Fix               | boc7kor
|************************************************************************/

/************************************************************************
| includes of component-internal interfaces
| (scope: component-local)
|-----------------------------------------------------------------------*/
#include "OsalConf.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "Linux_osal.h"

#include "ostrace.h"



#ifdef __cplusplus
extern "C" {
#endif


/************************************************************************
|defines and macros (scope: module-local)
|-----------------------------------------------------------------------*/

/*************************************************************************
|function prototype inclusion (scope: module-local)
|-----------------------------------------------------------------------*/


/************************************************************************
|typedefs (scope: module-local)
|-----------------------------------------------------------------------*/

/************************************************************************
| variable definition (scope: global)
|-----------------------------------------------------------------------*/
extern char process_name[256];

/************************************************************************
| variable definition (scope: module-local)
|-----------------------------------------------------------------------*/

/*  to be aligned with eSharedLib*/
static tCString  szLibNames[EN_SHARED_LAST]={"libshared_kds_so.so","libsensordrv_so.so", "libshared_cd_so.so","libshared_wup_so.so",
                                          "libshared_volt_so.so", "libshared_eollib_so.so","libshared_adr3ctrl_so.so","libcryptmodul_so.so",
                                          "libshared_acoustic_so.so","libosal_addon_so.so","libbasedrv_so.so"};


/************************************************************************
|function prototype (scope: module-local)
|-----------------------------------------------------------------------*/
void vSetupRegistry(void);
void LLD_vRegTraceCallback( TR_tenTraceChan enTraceChannel, OSAL_tpfCallback pfCallback );

/************************************************************************
|function prototype (scope: module-global)
|-----------------------------------------------------------------------*/
extern void HandleMaxErrMemFilesize(int u32Size);
extern void vSetTraceForAllDeviceIo(char cVal, tS32 s32Pid);
extern tBool bCreateRegFromFileNativ(char* szFileName);
extern void vReplaceMountPointTable(void);

/************************************************************************
|function implementation (scope: module-local)
|-----------------------------------------------------------------------*/

/************************************************************************
|function implementation (scope: global)
|-----------------------------------------------------------------------*/

void TraceIOString(tCString cBuffer)
{
  TraceString(cBuffer);
}


/*****************************************************************************
 * helper date functions for vTraceErrmem
 *****************************************************************************/




extern tU32 REG_u32IOCreate(tCString coszName, OSAL_tenAccess enAccess, uintptr_t *pu32RetAddr);
extern tU32 REG_u32IOOpen(tCString coszName, OSAL_tenAccess enAccess,uintptr_t* pu32RetAddr);
extern tU32 REG_u32IOClose(uintptr_t u32fd);
extern tU32 REG_u32IOControl(uintptr_t u32fd, tS32 fun, uintptr_t arg);


void vSetDefaultRegValues( uintptr_t u32Fd)
{
   tS32 s32Val;
   OSAL_trIOCtrlRegistry rReg;

#ifdef AES_ENCRYPTION_AVAILABLE
   s32Val = 0x00000001;//1= active
#else
   s32Val = 0x00000000;//0= Not active
#endif
   rReg.pcos8Name = (tS8*)"AES_ENCRYPTION";
   rReg.ps8Value  = (tU8*)&s32Val;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   (void)REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGSETVALUE,(uintptr_t)&rReg);

   s32Val = 0x00000001;//0=Not active,1 Nice Level, 2Prio
   rReg.pcos8Name = (tS8*)"LINUX_PRIO";
   rReg.ps8Value  = (tU8*)&s32Val;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   (void)REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGSETVALUE,(uintptr_t)&rReg);

   s32Val = OSAL_MSG_POOL_SIZE;//default size
   rReg.pcos8Name = (tS8*)"MAXPOOLSIZE";
   rReg.ps8Value  = (tU8*)&s32Val;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   (void)REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGSETVALUE,(uintptr_t)&rReg);


   s32Val = (tS32)0xffffffff;//default unlimited, 0 kernel configuration is used , other value configured by project
   rReg.pcos8Name = (tS8*)"MQ_LIMIT";
   rReg.ps8Value  = (tU8*)&s32Val;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   (void)REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGSETVALUE,(uintptr_t)&rReg);

   s32Val = 0x1;//default uppercase workaround supported
   rReg.pcos8Name = (tS8*)"UPPER_CASE";
   rReg.ps8Value  = (tU8*)&s32Val;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   (void)REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGSETVALUE,(uintptr_t)&rReg);

   s32Val = 0x0;//default LD_LIBRARY_PATH should be used
   rReg.pcos8Name = (tS8*)"NO_LD_LIBRARY_PATH";
   rReg.ps8Value  = (tU8*)&s32Val;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   (void)REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGSETVALUE,(uintptr_t)&rReg);

   rReg.pcos8Name = (tCS8*)"TIM_RESOLUTION";
   rReg.ps8Value  = (tU8*)&pOsalData->u32TimerResolution;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   (void)REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGSETVALUE,(uintptr_t)&rReg);

#ifdef USE_EVENT_AS_CB  
   s32Val = 1;
#else
   s32Val = 0;
#endif
   rReg.pcos8Name = (tCS8*)"NOTIFY_EVENT";
   rReg.ps8Value  = (tU8*)&s32Val;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   (void)REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGSETVALUE,(uintptr_t)&rReg);
}

void vPrepareLocalFileSystem(void)
{
   char Path[256];
   int Len;
   int Ret;
   int Val = TRUE;
   if(getcwd(&Path[0],256) == NULL)
   {
     TraceString("vPrepareFileSystem getcwd failed %d",errno);
   }
   else
   {
      if(pOsalData->u32StartTrace == 0)TraceString("vPrepareFileSystem cwd %s",&Path[0]);
   }
   Len = (int)strlen(Path);
   /*Coverity Fix:CID 16297*/
   strncat(&Path[Len],"/bosch",255 - (size_t)Len);
   Ret = mkdir(Path,S_IFDIR | OSAL_ACCESS_RIGTHS);
   if(Ret == -1)
   {
      if(errno == EEXIST)
      {
        Val = TRUE;
      } 
      else
      {
         Val = FALSE;
         TraceString("Create Directory %s failed %d",Path,errno);
         vWritePrintfErrmem("Create Directory %s failed %d",Path,errno);
/* workaround for QNX */
#ifdef QNX
         if(!strncmp(VOLATILE_DIR,Path,strlen(VOLATILE_DIR)))
         {
            Ret = open(VOLATILE_DIR"/bosch/dynamic/ffs/test.txt", O_RDWR | O_CREAT | O_APPEND , OSAL_ACCESS_RIGTHS);
            close(Ret);
            Ret = open(VOLATILE_DIR"/bosch/dynamic/navdata/test.txt", O_RDWR | O_CREAT | O_APPEND , OSAL_ACCESS_RIGTHS);
            close(Ret);
         }
#endif
      }
   }
   else
   {
      Val = TRUE;
      if(chmod(Path, OSAL_VOLATILE_OSAL_PRC_ACCESS_RIGTHS) == -1)
      {
         vWritePrintfErrmem("vPrepareLocalFileSystem -> %s chmod error %d \n",Path,errno);
      }
   }
   if(Val == TRUE)
   {
      memset(&Path[Len],0,(size_t)(256-Len));
      strncpy(&Path[Len],"/bosch/dynamic",strlen("/bosch/dynamic"));
      if(mkdir(Path,S_IFDIR | OSAL_ACCESS_RIGTHS) == 0)
      {
         if(chmod(Path, OSAL_VOLATILE_OSAL_PRC_ACCESS_RIGTHS) == -1)
         {     vWritePrintfErrmem("vPrepareLocalFileSystem -> %s chmod error %d \n",Path,errno);   }
      }
      memset(&Path[Len],0,(size_t)(256-Len));
      strncpy(&Path[Len],"/bosch/dynamic/ffs",strlen("/bosch/dynamic/ffs"));
      if(mkdir(Path,S_IFDIR | OSAL_ACCESS_RIGTHS) == 0)
      {
         if(chmod(Path, OSAL_VOLATILE_OSAL_PRC_ACCESS_RIGTHS) == -1)
         {     vWritePrintfErrmem("vPrepareLocalFileSystem -> %s chmod error %d \n",Path,errno);   }
      }
      memset(&Path[Len],0,(size_t)(256-Len));
      strncpy(&Path[Len],"/bosch/dynamic/ffs2",strlen("/bosch/dynamic/ffs2"));
      if(mkdir(Path,S_IFDIR | OSAL_ACCESS_RIGTHS) == 0)
      {
         if(chmod(Path, OSAL_VOLATILE_OSAL_PRC_ACCESS_RIGTHS) == -1)
         {     vWritePrintfErrmem("vPrepareLocalFileSystem -> %s chmod error %d \n",Path,errno);   }
      }
      memset(&Path[Len],0,(size_t)(256-Len));
      strncpy(&Path[Len],"/bosch/navdata",strlen("/bosch/navdata"));
      if(mkdir(Path,S_IFDIR | OSAL_ACCESS_RIGTHS) == 0)
      {
         if(chmod(Path, OSAL_VOLATILE_OSAL_PRC_ACCESS_RIGTHS) == -1)
         {     vWritePrintfErrmem("vPrepareLocalFileSystem -> %s chmod error %d \n",Path,errno);   }
      }
      memset(&Path[Len],0,(size_t)(256-Len));
      strncpy(&Path[Len],"/bosch/navdb",strlen("/bosch/navdb"));
      if(mkdir(Path,S_IFDIR | OSAL_ACCESS_RIGTHS) == 0)
      {
         if(chmod(Path, OSAL_VOLATILE_OSAL_PRC_ACCESS_RIGTHS) == -1)
         {     vWritePrintfErrmem("vPrepareLocalFileSystem -> %s chmod error %d \n",Path,errno);   }
      }
      vReplaceMountPointTable();
   }
}

void vSetOsalDebugRegValues(uintptr_t u32Fd)
{
   OSAL_trIOCtrlRegistry rReg;
   tS32 s32Val;
   char NameBuffer[64];

   rReg.pcos8Name = (tCS8*)"OSAL_TIM_CHECK";
   rReg.ps8Value  = (tU8*)&pOsalData->CheckTimerApp[0];
   rReg.u32Size   = OSAL_C_U32_MAX_NAMELENGTH;
   rReg.s32Type = OSAL_C_S32_VALUE_STRING;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);

   /* check for supervison OSAL objects*/
   rReg.u32Size   = OSAL_C_U32_MAX_NAMELENGTH;
   rReg.s32Type   = OSAL_C_S32_VALUE_STRING;
   for(s32Val=0;s32Val<MAX_NR_SUPERVISION_OBJ;s32Val++)
   {
     snprintf(NameBuffer,64,"MSG_QUEUE%d",s32Val+1);  
     rReg.pcos8Name = (tCS8*)NameBuffer;
     rReg.ps8Value  = (tU8*)&pOsalData->rMqName[s32Val].szObjName[0];
     if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg)!=OSAL_E_NOERROR)break;
   }
   
   for(s32Val=0;s32Val<MAX_NR_SUPERVISION_OBJ;s32Val++)
   {
     snprintf(NameBuffer,64,"OSAL_EVENT%d",s32Val+1);  
     rReg.pcos8Name = (tCS8*)NameBuffer;
     rReg.ps8Value  = (tU8*)&pOsalData->rEventName[s32Val].szObjName[0];
     if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg)!=OSAL_E_NOERROR)break;
   }

   for(s32Val=0;s32Val<MAX_NR_SUPERVISION_OBJ;s32Val++)
   {
     snprintf(NameBuffer,64,"OSAL_SEM%d",s32Val+1);  
     rReg.pcos8Name = (tCS8*)NameBuffer;
     rReg.ps8Value  = (tU8*)&pOsalData->rSemName[s32Val].szObjName[0];
     if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg)!=OSAL_E_NOERROR)break;
   }
   for(s32Val=0;s32Val<MAX_NR_SUPERVISION_OBJ;s32Val++)
   {
     snprintf(NameBuffer,64,"OSAL_MTX%d",s32Val+1);  
     rReg.pcos8Name = (tCS8*)NameBuffer;
     rReg.ps8Value  = (tU8*)&pOsalData->rMtxName[s32Val].szObjName[0];;
     if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg)!=OSAL_E_NOERROR)break;
   }

   rReg.pcos8Name = (tCS8*)"OSAL_SEM_CHECK";
   rReg.ps8Value  = (tU8*)&pOsalData->szCheckSemName;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);

   rReg.pcos8Name = (tCS8*)"OSAL_SHARED_MEM";
   rReg.ps8Value  = (tU8*)&pOsalData->szShMemName;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);

   rReg.pcos8Name = (tCS8*)"OSAL_STRACE_PRC";
   rReg.ps8Value  = (tU8*)&pOsalData->szSTraceProcess;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
   
   pOsalData->u32CheckSemTmo = 3000;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type   = OSAL_C_S32_VALUE_S32;
   rReg.pcos8Name = (tCS8*)"OSAL_SEM_CHECK_TMO";
   rReg.ps8Value  = (tU8*)&pOsalData->u32CheckSemTmo;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
 
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type   = OSAL_C_S32_VALUE_S32;
   rReg.pcos8Name = (tCS8*)"OSAL_DISABLE_ACS";
   rReg.ps8Value  = (tU8*)&pOsalData->u32DisableAssertCS;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
 
   rReg.pcos8Name = (tCS8*)"OSAL_STRACE_FILTER";
   rReg.ps8Value  = (tU8*)&pOsalData->u32STraceLevel;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
  
   rReg.pcos8Name = (tCS8*)"OSAL_LOG_SIGCHLD";
   rReg.ps8Value  = (tU8*)&pOsalData->u32LogSigChld;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
  
   s32Val = 0;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type   = OSAL_C_S32_VALUE_S32;
   rReg.pcos8Name = (tCS8*)"DUMP_MSG_POOL";
   rReg.ps8Value  = (tU8*)&s32Val;
   if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg)==OSAL_E_NOERROR)
   {  
      if(s32Val & 0x01)
      {
         pOsalData->rMsgPoolStruct.u32InvestigatePool = 1;
      }
      if(s32Val & 0x10)
      {
         pOsalData->rMsgPoolStruct.bLogPidTid = TRUE;
      } 
      if(s32Val & 0x100)
      {
         pOsalData->u32CheckOpnHandle = TRUE;
      } 
   }

   rReg.pcos8Name = (tCS8*)"TRACE_DEV";
   rReg.ps8Value  = (tU8*)&pOsalData->szDevTrace;
   rReg.u32Size   = 64;
   rReg.s32Type = OSAL_C_S32_VALUE_STRING;
   if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg)==OSAL_E_NOERROR)
   {  
      if(!strncmp(pOsalData->szDevTrace,"all",strlen("all")))
      {
         vSetTraceForAllDeviceIo(1,0);
      }
      else
      {
         tS32 s32Dummy = 0;
         vSetDevTrace((char*)&s32Dummy,(tCString)pOsalData->szDevTrace);
      }
   }

   rReg.pcos8Name = (tCS8*)"PROCESS_PATH";
   rReg.ps8Value  = (tU8*)&pOsalData->cProcessPath;
   rReg.u32Size   = OSAL_C_U32_MAX_PATHLENGTH;
   rReg.s32Type = OSAL_C_S32_VALUE_STRING;
   if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg)!=OSAL_E_NOERROR)
   {
      strcpy(pOsalData->cProcessPath,"/opt/bosch/base/bin");
   }
   
   rReg.pcos8Name = (tCS8*)"DBG_SIG_PRC";
   rReg.ps8Value  = (tU8*)&pOsalData->cDbgPrcName;
   rReg.u32Size   = OSAL_C_U32_MAX_PATHLENGTH;
   rReg.s32Type = OSAL_C_S32_VALUE_STRING;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
  
   rReg.pcos8Name = (tCS8*)"DBG_SIGNAL";
   rReg.ps8Value  = (tU8*)&pOsalData->u32DebugSignal;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
   
   rReg.pcos8Name = (tCS8*)"DBG_SIG_ACT";
   rReg.ps8Value  = (tU8*)&pOsalData->u32SignalAction;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);

   rReg.pcos8Name = (tCS8*)"OSAL_MSG_CNT_TIME";
   rReg.ps8Value  = (tU8*)&pOsalData->MessageCountingActive;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
}

void vSetOsalTraceRegValues(uintptr_t u32Fd)
{
   OSAL_trIOCtrlRegistry rReg;
   char Buffer[OSAL_C_U32_MAX_NAMELENGTH];
   int i;
   char szPathName[256];

   rReg.pcos8Name = (tCS8*)"OSAL_TRACE";
   rReg.ps8Value  = (tU8*)&pOsalData->u32OsalTrace;
   rReg.u32Size   = sizeof(tU32);
   rReg.s32Type  = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);

   rReg.pcos8Name = (tCS8*)"TRACE_LOG";
   rReg.ps8Value  = (tU8*)&pOsalData->szPathTraceLog;
   rReg.u32Size   = 256;
   rReg.s32Type = OSAL_C_S32_VALUE_STRING;
   if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg)==OSAL_E_NOERROR)
   {
      if(strstr(pOsalData->szPathTraceLog,".pro"))
      {
         pOsalData->u32WritToFile = 2;
      }
      else
      {
         pOsalData->u32WritToFile = 1;
      }
      if(pOsalData->u32StartTrace == 0)TraceString("Log Trace to file %s ",pOsalData->szPathTraceLog);
   }

   rReg.pcos8Name = (tCS8*)"TRACE_LEVEL";
   rReg.ps8Value  = (tU8*)&pOsalData->u32TraceLevel;
   rReg.u32Size   = sizeof(tU32);
   rReg.s32Type  = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
  if(pOsalData->u32StartTrace == 0)TraceString("General Trace level %d active",pOsalData->u32TraceLevel);

   rReg.pcos8Name = (tCS8*)"TRACE_FS_ACCESS";
   rReg.ps8Value  = (tU8*)&pOsalData->u32TraceAll;
   rReg.u32Size   = sizeof(tU32);
   rReg.s32Type  = OSAL_C_S32_VALUE_S32;
   if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg)==OSAL_E_NOERROR)
   {
      if(pOsalData->u32TraceAll)TraceString("Trace Active for File System Access");
   }

   for(i=0;i<50;i++)
   {
      snprintf(szPathName,100,"Trace%d",i+1);
      rReg.pcos8Name = (tCS8*)szPathName;
      rReg.ps8Value  = (tU8*)&Buffer[0];
      rReg.u32Size   = OSAL_C_U32_MAX_NAMELENGTH;
      rReg.s32Type = OSAL_C_S32_VALUE_STRING;
      if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg) != OSAL_E_NOERROR)
      {
         break;
      }
      else
      {
        char *pTemp = (char*)OSAL_ps8StringSearchChar((tString)Buffer,',' );/*lint !e505 */
        if(pTemp)
        {
        *pTemp = 0;
        pTemp++;
        pOsalData->u32Class[i] = (tU32)atoi(Buffer);
        pOsalData->u32Level[i] = (tU32)atoi(pTemp);
        pOsalData->u32NrOfClass++;
        if(pOsalData->u32StartTrace == 0)TraceString("Trace Class %d on Level %d Active",pOsalData->u32Class[i],pOsalData->u32Level[i] );
      }
        else
        {
           TraceString("Wrong Traces Class Entry %s",Buffer);
           break;
        }
      }
   }
}

void vSetOsalDispatcherRegValues(uintptr_t u32Fd)
{
   OSAL_trIOCtrlRegistry rReg;
   char szPathName[256];
   tBool bTrace = FALSE;
   if(pOsalData->FirstPrcId == OSAL_ProcessWhoAmI())bTrace = TRUE;
   
   rReg.pcos8Name = (tCS8*)"/dev/ffs";
   rReg.ps8Value  = (tU8*)szPathName;
   rReg.u32Size   = 256;
   rReg.s32Type = OSAL_C_S32_VALUE_STRING;
   if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg) == OSAL_E_NOERROR)
   {
      ReplaceMountPointEntry(IndexFfs,szPathName,bTrace);
   }       
   rReg.pcos8Name = (tCS8*)"/dev/ffs2";
   if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg) == OSAL_E_NOERROR)
   {
      ReplaceMountPointEntry(IndexFfs2,szPathName,bTrace);
   }
   rReg.pcos8Name = (tCS8*)"/dev/ramdisk";
   if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg) == OSAL_E_NOERROR)
   {
      ReplaceMountPointEntry(IndexRamDisk1,szPathName,bTrace);
   }
   rReg.pcos8Name = (tCS8*)"/dev/media";
   if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg) == OSAL_E_NOERROR)
   {
      ReplaceMountPointEntry(IndexDevMedia,szPathName,bTrace);
   }  
   rReg.pcos8Name = (tCS8*)"/dev/local";
   if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg) == OSAL_E_NOERROR)
   {
      ReplaceMountPointEntry(IndexLocal,szPathName,bTrace);
   }  
}

void vSetOsalPoolSizeRegValues(uintptr_t u32Fd)
{
   OSAL_trIOCtrlRegistry rReg;
 
   rReg.pcos8Name = (tCS8*)"DEVICE_DES";
   rReg.ps8Value  = (tU8*)&pOsalData->u32DeviceHandles;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
   rReg.pcos8Name = (tCS8*)"FILE_DES";
   rReg.ps8Value  = (tU8*)&pOsalData->u32FileHandles;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
   rReg.pcos8Name = (tCS8*)"MQ_DES";
   rReg.ps8Value  = (tU8*)&pOsalData->u32MqHandles;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
   rReg.pcos8Name = (tCS8*)"EV_DES";
   rReg.ps8Value  = (tU8*)&pOsalData->u32EventHandles;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
   rReg.pcos8Name = (tCS8*)"SEM_DES";
   rReg.ps8Value  = (tU8*)&pOsalData->u32SemHandles;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
   
   rReg.pcos8Name = (tCS8*)"SEM_MAX";
   rReg.ps8Value  = (tU8*)&pOsalData->u32MaxNrSemaphoreElements;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
   rReg.pcos8Name = (tCS8*)"MUTEX_MAX";
   rReg.ps8Value  = (tU8*)&pOsalData->u32MaxNrMutexElements;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
   rReg.pcos8Name = (tCS8*)"EVENT_MAX";
   rReg.ps8Value  = (tU8*)&pOsalData->u32MaxNrEventElements;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
   rReg.pcos8Name = (tCS8*)"SHMEM_MAX";
   rReg.ps8Value  = (tU8*)&pOsalData->u32MaxNrSharedMemElements;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
   rReg.pcos8Name = (tCS8*)"TIMER_MAX";
   rReg.ps8Value  = (tU8*)&pOsalData->u32MaxNrTimerElements;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
   rReg.pcos8Name = (tCS8*)"TASK_MAX";
   rReg.ps8Value  = (tU8*)&pOsalData->u32MaxNrThreadElements;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
   pOsalData->u32OffsetNodeElements = pOsalData->u32MaxNrThreadElements + 1;
   rReg.pcos8Name = (tCS8*)"MSGQ_MAX";
   rReg.ps8Value  = (tU8*)&pOsalData->u32MaxNrMqElements;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
   rReg.pcos8Name = (tCS8*)"PROC_MAX";
   rReg.ps8Value  = (tU8*)&pOsalData->u32MaxNrProcElements;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
   
   /* adapt values for OSAL internal used resources for own message queue implementation */
#ifdef OSAL_SHM_MQ_FOR_LINUX_MQ
   pOsalData->u32EventHandles           += pOsalData->u32MaxNrMqElements;
   pOsalData->u32MaxNrSharedMemElements += pOsalData->u32MaxNrMqElements;
#ifdef SHM_MQ_USE_SEM
   pOsalData->u32MaxNrSemaphoreElements += (2* pOsalData->u32MaxNrMqElements);
#else
   pOsalData->u32MaxNrMutexElements     += pOsalData->u32MaxNrMqElements;
   pOsalData->u32MaxNrSemaphoreElements += pOsalData->u32MaxNrMqElements;
#endif //SHM_MQ_USE_SEM
#endif //OSAL_SHM_MQ_FOR_LINUX_MQ
  
   if(pOsalData->u32MaxNrProcElements > MAX_LINUX_PROC)pOsalData->u32MaxNrProcElements = MAX_LINUX_PROC;
}

#ifdef ANDROID
uint32_t GetMaxNrOfSharedMemory(void)
{
   return pOsalData->u32MaxNrSharedMemElements;
}
#endif

void vSetOsalRegValues(uintptr_t u32Fd)
{
   tS32 i,s32Val = 0;
   OSAL_trIOCtrlRegistry rReg;
   char szPathName[256];

   rReg.pcos8Name = (tCS8*)"NO_LD_LIBRARY_PATH";
   rReg.ps8Value  = (tU8*)&s32Val;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);

   if(s32Val)
   {
      rReg.pcos8Name = (tCS8*)"SHARED_PATH";
      rReg.ps8Value  = (tU8*)szPathName;
      rReg.u32Size   = 256;
      rReg.s32Type = OSAL_C_S32_VALUE_STRING;
      if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg) == OSAL_E_NOERROR)
      {
         for(i=0;i<EN_SHARED_LAST;i++)
         {
            OSAL_szStringCopy(pOsalData->rLibrary[i].cLibraryNames,szPathName);
         }
      }
      else
      {
         for(i=0;i<EN_SHARED_LAST;i++)
         {
            OSAL_szStringCopy(pOsalData->rLibrary[i].cLibraryNames,OSAL_SHARED_LIB_PATH);
         }
      }
      for(i=0;i<EN_SHARED_LAST;i++)
      {
         OSAL_szStringConcat(pOsalData->rLibrary[i].cLibraryNames,szLibNames[i]);
      }
   }

   rReg.pcos8Name = (tCS8*)"REGFILE_DEFAULT_PATH";
   rReg.ps8Value  = (tU8*)pOsalData->szRegFileDefaultPath;
   rReg.u32Size   = 256;
   rReg.s32Type = OSAL_C_S32_VALUE_STRING;
   if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg) != OSAL_E_NOERROR)
   {
   }
   if(pOsalData->u32StartTrace == 0)TraceString("Registry Default Path is %s",pOsalData->szRegFileDefaultPath);

   
   rReg.pcos8Name = (tCS8*)"USE_OSAL_TIME";
   rReg.ps8Value  = (tU8*)&pOsalData->u32UseOsalTime;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg) == OSAL_E_NOERROR)
   {
      if(pOsalData->u32StartTrace == 0)if(pOsalData->u32UseOsalTime)TraceString("OSAL uses intern time instead of Linux Time");
   }
   rReg.pcos8Name = (tCS8*)"UPPER_CASE";
   rReg.ps8Value  = (tU8*)&pOsalData->u32UpperCase;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);

   rReg.pcos8Name = (tCS8*)"MAXPOOLSIZE";
   rReg.ps8Value  = (tU8*)&pOsalData->u32MsgPoolSize;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);

   rReg.pcos8Name = (tCS8*)"ASSERT_MODE";
   rReg.ps8Value  = (tU8*)&pOsalData->u32AssertMode;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
 
   rReg.pcos8Name = (tCS8*)"USE_LIBUNWIND";
   rReg.ps8Value  = (tU8*)&pOsalData->u32UseLibunwind;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);

   rReg.pcos8Name = (tCS8*)"LINUX_PRIO";
   rReg.ps8Value  = (tPU8)&pOsalData->u32Prio;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);

   rReg.pcos8Name = (tCS8*)"LINUX_CGROUP";
   rReg.ps8Value  = (tPU8)&pOsalData->u32CGroup;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);

   pOsalData->u32MqResource = (tU32)RLIM_INFINITY;
   rReg.pcos8Name = (tCS8*)"MQ_LIMIT";
   rReg.ps8Value  = (tPU8)&pOsalData->u32MqResource;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
   if(pOsalData->u32MqResource == 0xffffffff)pOsalData->u32MqResource = (tU32)RLIM_INFINITY;

   s32Val = 0;
   rReg.pcos8Name = (tCS8*)"ERRMEM_SIZE";
   rReg.ps8Value  = (tPU8)&s32Val;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg) == OSAL_E_NOERROR)
   {
     HandleMaxErrMemFilesize(s32Val);
   }

   rReg.pcos8Name = (tCS8*)"CRYPTCARD_APP";
   rReg.ps8Value  =  (tPU8)&pOsalData->u32PrmAppId;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);

   rReg.pcos8Name = (tCS8*)"AM_VERSION";
   rReg.ps8Value  = (tPU8)&pOsalData->u32AmVersion;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);

   rReg.pcos8Name = (tCS8*)"TIMER_SIGNAL";
   rReg.ps8Value  = (tPU8)&pOsalData->u32TimSignal;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);

   rReg.pcos8Name = (tCS8*)"EXC_HDR";
   rReg.ps8Value  = (tPU8)&pOsalData->u32ExcStatus;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);

   rReg.pcos8Name = (tCS8*)"OSAL_MAIN";
   rReg.ps8Value  = (tU8*)&pOsalData->OsalMainApp[0];
   rReg.u32Size   = OSAL_C_U32_MAX_NAMELENGTH;
   rReg.s32Type = OSAL_C_S32_VALUE_STRING;
   if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg) != OSAL_E_NOERROR)
   {
       /*Coverity Fix: CID 10050*/
      strncpy(&pOsalData->OsalMainApp[0],"procbase\0",
              sizeof(pOsalData->OsalMainApp) - 1);
      pOsalData->OsalMainApp[OSAL_C_U32_MAX_NAMELENGTH - 1]= '\0';

   }

   rReg.pcos8Name = (tCS8*)"CLK_MONO";
   rReg.ps8Value  = (tU8*)&pOsalData->u32ClkMonotonic;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);

   if(pOsalData->u32ClkMonotonic)
   {
      if(pOsalData->u32StartTrace == 0)
      {
        if(pOsalData->u32ClkMonotonic & 0x00000001)TraceString("Clock Monotonic for OSAL MQ API active");
        if(pOsalData->u32ClkMonotonic & 0x00000010)TraceString("Clock Monotonic for OSAL Semaphore API active");
        if(pOsalData->u32ClkMonotonic & 0x00000100)TraceString("Clock Monotonic for OSAL Event API active");
        if(pOsalData->u32ClkMonotonic & 0x10000000)TraceString("Clock Monotonic Logging active");
      }
   }
   rReg.pcos8Name = (tCS8*)"MQ_POST_TMO";
   rReg.ps8Value  = (tU8*)&pOsalData->u32MqPostTmo;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);

   rReg.pcos8Name = (tCS8*)"TIM_RESOLUTION";
   rReg.ps8Value  = (tU8*)&pOsalData->u32TimerResolution;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);

   rReg.pcos8Name = (tCS8*)"NO_MQ_BLOCK_ENTRY";
   rReg.ps8Value  = (tU8*)&pOsalData->u32NoMqBlockEntry;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);

   rReg.pcos8Name = (tCS8*)"SPECIAL_SIGCONF";
   rReg.ps8Value  = (tU8*)&pOsalData->u32SpecialSigConf;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);

   s32Val = 0;
   rReg.pcos8Name = (tCS8*)"LOG_ERROR";
   rReg.ps8Value  = (tU8*)&s32Val;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg) == OSAL_E_NOERROR)
   {
      pOsalData->bLogError = (tBool)s32Val;
   }

   rReg.pcos8Name = (tCS8*)"REC_OSAL_LOCK";
   rReg.ps8Value  = (tU8*)&pOsalData->u32RecLockAccess;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);

   rReg.pcos8Name = (tCS8*)"ALLOW_EXIT";
   rReg.ps8Value  = (tU8*)&pOsalData->u32AllowExit;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);

   rReg.pcos8Name = (tCS8*)"PRM_DBUS";
   rReg.ps8Value  = (tU8*)&pOsalData->u32PrmDBus;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);

   rReg.pcos8Name = (tCS8*)"OSAL_MQ_DBUS";
   rReg.ps8Value  = (tU8*)&pOsalData->u32OsalMqDBus;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
   
   rReg.pcos8Name = (tCS8*)"OSAL_USB_HUB";
   rReg.ps8Value  = (tU8*)&pOsalData->u32OsalUsbHub;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
  
   s32Val = 0;
   rReg.pcos8Name = (tCS8*)"BT_SIGNAL";
   rReg.ps8Value  = (tU8*)&s32Val;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg)==OSAL_E_NOERROR)
   {
      /* Only standard signals are here possible regarding ADIT exception handler */
      if(s32Val < 32)
      {
         pOsalData->u32BtSignal = (tU32)s32Val;
      }
      else
      {
          TraceString("Wrong configuration of backtrace signal %d",s32Val);
      }
   }
   
   rReg.pcos8Name = (tCS8*)"VARIABLE_PATH";
   rReg.ps8Value  = (tU8*)&pOsalData->szNavDatPath;
   rReg.u32Size   = MAX_MOUNTPOINT_STRING_SIZE;
   rReg.s32Type = OSAL_C_S32_VALUE_STRING;
   if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg)==OSAL_E_NOERROR)
   {
       if(pOsalData->u32StartTrace == 0)TraceString("/dev/data points to %s",pOsalData->szNavDatPath);
   }

   rReg.pcos8Name = (tCS8*)"ERRMEM_DUMP_PATH";
   rReg.ps8Value  = (tU8*)&pOsalData->szErrMemDumpPath;
   rReg.u32Size   = MAX_MOUNTPOINT_STRING_SIZE;
   rReg.s32Type = OSAL_C_S32_VALUE_STRING;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);

   rReg.pcos8Name = (tCS8*)"FS_TO_LOCAL";
   rReg.ps8Value  = (tU8*)&pOsalData->u32FsToLocal;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
   if(pOsalData->u32FsToLocal == 1)
   {
      if(pOsalData->u32StartTrace == 0)TraceString("Buildup local file system");
      vPrepareLocalFileSystem();
   }

   rReg.pcos8Name = (tCS8*)"MMAP_MSG_SIZE";
   rReg.ps8Value  = (tU8*)&pOsalData->u32MmapMsgSize;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
   
   rReg.pcos8Name = (tCS8*)"MIN_DYN_MMAP_MSG_SIZE";
   rReg.ps8Value  = (tU8*)&pOsalData->u32DynMmapMsgSize;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
  
   rReg.pcos8Name = (tCS8*)"LOOP_DEVICE";
   rReg.ps8Value  = (tPU8)&pOsalData->bLoopdeviceloaded;
   rReg.u32Size   = sizeof(tS32);
   rReg.s32Type = OSAL_C_S32_VALUE_S32;
   REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg);
  
   /* set system wide default exception handler behaviour if nonone has defined defined it for the specific process i*/
   if(s32ExcHdrStatus == 0)s32ExcHdrStatus = (tS32)pOsalData->u32ExcStatus;
   for(i=0;i<MAX_BOSCH_CONF_APP;i++)
   {
      snprintf(szPathName,100,"EXCHDR_APP%d",i+1);
      rReg.pcos8Name = (tCS8*)szPathName;
      rReg.ps8Value  = (tU8*)&pOsalData->rBoschExcHdrApps[i].szAppName[0];
      rReg.u32Size   = OSAL_C_U32_MAX_NAMELENGTH;
      rReg.s32Type = OSAL_C_S32_VALUE_STRING;
      if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg) != OSAL_E_NOERROR)break;
   }

   for(i=0;i<MAX_BOSCH_CONF_APP;i++)
   {
      snprintf(szPathName,100,"TIM_APP%d",i+1);
      rReg.pcos8Name = (tCS8*)szPathName;
      rReg.ps8Value  = (tU8*)&pOsalData->rNoSigTimerApp[i].szAppName[0];
      rReg.u32Size   = OSAL_C_U32_MAX_NAMELENGTH;
      rReg.s32Type = OSAL_C_S32_VALUE_STRING;
      if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg) != OSAL_E_NOERROR)break;
   }

   for(i=0;i<MAX_BOSCH_CONF_APP;i++)
   {
      snprintf(szPathName,100,"EXIT_APP%d",i+1);
      rReg.pcos8Name = (tCS8*)szPathName;
      rReg.ps8Value  = (tU8*)&pOsalData->rExitApp[i].szAppName[0];
      rReg.u32Size   = OSAL_C_U32_MAX_NAMELENGTH;
      rReg.s32Type = OSAL_C_S32_VALUE_STRING;
      if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg) != OSAL_E_NOERROR)break;
   }

   for(i=0;i<MAX_BOSCH_CONF_APP;i++)
   {
      snprintf(szPathName,100,"RT_APP%d",i+1);
      rReg.pcos8Name = (tCS8*)szPathName;
      rReg.ps8Value  = (tU8*)&pOsalData->rRtApp[i].szAppName[0];
      rReg.u32Size   = OSAL_C_U32_MAX_NAMELENGTH;
      rReg.s32Type = OSAL_C_S32_VALUE_STRING;
      if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg) != OSAL_E_NOERROR)break;
   }
   
   for(i=0;i<MAX_BOSCH_CONF_PATH;i++)
   {
      snprintf(szPathName,100,"REMOUNT_PATH%d",i+1);
      rReg.pcos8Name = (tCS8*)szPathName;
      rReg.ps8Value  = (tU8*)&pOsalData->rRemountPath[i].szPathName[0];
      rReg.u32Size   = OSAL_C_U32_MAX_PATHLENGTH;
      rReg.s32Type = OSAL_C_S32_VALUE_STRING;
      if(REG_u32IOControl(u32Fd,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&rReg) != OSAL_E_NOERROR)break;
   }
}

void SetOsalConfViaRegistry(tBool bStartup)
{
   uintptr_t u32Fd = 0;
   pOsalData->ConfigCheckPid = OSAL_ProcessWhoAmI();

   // already locked by loading semaphore
   if(REG_u32IOOpen(REGISTRY_BASE_PATH"/VERSIONS/OSAL",OSAL_EN_READWRITE,&u32Fd) == OSAL_E_NOERROR)
   {
      vSetOsalRegValues(u32Fd);
      REG_u32IOClose(u32Fd);
   }
   else
   {
      TraceString("Open %s/VERSIONS/OSAL failed",REGISTRY_BASE_PATH); 
   }
 
   if(REG_u32IOOpen(REGISTRY_BASE_PATH"/VERSIONS/OSAL/FS_DISPATCHER",OSAL_EN_READWRITE,&u32Fd) == OSAL_E_NOERROR)
   {
      vSetOsalDispatcherRegValues(u32Fd);
      REG_u32IOClose(u32Fd);
   }
 
   if(bStartup)
   {
      if(REG_u32IOOpen(REGISTRY_BASE_PATH"/VERSIONS/OSAL/POOLSIZES",OSAL_EN_READWRITE,&u32Fd) == OSAL_E_NOERROR)
      {
         vSetOsalPoolSizeRegValues(u32Fd);
         REG_u32IOClose(u32Fd);
	  }
   }
   
   if(REG_u32IOOpen(REGISTRY_BASE_PATH"/VERSIONS/OSAL/INTERNAL_TRACE",OSAL_EN_READWRITE,&u32Fd) == OSAL_E_NOERROR)
   {
      vSetOsalTraceRegValues(u32Fd);
      REG_u32IOClose(u32Fd);
   }
   if(REG_u32IOOpen(REGISTRY_BASE_PATH"/VERSIONS/OSAL/DEBUG",OSAL_EN_READWRITE,&u32Fd) == OSAL_E_NOERROR)
   {
      vSetOsalDebugRegValues(u32Fd);
      REG_u32IOClose(u32Fd);
   }
}

void vCheckRegOverride(void)
{
   /* check if osal.reg exist to overide values */
   tBool bSetOsalMain = TRUE;
   char File1[128] = {0};
   char File2[128] = {0};
   char File3[128] = {0};
#ifdef ANDROID
   char Path[64] = "/vendor/etc/reg";
#elif QNX
   char Path[64] = "/etc/reg";
#else
   char Path[64] = "/opt/bosch/base/registry";
#endif
   
#ifdef SINGLE_PROCESS_OSAL
  char Name[256] = {0};
   char* tmp = strchr(process_name,'.');
   if( tmp != NULL )
   {
       *tmp = 0;
   }
   strncpy(Name,process_name,256);
   Name[255] = 0;
   snprintf(File1,128,"%s/%s_%s",Path,Name,"osal.reg");
   snprintf(File2,128,"%s_%s",Name,"osal.reg");
#else
   snprintf(File1,128,"%s/%s",Path,"osal.reg");
   snprintf(File2,128,"%s","osal.reg");
   snprintf(File3,128,"%s/%s",Path,"testosal.reg");
#endif
   if(bCreateRegFromFileNativ(&File1[0]) == FALSE)
   {
      if(bCreateRegFromFileNativ(&File2[0]) == FALSE)
      {
         if(bCreateRegFromFileNativ(&File3[0]) == FALSE)
         {
            if(pOsalData->u32StartTrace == 0)TraceString("No osal.reg file found ");
            bSetOsalMain = FALSE;
         }
      }
   }
   if(bSetOsalMain)SetOsalConfViaRegistry(TRUE);
   if(pOsalData->OsalMainApp[0] == 0)
   {
       /*Coverity Fix:CID 10051*/
      strncpy(&pOsalData->OsalMainApp[0],"procbase\0",
                         sizeof(pOsalData->OsalMainApp)-1);
      pOsalData->OsalMainApp[OSAL_C_U32_MAX_NAMELENGTH - 1] = '\0';
   }
}

void vSetupRegistry(void)
{
   uintptr_t u32Fd = 0;
   int i;
    
   //  already locked by loading semaphore
   if(REG_u32IOCreate("LOCAL_MACHINE",OSAL_EN_READWRITE,&u32Fd) != OSAL_E_NOERROR)
   {  TraceString("vSetupRegistry LOCAL_MACHINE failed %d",errno);       }
   else
   {  REG_u32IOClose(u32Fd);   }
   if(REG_u32IOCreate("LOCAL_MACHINE/SOFTWARE",OSAL_EN_READWRITE,&u32Fd) != OSAL_E_NOERROR)
   {   TraceString("vSetupRegistry SOFTWARE failed");   }
   else
   {  REG_u32IOClose(u32Fd);   }
   if(REG_u32IOCreate(REGISTRY_BASE_PATH,OSAL_EN_READWRITE,&u32Fd) != OSAL_E_NOERROR)
   {   TraceString("vSetupRegistry BLAUPUNKT/Bosch failed");   }
   else
   {  REG_u32IOClose(u32Fd);   }
   if(REG_u32IOCreate(REGISTRY_BASE_PATH"/VERSIONS",OSAL_EN_READWRITE,&u32Fd) != OSAL_E_NOERROR)
   {   TraceString("vSetupRegistry VERSIONS failed");   }
   else
   {  REG_u32IOClose(u32Fd);   }
   if(REG_u32IOCreate(REGISTRY_BASE_PATH"/VERSIONS/OSAL",OSAL_EN_READWRITE,&u32Fd) != OSAL_E_NOERROR)
   {   TraceString("vSetupRegistry OSAL failed");   }
   else
   {  REG_u32IOClose(u32Fd);   }

   if(REG_u32IOOpen(REGISTRY_BASE_PATH"/VERSIONS/OSAL",OSAL_EN_READWRITE,&u32Fd) == OSAL_E_NOERROR)
   {
       /*set default values */
       vSetDefaultRegValues(u32Fd);
       for(i=0;i<EN_SHARED_LAST;i++)
       {
          OSAL_szStringConcat(pOsalData->rLibrary[i].cLibraryNames,szLibNames[i]);
       }
       pOsalData->u32ExcStatus = OSAL_EXCHDR_STATUS;
       pOsalData->u32PrmAppId  = 0xffffffff; /*set default value*/
       pOsalData->u32AmVersion = 2;
       REG_u32IOClose(u32Fd);
   }
   else
   {
       TraceString("vSetupRegistry REG_u32IOOpen %s/VERSIONS/OSAL failed Error:%d",REGISTRY_BASE_PATH, OSAL_u32ErrorCode()); 
   }

    /* override existing values if osal.reg exists */
    vCheckRegOverride();

    if(pOsalData->u32MsgPoolSize == 0)
    {
       pOsalData->u32MsgPoolSize = OSAL_MSG_POOL_SIZE;
    }
}

#ifdef __cplusplus
}
#endif
/************************************************************************
|end of file Devinit.c
|-----------------------------------------------------------------------*/
