/************************************************************************
| FILE:         prm_dbus.h
| PROJECT:      Platform
| SW-COMPONENT: OSAL IO
|------------------------------------------------------------------------
| DESCRIPTION:  This is the interface for the prm_dbus usage
|
|
|------------------------------------------------------------------------
| COPYRIGHT:    (c) 2005 Blaupunkt GmbH
| HISTORY:      
| Date      | Modification               | Author
| 15.03.17  | Initial revision           | MRK2HI
| --.--.--  | ----------------           | -------, -----
|
|************************************************************************
|
|************************************************************************/

#if !defined (PRMDBUS_HEADER)
   #define PRMDBUS_HEADER

/************************************************************************ 
| includes of component-internal interfaces
| (scope: component-local)
|-----------------------------------------------------------------------*/ 
     
#ifdef __cplusplus
extern "C" {
#endif

/************************************************************************ 
|defines and macros (scope: global) 
|-----------------------------------------------------------------------*/
extern const char *const INTERFACE_NAME; 
extern const char *const SERVER_BUS_NAME; 
extern const char *const SERVER_OBJECT_PATH_NAME; 

#define METHOD_REMOUNT      "remount"
#define METHOD_SYSTEM_CALL  "systemcall"
#define METHOD_USB_SET_PWR  "usb_set_portpower"
#define METHOD_USB_GET_STAT "usb_get_portstate"
#define METHOD_USB_GET_CNT  "usb_get_portcount"
#define METHOD_STOP         "stop_prm_dbus"
#define METHOD_RESET_ADR3   "reset_adr3"
#define METHOD_SET_TIME     "set_time"
#define METHOD_SET_RT_PRIO  "set_prio"

/************************************************************************ 
|typedefs and struct defs (scope: global) 
|-----------------------------------------------------------------------*/

/************************************************************************ 
|function prototypes (scope: global) 
|-----------------------------------------------------------------------*/
extern unsigned int CallDBusMethod(char* param,char* name,int control);

#ifdef __cplusplus
}
#endif

#else
#error prm_dbus.h included several times
#endif 
