/************************************************************************
| FILE:         Osal_Conf.h
| PROJECT:      platform
| SW-COMPONENT: OSAL
|------------------------------------------------------------------------------
| DESCRIPTION:  This is the header file for the OSAL Abstraction Layer to
|               configure the OSAL Layer
|               modules of OSAL core.
|
|
|------------------------------------------------------------------------------
| COPYRIGHT:    (c) 2011 Robert Bosch GmbH
| HISTORY:
| Date      | Modification                   | Author
| 03.10.05  | Initial revision               | MRK2HI
| --.--.--  | ----------------               | -------, -----
| 07.09 .12 | Changedthe OSFILE_BLOCKSIZE    | sja3kor
| --.--.--  | ----------------               | -------, -----
| 26.09.12  |Feature PRM_LIBUSB_CONNECTION   |sja3kor
|           |defined for OSAL_GEN2 section   |
  29.11.12  |Removed the enum structure      |mdh4cob
| 11.12.12  | To Add signals used in Timer   | SWM2KOR
| 21.01.13  | Added Macro MQ_MEASUREMENT     | SWM2KOR 
| 24.01.13  |Defined PRM_LIBUSB_CONNECTION   | dhs2cob
|           |   for LSIM
| 19.03.13  |Defined                         | nro2kor
|           |GEN3_ODOMETER_ACTIVE for GEN3
| 09.04.2014| LSIM-Gen3 CD Audio and control 
|             related unused-macros removed  | sgo1cob
| 03.06.14  | Enable PRMLIB USB POWER	     | kgr1kor
| 27.04.16  | Defined AM_BIN for Gen3 SIM    | sja1kor
|*****************************************************************************/
#if !defined OSAL_CONF_HEADER
#define OSAL_CONF_HEADER

/******************************************************************************
** #include
******************************************************************************/
#include <errno.h>
#include <stddef.h>
#include <pthread.h>
#include <signal.h>
#include <poll.h>
#include <time.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <unistd.h>
#include <dirent.h>
#include <stdio.h>
#include <sys/mman.h>
#include <sys/ioctl.h>
#include <sys/resource.h>
#include <sched.h>
#include <setjmp.h>
#include <grp.h>
#include <limits.h>
#include <sys/wait.h>
#include <inttypes.h>
#include <dlfcn.h>
#include <sys/statvfs.h>
#ifdef ANDROID
#include <ashmem.h>
#include <sys/syscall.h>
#include <sys/prctl.h>
#include <sys/reboot.h>
#include <android/log.h>
#else  // ANDROID
#include <mqueue.h>
#ifdef QNX
#include <sys/neutrino.h>
#include <sys/dispatch.h>
#include <sys/target_nto.h>
#include <sys/kercalls.h>
#include <sys/slog.h>
#include <sys/slogcodes.h>
#include <backtrace.h>
#else  // QNX
#include <execinfo.h>
#include <sys/prctl.h>
#include <sys/epoll.h>
#include <asm/param.h>
#include <sys/syscall.h>
#include <linux/futex.h>
#include <sysexits.h>
#include <sys/reboot.h>
#endif // QNX
#endif // ANDROID

/*********************************************************************************************/
/* Definition of special OSAL Core features                                                  */
/*********************************************************************************************/
#ifndef OSAL_C_S32_IOCTRL_PRM_SET_TIME
#define OSAL_C_S32_IOCTRL_PRM_SET_TIME OSAL_C_S32_IOCTRL_PRM_GET_NAVIROOT
#define OSAL_C_S32_IOCTRL_PRM_SET_PRIO OSAL_C_S32_IOCTRL_PRM_SET_NAVIROOT
#endif

#define OSAL_NAME_SHMEM     "/OSAL-arena"
#define OSAL_NAME_RES_SHMEM "/OSAL_RES_MEM"
#define OSAL_NAME_LOCK      "OSAL-init"
#define OSAL_NAME_SYNCLOCK  "OSAL-initsync"
#define OSAL2_NAME_LOCK     "OSAL2-init"

#define OSAL_SHARED_LIB_PATH   "/opt/bosch/base/lib/"

#ifdef ANDROID
#define LIB_UNWIND    "libunwind.so"
#define LIB_M         "libm.so"
#else
#define LIB_M         "libm.so.6"
#define LIB_UNWIND    "libunwind.so.8"
#endif
#define LIB_ASOUND    "libasound.so.2"
#define LIB_UDEV      "libudev.so.1"
#define LIB_DLT       "libdlt.so.2"
#define LIB_ERRMEM    "liberrmem.so.3"

#define OSAL_EXCHDR_STATUS  1         /* Bosch exception handler is active as default */

//#define MEASURE_OSAL_START

/* constants */
/* minimum allowed size of a thread stack, otherwise you get 8MB (the default "ulimit -s" value) */
#define RBTREE_SEARCH                        /* use RB tree algorithm for thread ID (set/get error) */

#define MAX_MSG_CBHDR           20           /* Max Messages of Callback handler queue task */


#define OSALIO_PRIORITY_THREAD_PRM_LIBUSB_TA        10
#define OSALIO_PRIORITY_THREAD_PRM_LIBUSBQ_TA       10

/* in past: Priority must be higher than SPM -> ThreadSuspend Problem */
#define OSALCORE_C_U32_PRIORITY_2DI              (OSAL_C_U32_THREAD_PRIORITY_NORMAL)

#define OSAL_MSG_POOL_SIZE 0x001F4000   //default CCA Message pool size

#define LINUX_OS_TIME_RESOLUTION_IN_MS   10  // default resolution for LINUX timer
//#define TRACE_ASYNCIO              // activate trace output for asynchronous IO

#if defined ANDROID || defined QNX
#if defined  __arm__ || __arm_64__ || defined __aarch64__  || defined __x86_64__
#define tkill(x, sig) kill(x, sig)
#else
#define tkill(x, sig) syscall(SYS_tkill, (x), (sig))
#define tgkill(x, sig) syscall(SYS_tgkill, (x), getpid(),(sig))
#endif
#else
#define tkill(x, sig) syscall(SYS_tkill, (x), (sig))
#define tgkill(x, sig) syscall(SYS_tgkill, (x), getpid(),(sig))
#endif


/* what signal the timerThread uses */
#define OSAL_TIMER_SIGNAL                  40 // changed due valgrind from SIGRTMAX 

#if defined _LINUXX86_64_ || defined _LINUXX86MAKE_ || ANDROID || QNX // problem with Jenkins disconnect during test and no ADIT exception handler running
#define SIG_BACKTRACE                    SIGUSR2
#define SIG_INTERNAL                     SIGUSR1
#else
#define SIG_BACKTRACE                    SIGRTMIN /*signal for callstack generation allowed signals from SIGRTMIN up to SIGRTMAX -3 */
#define SIG_INTERNAL                     (SIG_BACKTRACE+1)
#endif

#define OSAL_CB_HDR_SIGNAL               54 /*signal to interrupt callack execution in callbackhandler task */
//#define OSAL_PRC_EXIT_SIG                 53 /*signal to indicate proper shutdown of an OSAL based process */
#define OSAL_STACK_SIGNAL                52 /*signal for stack info generation*/
#define OSAL_TRIGGER_OSAL_EXIT           51 /*signal to trigger OSAL_vProcessExit*/

#ifdef STACK_INVESTIGATION
#define SIG_INTERNAL2 (SIG_BACKTRACE+2)
#define SIG_TRIGGERSTACK  OSAL_STACK_SIGNAL
#endif
//#define RESTORE_SIGONLY_WITH_SIG         44

#define OSAL_TIMER_THREAD_PRIORITY       20

#define MAX_DEEP                         20 /* entry deep of via OSAL generated callstacks */

/* generic OSAL Core defines */
#define BLOCKING_TIMEOUT  3000           /* maximum blocking timeout for sending tasks to a MQ which is full */
#define MQ_NOTIFY_VIA_OSAL               /* MQ notify via OSAL callback handler task */
#define USE_EVENT_AS_CB                  /* support of direct event signaling for MQ notify */
#define OSAL_SHM_MQ                      /* support of Shared memory based implementation of OSAL MQ */
#define OSAL_RNG_BUF                     /* support of ringbuffer API similar like OSAL MQ */
//#define USE_FUTEX

//#define AREA_TEST
#define SIGONLY_TO_ERRMEM                /* enable this to trace all signals to errormem */


/* OSAL Core file&debug operation defines */
//#define CHECK_COPY                           // activates security mechanism for OSAL Core download
#define OSALCORE_FILECOPY_BUFFERSIZE 1000000   // maximum allocated memory for file copy operations in OSAL Core
#define DELAY_PRO_RW_CYCLE              100    // delay in ms after file copy operations defined with OSALCORE_FILECOPY_BUFFERSIZE

/* OSAL message queue related defines */
#define BLOCKING_TIMEOUT               3000    // Timeout for blocking OSAL message queue

#define TIMER_STORAGE_SIZE              100    // number of timer signals which could stored temporally

/* OSAL timer related defines */
#define MEASURE_CALLBACKS                      // automatic Measurement of timer callbacks

#define OSAL_TERM_LI_MQ          "LI_TERM_MQ"
#define ASYNCLOCK                "ASYNCLOC"
#define ASYNCJOBTRIG             "JOB_TRIG"

//#define SHM_MQ_USE_SEM        /* usage of semaphore instead of mutex for locking OSAL shared memory MQ or Ringbuffer */
//#define MSGPOOL_USE_SEM       /* usage of semaphore instead of mutex for locking OSAL (CCA) message pool */
//#define OSALLOCK_USE_SEM      /* usage of semaphore instead of mutex for locking OSAL structiures with OsalLock */
//#define SHM_RG_USE_SEM

//#define SEMAPHORE_WARN_LEVEL          1200   /* number of OSAL semaphores which causes a warning trace */

/*********************************************************************************************/


/*********************************************************************************************/
/* Definition of special OSAL IO features                                                  */
/*********************************************************************************************/
#define MAX_MOUNTPOINT_STRING_SIZE 256 // size of the longest string in MountPoint[] (see dispatcher_table.c)
/* File system related defines */
//#define READWRITE_SEGMENTED                // read&write large files in segments
#define READ_BUFFER_LENGTH            10240  // buffer length for segmented reading
#define FILECOPY_BUFFERSIZE         1000000  // maximum allocated buffer size for file copy operations

/*********************************************************************************************/

#define pOsalDataAddress (void*)0x00000000L  /* central OSAL shared memory should not have fix address for mapping*/
#define GLOBAL_DATA_OPTION  MAP_SHARED       /* Option for central OSAL shared memories */


//#define EPOLL_EV                    /* activate epoll based event implementation */
//#define SIGNAL_EV_HDR               /* activate signal based event implementation */
#if !defined (EPOLL_EV) && !defined(SIGNAL_EV_HDR)
#define SEM_EV
#else
#ifdef SIGNAL_EV_HDR
#define OSAL_SIGNAL_EVENT_AND            62
#define OSAL_SIGNAL_EVENT_OR             61
#define OSAL_SIGNAL_EVENT_XOR            60
#define OSAL_SIGNAL_EVENT_REPLACE        59

#define OSAL_SIGNAL_EVENT_PRC_AND        58
#define OSAL_SIGNAL_EVENT_PRC_OR         57
#define OSAL_SIGNAL_EVENT_PRC_XOR        56
#define OSAL_SIGNAL_EVENT_PRC_REPLACE    55
#endif
#endif

//#define SIGNAL_TRACE_EVENT          /* traces to follow event signals */
//#define SIGNAL_TRACE_TIMER          /* traces to follow timer signals */
//#define SIGNAL_TRACE                /* traces to follow process signals */
//#define FRAMEBUFFER_TEST            /* data for screen test active */
#define MMAP_FLAGS MAP_SHARED/*|MAP_UNINITIALIZED  Option for shared memory mapping*/
//#define OSAL_MMAP_SIZE   5*1024     /* activate mmap for OSAL_pvMemoryAllocate*/
//#define VIRTMEM_LIMIT               /* possibility to limit process adress space */

#define MMAP_FAST                     /* mmap with MAP_ANONYMOUS optione without file descriptor handling */
#ifndef MMAP_FAST
#define OSAL_MMAP_SHMEM               /* use shared memory instead of file IO for OSAL MMAP API */
#endif

#define AES_ENCRYPTION_AVAILABLE      /* AES encryption suppport from OSAL registry device */

#define MSG_HANDLE_BUFFER   50        /* number of messages which are marked as deleted before real deletion happen */


#define OSAL_FILE_ACCESS_RIGTHS  S_IRWXU | S_IRWXG | S_IRWXO  /* defines access option for all Linux 
                                                                file objects via OSAL */
#define OSAL_ACCESS_RIGTHS       S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP /* 0660  defines access option for all Linux  objects via OSAL (MQ, Share Mem)  S_IWUSR | S_IRUSR | S_IRGRP| S_IWGRP | S_IROTH | S_IWOTH 0666 */

#define OSAL_ACCESS_RIGTHS_RO       S_IRUSR | S_IRGRP /* 0440  */
#define OSAL_ACCESS_RIGTHS_WO       S_IWUSR | S_IWGRP /* 0220  */
#define OSAL_ACCESS_RIGTHS_RW       S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP /* 0660 */

#define OSAL_MEDIA_ACCESS_RIGTHS               0750
//#define OSAL_VOLATILE_OSAL_ACCESS_RIGTHS       0750 
#define OSAL_VOLATILE_OSAL_PRC_ACCESS_RIGTHS  01770


#define OSAL_GROUP_NAME    "eco_osal"
#define MEDIA_GROUP_NAME   "media"

#define PROTECTED_PAGE_SIZE         0x1000 /* 4KB*/


//#define REPLACE_SEM_WITH_MTX /* option for SINGLE_POCESS_OSAL, be careful behavior differs pthread_mutex_unlock only works
//                                if related thread is owner of the lock */

/*********************************************************************************************/
/*                   OSAL_GEN3 GEN3 ARM specific section                                     */
/*********************************************************************************************/
#ifdef GEN3ARM
//#define USE_DLT_IF                         // try to connect to DLT active  
#define VARIANT_S_FTR_ADIT_SUPPORTED         // ADIT exception handler IF
#define EXC_ARM                              // exception handling for ARM architecture
#define LIBUNWIND_USED                       // libunwind is used for callstack generation 
#define SHORT_TRACE_OUTPUT                   // trc interpretation needed for trace output
//#define OSAL_ERRMEM_TIMESTAMP              // set timestamp via OSAL to error memory for each entry
#define AM_BIN                               // ADIT automounter with API is available
#define SET_ERRMEM_TIME                      // Set time to ADIT errmem driver
#define PRM_LIBUSB_CONNECTION                // prm_usbpower.c (overcurrrent and undervoltage) module in PRM active
#define PRM_UDEV_CONNECTION                  // device recognition in PRM active
#define VOLATILE_DIR       "/run"            // directory used for temporary files
#define DEFAULT_REGISTRY_PATH  "/opt/bosch/base/registry" // directory search for registry files as default
#define SHM_BIGCCA_PATH    "/dev/shm/CCAMSG" // Path for CCA messages allocated with separate shred memory
#define DBUS_SUPPORT                         // activate DBUS communication for PRM and OSAL MQ
#define JOIN_ONLY_CHILD_PROCESS              // OSAL_s32ProcessJoin only for chiled processes useable
#define PROTECTED_OSAL_AREAS                 // protect shared memory regions against memory writer
#define USE_TRACE_IF                         // try to connect to Bosch Trace active  
#define ERRMEM_FILE   "/var/opt/bosch/dynamic/errmem"
#define ERRMEM_CSFILE "/run/OSAL/errmemcs"
#define USBLIB_NAME   "/lib/libusb-1.0.so"
#endif /* GEN3ARM */

/*********************************************************************************************/
/*                   OSAL_OSAL_GEN4 (64Bit) ARM specific section                                     */
/*********************************************************************************************/
#ifdef GEN4ARM
//#define USE_DLT_IF                          // try to connect to DLT active  
#define EXC_ARM                               // exception handling for ARM architecture
#ifdef POKY
#define VOLATILE_DIR       "/tmp"             // directory used for temporary files
#else
  #define VOLATILE_DIR       "/run"           // directory used for temporary files
  #define VARIANT_S_FTR_ADIT_SUPPORTED        // ADIT exception handler IF
  #define LIBUNWIND_USED                      // libunwind is used for callstack generation 
  #define AM_BIN                              // ADIT automounter with API is available
  #define SET_ERRMEM_TIME                     // Set time to errmem driver
  #define DBUS_SUPPORT                        // activate DBUS communication for PRM and OSAL MQ
  #define PRM_UDEV_CONNECTION                 // device recognition in PRM active
  #define PRM_LIBUSB_CONNECTION                // prm_usbpower.c (overcurrrent and undervoltage) module in PRM active
  #define USBLIB_NAME   "/lib64/libusb-1.0.so.0.1.0"
#endif
#define DEFAULT_REGISTRY_PATH  "/opt/bosch/base/registry" // directory search for registry files as default
#define WRITE_TO_STDOUT                       // write each exception handler erremm entry additional to standard out 
#define SHM_BIGCCA_PATH    "/dev/shm/CCAMSG"  // Path for CCA messages allocated with separate shred memory
#define PROTECTED_OSAL_AREAS                  // protect shared memory regions against memory writer
#define THREAD_CANCELATION_ACTIVE             // activate pthread_cancel for thread deletion 
#define JOIN_ONLY_CHILD_PROCESS               // OSAL_s32ProcessJoin only for chiled processes useable
#define USE_TRACE_IF                          // try to connect to Bosch Trace active  
#define ERRMEM_FILE   "/var/opt/bosch/dynamic/errmem"
#define ERRMEM_CSFILE "/run/OSAL/errmemcs"
#endif /* GEN4ARM */

/*********************************************************************************************/
/*                   ANDROID  Android specific section                                       */
/*********************************************************************************************/
#ifdef ANDROID
#define OSAL_BINDER_LIB                       // activate binder framework connection for OSAL
#define OSAL_BINDER_LIB_NAME "libosalbinder_so.so" //name of OSAL binder connection library
#define OSAL_SHM_MQ_FOR_LINUX_MQ              // use internal shared memory based MQ instead of POSIX MQ
#if defined __i386__ || defined __x86_64__
#define EXC_X86                               // exception handling for X86 architecture
#endif
#if defined __arm__ || defined __arm_64__ || defined __aarch64__
#define EXC_ARM                               // exception handling for ARM architecture
#endif
#define CS_GEN_VIA_OSAL                       // callstack generation via OSAL signal handler 
#define WRITE_TO_STDOUT                       // write each exception handler erremm entry additional to standard out 
#define VARIANT_S_FTR_ENABLE_ERRMEM_WRITE_TO_FILE // fix binding of errmem to file system 
#define VOLATILE_DIR       "/data/local/tmp" // directory used for temporary files 
#define SHM_BIGCCA_PATH    "/dev/ashmem/CCAMSG" // Path for CCA messages allocated with separate shred memory
#define DEFAULT_REGISTRY_PATH  "/system/etc/reg"// directory search for registry files as default
#define JOIN_ONLY_CHILD_PROCESS               // OSAL_s32ProcessJoin only for chiled processes useable
//#define LOAD_LIBUNWIND                      // load libunwind on demand  
//#define USE_DLT_IF                          // try to connect to DLT active     
#define ERRMEM_FILE   "/data/local/tmp/OSAL/errmem"
#define ERRMEM_CSFILE "/data/local/tmp/OSAL/errmemcs"
#endif /* ANDROID */

/*********************************************************************************************/
/*                   QNX specific section                                                    */
/*********************************************************************************************/
#ifdef QNX
#if defined __i386__ || defined __x86_64__
#define EXC_X86                               // exception handling for X86 architecture
#endif
#if defined __arm__ || defined __arm_64__ || defined __aarch64__
#define EXC_ARM                               // exception handling for ARM architecture
#endif
#define OSAL_SHM_MQ_FOR_LINUX_MQ              // for POSIX mqueue in QNX mqueue daemon has to be started -> adaptation of limits
//#define DBUS_SUPPORT                        // activate DBUS communication for PRM and OSAL MQ -> suitable daemon has to be started
#define CS_GEN_VIA_OSAL                       // callstack generation via OSAL signal handler 
#define WRITE_TO_STDOUT                       // write each exception handler erremm entry additional to standard out 
#define VOLATILE_DIR       "/tmp"             // directory used for temporary files 
#define DEFAULT_REGISTRY_PATH  "/usr/share/reg" // directory search for registry files as default
#define THREAD_CANCELATION_ACTIVE             // activate pthread_cancel for thread deletion 
#define OSAL_PTHREAD_CREATE_JOINABLE          // threads prepare for pthread_join
#define JOIN_ONLY_CHILD_PROCESS               // OSAL_s32ProcessJoin only for chiled processes useable
#define PROTECTED_OSAL_AREAS                  // protect shared memory regions against memory writer
#ifndef SINGLE_PROCESS_OSAL 
   #define USE_PRC_TID_COMBINED               // TID are store as combination of TID&PID to allow system unique identifiers
#endif
//#define USE_DLT_IF                          // try to connect to DLT active    
//#define SINGLE_PROCESS_OSAL                 // forbid shared memory usage no IPC via OSAL
#define OSAL_QNX_MQ                           // QNX MQ implementation active
#define ERRMEM_FILE   "/tmp/OSAL/errmem"
#define ERRMEM_CSFILE "/tmp/OSAL/errmemcs"
#endif /* ONX */

/*********************************************************************************************/
/*                   OSAL_LINUX_X86 specific section Ubuntu                                  */
/*********************************************************************************************/
#ifdef _LINUXX86MAKE_
//#define LIBUNWIND_USED                      // libunwind is used for callstack generation 
#define EXC_X86                               // exception handling for X86 architecture
#define CS_GEN_VIA_OSAL                       // callstack generation via OSAL signal handler 
#define WRITE_TO_STDOUT                       // write each exception handler erremm entry additional to standard out 
#define UBUNTU_ENV                            // nativ UBUNTU enviroment is used
//#define VARIANT_S_FTR_ENABLE_ERRMEM_WRITE_TO_FILE /*fix binding of errmem to file system */
#define VOLATILE_DIR       "/tmp"             // directory used for temporary files 
#define SHM_BIGCCA_PATH    "/dev/shm/CCAMSG"  // Path for CCA messages allocated with separate shred memory
#define DEFAULT_REGISTRY_PATH  "/opt/bosch/base/registry"       // directory search for registry files as default
#define NO_OSAL_EXIT_HDR                      // disable overwriting the exit handling from OSAL
#define PRM_UDEV_CONNECTION                   // device recognition in PRM active
//#define SIGTERM_HANDLER                     // enable special SIGTERM handler
#define JOIN_ONLY_CHILD_PROCESS               // OSAL_s32ProcessJoin only for chiled processes useable
#define PROTECTED_OSAL_AREAS                  // protect shared memory regions against memory writer
#define OSAL_SHM_MQ_FOR_LINUX_MQ              // use internal shared memory based MQ instead of POSIX MQ
#define ERRMEM_FILE   "/tmp/OSAL/errmem"
#define ERRMEM_CSFILE "/tmp/OSAL/errmemcs"
#endif /* OSAL_LINUX_X86 */

/*********************************************************************************************/
/*                   OSAL 64Bit OSAL_LINUX_X86 specific section                                     */
/*********************************************************************************************/
#ifdef _LINUXX86_64_
#define LIBUNWIND_USED                        // libunwind is used for callstack generation 
#define EXC_X86                               // exception handling for X86 architecture
#define CS_GEN_VIA_OSAL                       // callstack generation via OSAL signal handler 
#define WRITE_TO_STDOUT                       // write each exception handler erremm entry additional to standard out
#define UBUNTU_ENV                            // nativ UBUNTU enviroment is used
//#define VARIANT_S_FTR_ENABLE_ERRMEM_WRITE_TO_FILE  /*fix binding of errmem to file system */
#define VOLATILE_DIR       "/tmp"             // directory used for temporary files 
#define SHM_BIGCCA_PATH    "/dev/shm/CCAMSG"  // Path for CCA messages allocated with separate shred memory
#define NO_OSAL_EXIT_HDR                      // disable overwriting the exit handling from OSAL
//#define SIGTERM_HANDLER                     // enable special SIGTERM handler
#define DBUS_SUPPORT                          // activate DBUS communication for PRM and OSAL MQ
#define DBUS_MQ_SUPPORT                       // activate DBUS communication for OSAL MQ
#define JOIN_ONLY_CHILD_PROCESS               // OSAL_s32ProcessJoin only for chiled processes useable
#define PROTECTED_OSAL_AREAS                  // protect shared memory regions against memory writer
#define THREAD_CANCELATION_ACTIVE             // activate pthread_cancel for thread deletion 
//#define PRM_UDEV_CONNECTION                   // device recognition in PRM active
//#define SINGLE_PROCESS_OSAL                 // forbid shared memory usage no IPC via OSAL
#define OSAL_SHM_MQ_FOR_LINUX_MQ              // use internal shared memory based MQ instead of POSIX MQ
//#define OSAL_PTHREAD_CREATE_JOINABLE
#define DEFAULT_REGISTRY_PATH  "/opt/bosch/base/registry"       // directory search for registry files as default
#define ERRMEM_FILE   "/tmp/OSAL/errmem"
#define ERRMEM_CSFILE "/tmp/OSAL/errmemcs"
#endif /* _LINUXX86_64_ */


/*********************************************************************************************/
/*                   OSAL 64Bit Broxton specific section                                     */
/*********************************************************************************************/
#ifdef GEN4INTEL
#define EXC_X86                               // exception handling for X86 architecture
#define VARIANT_S_FTR_ADIT_SUPPORTED          // ADIT exception handler IF
#define LIBUNWIND_USED                        // libunwind is used for callstack generation 
#define WRITE_TO_STDOUT                       // write each exception handler erremm entry additional to standard out 
#define AM_BIN                                // ADIT automounter with API is available
#define SET_ERRMEM_TIME                       // Set time to errmem driver
#define VOLATILE_DIR       "/run"             // directory used for temporary files 
#define SHM_BIGCCA_PATH    "/dev/shm/CCAMSG"  // Path for CCA messages allocated with separate shred memory
#define DBUS_SUPPORT                          // activate DBUS communication for PRM and OSAL MQ
#define PROTECTED_OSAL_AREAS                  // protect shared memory regions against memory writer
#define THREAD_CANCELATION_ACTIVE             // activate pthread_cancel for thread deletion 
#define USE_TRACE_IF                          // try to connect to Bosch Trace active 
#define DEFAULT_REGISTRY_PATH  "/opt/bosch/base/registry" // directory search for registry files as default
#define PRM_UDEV_CONNECTION                   // device recognition in PRM active
#define ERRMEM_FILE   "/var/opt/bosch/dynamic/errmem"
#define ERRMEM_CSFILE "/var/opt/bosch/dynamic/errmemcs"
#endif /* GEN4INTEL */


/*********************************************************************************************/
/*********************************************************************************************/
/*********************************************************************************************/

/*********************************************************************************************/
/*                   OSAL_GEN3_SIM specific section                                          */
/*********************************************************************************************/
#ifdef OSAL_GEN3_SIM
#define EXC_X86                               // exception handling for X86 architecture
#define VARIANT_S_FTR_ADIT_SUPPORTED          // ADIT exception handler IF
#define LIBUNWIND_USED                        // libunwind is used for callstack generation 
#define SHORT_TRACE_OUTPUT                    // trc interpretation needed for trace output
#define AM_BIN                                // ADIT automounter with API is available
#define VOLATILE_DIR       "/run"             // directory used for temporary files 
#define SHM_BIGCCA_PATH    "/dev/shm/CCAMSG"  // Path for CCA messages allocated with separate shred memory
#define DBUS_SUPPORT                          // activate DBUS communication for PRM and OSAL MQ
#define JOIN_ONLY_CHILD_PROCESS               // OSAL_s32ProcessJoin only for chiled processes useable
#define PROTECTED_OSAL_AREAS                  // protect shared memory regions against memory writer
#define USE_TRACE_IF                          // try to connect to Bosch Trace active 
#define PRM_UDEV_CONNECTION                   // device recognition in PRM active
#define DEFAULT_REGISTRY_PATH  "/opt/bosch/base/registry" // directory search for registry files as default
#define ERRMEM_FILE   "/var/opt/bosch/dynamic/errmem"
#define ERRMEM_CSFILE "/var/opt/bosch/dynamic/errmemcs"
#endif /* OSAL_GEN3_SIM */

/*********************************************************************************************/
/*                   OSAL_GEN4_SIM specific section                                          */
/*********************************************************************************************/
#ifdef OSAL_GEN4_SIM
#define EXC_X86                               // exception handling for X86 architecture
#define VARIANT_S_FTR_ADIT_SUPPORTED          // ADIT exception handler IF
#define LIBUNWIND_USED                        // libunwind is used for callstack generation 
#define AM_BIN                                // ADIT automounter with API is available
#define VOLATILE_DIR       "/run"             // directory used for temporary files 
#define SHM_BIGCCA_PATH    "/dev/shm/CCAMSG"  // Path for CCA messages allocated with separate shred memory
#define DBUS_SUPPORT                          // activate DBUS communication for PRM and OSAL MQ
#define JOIN_ONLY_CHILD_PROCESS               // OSAL_s32ProcessJoin only for chiled processes useable
#define PROTECTED_OSAL_AREAS                  // protect shared memory regions against memory writer
#define THREAD_CANCELATION_ACTIVE             // activate pthread_cancel for thread deletion 
#define USE_TRACE_IF                          // try to connect to Bosch Trace active 
#define PRM_UDEV_CONNECTION                   // device recognition in PRM active
#define DEFAULT_REGISTRY_PATH  "/opt/bosch/base/registry"       // directory search for registry files as default
#define ERRMEM_FILE   "/var/opt/bosch/dynamic/errmem"
#define ERRMEM_CSFILE "/var/opt/bosch/dynamic/errmemcs"
#endif /* OSAL_GEN3_SIM */


/*********************************************************************************************/
/*   OSAL_ENABLE_CUSTOM_CONF specific section  requeted by OSAL applcation developer to      */
/*   overwrite existing or create own configuration                                          */
/*********************************************************************************************/
#ifdef OSAL_ENABLE_CUSTOM_CONF
#include "OsalCustomConf.h"
#endif /* OSAL_ENABLE_CUSTOM_CONF */  

/*********************************************************************************************/
/*********************************************************************************************/
/*********************************************************************************************/


/*********************************************************************************************/
/*                   Generic OSAL resource configuration                                     */
/*********************************************************************************************/
/* defines for OSAL Resources */
#define SEM_MEM_RES           10            /* Max number of semaphores useable for memory pools  */

#ifdef SINGLE_PROCESS_OSAL
#define MAX_LINUX_PROC         1   /* maximum number of processes belong to this configuration*/
#define MAX_OSAL_THREADS      50
#define MAX_OSAL_TIMER        50
#define MAX_OSAL_MSG_QUEUE    50
#define MAX_OSAL_SHARED_MEM   70   // -> 50 MAX_OSAL_MSG_QUEUE
#define MAX_OSAL_SEMAPHORES  150   // -> 50 MAX_OSAL_MSG_QUEUE
#define MAX_OSAL_MUTEX        60   // -> 50 MAX_OSAL_MSG_QUEUE
#define MAX_OSAL_EVENTS       50   // -> 50 MAX_OSAL_MSG_QUEUE

#else //SINGLE_PROCESS_OSAL
/*********************************************************************************************/
#ifdef QNX
#define MAX_LINUX_PROC        10   /* maximum number of OSAL processes in the a QNX system*/
#define MAX_OSAL_THREADS     100
#define MAX_OSAL_TIMER       100
#define MAX_OSAL_MSG_QUEUE    50

#ifdef OSAL_SHM_MQ_FOR_LINUX_MQ
#define MAX_OSAL_EVENTS      MAX_OSAL_MSG_QUEUE + 50   
#define MAX_OSAL_SHARED_MEM  MAX_OSAL_MSG_QUEUE + 20
#ifdef SHM_MQ_USE_SEM
#define MAX_OSAL_MUTEX       50
#define MAX_OSAL_SEMAPHORES  MAX_OSAL_MSG_QUEUE + MAX_OSAL_MSG_QUEUE + 200   
#else
#define MAX_OSAL_MUTEX       MAX_OSAL_MSG_QUEUE + 50
#define MAX_OSAL_SEMAPHORES  MAX_OSAL_MSG_QUEUE + 200   
#endif
#else //OSAL_SHM_MQ_FOR_LINUX_MQ
#define MAX_OSAL_EVENTS      50   
#define MAX_OSAL_SEMAPHORES  200  
#define MAX_OSAL_SHARED_MEM  20
#define MAX_OSAL_MUTEX       50
#endif //OSAL_SHM_MQ_FOR_LINUX_MQ

/*********************************************************************************************/
#elif defined ANDROID
#define MAX_LINUX_PROC        10   /* maximum number of OSAL processes in the a Android system*/
#define MAX_OSAL_THREADS     100
#define MAX_OSAL_TIMER       100
#define MAX_OSAL_MSG_QUEUE    50

#ifdef OSAL_SHM_MQ_FOR_LINUX_MQ
#define MAX_OSAL_EVENTS      MAX_OSAL_MSG_QUEUE + 50   
#define MAX_OSAL_SHARED_MEM  MAX_OSAL_MSG_QUEUE + 20
#ifdef SHM_MQ_USE_SEM
#define MAX_OSAL_MUTEX       50
#define MAX_OSAL_SEMAPHORES  MAX_OSAL_MSG_QUEUE + MAX_OSAL_MSG_QUEUE + 200   
#else
#define MAX_OSAL_MUTEX       MAX_OSAL_MSG_QUEUE + 50
#define MAX_OSAL_SEMAPHORES  MAX_OSAL_MSG_QUEUE + 200   
#endif
#else //OSAL_SHM_MQ_FOR_LINUX_MQ
#define MAX_OSAL_EVENTS      50   
#define MAX_OSAL_SEMAPHORES  200  
#define MAX_OSAL_SHARED_MEM  20
#define MAX_OSAL_MUTEX       50
#endif //OSAL_SHM_MQ_FOR_LINUX_MQ

#else
/*********************************************************************************************/
#define MAX_LINUX_PROC       100              /* maximum number of processes start via OSAL */
#define MAX_OSAL_THREADS     600
#define MAX_OSAL_TIMER       400
#define MAX_OSAL_MSG_QUEUE   300

#ifdef OSAL_SHM_MQ_FOR_LINUX_MQ
#define MAX_OSAL_EVENTS      MAX_OSAL_MSG_QUEUE + 500   
#define MAX_OSAL_SHARED_MEM  MAX_OSAL_MSG_QUEUE + 50
#ifdef SHM_MQ_USE_SEM
#define MAX_OSAL_MUTEX       100
#define MAX_OSAL_SEMAPHORES  MAX_OSAL_MSG_QUEUE + MAX_OSAL_MSG_QUEUE + 1400   
#else
#define MAX_OSAL_MUTEX       MAX_OSAL_MSG_QUEUE + 100
#define MAX_OSAL_SEMAPHORES  MAX_OSAL_MSG_QUEUE + 1400
#endif
#else  //OSAL_SHM_MQ_FOR_LINUX_MQ
#define MAX_OSAL_EVENTS      500
#define MAX_OSAL_SEMAPHORES  1400
#define MAX_OSAL_SHARED_MEM  50
#define MAX_OSAL_MUTEX       100
#endif  //OSAL_SHM_MQ_FOR_LINUX_MQ


/*#ifdef REPLACE_SEM_WITH_MTX	
#define MAX_OSAL_SEMAPHORES  200
#define MAX_OSAL_MUTEX       MAX_OSAL_SEMAPHORES  // -> semaphores mapped to mutex	
#else
#define MAX_OSAL_SEMAPHORES 1400
#endif*/

#endif

#endif // SINGLE_PROCESS_OSAL

#ifdef SEM_EV
#define CONF_DEP_LOCKS    MAX_OSAL_EVENTS *2 /*locks needed for event implementation based on semaphores */
#else //SEM_EV
#define CONF_DEP_LOCKS    0 
#endif //SEM_EV

#define MAX_OSAL_LOCK  MAX_OSAL_SEMAPHORES + CONF_DEP_LOCKS + (C_MAX_JOBS + 1) + SEM_MEM_RES

/* defines for Block Pools defult sizes, can be overwritenn in osal.reg */ 
#if defined ANDROID || defined QNX || defined SINGLE_PROCESS_OSAL
#define DEVDECS_BLOCKCOUNT     50  // number of device descriptor in OSAL mempool
#define FILEDECS_BLOCKCOUNT    20  // number of file descriptors in OSAL mempool
#define MQHANDLE_BLOCKCOUNT    MAX_OSAL_MSG_QUEUE  + 100 // number of OSAL MQ handles in OSAL mempool
#define EVDAT_BLOCKCOUNT       MAX_OSAL_EVENTS     + 100
#define SEMDAT_BLOCKCOUNT      MAX_OSAL_SEMAPHORES + 200
#else
#define DEVDECS_BLOCKCOUNT    800  // number of device descriptor in OSAL mempool
#define FILEDECS_BLOCKCOUNT   256  // number of file descriptors in OSAL mempool
#define MQHANDLE_BLOCKCOUNT   1500 // number of OSAL MQ handles in OSAL mempool
#define EVDAT_BLOCKCOUNT      800
#define SEMDAT_BLOCKCOUNT     2000
#endif

#define MQSTDDAT_BLOCKCOUNT   MAX_OSAL_MSG_QUEUE  // maximum number of OSAL MQ itself

#define DEVDECS_BLOCKSIZE    sizeof(OsalDeviceDescriptor)
#define FILEDECS_BLOCKSIZE   sizeof(OSAL_tfdIO)
#define MQHANDLE_BLOCKSIZE   sizeof(tMQUserHandle)
#define EVDAT_BLOCKSIZE      sizeof(tEvHandle)
#define SEMDAT_BLOCKSIZE     sizeof(tSemHandle)
/*********************************************************************************************/

#else
#error OsalConf.h included several times
#endif
