
#include "OsalConf.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "Linux_osal.h"

#include "minispm.h"

#ifdef __cplusplus
extern "C" {
#endif

void vStartCcaApplications(OSAL_tSemHandle hAllNormalEvent = OSAL_C_INVALID_HANDLE, const char *szApps = NULL);
void vTerminateCcaApplications();
void vPauseApplications(OSAL_tSemHandle hAllDoneEvent = OSAL_C_INVALID_HANDLE);
void vNormalizeApplications(OSAL_tSemHandle hAllDoneEvent = OSAL_C_INVALID_HANDLE);


OSAL_tSemHandle gl_hSem = OSAL_C_INVALID_HANDLE;
tS32 gl_s32SemCreated = OSAL_ERROR;
char gl_semName[32];

extern "C" tS32 bOverrideOsalConf(char* Path);


int main(int argc,char** argv) 
{
    int c=0;
    char* pRegistryPah = NULL;
    char* pStartList   = NULL;
	tBool bTerminate = FALSE;

    while ((c = getopt (argc, argv, "r:a:t")) != -1)
         switch (c)
           {
           case 'r':
             pRegistryPah = optarg;
             break;
          case 'a':
             pStartList = optarg;
             break;
          case 't':
             TraceString("Process will terminate at end");
             bTerminate = TRUE;
             break;
           case '?':
             if (optopt == 'r')
               fprintf (stderr, "Option -%d requires an argument (registry file).\n", optopt);
             else if (isprint (optopt))
               fprintf (stderr, "Unknown option `-%c'.\n", optopt);
             else
               fprintf (stderr, "Unknown option character `\\x%x'.\n", optopt);
             return 1;
           default:
             abort ();
    }

   /*prepare registry */
// bOverrideOsalConf("/dev/root/opt/bosch/base/registry/osal.reg")
   if(pRegistryPah)
   {
      TraceString("Process %s registry file",pRegistryPah);
      bOverrideOsalConf(pRegistryPah);
   }
   snprintf(gl_semName, 32, "WSEM%X%X",OSAL_ThreadWhoAmI(), OSAL_ProcessWhoAmI());
   gl_s32SemCreated = OSAL_s32SemaphoreCreate(gl_semName, &gl_hSem, 0);
   
   OSAL_tSemHandle endlessWaitSemaphore;
   OSAL_s32SemaphoreCreate("MiniSpmEndlessWait", &endlessWaitSemaphore, 0);
   if (gl_s32SemCreated == OSAL_ERROR) 
   {
      TraceString("MiniSpmLinux: Could not create Semaphore, code=%u", OSAL_u32ErrorCode());
   }

   if(pStartList)
   {
      TraceString("Start CCA Apps %s",pStartList);
   }
   else
   {
      TraceString("Start CCA Apps No App in List");
   }
   
   vStartCcaApplications(gl_hSem,pStartList);

    OSAL_s32ThreadWait(10000);
    vPauseApplications(gl_hSem);
	
    OSAL_s32ThreadWait(10000);
    vNormalizeApplications(gl_hSem);
	
 	
    if (gl_s32SemCreated == OSAL_OK) 
    {
       if(bTerminate)
       {		   
          OSAL_s32ThreadWait(10000);
          vTerminateCcaApplications();
          OSAL_s32ThreadWait(10000);
          OSAL_tEventHandle  hEvShutdown = 0;
          if (OSAL_s32EventOpen("GAW_SHATDOWN", &hEvShutdown) == OSAL_OK)
          {
             OSAL_s32EventPost(hEvShutdown, 0x00000001, OSAL_EN_EVENTMASK_OR);
             OSAL_s32EventClose(hEvShutdown);
          }
       }
       else
       {
          OSAL_s32SemaphoreWait(endlessWaitSemaphore, OSAL_C_U32_INFINITE);
       }
    }
    else
    {
      TraceString("MiniSpmMain: can't start MiniSpm, please check posix message queue setting.");
      TraceString("see https://inside-wiki.bosch.com/confluence/display/cmaicfnavi/ASF+Development+Setup#ASFDevelopmentSetup-LinuxSetupUbuntu12.1032bit");
    }
	return 0;
}


#ifdef __cplusplus
}
#endif
