/************************************************************************
| FILE:         inc.h
| PROJECT:      platform
| SW-COMPONENT: INC
|------------------------------------------------------------------------------
| DESCRIPTION:  This is the header file for the INC user-space interface. It
|               shall be included by all user-space INC applications.
|
|------------------------------------------------------------------------------
| COPYRIGHT:    (c) 2012 Robert Bosch GmbH
| HISTORY:
| Date      | Modification               | Author
| 17.12.12  | Initial revision           | tma2hi
| 07.10.16	| Support for TCP/IP		 | Venkatesh Parthasarathy
|			| based Gen4 INC			 |
| 29.05.17  | Gen4lsim AF_INET Support   | Dharmender Sharma
| 02.06.17  | Gen4lsim AF_INET Support   | Ravi Kiran Gundeti
| 24.09.18  | Use appropriate AF_INC	 | Kiran Manju Devaraje
|	    | depending on Kernel version|
| --.--.--  | ----------------           | -------, -----
|
|*****************************************************************************/
#ifndef INC_H
#define INC_H

#ifdef __cplusplus
extern "C" {
#endif

#include <linux/version.h>

#ifdef OSAL_GEN3_SIM           /* For Gen3 Simulator */
	#define AF_INC 41
	#define AF_BOSCH_INC_ADR      AF_INET
	#define AF_BOSCH_INC_AUTOSAR  AF_INC
#elif defined OSAL_GEN4_SIM    /* For Gen4 Simulator */
		#if LINUX_VERSION_CODE >= KERNEL_VERSION(4,18,0)
			#define AF_INC 45
		#elif LINUX_VERSION_CODE >= KERNEL_VERSION(4,14,0)
			#define AF_INC 44
		#else
			#define AF_INC 43
		#endif
	#define AF_BOSCH_INC_ADR      AF_INET
	#define AF_BOSCH_INC_AUTOSAR  AF_INC
#elif defined OSAL_GEN4        /* For Gen4 */  
		#if LINUX_VERSION_CODE >= KERNEL_VERSION(4,18,0)
			#define AF_INC 45
		#elif LINUX_VERSION_CODE >= KERNEL_VERSION(4,14,0)
			#define AF_INC 44
		#else
			#define AF_INC 43
		#endif
	#define AF_BOSCH_INC_AUTOSAR  AF_INET
	#define AF_BOSCH_INC_ADR      AF_INC              /* AF_INC for external ADR3 */
#else                          /* For Gen3 */
	#define AF_INC 41
	#define AF_BOSCH_INC_ADR      AF_INC
	#define AF_BOSCH_INC_AUTOSAR  AF_INC
#endif

#define AF_BOSCH_INC_LINUX    AF_INET

#ifdef __cplusplus
}
#endif

#endif /* INC_H */