#ifndef __WRITE_PROFILER__
#define __WRITE_PROFILER__
#define _XOPEN_SOURCE
#define _GNU_SOURCE
/************************************************* Headers *************************************/
#include <stdio.h>
#include <stdlib.h>
#include <libgen.h>
#include <string.h>
#include <malloc.h>
#include <errno.h>
#include <fcntl.h>           /* For O_* constants */
#include <sys/stat.h>        /* For mode constants */
#include <sys/types.h>
#include <mqueue.h>
#include <pthread.h>
#include <sched.h>
#include <signal.h>
#include <unistd.h>
#include <time.h>
#include <semaphore.h>
#include <json-c/json.h>
#include <errno.h>
#include <dirent.h>
#include "dbus_interface.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
/************************************************* Defines *************************************/
//#define TEST_UBUNTU
//#define DEBUG_PRINT
//#define INFO_PRINT
//#define WARN_PRINT

/*enable this macro when required for debugging */
//#define DUMP_TRACE_INFO
#ifdef TEST_UBUNTU
#define PROFILER_DATA_PATH "/tmp"

#define PROFILER_DEBUG_INFO				PROFILER_DATA_PATH"/profiler_debug.log"
#define JSON_CONFIG_FILE				PROFILER_DATA_PATH"/emmc-writeProfiler.cfg"
#define BLK_COUNT_PRESISTENT_FILE		PROFILER_DATA_PATH"/blkcount_%s.txt"
#define TOT_BLK_COUNT_PERSISTENT_FILE	PROFILER_DATA_PATH"/Total_blkcount.txt"
#define BLK_COUNT_PRESISTENT_FILE_TMP	PROFILER_DATA_PATH"/blkcount_%s_dummy.txt"

#define BLKIO_PATH_NATIVE    			"/sys/fs/cgroup/blkio/blkio.throttle.io_service_bytes"
#define BLKIO_PATH_CONTAINER   			"/sys/fs/cgroup/blkio/lxc/%s/blkio.throttle.io_service_bytes"
#define CMDLINE 						"/proc/cmdline"
#define DISKSTATS 						"/proc/diskstats"
#define	LOCATION_BLK_DEV_NAME			"/dev/sda"
#define	LOCATION_PARTITION				"/dev/mmcblkXpN"
#define ROOT_DEVICE_NODE				"cat /proc/diskstats|grep -w sda | awk '{print $1,$2}'"
#define	CMD_BLK_CNT_PARITION			"cat /proc/diskstats|grep -w '%s'|awk '{print $10}'"
#define PERSISTENT_FILE_DATA_FORMAT  "Date:%02d/%02d/%04d Blk_Count %llu TotalWriteBytes %llu\n"

#else
#define PROFILER_DATA_PATH "/var/opt/bosch/persistent/excessive_write"
#define PROFILER_DEBUG_INFO				PROFILER_DATA_PATH"/profiler_debug.log"
#define JSON_CONFIG_FILE				PROFILER_DATA_PATH"/emmc-writeProfiler.cfg"
#define BLK_COUNT_PRESISTENT_FILE		PROFILER_DATA_PATH"/blkcount_%s.txt"

#define PERSISTENT_FILE_DATA_FORMAT  "Date:%02d/%02d/%04d Blk_Count %llu TotalWriteBytes %llu\n"
#define TOT_BLK_COUNT_PERSISTENT_FILE	PROFILER_DATA_PATH"/Total_blkcount.txt"
#define BLK_COUNT_PRESISTENT_FILE_TMP	PROFILER_DATA_PATH"/blkcount_%s_dummy.txt"
#define BLKIO_PATH_NATIVE    			"/sys/fs/cgroup/blkio/blkio.throttle.io_service_bytes"
#define BLKIO_PATH_CONTAINER   			"/sys/fs/cgroup/blkio/%s/blkio.throttle.io_service_bytes"
#define BLK_DEV_THROTTLING_PATH			"grep blkio /proc/$(lxc-info -n %s | grep PID | awk {'print $2'})/cgroup | awk -F: '{print $NF}'"
#define CMDLINE 						"/proc/cmdline"
#define DISKSTATS 						"/proc/diskstats"
#define	LOCATION_BLK_DEV_NAME			"/dev/mmcblk"
#define	LOCATION_PARTITION				"/dev/mmcblkXpN"
#define ROOT_DEVICE_NODE				"ls -l /dev/mmcblk%d | awk '{print $5 $6}'"
//#define ROOT_DEVICE_NODE				"cat /proc/diskstats|grep -w mmcblk$((`mount| grep -w / |awk {'print $1'}|tr -d '/dev/mmcblk'|cut -d'p' -f1`)) | awk '{print $1,$2}'"
#define	CMD_BLK_CNT_PARITION			"cat /proc/diskstats|grep -w '%s'|awk '{print $10}'"
#define EXCESSIVEWP_EVTQUEUE_NAME  "/EXCESSIVEWP_EVTQUEUE"

#endif
#define	ERRMEM_ENTRY					"INFO::ExcessiveWrite {Location: %s}{Device:%s}{Event Name:%s}{Duration:%d}{Threshold:%lld}{ExcessiveWriteBytes:%lld}\n"
#define	TOTAL_BLK_CNT_READ_PATTERN		"%32s : %016llu\n"
#define	TOTAL_BLK_CNT_ENTRY_PATTERN		"%.32s : %016llu\n"
#define DBUS_NAME 						"com.bosch.monitor.excessive_write.emmc"
#define DBUS_OBJECT_PATH 				"/org/monitor/excessive_write/emmc"
#define SYS_DIR_MMCHOST_PATH	 		"/sys/class/mmc_host/"
#define NUM_NANOSEC_PER_SEC 		    (1000*1000*1000)


/* The 10th element in /proc/diskstats ouput (i.e."sectors written") is the value
is of our interest. */

#define DISKSTATS_CMD_FILE "/proc/diskstats"

#define DISKSTATS_READ_PATTERN "%d %d %s %d %d %d %d %d %d %llu %d %d %d %d"

#ifdef DUMP_TRACE_INFO
#define DEBUG(X,...)					{\
											if( fpTraceFile != NULL )\
												fprintf( fpTraceFile, X, ##__VA_ARGS__ );\
											else\
												printf (X, ##__VA_ARGS__) ;\
										}
#define ERROR(X,...)					{\
											if( fpTraceFile != NULL )\
												fprintf( fpTraceFile, X, ##__VA_ARGS__ );\
											else\
												printf (X, ##__VA_ARGS__) ;\
										}
#define TRACE_OPEN(__H__)				{\
											if( NULL == __H__ ) \
											{\
												__H__ = fopen(PROFILER_DEBUG_INFO,MODE_ARW);\
												if( NULL == __H__ )\
													eMMC_ExcessiveWP_WriteErrmem("ExcessiveProfiler:Debug Fopen Fails!!");\
											}\
										}

#define TRACE_CLOSE(__H__)				{\
											if( NULL != __H__ ) {\
												fflush( __H__ );\
												fclose(__H__);}\
											__H__= NULL;\
										}
#define TRACE_SYNC(__H__)				{\
											if( NULL != __H__ )\
											eMMC_ExcessiveWP_SyncData(__H__);\
										}
#else
#define DEBUG(X,...)					/*nop*/
#define ERROR(X,...)
#endif

#define MODE_RO							"r"
#define MODE_W							"w"
#define MODE_RW							"r+"
#define MODE_ARW						"a+"
#define LXC_NAME_PREFIX					"lxc-"
#define LXC_NAME_SPLIT					'-'
#define NODE_LENGTH       				32
#define SHELL_CMD_BYTES   				64
#define ERRME_BUFFER_EXTRA_SIZE			128
#define BLKIO_LXC_PATH					128
#define CFG_NAME_LEN					32
#define DBUS_NAME_LEN					64
#define CFG_PERSISTENT_PATN_LEN			256
#define SECONDS_PER_MIN					60
#define	PERSISTENT_WRITE_INTERVAL_SEC	SECONDS_PER_MIN
#define	CURRENT_DATE_CHECK_TIME_SEC		120
#define	PROFIER_SUPPORT_START_DATE		2017
#define	PROFIER_SYSTEM_BASE_DATE		1900
#define	PROFIER_SYSTEM_BASE_YEAR		70
#define	DAY_DIFF_ONE_DAY_FORWARD		1
#define	DAY_DIFF_ONE_DAY_BACKWARD		-1
#define MMC_CARD_INFO_ACCESS_ERROR      (-1)
#define ECSD_ACCESS_ERROR               (-2)
#define STATUS_REG_ACCESS_ERROR         (-3)
#define REG_PATH_UNAVAIL                (-4)
#define MMC_HOST_INFO_ACCESS_ERROR      (-5)
#define MAXLENGTH                   	(255)
#define NUMBER_OF_FIELDS_IN_DISKSTATS    14
#define COVERT_FROM_MILLISEC_TO_SEC		(1000)  /*Divide, time (in ms) by 1000 to convert to seconds */
#define BLKCNT_UPDATE_FREQUENCY_IN_MS	5000

/************************************************* Typedefs *************************************/
typedef char tChar;
typedef unsigned char tU8;
typedef signed char tS8;
typedef const char * tCString;
typedef unsigned char tBool;
typedef unsigned short tU16;
typedef signed short tS16;
typedef int tS32;
typedef unsigned int tU32;
typedef void * tPVoid;

/************************************************* Enums *************************************/
/*Values to find the monitor device type */
typedef enum MonitorDevType
{
	MONITOR_CONTAINER,
	MONITOR_BLK_DEVICE,
	MONITOR_BLK_PARTITION,
	MONITOR_UNKNOWN
}MonitorType;

/*Values of representes event notifications */
typedef enum
{
	EVT_LCM_NOTHING=0,
	EVT_LCM_LOAD_PERSISTENCY=1,
	EVT_LCM_SAVE_PERSISTENCY=2,
}lcm_evt_t;


/*Values of representes the current power cycle type */
typedef enum enumPowerCycleType
{
	PROFILER_NEW_STARTUP,
	PROFILER_NEW_POWERCYCLE,
	PROFILER_NEW_POWERCYCLE_IN_SAME_DAY,
	PROFILER_NEW_POWERCYCLE_DAY_BACKWARD
}PowerCycleType;

/*Values of representes Thread States */
typedef enum enumThreadState
{
	PROFILER_THREAD_LCM_LOAD_PERSISTENCY,
	PROFILER_THREAD_WAIT_FOR_LCM_LOAD_PERSISTENCY,
	PROFILER_THREAD_LCM_SAVE_PERSISTENCY,
	PROFILER_THREAD_LCM_SAVING_PERSISTENCY,
	PROFILER_THREAD_SIGNAL_COUGHT,
	PROFILER_THREAD_RUNNING,
	PROFILER_THREAD_STOPPED,
	PROFILER_THREAD_TERMINATED,
	PROFILER_THREAD_EXITED,
}MonitorThreadState;
/************************************************* Structures *************************************/
typedef struct structDBusInfo
{
	pthread_t 						DbusThrdhandle;
	OrgMonitorExcessive_writeEmmc 	*g_proxy;
	GMainLoop 						*main_loop;
	guint 							watcher_id;
	tChar							DBusName [ DBUS_NAME_LEN ];
	tS32							IsBusAcquired;
}DBusInfo;
/* Structure to holds the ring buffer details */
typedef struct node
{
	struct tm date; /* Current date */

	unsigned long long blk_count;                             /* Current block count (Bytes written on the device or cgroups ) */
	unsigned long long total_write_cycles_count;              /* Cumulative write bytes of previous cycle from day-1*/

	struct node *next;
	struct node *prev;
}node;

/* Structure to holds the trigger point details */
typedef struct write_profiler_config_info
{
	tChar 		name[CFG_NAME_LEN];                           /* trigger point name. Limited to 32 bytes */
	tS32 		duration;                           /* monitor Duration */
	long long 	threshold;                          /* limits of write to per the give duration*/
	struct write_profiler_config_info *next;   /* self-reference structure to the trigger point */
}write_profiler_params;

/* Structure to holds the Location details */
typedef struct write_monitor
{
	write_profiler_params 	*monitor;           /* This fields holds the list of trigger point to the respective location */
	struct write_monitor	*next;              /* self-reference structure filed for location structure */
	node   					*ringnode;          /* ring buffer per location */
	tChar 					unique_name[CFG_NAME_LEN];    /* Name of the location. Name is limited to 32 Bytes */
	tChar 					location[CFG_NAME_LEN];		/* Location to monitor(i.e block device or container). Location is limited to 32 Bytes */
	tU16					TracePointCnt;      /* This variable holds the no. of trigger point available to the respective location */
	tU16					MaxDuration;        /* Maximum duration among  the available trigger points per location */
	unsigned long long  	blockcnt;           /* No. of bytes written to the respective location(either on cgroups or block device) */
	unsigned long long 		PrevBlkcount;       /* Last entry block count (Bytes written on the device or cgroups ) */
	PowerCycleType			PowerCycleStats;    /* Cumulative write count (in bytes ) from the day-1 */
	MonitorThreadState		MonitorThrdState;	/* Current thread state */
	tS32  					DataWriteInterval;	/* This field Holds the Persistent file write interval in seconds */
	long long				CumulativeBlkCount;	/* This field Holds the Persistent file write interval in seconds */
	pthread_t 				LocationThread;		/* Thread Handle */
	tS32					ErrmemNotification; /* This is the control variable to route the excessive write notification to errmem*/
	tU32 evt_state;
	sem_t eventObj;
	sem_t AckeventObj;
	DBusInfo				*trDbusInfo;
}monitor_blkio;
/* Structure to hold the cfg file and block count info */
typedef struct
{
	tChar 			PersistentDataLocation[CFG_PERSISTENT_PATN_LEN];            /* This fields holds the location to store the persistent data. Path is limited to 256Bytes */
	DBusInfo		trDbusInfo;
	monitor_blkio 	*blkio;                          /* Pointer to the Location structure */
	tS32  			PersistentDataSaveCycle;                /* This field indicates either the persistent date has been store or not */
	tS32			MonitorLocationCnt;                     /* This variable have the no. of location available in the cfg file */
	tS32			s32NodesToSave;                         /* This vairable is used to indicate how many notes are saved*/
	tS32			ErrmemNotification;                     /* This is the control variable to route the excessive write notification to errmem*/
	mqd_t evt_lcm; /* Event Notification*/
	sem_t ackevent_lcm;

}monitor_global_info;

#ifdef DUMP_TRACE_INFO
FILE *fpTraceFile;
#endif
sem_t RestrictSharedAccessSem;


tBool eMMC_ExcessiveWP_CheckWatchWindow(monitor_blkio *blkioLocationInfo);
tBool eMMC_ExcessiveWP_GetContainerName(tChar *Location, tChar* ContainerName);
node* eMMC_ExcessiveWP_CreateNode( void );
tBool eMMC_ExcessiveWrite_PopulateCriticalNodes (monitor_blkio *blkioLocationInfo, unsigned long long BlkCount, struct tm CurrentDate);
tPVoid	eMMC_ExcessiveWP_AllocateMemory ( size_t size );
void eMMC_ExcessiveWP_SyncData (FILE *fptr);
tS32 eMMC_ExcessiveWP_ReadLineInPresistentFile (FILE *fp, node* ringbuffer );
void	eMMC_ExcessiveWP_DeallocateMemory ( tPVoid ptr );

tPVoid	eMMC_ExcessiveWrite_DbusThread ( tPVoid Arg );


void eMMC_ExcessiveWP_CreateMsgObj(mqd_t *evt_q,const char*name);
tS32 eMMC_ExcessiveWP_SendMsg (mqd_t evt_q,tU32 data,tS32 timeout);

/* timeout in msec */
tS32 eMMC_ExcessiveWP_ReceiveMsg (mqd_t evt_q,tU32 *msg,tS32 timeout);
tS32 eMMC_ExcessiveWP_DeleteMsgObj (mqd_t evt_q,const char*name);

tS32 createEvent(sem_t *pevHandle);
tS32 postEvent(sem_t *eventObj);
tS32 waitEvent(sem_t *eventObj,tS32 timeout);

tBool eMMC_ExcessiveWP_ParseConfigFile (monitor_global_info *stcfgInfo );

tPVoid	eMMC_ExcessiveWP_MonitorThread ( tPVoid LocationInfo );

tBool eMMC_ExcessiveWriteSendDbusNotification( write_profiler_params *TriggerEvent, long long ExcessiveBytes,monitor_blkio *blkioLocationInfo);
void eMMC_ExcessiveWP_DeleteRingBuffer(monitor_blkio *blkioLocationInfo);
tS32 eMMC_ExcessiveWP_CompareDates(struct tm previous_time,struct tm current_time);
tVoid eMMC_ExcessiveWP_ObtainPresentDate ( struct tm *date);




#endif /*__WRITE_PROFILER__*/
