#ifndef PLATFORM_APP_MANAGER_H_
#define PLATFORM_APP_MANAGER_H_


#ifdef __cplusplus
extern "C" {
#endif


#define PLF_LOG_DEBUG 20
#define PLF_LOG_INFO 21
#define PLF_LOG_WARN 22
#define PLF_LOG_ERROR 23
#define PLF_LOG_FATAL 24

#define ERRSTR_MAXLENGTH (512)
#define DEBUG_FILE "refresh_debug.txt"
#include "types.h"

void InitApplicationLogging(tBool s8LogDebugMsgs, tPC8 s8DebugFilePath);
void application_tearDown();
void ReportApplicationStartup();
void log_message(int loglev,tPC8 pc8FileName,tS32 s32LineNo, tPC8 pc8FuncName,tPC8 message,...);
void vSetGroupId(tPC8 pc8FilePath);
void vRemoveFile(tPC8 filePath);

#ifdef __cplusplus
}
#endif

#define log_debug(...)   log_message(PLF_LOG_DEBUG,__FILE__,__LINE__,__func__,__VA_ARGS__)
#define log_info(...)    log_message(PLF_LOG_INFO,__FILE__,__LINE__,__func__,__VA_ARGS__)
#define log_warn(...)    log_message(PLF_LOG_WARN,__FILE__,__LINE__,__func__,__VA_ARGS__)
#define log_error(...)   log_message(PLF_LOG_ERROR,__FILE__,__LINE__,__func__,__VA_ARGS__)
#endif


