#ifndef NVM_REFRESH_H_
#define NVM_REFRESH_H_

#include "types.h"

struct nvm_info
{
	struct nvm_info *next;
	tU8 u8DeviceCount;
	tPS8 ps8DeviceName;
	tPS8 ps8ConfigFileDir;
	tPS8 ps8MetaDataFileDir;
};

typedef struct
{
	struct nvm_info *nvm_device_details;
	tBool u8EnableDebug;
	tPS8 s8logFilePath;
	tU8 uSleepInSec;
	tBool s8ForceRefresh;
}refresh_args;

tS32 s32Perform_eMMCRefresh(refresh_args *arguments);

#define REFRESH_INITIAL_WAIT_TIME		(120) // Time in seconds

#endif
