/*
 * eMMC_Refresh.h
 *
 *  Created on: Jul 4, 2019
 *      Author: RAP5COB
 */
#ifndef EMMC_REFRESH_H_
#define EMMC_REFRESH_H_
#ifndef _GNU_SOURCE
	#define _GNU_SOURCE
#endif
#ifndef __USE_LARGEFILE64
	#define __USE_LARGEFILE64
#endif
#include "types.h"
#include <time.h>
#define CHECKSUM_COUNT              (8)
#define EXT_CSD_BKOPS_EN			(163)
#define REFRESH_INPROGRESS          (0x00)  // possible value for  u32Refresh_state
#define TERMINATED                  (0x02)  // possible value for  u32Refresh_state
#define REFRESHCOUNT_INITMAGIC      (0xDEADDEAD)
#define CHECKSUM_COUNT              (8)     // number of checksum fields in metadata (struct and file)
#define METADATA_BACKUP
#define NORMAL_REFRESH_INTERVAL     (6)   /*in months*/
#define URGENT_REFRESH_INTERVAL     (4)   /*in months*/
#define	DAYS_PER_MONTH              (30)
#define MONTH_PER_YEAR              (12)
#define MAX_URGENT_REFRESH_RETRY    (3)
#define URGENT_BKOPS_CLEAR_WAIT_US  (300000)
#define MAX_REFRESH_DEVICES         (5)
//Taking 30 days a month in average
#define MONTH_IN_SEC(x) ((long) (x*30*24*60*60))
#define NORMAL_REFRESH_INTERVAL     (6)   /*in months*/
#define URGENT_REFRESH_INTERVAL     (4)   /*in months*/
#define MILLISECONDS_PER_SECOND     (1000)
#define SECTOR_SIZE                 (1<<9)
#define SWAB_ALIGN_OFFSET 2
#define INPUT_BLOCK_SLOP(page_size) (page_size - 1)
#define URGENT_BKOPS                (1 << 6)    // Bit in MMC status register indicating urgent backops.
#define EXT_CSD_BKOPS_STATUS        (246)   /* RO */
#define EXT_CSD_MMC_REVISION 		(192)
#define BKOPS_STATUS_CRITICAL       (0x3)   /*Critical*/
#define BKOPS_STATUS_PERFORMANCE_IMPACTED (0x2)
#define EMMC_MAX_PATH_LEN 			(256)
#define MAX_SUB_DEVICES 			(5)
/* After every 6.25% of the scetors covered, create a Metadata Backup File
   This Percentage is chosen so that it is an integral multiple of the 128 sector*/
#define BACKUP_THRESHHOLD(s32Total_sector)  ((s32Total_sector <= 65536)?\
		(s32Total_sector):((s32Total_sector*8)/128))
typedef struct {
	tU32 u32no_of_sectors_covered;
	tU32 u32partition_covered;
	tU32 u32day, u32month, u32year;
	tU32 u32due_day, u32due_month, u32due_year;
	tU32 u32checksum[CHECKSUM_COUNT];
	tU32 u32total_numbers_of_sectors;
	tU32 u32refresh_type;
	tU32 u32refresh_size;
	tU32 u32Refresh_threshold;
	tU32 u32TotalRefreshCount;
	tU32 u32Refresh_normal_delay_ms;
	tU32 u32Refresh_fastmode_delay_ms;
	tU32 u32Refresh_multiFactor;
	tU32 u32EnableRPMBRefresh;
	tU32 total_partitions;
	tU32 u32CalculatedDelayTime;
	tU32 u32RefreshMonthInterval;
}refresh_config;
typedef struct
{
	char dev_path_name[EMMC_MAX_PATH_LEN]; //Absolute path /dev/mmcblk1
	tU64 dev_size;	// size of the device, in bytes.
	tS32 s32fd;
} emmc_dev_data;
typedef struct {
	emmc_dev_data* dev_data;
	tPS8 ps8ConfigFileDir;
	tPS8 ps8MetaDataFileDir;
	refresh_config refresh_config_data;
	tU32 u32UrgentRefreshCheckNeeded;
	struct timespec readdelay;
	tU8 u8NumOfPartitions;
	tU32 u32mmc_revision;	// revision as read from csd regs
	tU32 u32mmc_vendor;		// vendor ID
	tU8 u8ForceRefresh;
}refresh_data;
struct date {
	tU32 u32day, u32month, u32year;
};
#define METADATA_FILE_PATH "metadata.txt"
#define METADATA_DUMMY  "metadata_dummy.txt"
#define METADATA_FILE_PATH_BK  "metadata_backup.txt"
typedef enum
{
	SAMSUNG_VENDOR_ID   =   0x15,
	MICRON_VENDOR_ID    =   0xFE,
	MICRON_VENDOR_ID_I  =   0x13,
	TOSHIBA_VENDOR_ID   =   0x11,
	DEFAULT_VENDOR      =   0
}eMMC_DEV_VENDOR;
tS32 s32Perform_Refresh(void *arguments);
// Some constants from standard-headers are missing in the QNX version of these.
# if !defined(O_DIRECT)
#  define O_DIRECT 0
# endif
#define MMC_SPEC_V5_0                   (7)
#define MMC_SPEC_V5_1                   (8)
#define MAXLENGTH                   	(255)   // max length of some temporary string buffers.
#endif /* EMMC_REFRESH_H_ */
