/*!----------------------------------------------------------------------------
 *! @file pos_gnss_data_logging.h
 *!
 *! @brief Header file
 *!
 *! @author Sanjay Gurugubelli(RBEI/ECF1)
 *!
 *! @date 2018-Feb-26 sga5kor  initial version.
 *!
 *! Copyright (c) Robert Bosch GmbH, 2018. All rights reserved.
 *!----------------------------------------------------------------------------
 */
#ifndef _SENSOR_DATA_LOGGING_H
#define _SENSOR_DATA_LOGGING_H

/*! direction of data */
typedef enum
{
   POSGNSS_EN_DATA_IN=0,
   POSGNSS_EN_DATA_OUT
}PoSGnss_enDataDirection;

 /*! defined in pos_gnss_data_logging.c */
/* below are variables and functions are visible for c and c++ compilers */
#ifdef __cplusplus
extern "C"{
#endif
extern tBool PosGnss_IsDataLoggingEnabled;
extern void PosGnss_vInitDataLogging(tVoid);
extern void PosGnss_WritePosDataToLogFile(const unsigned char*, unsigned int, PoSGnss_enDataDirection);
extern void PosGnss_WriteGnssDataToLogFile(const unsigned char* , unsigned int,PoSGnss_enDataDirection);
extern void PosGnss_vDeInitDataLogging(tVoid);
#ifdef __cplusplus
}
#endif
#endif
/*! end of file */
