/******************************************************************************
*FILE         : dev_gyro_TestFunctions.h
*
*SW-COMPONENT : Google Testing framework
*
*DESCRIPTION  : This file contains headers and macros for the Gyro Google@tgt Test Functions.
*
*AUTHOR       : Abhimanyu Pandit
*
*COPYRIGHT    : (C) COPYRIGHT RBEI - All Rights Reserved
*****************************************************************************/

#ifndef GYRO_DRV_GOOGLETEST_TARGET_HEADER
#define GYRO_DRV_GOOGLETEST_TARGET_HEADER

#include "gtest/gtest.h"
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

/*****************************************************************
| defines and macros (scope: module-local)
|------------------------------------------------------------------*/
#define GYRO_SENSOR_DATA_RESOLUTION_RANGE    65536
#define NO_OF_RECORDS 10
#define NO_OF_ELEMENTS_TO_READ 10
#define OSAL_MULTITHREAD_WAIT_TIMEOUT    10000
#define MULTI_THREAD_EVENT               (tString)"MthrdEvent"
#define GYRO_DEFAULT_TIME_INTERVAL  50000000 //NS
#define GYRO_READ_WAIT 1000
#define GYRO_OEDT_TRACE_WIDTH (25)
#define GYRO_OEDT_MID_GYROVALUE (0xFFFF/2)
#define GYRO_OEDT_DATA_SCALE_FACTOR (GYRO_OEDT_MID_GYROVALUE/GYRO_OEDT_TRACE_WIDTH)
#define GYRO_OEDT_NO_OF_PLOT_COLUMNS (6)
#define GYRO_OEDT_TOTAL_PLOT_WIDTH (GYRO_OEDT_TRACE_WIDTH * GYRO_OEDT_NO_OF_PLOT_COLUMNS)
#define GYRO_OEDT_R_PLOT_OFFSET (0)
#define GYRO_OEDT_S_PLOT_OFFSET (GYRO_OEDT_TRACE_WIDTH *2)
#define GYRO_OEDT_T_PLOT_OFFSET (GYRO_OEDT_TRACE_WIDTH *4)
//#define GYRO_OEDT_MAX_CONT_READ_FAILURES (10)
#define GYRO_OEDT_TEST_DURATION_MS (60000)
#define GYRO_OEDT_PLOT_DATA_INTERVALL (300)
#define GYRO_MASK_VALUE 0x0001
#define ACC_MASK_VALUE  0x0002
#define ODO_MASK_VALUE  0x0004
#define GYRO_TIMESTAMP_DIFFERENCE_UPPER_LIMIT 55
#define GYRO_TIMESTAMP_DIFFERENCE_LOWER_LIMIT 45
#define GYRO_SAMPLE_READ_TIME_IN_MS       300000
#define GYRO_TIMESTAMP_RECORD "/var/opt/bosch/dynamic/ffs/GyroRecord.txt"

/******************************************************************
|Error codes used
|-----------------------------------------------------------------*/
#define GYRO_ERROR_NONE                                0
#define GYRO_ERROR_IOREAD                              1
#define GYRO_ERROR_VALUE_RANGE                         2
#define GYRO_ERROR_MID_VALUE                           3
#define GYRO_ERROR_TIMESTAMP_RECORD_OPEN               4
#define GYRO_ERROR_TIMESTAMP_RECORD_READ               5
#define GYRO_ERROR_TIMESTAMP                           6
#define GYRO_ERROR_THREAD_SPAWN                        7

#endif

