/******************************************************************************
*FILE         : dev_acc_TestFunctions.h
*
*SW-COMPONENT : Google Testing framework
*
*DESCRIPTION  : This file contains headers and macros for the Acc Google@tgt Test Functions.
*
*AUTHOR       : Abhimanyu Pandit
*
*COPYRIGHT    : (C) COPYRIGHT RBEI - All Rights Reserved
*****************************************************************************/

#ifndef ACC_DRV_GOOGLETEST_TARGET_HEADER
#define ACC_DRV_GOOGLETEST_TARGET_HEADER

#include "gtest/gtest.h"
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

/*****************************************************************
| defines and macros (scope: module-local)
|------------------------------------------------------------------*/

#define ACC_OEDT_TRACE_WIDTH (25)
#define ACC_OEDT_MID_ACCVALUE (8192/2)
#define ACC_OEDT_DATA_SCALE_FACTOR (ACC_OEDT_MID_ACCVALUE/ACC_OEDT_TRACE_WIDTH)
#define ACC_OEDT_NO_OF_PLOT_COLUMNS (6)
#define ACC_OEDT_TOTAL_PLOT_WIDTH (ACC_OEDT_TRACE_WIDTH * ACC_OEDT_NO_OF_PLOT_COLUMNS)
#define ACC_OEDT_X_PLOT_OFFSET (0)
#define ACC_OEDT_Y_PLOT_OFFSET (ACC_OEDT_TRACE_WIDTH *2)
#define ACC_OEDT_Z_PLOT_OFFSET (ACC_OEDT_TRACE_WIDTH *4)
//#define ACC_OEDT_MAX_CONT_READ_FAILURES (10)
#define ACC_OEDT_TEST_DURATION_MS (60000)
#define ACC_OEDT_PLOT_DATA_INTERVALL (300)
#define MAX_SAMPLES_PER_READ                  512
#define ACC_TIMESTAMP_DIFFERENCE_LOWER_LIMIT   45
#define ACC_TIMESTAMP_DIFFERENCE_UPPER_LIMIT   55
#define ACC_SAMPLE_READ_TIME_IN_MS         300000     // to read ACC data for 300000 ms(5 mins)
//#define ACC_ADC_BIT_RESOLUTION_RANGE        2048
#define ACC_DEFAULT_TIME_INTERVAL 50000000 //NS
#define ACC_TIMESTAMP_RECORD "/var/opt/bosch/dynamic/ffs/ACCRecord.txt"

/******************************************************************
|Error codes used
|-----------------------------------------------------------------*/
#define ACC_ERROR_NONE                         0
#define ACC_ERROR_IOREAD                       1
#define ACC_ERROR_VALUE_RANGE                  2
#define ACC_ERROR_MID_VALUE                    3
#define ACC_ERROR_TIMESTAMP_RECORD_OPEN        4
#define ACC_ERROR_TIMESTAMP_RECORD_READ        5
#define ACC_ERROR_TIMESTAMP                    6


#endif
