#include "OsalConf.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "Linux_osal.h"

#ifdef QNX
#include <devctl.h>
#include "errmem_rm.h"
#else
#include "errmem.h"
#ifdef VARIANT_S_FTR_ADIT_SUPPORTED 
#include "errmem_lib.h"
#endif
#endif

extern int  errmem_fd;

#ifdef VARIANT_S_FTR_ADIT_SUPPORTED 
static tS32 ReadHandle = -1;
#ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT
typedef int (*tperrmem_backend_open_session)(void);
typedef int (*tperrmem_backend_close_session)(int handle);
typedef int (*tperrmem_backend_set_storage)(int handle, int storage);
typedef int (*tperrmem_backend_read)(int handle, struct errmem_message *buf);
typedef int (*tperrmem_backend_erase)(int handle, int storage);

static void* pLibHandle = NULL;

static tperrmem_backend_open_session   perrmem_backend_open_session = NULL;
static tperrmem_backend_close_session  perrmem_backend_close_session = NULL;
static tperrmem_backend_set_storage    perrmem_backend_set_storage = NULL;
static tperrmem_backend_read           perrmem_backend_read = NULL;
static tperrmem_backend_erase          perrmem_backend_erase = NULL;

static tBool bErrMemLoaded = FALSE;
tBool LoadErrMemIf(void)
{
   OSAL_tProcessID Pid =  OSAL_ProcessWhoAmI();
//   char *error;
   dlerror();    /* Clear any existing error */
   pLibHandle = dlopen(LIB_ERRMEM, RTLD_NOW );
   if(pLibHandle == NULL)
   {
       return FALSE;
   }
   else
   {
      perrmem_backend_open_session   = (tperrmem_backend_open_session)(dlsym(pLibHandle, (const char*)"errmem_backend_open_session"));/*lint !e611 */;
      perrmem_backend_close_session  = (tperrmem_backend_close_session)(dlsym(pLibHandle, (const char*)"errmem_backend_close_session"));/*lint !e611 */
      perrmem_backend_set_storage    = (tperrmem_backend_set_storage)(dlsym(pLibHandle, (const char*)"errmem_backend_set_storage"));/*lint !e611 */
      perrmem_backend_read           = (tperrmem_backend_read)(dlsym(pLibHandle, (const char*)"errmem_backend_read"));/*lint !e611 */
      perrmem_backend_erase          = (tperrmem_backend_erase)(dlsym(pLibHandle, (const char*)"errmem_backend_erase"));/*lint !e611 */
          
      if((!perrmem_backend_open_session)||(!perrmem_backend_close_session)||(!perrmem_backend_set_storage)||(!perrmem_backend_read)||(!perrmem_backend_erase))
      {
         dlclose(pLibHandle);
         return FALSE;
      }
      if(LLD_bIsTraceActive(TR_COMP_OSALCORE,TR_LEVEL_COMPONENT))
      {
         tS32 s32PidEntry = s32FindProcEntry(Pid);
         if(s32PidEntry == OSAL_ERROR)
         {
           //NORMAL_M_ASSERT_ALWAYS();
           TraceString("Loaded Trace for unknown PID OSAL during load?");
         }
         else
         {
            TraceString("Loaded Trace PID:%d %s",(int)Pid,prProcDat[s32PidEntry].pu8CommandLine);
         }
      }
      return TRUE;
   }
}
#endif

int eb_open_session()
{
#ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT
	return perrmem_backend_open_session();
#else
	return errmem_backend_open_session();
#endif
}
int eb_close_session(int handle)
{
#ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT
	return perrmem_backend_close_session(handle);
#else
	return errmem_backend_close_session(handle);
#endif
}
int eb_set_storage(int handle, int storage)
{
#ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT
	return perrmem_backend_set_storage(handle, storage);
#else
	return errmem_backend_set_storage(handle, storage);
#endif
}
int eb_read(int handle, struct errmem_message *buf)
{
#ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT
	return perrmem_backend_read(handle,buf);
#else
	return errmem_backend_read(handle,buf);
#endif
}
int eb_erase(int handle, int storage)
{
#ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT
	return perrmem_backend_erase(handle,storage);
#else
	return errmem_backend_erase(handle,storage);
#endif
}

#endif


int CheckForErrmemDev(void)
{
   int fd = open("/dev/errmem", O_WRONLY);
   if(fd != -1)
   {
      close(fd);
   }
   return fd;   
}

tS32 ERRMEM_S32IOOpen_File(tS32 s32Id, tCString szName, 
                      OSAL_tenAccess enAccess, uintptr_t *pu32FD,
                      tU16 app_id);
tS32 ERRMEM_S32IOClose_File(tS32 s32ID, uintptr_t u32FD);
tS32 ERRMEM_s32IOWrite_File(tS32 s32ID, uintptr_t u32FD, tPCS8 buffer,tU32 size, uintptr_t *ret_size);
tS32 ERRMEM_s32IORead_File(tS32 s32ID, uintptr_t u32FD, tPS8 buffer,tU32 size, uintptr_t *ret_size);
tS32 ERRMEM_s32IOControl_File(tS32 s32ID, uintptr_t u32fd, tS32 io_func, intptr_t param);


tS32 ERRMEM_S32IOOpen(tS32 s32Id, tCString szName,OSAL_tenAccess enAccess, uintptr_t *pu32FD,tU16 app_id)
{
   if(!pOsalData->bDevErrMem)
   {
      return ERRMEM_S32IOOpen_File(s32Id, szName, enAccess, pu32FD,app_id);
   }
   else
   {
       if((enAccess == 0)||(enAccess > OSAL_EN_READWRITE))
       {
          return(OSAL_E_INVALIDVALUE); 
       }
       if(errmem_fd == -1)
       {
          errmem_fd = open("/dev/errmem", O_RDWR,OSAL_ACCESS_RIGTHS);
          TraceString("/dev/errmem has to be openend by OSAL driver");
       }
       if(errmem_fd < 0)
       {
          TraceString("/dev/errmem open by OSAL driver failed errno:%d",errno);
          return (tS32)u32ConvertErrorCore(errno);
       }
       else
       {
          return OSAL_E_NOERROR;
       }
   }
}

tS32 ERRMEM_S32IOClose(tS32 s32ID, uintptr_t u32FD)
{
  if(!pOsalData->bDevErrMem)
  {
     return ERRMEM_S32IOClose_File(s32ID,u32FD);
  }
  else
  {
     return OSAL_E_NOERROR;
  }
}

tS32 ERRMEM_s32IOWrite(tS32 s32ID, uintptr_t u32FD, tPCS8 buffer,tU32 size, uintptr_t *ret_size)
{
  if(!pOsalData->bDevErrMem)
  {
    return ERRMEM_s32IOWrite_File(s32ID, u32FD, buffer,size,ret_size);
  }
  else
  {
#ifdef OSAL_ERRMEM_TIMESTAMP
   vWriteUtcTime(errmem_fd);
#endif
#ifdef QNX
   trErrmemEntry* pOsalEntry = (trErrmemEntry*)buffer;/*lint !e826 */ /* used buffer is always size of trErrmemEntry*/
   *ret_size = (uintptr_t)write(errmem_fd,(char*)&pOsalEntry->au8EntryData[0],(uint32_t)pOsalEntry->u16EntryLength+1);
#else
#ifdef VARIANT_S_FTR_ADIT_SUPPORTED 
   struct errmem_message  rErrMem;
  
   if(size < sizeof(trErrmemEntry))
   {
      TraceString("size < sizeof(trErrmemEntry) ");
      return OSAL_E_INVALIDVALUE;
   }
   memset(&rErrMem,0,sizeof(rErrMem));
   trErrmemEntry* pOsalEntry = (trErrmemEntry*)buffer;/*lint !e826 */ /* used buffer is always size of trErrmemEntry*/

   rErrMem.type = ERRMEM_TYPE_TRACE;
   rErrMem.message[0] = 0;

 /*  if(pOsalEntry->u16Entry)
   {
        rErrMem.type = ERRMEM_TYPE_TRACE;
        rErrMem.message[0] = 0;
   }
   else
   {
        rErrMem.type = ERRMEM_TYPE_ASCII;
        rErrMem.message[0] = 1;
   }*/
   rErrMem.length = pOsalEntry->u16EntryLength;
   if(pOsalEntry->u16EntryLength == ERRMEM_MAX_ENTRY_LENGTH)
   {
       pOsalEntry->u16EntryLength = (tU16)(pOsalEntry->u16EntryLength-1);
   }
   memcpy(&rErrMem.message[1],pOsalEntry->au8EntryData,pOsalEntry->u16EntryLength);

   
   /*
     Changed the len from 'sizeof(rErrMem.message)' to 'pOsalEntry->u16EntryLength+1'
      to transmitt the real required size.
      Trace TTFIS TRC rules gets confused if teh message contains tooo much trailing '00's
   */
   *ret_size = (uintptr_t)write(errmem_fd,(char*)&rErrMem.message,(tU32)(pOsalEntry->u16EntryLength+1));
#else
   *ret_size = (uintptr_t)-1;
   errno = ENOENT;
#endif
#endif   
   if((int)*ret_size == -1)
   {
      *ret_size = 0;
      return (tS32)u32ConvertErrorCore(errno);
   }
   return (tS32)size;
  }
}


tS32 ERRMEM_s32IORead(tS32 s32ID, uintptr_t u32FD, tPS8 buffer, tU32 size, uintptr_t *ret_size)
{
#ifdef SINGLE_PROCESS_OSAL
   (void)s32ID;
   (void)u32FD;
   (void)buffer;
   (void)size;
   (void)ret_size;
   return OSAL_E_NOTSUPPORTED;
#else
  if(!pOsalData->bDevErrMem)
  {
    return ERRMEM_s32IORead_File(s32ID, u32FD, buffer,size, ret_size);
  }
  else
  {
   tS32 s32Ret;
   trErrmemEntry* pEntry;
#ifdef QNX
   char cReadBuf[512];
   pEntry = (trErrmemEntry*)buffer;
  
   s32Ret = (tS32)read(errmem_fd,cReadBuf,512);
   if((s32Ret == -1)&&(errno == EBADF))
   {
       close(errmem_fd);
       errmem_fd = open("/dev/errmem",O_RDWR);
       s32Ret = (tS32)read(errmem_fd,cReadBuf,512);
   }
   if(s32Ret <= 0)
   {
      return (tS32)OSAL_E_IOERROR;
   }
   else
   {
      *ret_size = (uintptr_t)s32Ret;
      pEntry->u16Entry       = 0x4c5a;
      pEntry->u16EntryLength = (unsigned short)s32Ret;
      pEntry->eEntryType     = eErrmemEntryNormal;
      /* in OSAL the first 2 Bytes are for Trace Class */
      pEntry->au8EntryData[0] = 0;
      pEntry->au8EntryData[1] = 0;
      memcpy(&pEntry->au8EntryData[2],&cReadBuf[0],(size_t)min(s32Ret,512));
   }
#else
#ifdef VARIANT_S_FTR_ADIT_SUPPORTED 
   struct errmem_message  rErrMem;
//   tBool bIgnore = FALSE;

//   TraceString("ERRMEM_s32IORead start");
   if((buffer == NULL)||(size < sizeof(trErrmemEntry)))
   {
       TraceString("ReadBackend parameter error  buffer:0x%x , size:%d", buffer,size);
       return (tS32)OSAL_E_INVALIDVALUE;
   }

#ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT
   if(bErrMemLoaded == FALSE)
   {
      if((bErrMemLoaded = LoadErrMemIf()) == FALSE)return OSAL_ERROR;
   }
#endif

   if(ReadHandle == -1)
   {
      TraceString("errmem_backend_open_session start");
      ReadHandle = eb_open_session();
      if(ReadHandle < 0)
      {
         TraceString("errmem_backend_open_session failed %d Check the Daemon", ReadHandle);
         ReadHandle = -1;
         return (tS32)u32ConvertErrorCore(errno);
      }
      if(pOsalData->u32ErrmemBE == 0)pOsalData->u32ErrmemBE = 1;
      if((s32Ret = eb_set_storage(ReadHandle,(int)pOsalData->u32ErrmemBE)) < 0)
      {
         eb_close_session(ReadHandle);
         ReadHandle = -1;
         TraceString("errmem_backend_set_storage %d failed error:%d",s32Ret);
         return (tS32)OSAL_E_UNKNOWN;
      }
   }

   while(1)
   {
      s32Ret = eb_read(ReadHandle,&rErrMem);
#ifdef GEN4ARM
      if(s32Ret == -2)s32Ret=2;
#endif
      if(s32Ret < 0)
      {
         TraceString("ReadBackend failed %d", s32Ret);
         eb_close_session(ReadHandle);
         ReadHandle = -1;
         return (tS32)u32ConvertErrorCore(s32Ret);
      }
      else
      {
         pEntry = (trErrmemEntry*)buffer; /*lint !e826 */ /* used buffer is always size of trErrmemEntry*/
   //   TraceString("ReadBackend Ret:%d Type:%d  Size:%d %s",s32Ret,rErrMem.type,rErrMem.length,rErrMem.message);

         /* finish session when last entry received */
         if(s32Ret > 0)
         {
            if(s32Ret == 1)
            {
                TraceString("errmem_backend_read last entry reached ");
            }
            if(s32Ret == 2)
            {
               TraceString("errmem_backend_read errmem content invalidated");
            }
            if((s32Ret = eb_close_session(ReadHandle)) == -1)
            {
              TraceString("errmem_backend_close_session failed with error:%d",s32Ret);
           //   return (tS32)u32ConvertErrorCore(s32Ret);
            }
            TraceString("errmem_backend_close_session ");
            ReadHandle = -1;
            return (tS32)OSAL_E_IOERROR;
         }

   /*      if(rErrMem.internal.seqnum == 0)
         {
            if(strstr(rErrMem.message,"MESSAGE CRC ERROR ====="))
            {
                bIgnore = TRUE;
            }
         }

         if(bIgnore == FALSE)
         {*/
            tU64 time_local;
            time_t current_time;
            struct tm result;

            time_local = ((tU64)(rErrMem.internal.local_clock[1])) << 32
                        | (tU64)(rErrMem.internal.local_clock[0]);
            time_local /= 1000000000UL;
            current_time = (time_t)(time_local);
            localtime_r(&current_time, &result);
            pEntry->rEntryTime.s32Second         = result.tm_sec;
            pEntry->rEntryTime.s32Minute         = result.tm_min;
            pEntry->rEntryTime.s32Hour           = result.tm_hour;
            pEntry->rEntryTime.s32Day            = result.tm_mday;
            pEntry->rEntryTime.s32Month          = result.tm_mon+1;
            pEntry->rEntryTime.s32Year           = result.tm_year;
            pEntry->rEntryTime.s32Weekday        = result.tm_wday;
            pEntry->rEntryTime.s32Yearday        = result.tm_yday;
            pEntry->rEntryTime.s32Daylightsaving = result.tm_isdst; /* do we have locale info? */

            if(rErrMem.type == ERRMEM_TYPE_TRACE) 
            {
                  pEntry->u16Entry       = 0x4c5a;
                  pEntry->u16EntryLength = (unsigned short)(rErrMem.length-1);
                  pEntry->eEntryType     = eErrmemEntryNormal;
                  memcpy(&pEntry->au8EntryData[0],&rErrMem.message[1],(size_t)(rErrMem.length-1));
                  break;
            }
            else
            {
               int len;
               if(rErrMem.length >= ERRMEM_MAX_ENTRY_LENGTH-4)
               {
                  TraceString("Entry is truncated from %d to %d Bytes",rErrMem.length,ERRMEM_MAX_ENTRY_LENGTH-3);
                  rErrMem.length=ERRMEM_MAX_ENTRY_LENGTH - 4;
               }
               len = rErrMem.length;
               if (rErrMem.message[len-1] == '\n') 
               {
                  --len;
               }
               rErrMem.message[len] = 0;

               pEntry->u16Entry = 0x4c5a;
               pEntry->u16EntryLength  = (unsigned short)(len+3);
               pEntry->eEntryType      = eErrmemEntryNormal;
               pEntry->au8EntryData[0] =  ((int)TR_CLASS_EXCEPTION) & 0x000000FF;
               pEntry->au8EntryData[1] =  0; /*(((int)TR_CLASS_EXCEPTION) >> 8) & 0x000000FF; */
               pEntry->au8EntryData[2] =  255;
               memcpy(&pEntry->au8EntryData[3],&rErrMem.message[0],(size_t)len);
               break;
            }
     /*    }//if(bIgnore == FALSE)
         else
         {
            if(rErrMem.internal.seqnum != 0)
            {
               bIgnore = FALSE;
            }
         }//if(bIgnore == FALSE)*/
      }//if(s32Ret < 0)
   }//end while 
   pEntry->u16EntryCount   = 0;
#else
   pEntry = (trErrmemEntry*)buffer;
   if(!pEntry)s32Ret = -1; 
   else s32Ret = 0; 
   *ret_size = (uintptr_t)s32Ret;
   size = 0;
#endif
#endif
   *ret_size = sizeof(trErrmemEntry);
   return (tS32)size;
   }
#endif
}

tS32 ERRMEM_s32IOControl(tS32 s32ID, uintptr_t u32fd, tS32 io_func, intptr_t param)
{
   (void)s32ID;
   (void)u32fd;
#ifdef SINGLE_PROCESS_OSAL
    (void)io_func;
    (void)param;
   return OSAL_E_NOTSUPPORTED;
#else
  if(!pOsalData->bDevErrMem)
  {
    return ERRMEM_s32IOControl_File(s32ID,u32fd,io_func,param);
  }
  else
  {
   tU32 u32Ret = OSAL_E_NOERROR;
 
#ifdef QNX
   int dev_info,Ret = -1;
   char buf[10];
   int fd = open("/dev/errmem",O_RDWR);
   
   if(io_func == OSAL_C_S32_IOCTRL_ERRMEM_CLEAR)
   {
       Ret = devctl (fd,ERRMEM_DEVCTL_ERASE,buf,10,&dev_info);
   }
   else if(io_func == OSAL_C_S32_IOCTRL_ERRMEM_SET_BE)
   {
       Ret = devctl (fd,ERRMEM_DEVCTL_SET_BE,buf,10,&dev_info);
   }
   else if(io_func == OSAL_C_S32_IOCTRL_ERRMEM_FLUSH)
   {
       Ret = devctl (fd,ERRMEM_DEVCTL_FLUSH,buf,10,&dev_info);
   }
   else
   {
	   TraceString("Unexpected IO control used");
   }
   close(fd);
   if(Ret == -1)
   {
      u32Ret = u32ConvertErrorCore(errno);
   }
#else
#ifdef VARIANT_S_FTR_ADIT_SUPPORTED 
#ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT
   if(bErrMemLoaded == FALSE)
   {
      if((bErrMemLoaded = LoadErrMemIf()) == FALSE)return OSAL_ERROR;
   }
#endif
   uintptr_t s32Val = *((uintptr_t*)param);
   int Handle = eb_open_session();
   if(io_func == OSAL_C_S32_IOCTRL_ERRMEM_CLEAR)
   {
      if(eb_erase(Handle,(int)pOsalData->u32ErrmemBE) != 0)
      {
         TraceString("errmem_backend_erase failed error:%d",errno);
         u32Ret = u32ConvertErrorCore(errno);
      }
   }
   else if(io_func == OSAL_C_S32_IOCTRL_ERRMEM_SET_BE)
   {
          pOsalData->u32ErrmemBE = (tU32)s32Val;
   }
   else if(io_func == OSAL_C_S32_IOCTRL_ERRMEM_STOP_BE)
   {
      //    errmem_backend_stop(Handle);
      u32Ret = OSAL_E_NOTSUPPORTED;
   }
   else if(io_func == OSAL_C_S32_IOCTRL_ERRMEM_SET_LOGLEVEL)
   {
      if(errmem_fd != -1)
      {
         if(ioctl(errmem_fd, IOCTL_ERRMEM_SET_KERNEL_MSG_LEVEL, &s32Val) ==  -1)
         {
            TraceString("OSAL_C_S32_IOCTRL_ERRMEM_SET_LOGLEVEL Errmem ioctl failed errno %d",errno);
         }
      }
   }
   else if(io_func == OSAL_C_S32_IOCTRL_ERRMEM_FLUSH)
   {
      if(errmem_fd != -1)
      {
        if(ioctl(errmem_fd, IOCTL_ERRMEM_FLUSH, &s32Val) ==  -1)
        {
            TraceString("IOCTL_ERRMEM_FLUSH Errmem ioctl failed errno %d",errno);
        }
      }
   }     

   if(eb_close_session(Handle) == -1)
   {
      u32Ret = u32ConvertErrorCore(errno);
   }
#else
   u32Ret = OSAL_E_NOTSUPPORTED;
#endif
#endif
   return (tS32)u32Ret;
  }
#endif
}



