/************************************************************************
 * FILE        :  OSAL_RPCMessageParser.h
 * SW-COMPONENT:  OSAL-RPC-SERVER
 *----------------------------------------------------------------------
 * DESCRIPTION :  Header file of OSAL-RPC Message Parser class
 *----------------------------------------------------------------------
 * COPYRIGHT   :  (c) 2009-2010 Robert Bosch Engg. & Business Solns. Ltd.
 * HISTORY     :
 * Date       |   Modification            | Author
 *----------------------------------------------------------------------
 * 01/02/2009 |   Initial Version         | Soj Thomas, RBEI/ECF
 *************************************************************************/

#ifndef __OSAL_RPCMESSAGEPARSER_H__
#define __OSAL_RPCMESSAGEPARSER_H__

/**************************************************************************/
/* includes                                                               */
/**************************************************************************/
#define  AHL_S_IMPORT_INTERFACE_STREAMER
#define  AHL_S_IMPORT_INTERFACE_ENDIAN
#include "ahl_if.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "imessagesender.h"
#include "imessageparser.h"
#include "osal_rpccommandcodes.h"

/**************************************************************************/
/* Defines                                                                */
/**************************************************************************/
#define OSALRPCSERVER_THREAD              "RPCSERVER_THREAD"
#define OSALRPCSERVER_THREAD_PRIO         70
#define OSALRPCSERVER_THREAD_STACKSIZE    10000
#define OSALRPCSERVER_SEMAPHORE           "RPCSERVER_SEM"

/**************************************************************************/
/* type definitions                                                       */
/**************************************************************************/
/* Internal state of RPC */
typedef enum
{
   EN_WAITING_FOR_FID,
   EN_FID_COMPLETE,
   EN_WAITING_FOR_QUEUE_NAME,
   EN_QUEUE_NAME_COMPLETE,
   EN_WAITING_FOR_MESSAGE,
   EN_MESSAGE_COMPLETE,
   EN_WAITING_FOR_ARGUMENTS
} tenInternalState;

class tclOSAL_RPCMessageParser : public tclIMessageParser
{
private:
   tclIMessageSender *m_poMessageSender;
   tU32 m_u32Fid;
   tU32 m_u32FidPointer;
   tBool m_bFidComplete;
   tPU8 m_pau8CopyBuffer;
   tU32 m_u32CopyBufferIndex;
   tU32 m_u32CopyBufferSize;
   tenInternalState m_enInternalState;
   tU32 m_localMsgCounter;
   tU32 m_localThreadNo;

public:
   tclOSAL_RPCMessageParser();
   ~tclOSAL_RPCMessageParser();//lint !e1510
   tVoid vSetMessageSender( tclIMessageSender *poMessageSender );
   tBool bParseMessage( tPU8 pau8Buffer, tU32 u32BufferSize );
   tBool bExecuteAndSendResult( tU32 u32Fid, tPCU8 pau8Message, tU32 u32BufferLength );

   tBool bAdjustCopyBuffer( tU32 u32RequestedSize );
   tBool bConsumeMessage( tU32 u32RequiredMsgSize, tPU8& pau8Buffer, tU32& u32BufferSize );

#ifdef VARIANT_S_FTR_ENABLE_CPPUNIT_TEST
   tBool bValidateProtocol( tPU8 pau8Buffer, tU32 u32BufferSize );
#endif
};

#endif  //__OSAL_RPCMESSAGEPARSER_H__
