/************************************************************************
 * FILE        :  OSAL_RPCCommandCodes.h
 * SW-COMPONENT:  OSAL-RPC-SERVER
 *----------------------------------------------------------------------
 * DESCRIPTION :  Definition of OSAL-RPC Command codes
 *----------------------------------------------------------------------
 * COPYRIGHT   :  (c) 2009-2010 Robert Bosch Engg. & Business Solns. Ltd.
 * HISTORY     :
 * Date       |   Modification            | Author
 *----------------------------------------------------------------------
 * 01/02/2009 |   Initial Version         | Susmith MR, RBEI/ECF
 * 01/05/2009 |   Adddes more definitions | Soj Thomas, RBEI/ECF
 *************************************************************************/
#ifndef __OSAL_RPCCOMMANDCODES_H__
#define __OSAL_RPCCOMMANDCODES_H__

/******************************************************************************/
/* Definition of OSAL RPC Command Codes                                       */
/******************************************************************************/
/* Generic OSAL APIs */
#define OSAL_S32IOOPEN                       (tU32)6
#define OSAL_S32IOWRITE                      (tU32)7
#define OSAL_S32IOCLOSE                      (tU32)8
#define OSAL_S32IOCREATE                     (tU32)9
#define OSAL_S32IOREMOVE                     (tU32)10
#define OSAL_S32IOCTRL                       (tU32)11
#define OSAL_S32IOREAD                       (tU32)12
#define OSAL_S32MESSAGEQUEUECREATE           (tU32)39
#define OSAL_S32MESSAGEQUEUEOPEN             (tU32)40
#define OSAL_S32MESSAGEQUEUECLOSE            (tU32)41
#define OSAL_S32MESSAGEQUEUEDELETE           (tU32)42
#define OSAL_S32MESSAGEQUEUEPOST             (tU32)43
#define OSAL_S32MESSAGEQUEUEWAIT             (tU32)44
#define OSAL_SHAREDMEMORYCREATE              (tU32)45
#define OSAL_SHAREDMEMORYOPEN                (tU32)46
#define OSAL_S32SHAREDMEMORYCLOSE            (tU32)47
#define OSAL_S32SHAREDMEMORYDELETE           (tU32)48
#define OSAL_PVSHAREDMEMORYMAP               (tU32)49
#define OSAL_S32SHAREDMEMORYUNMAP            (tU32)50
#define OSAL_S32MESSAGEPOOLCREATE            (tU32)1000
#define OSAL_S32MESSAGEPOOLOPEN              (tU32)1001
#define OSAL_S32MESSAGEPOOLCLOSE             (tU32)1002
#define OSAL_S32MESSAGEPOOLDELETE            (tU32)1003
#define OSALPIPE_S32MESSAGEQUEUEPOST         (tU32)1010
#define OSALPIPE_S32MESSAGEQUEUEWAIT         (tU32)1011
#define OSALPIPE_PING                        (tU32)1042
#define OSALPIPE_S32IOCTRL                   (tU32)1110
/* Driver engineering functions */
#define WOS_S32IO_ENGINEERING_FCT            (tU32)53
#define ENG_FAKE_EXCL_ACCESS                 (tU32)54
#define ENG_REMOVE_EXCL_ACCESS               (tU32)55
/* MiniSPM */
#define MINISPM_SHUTDOWN                     (tU32)56

/******************************************************************************/
/* Defines for RPC Protocol message format                                    */
/* All length units are in Bytes...and excluding the FID                      */
/******************************************************************************/
#define OSALRPC_REQUEST_MAXNAME_LENGTH       (tU32)256
#define MESSAGEQUEUECREATE_REQUEST_LENGTH    (tU32)(OSALRPC_REQUEST_MAXNAME_LENGTH + sizeof( tU32 ) + sizeof( tU32 ) + sizeof( tU32/*OSAL_tenAccess*/ ))
#define MESSAGEQUEUECREATE_ANSWER_LENGTH     (tU32)(sizeof(tU32)+sizeof(tS32)+sizeof(OSAL_tMQueueHandle))
#define MESSAGEQUEUESHMOPEN_REQUEST_LENGTH   (tU32)(OSALRPC_REQUEST_MAXNAME_LENGTH + sizeof( tU32/*OSAL_tenAccess*/ ))
#define MESSAGEQUEUEOPEN_ANSWER_LENGTH       (tU32)(sizeof(tU32)+sizeof(tS32)+sizeof(OSAL_tMQueueHandle))
#define MQSHMIOCLOSE_REQUEST_LENGTH          (tU32)4
#define MESSAGEQUEUECLOSE_REQUEST_LENGTH     (tU32) sizeof(OSAL_tMQueueHandle)
#define MESSAGEQUEUECLOSE_ANSWER_LENGTH      (tU32)(sizeof(tU32)+sizeof(tS32))
#define MESSAGEQUEUEDELETE_ANSWER_LENGTH     (tU32)(sizeof(tU32)+sizeof(tS32))
#define MESSAGEQUEUEWAIT_REQUEST_LENGTH      (tU32)(sizeof(OSAL_tMQueueHandle)+sizeof(tU32)+sizeof(tU32))
#define MESSAGEQUEUEWAIT_ANSWER_LENGTH       (tU32)(sizeof(tU32)+sizeof(tS32)+sizeof(tU32))
#define MESSAGEQUEUEPOST_ANSWER_LENGTH       (tU32)(sizeof(tU32)+sizeof(tS32))
#define MESSAGEQUEUEPOST_MESSAGE_OFFSET      (tU32)(sizeof(OSAL_tMQueueHandle)+sizeof(tU32))        /* Offset to the MQ message in the RPC message body */

#define SHAREDMEMORYCREATE_REQUEST_LENGTH    (tU32)(OSALRPC_REQUEST_MAXNAME_LENGTH + sizeof(tU32)+sizeof(tS32))
#define SHAREDMEMORYMAP_REQUEST_LENGTH       (tU32)(sizeof(OSAL_tShMemHandle) + sizeof( tU32 ) + sizeof( tU32 ) + sizeof( tU32/*OSAL_tenAccess*/ ))
#define SHAREDMEMORYCREATE_ANSWER_LENGTH     (tU32)(sizeof(tU32)+sizeof(OSAL_tShMemHandle)+sizeof(tS32))
#define SHAREDMEMORYOPEN_ANSWER_LENGTH       (tU32)(sizeof(tU32)+sizeof(OSAL_tShMemHandle)+sizeof(tS32))
#define SHAREDMEMORYCLOSE_REQUEST_LENGTH     (tU32) sizeof(OSAL_tShMemHandle)
#define SHAREDMEMORYCLOSE_ANSWER_LENGTH      (tU32)(sizeof(tU32)+sizeof(tS32)+sizeof(tU32))
#define SHAREDMEMORYDELETE_ANSWER_LENGTH     (tU32)(sizeof(tU32)+sizeof(tS32)+sizeof(tU32))
#define SHAREDMEMORYMAP_ANSWER_LENGTH        (tU32)(sizeof(tU32)+sizeof(uintptr_t)+sizeof(tU32)+sizeof(tU32))
#define SHAREDMEMORYUNMAP_ANSWER_LENGTH      (tU32)(sizeof(tU32)+sizeof(tS32)+sizeof(tU32))

/* Reply headers used between osal NT and rcdotcca. */
#define SHAREDMEMORYCREATE_ANSWER_MAGIC      (tU32)0x802d
#define SHAREDMEMORYOPEN_ANSWER_MAGIC        (tU32)0x802e
#define SHAREDMEMORYCLOSE_ANSWER_MAGIC       (tU32)0x802f
#define SHAREDMEMORYDELETE_ANSWER_MAGIC      (tU32)0x8030
#define SHAREDMEMORYMAP_ANSWER_MAGIC         (tU32)0x8031
#define SHAREDMEMORYUNMAP_ANSWER_MAGIC       (tU32)0x8032
#define WOS_S32IO_ENGINEERING_FCT_MAGIC      (tU32)0x8035
#define ENG_FAKE_EXCL_ACCESS_MAGIC           (tU32)0x8036
#define ENG_REMOVE_EXCL_ACCESS_MAGIC         (tU32)0x8037
#define MINISPM_SHUTDOWN_MAGIC               (tU32)0x8038

#define IOENGINEERINGFCT_ARGUMENT_OFFSET     (tU32)8        /* offset to args in message body */
#define IOENGINEERINGFCT_ANSWER_LENGTH       (tU32)(sizeof(tU32)+sizeof(tU32)+sizeof(tS32)+sizeof(tU32))       /* Excluding dynamic argument length */
#define ENG_FAKE_EXCL_ANSWER_LENGTH          (tU32)(sizeof(tU32)+sizeof(tU32)+sizeof(tS32))
#define ENG_REMOVE_EXCL_ANSWER_LENGTH        (tU32)(sizeof(tU32)+sizeof(tU32)+sizeof(tS32))
#define MINISPM_SHUTDOWN_ANSWER_LENGTH       (tU32)(sizeof(tU32)+sizeof(tS32))

#define MESSAGEPOOLCREATE_REQUEST_LENGTH     (tU32) sizeof(tU32)
#define MESSAGEPOOLCREATE_ANSWER_LENGTH      (tU32)(sizeof(tU32)+sizeof(tS32))
#define MESSAGEPOOLOPEN_ANSWER_LENGTH        (tU32)(sizeof(tU32)+sizeof(tS32))
#define MESSAGEPOOLCLOSE_ANSWER_LENGTH       (tU32)(sizeof(tU32)+sizeof(tS32))
#define MESSAGEPOOLDELETE_ANSWER_LENGTH      (tU32)(sizeof(tU32)+sizeof(tS32))

#define PIPEMESSAGEQUEUEPOST_ANSWER_LENGTH   (tU32)(sizeof(tU32)+sizeof(tS32))
#define PIPEMESSAGEQUEUEWAIT_ANSWER_LENGTH   (tU32)(sizeof(tU32)+sizeof(tU32)+sizeof(tU32))

#define IOCREATE_REQUEST_LENGTH              (tU32)OSALRPC_REQUEST_MAXNAME_LENGTH + 4
#define IOCREATE_ACCESS_REQUEST_LENGTH       (tU32)4
#define IOCREATE_ANSWER_LENGTH               (tU32)(sizeof(tU32)+sizeof(OSAL_tIODescriptor))
#define IOREMOVE_ANSWER_LENGTH               (tU32)(sizeof(tU32)+sizeof(tS32))
#define IOOPEN_ANSWER_LENGTH                 (tU32)(sizeof(tU32)+sizeof(OSAL_tIODescriptor))
#define IOCLOSE_REQUEST_LENGTH               (tU32) sizeof(OSAL_tIODescriptor)
#define IOCLOSE_ANSWER_LENGTH                (tU32)(sizeof(tU32)+sizeof(tS32))
#define IOCTRL_ANSWER_LENGTH                 (tU32)(sizeof(tU32)+sizeof(tS32))
#define IOWRITE_ANSWER_LENGTH                (tU32)(sizeof(tU32)+sizeof(tS32))
#define IOWRITE_WRITEBUFFER_OFFSET           (tU32)(sizeof(tU32)+sizeof(tS32))        /* Offset to the write buffer in the RPC message body */
#define IOREADSHMUNMAP_REQUEST_LENGTH        (tU32)8
#define IOREAD_ANSWER_LENGTH                 (tU32)(sizeof(tU32)+sizeof(tS32))
#define PIPEIOCTRL_ARGUMENT_OFFSET           (tU32)12
#define PIPEIOCTRL_ANSWER_LENGTH             (tU32)(sizeof(tU32)+sizeof(tS32)+sizeof(tU32))

#define PING_MESSAGE_OFFSET                  (tU32)12
#define PIPEMESSAGE_PING_ANSWER_LENGTH_BASE  (tU32)(sizeof(tS32)+sizeof(tS32)+sizeof(tS32)+sizeof(tU32)+sizeof(tU32))


#endif //__OSAL_RPCCOMMANDCODES_H__
