#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

/* --This file implements save variants for string functions 

     OSAL_szStringNConcat, 
     OSAL_szStingNCopy,
     OSALUTIL_s32NPrintFormat and
     OSAL_s32VarNPrintFormat
*/

/* -- OSALUTIL_szSaveStringNConcat */
tString OSALUTIL_szSaveStringNConcat(tString szDest, tCString coszSource, tU32 u32BufferLength)
{
   return OSAL_szStringNConcat(szDest, coszSource, u32BufferLength);
}


/* -- OSALUTIL_szSaveStringNCopy */
tString OSALUTIL_szSaveStringNCopy(tString szDest, tCString coszSource, tU32 u32BufferLength)
{
   tString szRet = OSAL_szStringNCopy(szDest, coszSource, u32BufferLength);

   if(0 < u32BufferLength)
   {
      szDest[u32BufferLength - 1] = 0x00;
   }

   return szRet;
}

   
/* -- OSALUTIL_s32SaveNPrintFormat */
tS32 OSALUTIL_s32SaveNPrintFormat(tString szDest, tU32 u32BufferLength, tCString coszFormat, ...) 
{ 
	tS32 s32Size;
	/* --Do nothing special */
	OSAL_tVarArgList args; /*lint -e530 */
	OSAL_VarArgStart(args,coszFormat); //lint!e530
	s32Size=OSALUTIL_s32SaveVarNPrintFormat(szDest,u32BufferLength,coszFormat,args); //lint !e530 
                                                                                    // args has been initialized within OSAL_VarArgStart
   // ArgEnd was forgotten, fix it. wif2hi 21.07.09
   OSAL_VarArgEnd(args); //lint !e530 
                         // args has been initialized within OSAL_VarArgStart

	return s32Size<0 ? OSAL_ERROR : s32Size;
}


/* -- OSALUTIL_s32SaveVarNPrintFormat */
tS32 OSALUTIL_s32SaveVarNPrintFormat(tString szBuffer, tU32 u32BufferLength, tCString szFormat, va_list argptr)
{
   tS32 s32Result = OSAL_s32VarNPrintFormat(szBuffer, u32BufferLength, szFormat, argptr);

   if(s32Result >= (tS32)u32BufferLength)
   {
      szBuffer[u32BufferLength - 1] = 0x00;
      s32Result = OSAL_ERROR;
   }

   return s32Result;
}

