/************************************************************* +MHDR * .MA *

 .FILE             [ osshmem.cpp  ]

 .SW-COMPONENT      osal

 .DESCRIPTION
  This file contains the implementation of the class OSAL_tclSharedMemory.

 .COPYRIGHT            [ (c) 2001 Robert Bosch GmbH, Hildesheim           ]
 .AUTHOR               [ U. Walkling                                      ]

 .HISTORY

  Date     | Name            Modification
 ----------|---------------------------------------------------------------
  29.01.02 | CM-DI/EST-Wg    New
  12.02.02 | CM-DI/EST-Wg    include osal.h replaced
  01.03.02 | CM-DI/EST-Wg    destructor: name deleted if exists
           |                 NULL -> OSAL_NULL
           |                 s32Close: check first the handle before calling
           |                 the OSAL-close function.
************************************************************** -MHDR * .ME */
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
/* Constructor of this class. */
OSAL_tclSharedMemory::OSAL_tclSharedMemory()
{
   /*
      Initialisation of the member variables of the class.
   */
   szName = OSAL_NULL;
   /*
       Attention dirty OSAL hack!
       Do not use OSAL_C_INVALID_HANDLE! OSAL_C_INVALID_HANDLE is 
       defined as (2^32)-1!
       The handle type is defined as a tS32!
       
       Furthermore the genius OSAL developer uses the handle 
       variable to transport also the error information.
       
       So you have to initialise the handle variable with OSAL_ERROR
       instead of OSAL_C_INVALID_HANDLE!
   */
   hSharedMemoryHandle = OSAL_ERROR;
}
/* Destructor of this class. */
OSAL_tclSharedMemory::~OSAL_tclSharedMemory()
{
   this->s32Close();
   if (OSAL_NULL != this->szName)
   {
      /*
         Delete the name string.
      */
      OSAL_vMemoryFree( (tPVoid)this->szName);
      this->szName = OSAL_NULL;
   }
}
/*
   This methode creates a shared memory area. 
   If the creation of the shared memory area has finished without
   an error the s32Open methode is called afterwards.
   (For more detail see OSAL Refernzhandbuch Kapitel Shared Memory.)

   Additional Errors or meaning:
   OSAL_E_UNKNOWN: A handle already stored in this object.
   OSAL_E_NOSPACE: There is no space to save the name.
*/
tS32 OSAL_tclSharedMemory::s32Create( tCString coszName,       /* (I) */
                                      OSAL_tenAccess enAccess, /* (I) */
                                      tU32 u32Size             /* (I) */)
{
   OSAL_tShMemHandle s32ErrorValue = OSAL_OK;
   /*
      This variable stores the temporary handle of the shared memory area.
   
      Attention dirty OSAL hack!
      Do not use OSAL_C_INVALID_HANDLE! OSAL_C_INVALID_HANDLE is 
      defined as (2^32)-1!
      The handle type is defined as a tS32!
       
      Furthermore the genius OSAL developer uses the handle 
      variable to transport also the error information.
       
      So you have to initialise the handle variable with OSAL_ERROR
      instead of OSAL_C_INVALID_HANDLE!
      (For a better implementation see the C functions for semaphores!)
   */
   do
   {
      if (OSAL_NULL == coszName)
      {
         /*
            There is a NULL pointer as name specified.
         */
         s32ErrorValue = OSAL_ERROR;
         OSAL_vSetErrorCode( OSAL_E_INVALIDVALUE );
         break;
      }
      /*
         OSAL_ERROR: Dirty OSAL hack. See above.
      */
      if (OSAL_ERROR != this->hSharedMemoryHandle)
      {
         /*
            There is a handle already stored in this object.
         */
         s32ErrorValue = OSAL_ERROR;
         OSAL_vSetErrorCode( OSAL_E_UNKNOWN );
         break;
      }
      if (OSAL_NULL != this->szName)
      {
         /*
            Delete the name string.
         */
         OSAL_vMemoryFree( (tPVoid)this->szName);
         this->szName = OSAL_NULL;
      }
      s32ErrorValue = this->s32SaveName( coszName, (tCString&)this->szName );
      if (OSAL_OK == s32ErrorValue)
      {
         /*
            Call the OSAL function to create the shared memory area.
         */
         s32ErrorValue = OSAL_SharedMemoryCreate( coszName, 
                                                  enAccess,
                                                  u32Size);
      }
      else
      {
         break;
      }
      if (OSAL_ERROR == s32ErrorValue)
      {
         /*
            Delete the name string.
         */
         OSAL_vMemoryFree( (tPVoid)this->szName);
         this->szName = OSAL_NULL;
      }
      else
      {
         /*
            Save the object internal values.
         
            Dirty OSAL hack. See above.
         */
         this->hSharedMemoryHandle = s32ErrorValue;
         s32ErrorValue = OSAL_OK;
      }
   }
   while (FALSE);
   return s32ErrorValue;
}
/*
   This methode opens a shared memory area.
   (For more detail see OSAL Refernzhandbuch Kapitel Shared Memory.)

   Additional Errors or meaning:
   OSAL_E_ALREADYEXISTS: There exists already an opened shared memory area.
   OSAL_E_NOSPACE: There is no space to save the name.
*/
tS32 OSAL_tclSharedMemory::s32Open( tCString coszName,      /* (I) */
                                    OSAL_tenAccess enAccess /* (I) */ )
{
   OSAL_tShMemHandle s32ErrorValue = OSAL_OK;
   /*
      This member stores temporary the name of the shared memory area.
   */
   tString szTempName = this->szName;
   do
   {
      if (OSAL_NULL == coszName)
      {
         /*
            There is a NULL pointer as name specified.
         */
         s32ErrorValue = OSAL_ERROR;
         OSAL_vSetErrorCode( OSAL_E_INVALIDVALUE );
         break;
      }
      /*
         Check whether there is already a handle saved in the object.
      
         OSAL_ERROR: Dirty OSAL hack. See comment in constuctor.
      */
      if (OSAL_ERROR != this->hSharedMemoryHandle)
      {
         /*
            Set the error to tell the user there exists already an 
            opened shared memory area.
         */
         s32ErrorValue = OSAL_ERROR;
         OSAL_vSetErrorCode( OSAL_E_ALREADYEXISTS );
         break;
      }
      s32ErrorValue = this->s32SaveName( coszName, (tCString&)this->szName );
      /*
         Check whether there is already a name saved in the object.
      */
      if (OSAL_OK == s32ErrorValue)
      {
         s32ErrorValue = OSAL_SharedMemoryOpen( coszName, 
                                                   enAccess );
         if (OSAL_ERROR != s32ErrorValue)
         {
            /*
               Save the object internal values.
            
               OSAL_ERROR: Dirty OSAL hack. See comment in constuctor.
            */
            this->hSharedMemoryHandle = s32ErrorValue;
            /*
               Delete the new name string.
            */
            OSAL_vMemoryFree( (tPVoid)szTempName );
            s32ErrorValue = OSAL_OK;
         }
         else
         {
            /*
               Delete the new name string.
            */
            OSAL_vMemoryFree( (tPVoid)this->szName );
            /*
               Restore the last name.
            */
            this->szName = szTempName;
         }
      }
      else
      {
         /*
            Restore the last name.
         */
         this->szName = szTempName;
      }
   }
   while (FALSE);
   return s32ErrorValue;
}
/*
   This methode opens a shared memory area with the name stored
   in this object.
   (This is an additional method!)

   Additional Errors or meaning:
   OSAL_E_ALREADYEXISTS: There exists already an opened shared memory area.
   OSAL_E_UNKNOWN: There is no name saved in the object. 
                   (Use s32Open( tCString coszName ) )
*/
tS32 OSAL_tclSharedMemory::s32Open( OSAL_tenAccess enAccess ) /* (I) */
{
   OSAL_tShMemHandle s32ErrorValue = OSAL_OK;
   do
   {
      /*
         Check whether there is already a handle saved in the object.
      
         OSAL_ERROR: Dirty OSAL hack. See comment in constuctor.
      */
      if (OSAL_ERROR != this->hSharedMemoryHandle)
      {
         /*
            Set the error to tell the user there exists already an 
            opened shared memory area.
         */
         s32ErrorValue = OSAL_ERROR;
         OSAL_vSetErrorCode( OSAL_E_ALREADYEXISTS );
         break;
      }
      if (OSAL_NULL == this->szName)
      {
         /*
            Set the error to tell the user there is no name specified.
         */
         s32ErrorValue = OSAL_ERROR;
         OSAL_vSetErrorCode( OSAL_E_UNKNOWN );
         break;
      }
      s32ErrorValue = OSAL_SharedMemoryOpen( this->szName, 
                                                enAccess );
      if (OSAL_ERROR == s32ErrorValue)
      {
         /*
            Initialise the internal value.
         
            OSAL_ERROR: Dirty OSAL hack. See comment in constuctor.
         */
         this->hSharedMemoryHandle = OSAL_ERROR;
      }
      else
      {
         /*
            Save the object internal value.
         
            OSAL_ERROR: Dirty OSAL hack. See comment in constuctor.
         */
         this->hSharedMemoryHandle = s32ErrorValue;
         s32ErrorValue = OSAL_OK;
      }
   }
   while (FALSE);
   return s32ErrorValue;
}
/*
   This methode closes a shared memory area.
   (For more detail see OSAL Refernzhandbuch Kapitel Shared Memory.)
*/
tS32 OSAL_tclSharedMemory::s32Close( )
{
   tS32 s32ErrorValue = OSAL_OK;
   if (OSAL_ERROR != this->hSharedMemoryHandle)
   {
      s32ErrorValue = OSAL_s32SharedMemoryClose( this->hSharedMemoryHandle );
      if (OSAL_OK == s32ErrorValue)
      {
         /*
            OSAL_ERROR: Dirty OSAL hack. See comment in constuctor.
         */
         this->hSharedMemoryHandle = OSAL_ERROR;
      }
   }
   return s32ErrorValue;
}
/*
   This methode deletes the shared memory area. 
   Before deleting the shared memory area the methode s32Close will be
   performed to close the shared memory area. After performing this 
   methode this shared memory area object provides no shared memory 
   functionality but it is possible to create a new shared memory area 
   in the same object.
   (For more detail see OSAL Refernzhandbuch Kapitel Shared Memory.)
*/
tS32 OSAL_tclSharedMemory::s32Delete( )
{
   tS32 s32ErrorValue = OSAL_OK;
   tU32 u32ErrorCode = OSAL_E_NOERROR;
   do
   {
      /*
         OSAL_ERROR: Dirty OSAL hack. See comment in constuctor.
      */
      if (OSAL_ERROR != this->hSharedMemoryHandle)
      {
         /*
            The shared memory area is still open. Close them.
         */
         s32ErrorValue = this->s32Close();
      }
      if (OSAL_OK == s32ErrorValue)
      {
         /*
            Reset the value of the handel.
         
            OSAL_ERROR: Dirty OSAL hack. See comment in constuctor.
         */
         this->hSharedMemoryHandle = OSAL_ERROR;
      }
      else
      {
         break;
      }
      s32ErrorValue = OSAL_s32SharedMemoryDelete( this->szName );
      u32ErrorCode = OSAL_u32ErrorCode();
      if (( OSAL_OK == s32ErrorValue )
          ||
          (
             ( OSAL_ERROR == s32ErrorValue )
             &&
             ( OSAL_E_INVALIDVALUE == u32ErrorCode)
          ))
      {
         /*
            Delete the name string.
         */
         OSAL_vMemoryFree( (tPVoid)this->szName);
         this->szName = OSAL_NULL;
      }
   }
   while (FALSE);
   return s32ErrorValue;
}
/*
   This methode returns a pointer to the requested memory or OSAL_NULL.
   In case of OSAL_NULL there is also set an errorcode.
   (For more detail see OSAL Refernzhandbuch Kapitel Shared Memory.)
*/
tPVoid OSAL_tclSharedMemory::pvMap( OSAL_tenAccess enAccess,    /* (I) */
                                    tU32           u32Length,   /* (I) */
                                    tU32           u32Offset )  /* (I) */
{
   return OSAL_pvSharedMemoryMap( this->hSharedMemoryHandle,
                                  enAccess,
                                  u32Length,
                                  u32Offset );
}
/*
   This methode releases the pointer to the shared memory.
   (For more detail see OSAL Refernzhandbuch Kapitel Shared Memory.)
*/
tS32 OSAL_s32Unmap( tPVoid pvSharedMemory, /* (I) */
                    tU32   u32Size )       /* (I) */
{
   return OSAL_s32SharedMemoryUnmap( pvSharedMemory,
                                     u32Size );
}
/* 
   The following methods are new and/or with modification 
   to the OSAL specification. 
*/
/*
   To get the name of the created shared memory area this methode can be used.
   After deletion the shared memory area there is no name available furthermore.
*/
tCString OSAL_tclSharedMemory::pszGetName()
{
   return this->szName;
}
