/************************************************************* +MHDR * .MA *

 .FILE             [ osmsg.cpp  ]

 .SW-COMPONENT      osal

 .DESCRIPTION
  This file contains the implementation of the class OSAL_tclMessage.

 .COPYRIGHT            [ (c) 2001 Robert Bosch GmbH, Hildesheim           ]
 .AUTHOR               [ U. Walkling                                      ]

 .HISTORY

  Date     | Name            Modification
 ----------|---------------------------------------------------------------
  05.02.02 | CM-DI/EST-Wg    New
************************************************************** -MHDR * .ME */
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
/* Constructor of this class. */
OSAL_tclMessage::OSAL_tclMessage()
{
   /*
      Initialisation of the member variables of the class.
   */
   MessageDescriptor.enLocation = OSAL_EN_MEMORY_INVALID;
   MessageDescriptor.u32Offset = 0;
}
/* Constructor of this class. */
OSAL_tclMessage::OSAL_tclMessage( OSAL_trMessage& rfMessage )
{
   /*
      Copy the content of the in parameter into the member variable
      of the class.
   */
   MessageDescriptor.enLocation = rfMessage.enLocation;
   MessageDescriptor.u32Offset = rfMessage.u32Offset;
}
/* Destructor of this class. */
OSAL_tclMessage::~OSAL_tclMessage()
{
}
/*
   This methode creates a message in the spezified location.
   (For more details see OSAL Refernzhandbuch Kapitel Nachrichtenverwaltung.)
*/
tS32 OSAL_tclMessage::s32Create
        ( 
           tU32                    u32Size,      /* (I) */
           OSAL_tenMemoryLocation  enLocation    /* (I) */
        )
{
   return OSAL_s32MessageCreate( &this->MessageDescriptor, u32Size, enLocation );
}
/*
   This methode deletes a message.
   (For more details see OSAL Refernzhandbuch Kapitel Nachrichtenverwaltung.)
*/
tS32 OSAL_tclMessage::s32Delete()
{
   return OSAL_s32MessageDelete( this->MessageDescriptor );
}
/*
   This methode returns a pointer to the message content.
   (For more details see OSAL Refernzhandbuch Kapitel Nachrichtenverwaltung.)
*/
tPU8 OSAL_tclMessage::pu8ContentGet( OSAL_tenAccess Right ) /* (I) */
{
   return OSAL_pu8MessageContentGet( this->MessageDescriptor, Right );
}
