#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

/* --OSAL_tclMessageQueue. */

/* --Simple original OSAL-like methods. */

tS32 OSAL_tclMessageQueue::s32Status(tPU32 pu32MaxMessages, 
						tPU32 pu32MaxLength, tPU32 pu32Messages) {
	return OSAL_s32MessageQueueStatus(hMQ, pu32MaxMessages, pu32MaxLength, pu32Messages);
}

tS32 OSAL_tclMessageQueue::s32Post(tPCU8 pcou8Msg, tU32 u32Length, tU32 u32Prio) {
	return OSAL_s32MessageQueuePost(hMQ, pcou8Msg, u32Length, u32Prio);
}
	
tS32 OSAL_tclMessageQueue::s32Wait(tPU8 pu8Buffer, tU32 u32Length, tPU32 pu32Prio,
										  OSAL_tMSecond msec) {
	return OSAL_s32MessageQueueWait(hMQ, pu8Buffer, u32Length, pu32Prio, msec);
}

/* --Open, Create, Close, Delete. */

tS32 OSAL_tclMessageQueue::s32Create(tCString coszName, tU32 u32MaxMessages, 
											tU32 u32MaxLength, OSAL_tenAccess enAccess) {
	tS32 s32ReturnValue=OSAL_ERROR;
	if (coszName) {
		if (hMQ==OSAL_C_INVALID_HANDLE) {
			/* --Store the name. */
			OSAL_vMemoryFree(szName);
			szName = (tChar*) OSAL_pvMemoryAllocate(OSAL_u32StringLength(coszName)+1);
			if (szName) {
				OSAL_szStringCopy(szName,coszName);
				s32ReturnValue=OSAL_s32MessageQueueCreate(coszName, u32MaxMessages, u32MaxLength,
																						enAccess, &hMQ);
			} else
				/* --No Memory available. */
				OSAL_vSetErrorCode(OSAL_E_NOSPACE);
		} else
			/* --Already opened. */		
			OSAL_vSetErrorCode(OSAL_E_ALREADYOPENED);
	} else
		/* --Invalid parameter. */
		OSAL_vSetErrorCode(OSAL_E_INVALIDVALUE);
	/* --Return. */
	return s32ReturnValue;
}

tS32 OSAL_tclMessageQueue::s32Open(tCString coszName, OSAL_tenAccess enAccess) {
	tS32 s32ReturnValue=OSAL_ERROR;
	if (coszName) {
		if (hMQ==OSAL_C_INVALID_HANDLE) {
			/* --Store the name. */
			OSAL_vMemoryFree(szName);
			szName=(tChar*) OSAL_pvMemoryAllocate(OSAL_u32StringLength(coszName)+1);
			if (szName) {
				OSAL_szStringCopy(szName,coszName);
				s32ReturnValue=OSAL_s32MessageQueueOpen(coszName, enAccess, &hMQ);
            if(s32ReturnValue != OSAL_OK)  /*Wn*/
            {
               hMQ = OSAL_C_INVALID_HANDLE;
            }
			} else
				/* --No Memory available. */
				OSAL_vSetErrorCode(OSAL_E_NOSPACE);
		} else
			/* --Already opened. */		
			OSAL_vSetErrorCode(OSAL_E_ALREADYOPENED);
	} else
		/* --Invalid parameter. */
		OSAL_vSetErrorCode(OSAL_E_INVALIDVALUE);
	/* --Return. */
	return s32ReturnValue;	
}
	
tS32 OSAL_tclMessageQueue::s32Close() {
	tS32 s32ReturnValue=OSAL_s32MessageQueueClose(hMQ);
	hMQ=OSAL_C_INVALID_HANDLE;
	return s32ReturnValue;
}

tS32 OSAL_tclMessageQueue::s32Delete() {
	/* --Check if closed. */
	if (hMQ!=OSAL_C_INVALID_HANDLE)
		if (s32Close()==OSAL_OK)
			return OSAL_s32MessageQueueDelete(szName);
	return OSAL_ERROR;
}

OSAL_tclMessageQueue::OSAL_tclMessageQueue():hMQ(OSAL_C_INVALID_HANDLE),
	szName(0) {}

OSAL_tclMessageQueue::~OSAL_tclMessageQueue() {
	/* --Hopefully works. The destructor cannot return any value. */
	if (hMQ!=OSAL_C_INVALID_HANDLE)
		OSAL_tclMessageQueue::s32Close();
	/* --Delete the string. */
	OSAL_vMemoryFree(szName);
}

/* --Notification. */

tVoid OSAL_tclMessageQueue::vOnMessageReceived() {}

tS32 OSAL_tclMessageQueue::s32Notify(tBool bSetNotification) {
	return OSAL_s32MessageQueueNotify(hMQ,(bSetNotification==TRUE ? vCallback : 0),this);
}

tVoid OSAL_tclMessageQueue::vCallback(tPVoid pvObject) {
	((OSAL_tclMessageQueue*)pvObject)->vOnMessageReceived();
}

