/************************************************************* +MHDR * .MA *

 .FILE             [ osalbase.cpp  ] 

 .SW-COMPONENT      osal

 .DESCRIPTION
  This file contains the implementation of the class OSAL_tclBase.

 .COPYRIGHT            [ (c) 2001 Robert Bosch GmbH, Hildesheim           ]
 .AUTHOR               [ U. Walkling                                      ]

 .HISTORY

  Date     | Name            Modification
 ----------|---------------------------------------------------------------
  28.01.02 | CM-DI/EST-Wg    New
  12.02.02 | CM-DI/EST-Wg    include osal.h replaced
************************************************************** -MHDR * .ME */
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
/* Constructor of this class. */
OSAL_tclBase::OSAL_tclBase()
{
}
/* Destructor of this class. */
OSAL_tclBase::~OSAL_tclBase()
{
}
/*
   Get memory for the name and save the name in it.
*/
tS32 OSAL_tclBase::s32SaveName( tCString coszName,           /* (I) */
                                tCString& rfszDestinationName /* (I) */)
{
   intptr_t s32NameLength = 0;
   tS32 s32ErrorValue = OSAL_OK;
   do
   {
      if (OSAL_NULL == coszName)
      {
         /*
            Set the error depending of the result of the memory allocation.
         */
         s32ErrorValue = OSAL_ERROR;
         OSAL_vSetErrorCode( OSAL_E_INVALIDVALUE );
         break;
      }
      s32NameLength = (tS32)OSAL_u32StringLength( coszName ) + 1;
      rfszDestinationName = (tString) OSAL_pvMemoryAllocate( s32NameLength );
      if (NULL == rfszDestinationName)
      {
         /*
            Set the error depending of the result of the memory allocation.
         */
         s32ErrorValue = OSAL_ERROR;
         OSAL_vSetErrorCode( OSAL_E_NOSPACE );
      }
      else
      {
         /*
            Copy the input string into the member variable.
         */
         OSAL_pvMemoryCopy((tPVoid) rfszDestinationName, (tPCVoid) coszName, s32NameLength);
      }
   }
   while (FALSE);
   return s32ErrorValue;
}
