/* Generated by Together */

#ifndef MINISPM_H
#define MINISPM_H

#define OSALEX_S_IMPORT_INTERFACE_GENERIC
#include "osalex_if.h"

#include "appmanager.h"

class MiniSpm 
{
   private:
      OSAL_tSemHandle     m_hProgressProtection;
      OSAL_tMQueueHandle  m_hSpmQueue;
      tBool               m_bSpmQueueCreatedByMe;
      tBool               m_bMsgPoolCreatedByMe;

      AppManager *m_poAppManager;

      OSAL_tSemHandle m_phAllNormalEvent;

      const char *m_szAppsToWaitFor;

      typedef std::vector<tU32> tStateVector;

      /** Das nullte Element ist immer der aktuelle State! */
      tStateVector m_oStateList;
      OSEXMutex m_oStateListLock;

      //tU32 m_u32RequestedState;

   public:
      MiniSpm();
      ~MiniSpm();

      tS32 s32StartApplications(OSAL_tSemHandle phAllNormalEvent, const char *szApps);
      tS32 s32TerminateApplications();

      void vPauseApplications(OSAL_tSemHandle hAllDoneEvent);
      void vNormalizeApplications(OSAL_tSemHandle hAllDoneEvent);

      OSAL_tMQueueHandle hGetSpmQueueHandle();
      OSAL_tSemHandle hGetProtectionHandle();
      AppManager *poGetAppManager();

      static void AppStartThread(void *vMiniSpm);

   private:
      tS32 s32Init();
      void vDestroy();

      tS32 s32CCASendPowerMsg(tU16 u16PowerType, tU32 u32Data1, tU32 u32Data2, OSAL_tMQueueHandle m_hQueue, tU16 u16AppId);
      tS32 s32CCASendPowerMsg(tU16 u16PowerType, tU32 u32Data1, tU32 u32Data2, Application *app);
      tS32 s32CCASendSrvStatus(tU16 u16ServiceID, tU16 u16AppId, tU8 u8ServiceState,tU16 u16ClientAppID, OSAL_tMQueueHandle m_hQueue);
      tS32 s32CCASendAppInfoStatus(tU16 u16AppId, tU8 u8AppInfoState,tU16 u16ClientAppID, OSAL_tMQueueHandle m_hQueue);

      tU32 u32GetRegValue(tChar *RegEntryName, tChar *KeyName, tU32 u32DefaultValue);
      friend class AppManager;

      tS32 s32CCASendStateRequestMessage (tU8 u8Request, OSAL_tSemHandle hAllDoneEvent);

      static bool bGetRegValueDWord(const char *name, tU32 *pu32Value, tU32 defaultValue);

      tS32 s32FindPosOfState(tU32 u32State);
      void vTogglePauseNormalHelper (OSAL_tSemHandle hAllDoneEvent, tU32 u32TargetState);
};
#endif //MINISPM_H
