/* Generated by Together */

#ifndef APPLICATION_H
#define APPLICATION_H

#include <vector>

#include "CCAMessages.h"

class Application
{
   public:
      Application(tU16 u16AppId, OSAL_tMQueueHandle hMsgQueue, tU16 u16AppState);

      tU16 u16GetAppId();

      OSAL_tMQueueHandle hGetMsgQueueHandle();
      void vSetMsgQueueHandle(OSAL_tMQueueHandle hQueue);

      void vSetAppState(tU16 u16AppState);
      tU16 u16GetAppState();

      void vSetAppReqState(tU16 u16AppReqState);
      tU16 u16GetAppReqState();

      void vAddServiceId(tU16 u16ServiceId);
      tBool bCheckAppServiceProvider(tU16 u16ServiceId);

   private:
      tU16 m_u16AppId;
      OSAL_tMQueueHandle m_hMsgQueue;
      tU16 m_u16AppState;
      tU16 m_u16AppReqState;
      typedef std::vector<tU16> tServiceVector;
      tServiceVector m_ServiceVector;
};

class tclSrvSupplier
{
    class tclInterestedServiceInfo
    {
    public:
        tU8  m_u8ServiceState;
        tU16 m_u16ServiceId;
    };
    // Requesting application ID
    tU16 m_u16ClientAppId;
    typedef std::vector<tclInterestedServiceInfo *> tIntrSrvSuppVector;
public:
    tIntrSrvSuppVector m_oIntrSrvSuppVector;

    tclSrvSupplier(tU16 u16ClientAppId):m_u16ClientAppId(u16ClientAppId){}
    tU16 u16GetAppId(){return m_u16ClientAppId;}
    tBool bSrvSuppRegister(tU16 u16ServiceId);
    tBool bSrvSuppUnRegister(tU16 u16ServiceId);
    tU8 u8GetServiceInfoState(tU16 u16ServiceId);
    tBool bSetServiceInfoState(tU16 u16ServiceId,tU8 u8ServiceState);
    tclInterestedServiceInfo* poGetSrvSuppInfo(tU16 u16ServiceId);
    ~tclSrvSupplier();

};


class tclAppInfoService 
{
    // Requesting application ID
    tU16 m_u16ClientAppId;
    // Appid and states of the requested application
    class tclInterestedAppInfo
    {
    public:
        tU8 m_u8AppInfoState;
        tU16 m_u16AppId;
    };

    typedef std::vector<tclInterestedAppInfo *> tIntrAppInfoVector;
    // Requesting application may be interested in more than one application
public:
    tIntrAppInfoVector m_oIntrAppInfoVector;
    tclInterestedAppInfo * poGetIntrAppInfo(tU16 u16AppId);

    tclAppInfoService(tU16 u16ClientAppId):m_u16ClientAppId(u16ClientAppId){}
    ~tclAppInfoService();
    tBool bAppInfoRegister(tU16 u16AppId);
    tBool bAppInfoUnRegister(tU16 u16AppId);
    tBool bSetAppInfoState(tU16 u16AppId,tU8 u8AppInfoState);
    tU8 u8GetAppInfoState(tU16 u16AppId);
    tU16 u16GetAppId() {return m_u16ClientAppId;}

};

#endif //APPLICATION_H
