/* Generated by Together */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "CCAMessages.h"

#include "minispm.h"
#include "appmanager.h"
#include "application.h"

#define MINIPROFILER_S_IMPORT_INTERFACE_ITRACE
#define ENABLE_INTERNAL_TRACE
#define ITRACE_TO_CONSOLE
#include "mini_profiler_if.h"

#define SCD_MAX_POOL_SIZE_VALUE_NAME      "MAXPOOLSIZE"


#define MINISPM_SEMAPHORE_NAME "MiniSPMSem"
#define MBX0 "mbx_0"
#define MBX0_MAXMESSAGES 100
#define MBX0_MAXMESSAGESIZE sizeof(OSAL_trMessage)
#define MESSAGE_POOL_SIZE (1024*1024)


struct trThreadArgument
{
   const char *m_szAppsToStart;
   MiniSpm *m_this;

   trThreadArgument(const char *szAppsToStart, MiniSpm *__this)
      : m_szAppsToStart (szAppsToStart)
      , m_this (__this)
   {
   }
};

void MiniSpm::AppStartThread(void *pvThreadArgument)
{
   // warten, damit alle Clients Gelegenheit bekommen, den Startup-Request zu platzieren!
   //OSAL_s32ThreadWait (1000);

   trThreadArgument *poArgument = (trThreadArgument *) pvThreadArgument;

   MiniSpm *_this = poArgument->m_this;
   const char *szAppsToStart = poArgument->m_szAppsToStart;

   delete poArgument;

   AppManager *poAppManager = _this->poGetAppManager();
   poAppManager->vStartApps(szAppsToStart);

   OSAL_s32SemaphorePost(_this->hGetProtectionHandle());
}

OSAL_tSemHandle MiniSpm::hGetProtectionHandle()
{
   return m_hProgressProtection;
}


AppManager *MiniSpm::poGetAppManager()
{
   return m_poAppManager;
}


MiniSpm::MiniSpm()
: m_hProgressProtection (OSAL_C_INVALID_HANDLE)
, m_hSpmQueue (OSAL_C_INVALID_HANDLE)
, m_bSpmQueueCreatedByMe (FALSE)
, m_bMsgPoolCreatedByMe (FALSE)
, m_poAppManager(NULL)
, m_phAllNormalEvent (OSAL_C_INVALID_HANDLE)
, m_szAppsToWaitFor(NULL)
//, m_u32RequestedState (AMT_C_U32_STATE_INVALID)
{
}



MiniSpm::~MiniSpm()
{
   if (m_hProgressProtection != OSAL_C_INVALID_HANDLE)
   {
      OSAL_s32SemaphoreClose(m_hProgressProtection);
      OSAL_s32SemaphoreDelete(MINISPM_SEMAPHORE_NAME);
   }
}


bool MiniSpm::bGetRegValueDWord(const char *name, tU32 *pu32Value, tU32 defaultValue)
{
    bool bSuccess = false;

    OSAL_tIODescriptor fd = OSAL_IOOpen ("/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT", OSAL_EN_READONLY);
    if (fd != OSAL_ERROR)
    {
        OSAL_trIOCtrlRegistry arg;
        arg.pcos8Name = (tS8 *) name;
        arg.ps8Value = (tU8 *) pu32Value;
        arg.u32Size = sizeof(tU32);
        if (OSAL_s32IOControl (fd, OSAL_C_S32_IOCTRL_REGQUERYVALUE, (intptr_t) &arg) == OSAL_OK
            && arg.s32Type == OSAL_C_S32_VALUE_S32)
        {
            bSuccess = true;
        }
        else
        {
           *pu32Value = defaultValue;
        }
        OSAL_s32IOClose(fd);
    }

    return bSuccess;
}



tS32 MiniSpm::s32Init()
{
   tS32 s32Success = OSAL_OK;

   if (m_poAppManager == NULL)
   {
      if (m_hProgressProtection == OSAL_C_INVALID_HANDLE)
      {
         OSAL_s32SemaphoreCreate(MINISPM_SEMAPHORE_NAME, &m_hProgressProtection, 1);
      }

      if (m_hProgressProtection != OSAL_C_INVALID_HANDLE)
      {
         tU32 u32PoolSize = 0;
         bGetRegValueDWord(SCD_MAX_POOL_SIZE_VALUE_NAME, &u32PoolSize, 3*1024*1024);
         
         // create message pool, if case of failure, try to open it. if this fails, too --> ERROR!!!
         if ( OSAL_s32MessagePoolCreate(u32PoolSize)!= OSAL_OK )
         {
            if (OSAL_s32MessagePoolOpen() != OSAL_OK)
            {
               s32Success = OSAL_ERROR;
            }
         }
         else
         {
            m_bMsgPoolCreatedByMe = TRUE;
         }

         
         if (s32Success == OSAL_OK)
         {
            if (OSAL_s32MessageQueueCreate( MBX0, 
                                            MBX0_MAXMESSAGES, 
                                            MBX0_MAXMESSAGESIZE, 
                                            OSAL_EN_READWRITE, 
                                            &m_hSpmQueue ) != OSAL_OK )
            {
               if (OSAL_s32MessageQueueOpen( MBX0, 
                                             OSAL_EN_READWRITE, 
                                             &m_hSpmQueue ) != OSAL_OK)
               {
                  OSAL_s32SemaphoreClose(m_hProgressProtection);
                  OSAL_s32SemaphoreDelete(MINISPM_SEMAPHORE_NAME);
                  //scd_exit();
                  s32Success = OSAL_ERROR;
               }
            }
            else
            {
               m_bSpmQueueCreatedByMe = TRUE;
            }
         }
      }
   }
   else
   {
      s32Success = OSAL_ERROR;
   }

   if (s32Success == OSAL_OK)
   {
      m_poAppManager = new AppManager(this);
   }
   return s32Success;
}

void MiniSpm::vDestroy()
{
   //close the message-pool
   (tVoid)OSAL_s32MessagePoolClose();

   if ( m_bMsgPoolCreatedByMe )
   {
      // delete message-pool
      (tVoid)OSAL_s32MessagePoolDelete();
   }

   if (m_hSpmQueue != OSAL_C_INVALID_HANDLE)
   {
      OSAL_s32MessageQueueClose(m_hSpmQueue);
      if (m_bSpmQueueCreatedByMe == TRUE)
      {
         OSAL_s32MessageQueueDelete (MBX0);
      }
   }
   if (m_poAppManager != NULL)
   {
      delete m_poAppManager;
      m_poAppManager = NULL;
   }
}

tU32 MiniSpm::u32GetRegValue(tChar *RegEntryName, tChar *KeyName, tU32 u32DefaultValue)
{
    tU32 u32RetVal = u32DefaultValue;

    OSAL_tIODescriptor fd = OSAL_IOOpen (RegEntryName, OSAL_EN_READONLY);
    if (fd != OSAL_ERROR)
    {
        tU32 val;
        OSAL_trIOCtrlRegistry arg;
        arg.pcos8Name = (tS8 *) KeyName;
        arg.ps8Value = (tU8 *) &val;
        arg.u32Size = sizeof(val);
        if (OSAL_s32IOControl (fd, OSAL_C_S32_IOCTRL_REGQUERYVALUE, (intptr_t) &arg) == OSAL_OK)
        {
         u32RetVal = val;
        }
        OSAL_s32IOClose(fd);
    }

    return u32RetVal;
}

tS32 MiniSpm::s32StartApplications(OSAL_tSemHandle phAllNormalEvent, const char *szApps)
{
   m_oStateListLock.vLock();
   m_oStateList.push_back(AMT_C_U32_STATE_NORMAL);
   m_oStateListLock.vUnlock();

   s32Init();

   tS32 s32Success = OSAL_s32SemaphoreWait(m_hProgressProtection, OSAL_C_U32_INFINITE);
   if (s32Success == OSAL_OK)
   {
      OSAL_trThreadAttribute oStartThreadAtt;
      tU32 u32Priority = OSAL_C_U32_THREAD_PRIORITY_LOWEST;
      tS32  s32StackSize= 10000;
#if (( OSAL_OS==OSAL_WINCE ) || ( OSAL_OS==OSAL_LINUX) || ( OSAL_OS==OSAL_DARWIN))
      s32StackSize = u32GetRegValue("/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/OSAL/THREADS","MINI_SPM_STARTER_STCK",s32StackSize);
      u32Priority = u32GetRegValue("/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/OSAL/THREADS","MINI_SPM_STARTER_PRIO",u32Priority);
#endif
      oStartThreadAtt.pfEntry      = MiniSpm::AppStartThread;
      oStartThreadAtt.pvArg        = new trThreadArgument(szApps, this);
      oStartThreadAtt.s32StackSize = s32StackSize;
      oStartThreadAtt.szName       = "MINI_SPM_STARTER";
      oStartThreadAtt.u32Priority  = u32Priority;

      OSAL_tThreadID hThreadID = OSAL_ThreadSpawn (&oStartThreadAtt);
      if (hThreadID == OSAL_ERROR)
      {
         OSAL_s32SemaphorePost(m_hProgressProtection);
      }
      else
      {
         m_phAllNormalEvent = phAllNormalEvent;
      }
   }
   return s32Success;
}


tS32 MiniSpm::s32TerminateApplications()
{
   // warten und dadurch sicherstellen, dass der Startup beendet wurde:
   m_oStateListLock.vLock();
   m_oStateList.push_back(AMT_C_U32_STATE_NORMAL);
   m_oStateListLock.vUnlock();

   tS32 s32Success = OSAL_s32SemaphoreWait(m_hProgressProtection, OSAL_C_U32_INFINITE);

   if (m_poAppManager != NULL)
   {
      m_poAppManager->vEndApps();
      OSAL_s32SemaphoreWait(m_hProgressProtection, OSAL_C_U32_INFINITE);
      vDestroy();
   }
   OSAL_s32SemaphorePost(m_hProgressProtection);
   return OSAL_OK;
}


tS32 MiniSpm::s32FindPosOfState(tU32 u32State)
{
   tS32 s32Pos = -1;

   for (int i=0; i<(int) m_oStateList.size(); ++i)
   {
      if (m_oStateList[i] == u32State)
      {
         s32Pos = i;
         break;
      }
   }

   return s32Pos;
}



void MiniSpm::vPauseApplications(OSAL_tSemHandle hAllDoneEvent)
{
   vTogglePauseNormalHelper(hAllDoneEvent, AMT_C_U32_STATE_PAUSE);
}

void MiniSpm::vNormalizeApplications(OSAL_tSemHandle hAllDoneEvent)
{
   vTogglePauseNormalHelper(hAllDoneEvent, AMT_C_U32_STATE_NORMAL);
}

void MiniSpm::vTogglePauseNormalHelper (OSAL_tSemHandle hAllDoneEvent, tU32 u32TargetState)
{
   bool bDoStateRequest = false;

   m_oStateListLock.vLock();

   tS32 s32StatePos = s32FindPosOfState(u32TargetState);

   if (s32StatePos == -1)
   {
      // muss ausgefuehrt werden!
      m_oStateList.push_back(u32TargetState);
      bDoStateRequest = true;
      ITRACE(( "Mini-SPM: Statechange-Request to %u", 
               u32TargetState  ));
   }
   else if (s32StatePos == 0)
   {
      // Zustand ist aktuell!, keine weiteren State-Changes mehr durchfuehren!
      ITRACE(( "Mini-SPM: Skipping Statechange-Request to %u because its the current state!", 
               u32TargetState  ));
      while (m_oStateList.size() > 1)
      {
         m_oStateList.erase(m_oStateList.end()-1);
      }
   }
   else if (s32StatePos == 1)
   {
      // kann uebersprungen werden!
      ITRACE(( "Mini-SPM: Skipping Statechange-Request to %u because its already requested on pos %d!", 
               u32TargetState,
               s32StatePos  ));

      while (m_oStateList.size() > 2)
      {
         m_oStateList.erase(m_oStateList.end()-1);
      }
   }

   m_oStateListLock.vUnlock();

   if (bDoStateRequest == true)
   {
      if (OSAL_s32SemaphoreWait(m_hProgressProtection, OSAL_C_U32_INFINITE) == OSAL_OK)
      {
         if (s32CCASendStateRequestMessage( 
                                            DO_STATE_REQUEST,
                                            hAllDoneEvent
                                           ) == OSAL_ERROR)
         {
            OSAL_vAssert(0);
         }
      }
      else
      {
         OSAL_vAssert(0);
      }
   }
   else
   {
      if (hAllDoneEvent != OSAL_C_INVALID_HANDLE)
      {
         OSAL_s32SemaphorePost(hAllDoneEvent);
      }
   }
}


OSAL_tMQueueHandle MiniSpm::hGetSpmQueueHandle()
{
   return m_hSpmQueue;
}


tS32 MiniSpm::s32CCASendPowerMsg(tU16 u16PowerType, tU32 u32Data1, tU32 u32Data2, Application *app)
{
   return s32CCASendPowerMsg (u16PowerType, u32Data1, u32Data2, app->hGetMsgQueueHandle(), app->u16GetAppId());
}

tS32 MiniSpm::s32CCASendPowerMsg(tU16 u16PowerType, tU32 u32Data1, tU32 u32Data2, OSAL_tMQueueHandle m_hQueue, tU16 u16AppId)
{
   OSAL_trMessage hMessage;
   tS32 s32Result = OSAL_s32MessageCreate(&hMessage, sizeof(CPowerMsg), OSAL_EN_MEMORY_SHARED);

   if (s32Result == OSAL_OK)
   {
      tU8* pu8Mem = OSAL_pu8MessageContentGet(hMessage, OSAL_EN_READWRITE);

      CPowerMsg *oPowerMsg = (CPowerMsg *) pu8Mem; //lint !e826
      oPowerMsg->u16PowerType = u16PowerType;
      oPowerMsg->u32Data1 = u32Data1;
      oPowerMsg->u32Data2 = u32Data2;
      oPowerMsg->u16DestAppId = u16AppId;
      oPowerMsg->u16SourceAppId = 0; // LPM sends power messages
      oPowerMsg->u32Size = 32;

      oPowerMsg->u16SourceSubId = 0;
      oPowerMsg->u16DestSubId = 0;
      oPowerMsg->u32TimeStamp = 0;
      oPowerMsg->u16Dummy = 0;

      oPowerMsg->u16Version = 2;
      oPowerMsg->u8Context = 0;
      oPowerMsg->u8Type = 0x40;

      tS32 s32Success = OSAL_s32MessageQueuePost ( m_hQueue,
                                                   (tCU8*) &hMessage,
                                                   sizeof(OSAL_trMessage),
                                                   0  );
      if (s32Success == OSAL_ERROR)
      {
         OSAL_s32MessageDelete(hMessage);
      }
   }
   return s32Result;
}


tS32 MiniSpm::s32CCASendStateRequestMessage (tU8 u8Request, OSAL_tSemHandle hAllDoneEvent)
{
   OSAL_trMessage hMessage;
   tS32 s32Result = OSAL_s32MessageCreate(&hMessage, sizeof(CCCABaseMsg), OSAL_EN_MEMORY_SHARED);

   if (s32Result == OSAL_OK)
   {
      tU8* pu8Mem = OSAL_pu8MessageContentGet(hMessage, OSAL_EN_READWRITE);

      CCCABaseMsg *poMsg = (CCCABaseMsg *) pu8Mem; //lint !e826
      poMsg->u16DestAppId = 0;
      poMsg->u16SourceAppId = 0;
      poMsg->u16Version = 0;
      poMsg->u32Size = hAllDoneEvent;
      poMsg->u8Context = 0;
      poMsg->u8Type = u8Request;

      tS32 s32Success = OSAL_s32MessageQueuePost ( hGetSpmQueueHandle(),
                                                   (tCU8*) &hMessage,
                                                   sizeof(OSAL_trMessage),
                                                   0  );
      if (s32Success == OSAL_ERROR)
      {
         OSAL_s32MessageDelete(hMessage);
      }
   }
   return s32Result;
}

tS32 MiniSpm::s32CCASendSrvStatus(tU16 u16ServiceID, tU16 u16AppId, tU8 u8ServiceState,tU16 u16ClientAppID, OSAL_tMQueueHandle m_hQueue)
{
   OSAL_trMessage hMessage;
   tS32 s32Result = OSAL_s32MessageCreate(&hMessage, sizeof(CServiceSupplierStatus), OSAL_EN_MEMORY_SHARED);

   if (s32Result == OSAL_OK)
   {
      tU8* pu8Mem = OSAL_pu8MessageContentGet(hMessage, OSAL_EN_READWRITE);

      CServiceSupplierStatus *oServiceSuppStatus = (CServiceSupplierStatus *) pu8Mem; //lint !e826
      oServiceSuppStatus->m_u8ServiceSupplierState = u8ServiceState;
      oServiceSuppStatus->m_u16AppID = u16AppId;
      oServiceSuppStatus->m_u16ServiceID = u16ServiceID;
      oServiceSuppStatus->u16DestAppId = u16ClientAppID;
      oServiceSuppStatus->u16SourceAppId = 0; // LPM sends power messages
      oServiceSuppStatus->u32Size = 25;
      oServiceSuppStatus->m_u32TimeStamp = 0;
      oServiceSuppStatus->u16Version = 0;
      oServiceSuppStatus->u8Context = 0;
      oServiceSuppStatus->u8Type = AMT_C_U8_CCAMSGTYPE_SUPPLIER_STATE;

      tS32 s32Success = OSAL_s32MessageQueuePost ( m_hQueue,
                                                   (tCU8*) &hMessage,
                                                   sizeof(OSAL_trMessage),
                                                   0  );
      if (s32Success == OSAL_ERROR)
      {
         OSAL_s32MessageDelete(hMessage);
      }
   }
   return s32Result;
}
tS32 MiniSpm::s32CCASendAppInfoStatus(tU16 u16AppId, tU8 u8AppInfoState,tU16 u16ClientAppID, OSAL_tMQueueHandle m_hQueue)
{
   OSAL_trMessage hMessage;
   tS32 s32Result = OSAL_s32MessageCreate(&hMessage, sizeof(CApplicationInfoStatus), OSAL_EN_MEMORY_SHARED);

   if (s32Result == OSAL_OK)
   {
      tU8* pu8Mem = OSAL_pu8MessageContentGet(hMessage, OSAL_EN_READWRITE);

      CApplicationInfoStatus *oAppInfoStatus= (CApplicationInfoStatus *) pu8Mem; //lint !e826
      oAppInfoStatus->m_u16AppID = u16AppId;
      oAppInfoStatus->m_u8ApplicationInfoState = u8AppInfoState;
      oAppInfoStatus->m_u32Timestamp = 0;
      oAppInfoStatus->u16DestAppId = u16ClientAppID;
      oAppInfoStatus->u16SourceAppId = 0; // LPM sends power messages
      oAppInfoStatus->u32Size = 23;
      oAppInfoStatus->u16Version = 0;
      oAppInfoStatus->u8Context = 0;
      oAppInfoStatus->u8Type = AMT_C_U8_CCAMSGTYPE_APPLICATION_INFO;

      tS32 s32Success = OSAL_s32MessageQueuePost ( m_hQueue,
                                                   (tCU8*) &hMessage,
                                                   sizeof(OSAL_trMessage),
                                                   0  );
      if (s32Success == OSAL_ERROR)
      {
         OSAL_s32MessageDelete(hMessage);
      }
   }
   return s32Result;
}
