


#ifdef ENABLE_INTERNAL_TRACE
   #if defined(ITRACE_TO_CONSOLE)

      #define INIT_INTERNAL_SOCKET_TRACE
      #define SHUTDOWN_INTERNAL_SOCKET_TRACE
    #ifdef ANDROID
        #include <android/log.h>
        #define  LOG_TAG    "OsalNative"
        #define  LOGI(...)  __android_log_print(ANDROID_LOG_INFO,LOG_TAG,__VA_ARGS__)
        #define  LOGE(...)  __android_log_print(ANDROID_LOG_ERROR,LOG_TAG,__VA_ARGS__)
        #define ITRACE(x) LOGI x
    #else
        #define ITRACE(x) printf x; printf("\n")
    #endif

      #define ENABLED_ITRACE
   #elif defined(ITRACE_TO_SOCKET)

      void vInitInternalSocketTrace();
      void vShutdownInternalSocketTrace();
      void vTraceInternal (const char *data, ...);

      #define INIT_INTERNAL_SOCKET_TRACE      vInitInternalSocketTrace();
      #define SHUTDOWN_INTERNAL_SOCKET_TRACE  vShutdownInternalSocketTrace();
      #define ITRACE(FormatString) vTraceInternal FormatString;

      #define ENABLED_ITRACE
   #elif defined(ITRACE_TO_FILE) 
      void vInitInternalFileTrace();
      void vShutdownInternalFileTrace();
      void vTraceInternalFile (const char *data, ...);

      #define INIT_INTERNAL_SOCKET_TRACE      vInitInternalFileTrace();
      #define SHUTDOWN_INTERNAL_SOCKET_TRACE  vShutdownInternalFileTrace();
      #define ITRACE(FormatString) vTraceInternalFile FormatString;

      #define ENABLED_ITRACE
   #endif
#endif

#ifndef ENABLED_ITRACE
   #define INIT_INTERNAL_SOCKET_TRACE
   #define SHUTDOWN_INTERNAL_SOCKET_TRACE
   #define ITRACE(x)
#endif

#undef ENABLED_ITRACE
