/****************************************************************************
* FILE                      [ $Workfile:   system_errmem_def.h  $ ]
* PROJECT (1st APPLICATION) [ ELeNa ]
* ---------------------------------------------------------------------------
* EXPLANATION
* Definition of ERRMEM-Entries
*
* Define the types of global ERRMEM Entries
* Use the following sequence to get the defines in your context
*     #define SYSTEM_S_IMPORT_INTERFACE_ERRMEM_DEF
*     #include "system_pif.h"
*
* ---------------------------------------------------------------------------
* Last Review:
* ---------------------------------------------------------------------------
* COPYRIGHT (c) 2003 Blaupunkt GmbH, Hildesheim
* AUTHOR    [ CM-CR/EES4 Kania ]
* ---------------------------------------------------------------------------
* HISTORY AT THE END OF THE FILE
****************************************************************************/
#ifndef SYSTEM_ERRMEM_DEF_HEADER
   #define SYSTEM_ERRMEM_DEF_HEADER

//=========================================================================
//=========================================================================
//  ERRMEM ENTRIES FOR SYSTEM GLOBAL ERRORS "TR_COMP_SYSTEM"
//=========================================================================
//=========================================================================

   #ifdef TR_COMP_SYSTEM
      #if TR_COMP_SYSTEM != 0
         #error "Unexpected TR_COMP_SYSTEM"
      #endif
   #endif

/*=========================================================================
   Used in File:
   products\nucleus_core\init\nucleus\Tuareg\common\int_interrupt.c
===========================================================================*/
/* Description: Unhandled CPU Exception
   State      : Fatal-Error
   Result     : Reset
   Data       : typedef struct
                  {
                     unsigned int R0;
                     unsigned int R1;
                     unsigned int R2;
                     unsigned int R3;
                     unsigned int R4;
                     unsigned int R5;
                     unsigned int R6;
                     unsigned int R7;
                     unsigned int R8;
                     unsigned int R9;
                     unsigned int R10;
                     unsigned int R11;
                     unsigned int R12;
                     unsigned int StackPointer;
                     unsigned int InstrAddress;
                     unsigned int ExceptedModePSR;
                     unsigned int ExceptionModePSR;
                  } Exception_t;
*/
   #define U16_ERRMEM_CPU_EXCEPTION_ERROR      (0x0001)

/* Description: Unhandled interrupt received
                This is no fatal error. So, it is tried to store as normal error first.
                If this is not possible (maybe the ERRMEM isn't already initialised,
                the error is stored as fatal but without forcing a reset!
   State      :
   Result     : Store Fatal Error and clear interrupt
   Data       : Registervalue of EIC_CICR (tU32) is stored.
                Value is number of current Interrupt
*/
   #define U16_ERRMEM_NOT_HANDLED_INT_ERROR    (0x0002)

/*=========================================================================
   Used in File:
   products\nucleus_driver\common\nucleus\Tuareg\lld_common\armerror.c
===========================================================================*/

/* Description: Internal Function "__rt_trap" has been called. It is used
                to mark an "Library error".
   State      : Fatal error
   Result     : Reset
   Data       : Some of the data given to the function by parameter is
                stored:
*/
   #define U16_ERRMEM_TRAP_ERROR     (0x0003)
/* Structure of error storage */
typedef struct
{
   unsigned ErrCode;
   unsigned regs[16];
} tr_err_trap;

/* Description: Internal Function "__rt_raise" has been called. It is used
                to mark an "Library error".
   State      : Fatal error
   Result     : Reset
   Data       : The data given to the function by parameter is stored:
*/
   #define U16_ERRMEM_RAISE_ERROR    (0x0004)

/* Structure of error storage */
typedef struct
{
   int      signal;
   int      type;
} tr_err_raise;

/* Description: The assert function has been called.
                This is processed by the internal function "__assert".
   State      : Fatal error
   Result     : Reset
   Data       : The data given to the function by parameter is stored
                as an zero terminated string. The formmat of the entry is:
                File:Line:Expression
                If all information don't fit in the ERRMEM data field,
                the string is cut.
*/
   #define U16_ERRMEM_ASSERT_ERROR   (0x0005)

/* Description: This Error is called by the internal function "abort".
   State      : Fatal error
   Result     : Reset
   Data       : No data is given to the function, so there is no data stored.
*/
   #define U16_ERRMEM_ABORT_ERROR    (0x0006)

/* Description: This Error is called by the osal core function "nucleus_vSysCntrl_Error".
   State      : Fatal error
   Result     : Reset
   Data       : The calling params tS32 s32Class, tS32 s32ID, tS32 s32Code are
                posted in the buffer:
*/
   #define U16_ERRMEM_SYSCNTRL_ERROR (0x0007)

/* Structure of error storage */
typedef struct
{
   signed long s32Class;
   signed long s32ID;
   signed long s32Code;
} trSysCntrl_Error;

/*=========================================================================
   Used in File:
   products\nucleus_core\init\nucleus\Tuareg\common\int_interrupt.c
===========================================================================*/
/* Description: Unhandled CPU Exception
   State      : Fatal-Error
   Result     : Reset
   Data       : structure trExceptionData
*/
   #define U16_ERRMEM_CPU_EXCEPTION_ERROR_FULL   (0x0008)

/* Structure of error storage */
/* be sure to set the same values then in vectors.s */
   #ifndef NU_MAX_NAME
      #define NU_MAX_NAME           8
   #endif
   #ifndef PROZ_REGISTER_NUMBER
      #define PROZ_REGISTER_NUMBER  17
   #endif
   #ifndef EXCEPTION_DEEPNESS
      #define EXCEPTION_DEEPNESS    10
   #endif
typedef enum
{
   INT_Undef_Inst       = 0,
   INT_Software         = 1,
   INT_Prefetch_Abort   = 2,
   INT_Data_Abort       = 3,
   INT_Reserved         = 4
} enExceptionReason;

typedef struct
{
   enExceptionReason  exception_reason;
   tChar scTaskName[NU_MAX_NAME]; /* Name of task making exception */
   tU32  exception_address;
   tU32  exception_registers[PROZ_REGISTER_NUMBER];
   tU32  exception_backtrace[EXCEPTION_DEEPNESS];
} trExceptionData;


/*=========================================================================
   Used in File:
   products\nucleus_core\core\nucleus\Tuareg\sources\dmce.c
===========================================================================*/
/* Description: memory (de-)allocation error
   State      : Fatal-Error
   Result     : Reset
   Data       : structure trExceptionData
*/
   #define U16_ERRMEM_MEMALLOC_ERROR   (0x0009)

typedef struct
{
   tS32  s32Error;
   tU8   au8TaskName[NU_MAX_NAME]; /* Name of task making exception */
   tU32  u32Blck;
   tU32  u32Mem;
   tU32  u32MemSize;
   tU32  u32Blck_Next;
   tU32  u32Blck_Size;
} trMemAlloc_Error;


/*=========================================================================
   Used in File:
   products\
===========================================================================*/
/* Description: SW-Watchdog Error
   State      : Info if Timeouttime has ovberrun or Fatal if WD Resets System
   Result     : Normal or Reset
   Data       : tString
*/
   #define U16_SW_WD   (0x000A)



/*=========================================================================
   Used in File:
   products\nucleus_driver\common\nucleus\Tuareg\lld_common\armerror.c
===========================================================================*/
/* Description: The assert function has been called.
                This is processed by the internal function "__assert".
   State      : Fatal error
   Result     : Reset
   Data       : The data given to the function by parameter is stored
                as an zero terminated string. The formmat of the entry is:
                File:Line:Expression
                If all information don't fit in the ERRMEM data field,
                the string is cut.
                Additionally a set of backtrace pointer is given.
*/
   #define U16_ERRMEM_ASSERT_EX_ERROR   (0x000B)

   #ifndef ASSERT_EX_DEEPNESS
      #define ASSERT_EX_DEEPNESS    10
   #endif

   #ifndef ASSERT_EX_MAX_STRING_LENGTH
      #define ASSERT_EX_MAX_STRING_LENGTH    (ERRMEM_MAX_ENTRY_LENGTH - ASSERT_EX_DEEPNESS * 4)
   #endif

typedef struct
{
   tChar au8Assert[ASSERT_EX_MAX_STRING_LENGTH];
   tU32  assert_backtrace[ASSERT_EX_DEEPNESS];
} trAssertExData;


/*=========================================================================
   Used in File:
   products\nucleus_osal\osal_core\sources\osalcontrol.c
===========================================================================*/
/* Description: System Test Error
   State      : Info about tasks with highest schedule counts in case of
                SW watchdog is occured
   Result     : Normal
   Data       : structure buffer
*/
   #define U16_ERRMEM_SYSTEMTEST   (0x000C)

#define C_THREADSCHINFO_BUFFER_SIZE    5

typedef struct tr_ThreadSchInfo_Struct
{
   tChar    aTname[NU_MAX_NAME];
   tU32     u32Sched;
} tr_ThreadSchInfo;


/*=========================================================================
   Used in File:
   products\nucleus_osal\osal_core\sources\osaltime.c
===========================================================================*/
/* Description: OSAL Timer Error
   State      : Info timer callback function which seems to block the system.
   Result     : RESET
   Data       : tS32
*/
   #define U16_ERRMEM_OSTIME   (0x000D)


   /* Entry for original trace entries, stored in error memory */
   /* used with the dev_errmem.c function lldErrMem_WriteFatalTrace() */
   #define U16_ERRMEM_TRACE   (0x000E)


   /* Nucleus internal trace */
   #define U16_ERRMEM_NUCLEUS_TRACE  (0x000F)



//=========================================================================
//=========================================================================
//  ERRMEM ENTRIES FOR OSAL DEVICES "TR_COMP_OSALIO"
//=========================================================================
//=========================================================================

/*=========================================================================
Used in Module:
products\nucleus_driver\spi\nucleus\Tuareg\dev_spi
===========================================================================*/
/* Description: This region can be used to store Errors while transmitting
                on any bus
   State      : Normal errors
   Result     : store errmem entry and continue
   Data       : string
*/
/* The following Errorcodes are used:
   0x1000--0x100F: For Errors on SPI0
   0x1010--0x101F: For Errors on SPI1
   0x1020--0x102F: For Errors on Z-Plus
   0x1030--0x103F: For Errors on MMC
   0x1040--0x104F: For Errors on SSI
   0x1050--0x105F: For Errors on DISP
*/

/* Common Bus-Error-Id */
   #define U16_ERRMEM_BUS_ERROR        (TR_COMP_OSALIO)
   #define U16_ERRMEM_DEV_ERROR        (TR_COMP_OSALIO)

/* Bus-Id */
   #define U4_BUS_CD       (0)   /* Errors on BPCD and DISK */
   #define U4_BUS_SPI0     (1)   /* Common Errors on SPI-Bus 0 */
   #define U4_BUS_SPI1     (2)   /* Common Errors on SPI-Bus 1 */
   #define U4_BUS_ZPLUS    (3)   /* Errors in Z-Plus-Protocoll codec*/
   #define U4_BUS_MMC      (4)   /* Errors in MMC-Protocoll codec*/
   #define U4_BUS_SSI      (5)   /* Errors in SSI-Protocoll codec*/
   #define U4_BUS_DISPLAY  (6)   /* Errors in DISP-Protocoll codec*/
   #define U4_DEV_FFS      (7)   /* Errors of dev_ffs */


/* CD errors */
/* --------- */
   #ifndef OSAL_C_ERR_DISK_READ_ERR

/* Read errors - data: the failed M/S/F */
      #define OSAL_C_ERR_DISK_READ_ERR M_ERRMEM_BUS_ERROR_CODE(U4_BUS_CD,1) //(TR_COMP_OSALIO + 1)
   #endif
   #ifndef OSAL_C_ERR_BPCD_ERROR

/* BP7 error message - data: the contents of the error message */
      #define OSAL_C_ERR_BPCD_ERROR    M_ERRMEM_BUS_ERROR_CODE(U4_BUS_CD,2) //(TR_COMP_OSALIO + 2)
   #endif
   #ifndef OSAL_C_ERR_BPCD_COMM

/* BP7 communication failure - data: none */
      #define OSAL_C_ERR_BPCD_COMM     M_ERRMEM_BUS_ERROR_CODE(U4_BUS_CD,3) //(TR_COMP_OSALIO + 3)
   #endif

/* BP7 read errors - data: retry reasons */
#define OSAL_C_ERR_BPCD_READ_ERR M_ERRMEM_BUS_ERROR_CODE(U4_BUS_CD,4)
/* ------------------------------------------------------------------------ */

/* Error Codes SPI */
   #define U4_BUS_ERR_CODE_UNKNOWN      (0)   /* Unspecific Error in transmission detected */
   #define U4_BUS_ERR_CODE_INTERNAL     (1)   /* Internal Error in OS/OSAL/NUCLEUS */
   #define U4_BUS_ERR_CODE_HANDLING     (2)   /* Protocol Handling error */
   #define U4_BUS_ERR_CODE_COLLISION    (3)   /* BUS-Collision-Error */
   #define U4_BUS_ERR_CODE_LENGTH       (4)   /* Error in Transmission length */
   #define U4_BUS_ERR_CODE_ACK          (5)   /* Error ACK handling */
   #define U4_BUS_ERR_CODE_CHECKSUM     (6)   /* Checksum error */
   #define U4_BUS_ERR_CODE_BUFFER       (7)   /* Something is wrong with the transmission buffers */
   #define U4_BUS_ERR_CODE_OVERRUN      (8)   /* Buffer overrun error */
   #define U4_BUS_ERR_CODE_RX           (9)   /* Something is wrong within receiving data */
   #define U4_BUS_ERR_CODE_TX          (10)   /* Something is wrong within transmitting data */
   #define U4_BUS_ERR_CODE_DATA        (11)   /* Wrong data */
   #define U4_BUS_ERR_CODE_ID          (12)   /* Wrong ID */
   #define U4_BUS_ERR_CODE_HW_PROTOCOL (13)   /* Error in HW-Protocol */

/* Error Codes FFS */
   #define U4_DEV_ERR_CODE_INFORMATION  (0)

/* Use this Macro to get the Entry-Id for the Bus-Error */
/* Example: u16Id = M_ERRMEM_BUS_ERROR_CODE(U4_BUS_SPI1,U4_BUS_ERR_CODE_UNKNOWN); */
   #define M_ERRMEM_BUS_ERROR_CODE(bus_nr,err_code)  (U16_ERRMEM_BUS_ERROR + ((((bus_nr)&0xF)<<4) + ((err_code) & 0x0F)&0x3FF))
/* Same for dev/xxx where no BUS is available */
   #define M_ERRMEM_DEV_ERROR_CODE(dev_nr,err_code)  (U16_ERRMEM_DEV_ERROR + ((((dev_nr)&0xF)<<4) + ((err_code) & 0x0F)&0x3FF))

//=========================================================================
//=========================================================================
//  ERRMEM ENTRIES FOR "TUCC"
//=========================================================================
//=========================================================================
   #define U16_ERRMEM_TUCC_SYSTEM_ERROR       (TR_COMP_SIAS +1)
   #define U16_ERRMEM_TUCC_INTERFACE_ERROR    (TR_COMP_SIAS +2)
   #define U16_ERRMEM_TUCC_SENSOR_ERROR       (TR_COMP_SIAS +3)
   #define U16_ERRMEM_TUCC_GSM_ERROR          (TR_COMP_SIAS +4)

//=========================================================================
//=========================================================================
//  ERRMEM ENTRIES FOR DIAGNOSIS "TR_COMP_DIAGNOSIS"
//=========================================================================
//=========================================================================

/*=========================================================================
   Used in File:
   components\el_dia\el_dia_CdTester.cpp
===========================================================================*/
   #define U16_M_ERRMEM_BURNIN_ERROR(err_code)  (TR_COMP_DIAGNOSIS + (err_code & 0x3FF))

/* Description: Read errors during BurnIn out of limit
   State      : Error
   Result     : No
   Data       : structure trBurninReadFailedErrorData
*/
   #define U16_ERRMEM_BURNIN_READ_FAILED_ERROR      U16_M_ERRMEM_BURNIN_ERROR(0x01)

/* Structure of error storage */

typedef struct
{
   tU16 u16ReadErrorsInPercent;
} trBurninReadFailedErrorData;


/* Description: Gyro Error during BurnIn
   State      : Error
   Result     : No
   Data       : structure trBurninGyroErrorData
*/
   #define U16_ERRMEM_BURNIN_GYRO_ERROR      U16_M_ERRMEM_BURNIN_ERROR(0x02)

/* Structure of error storage */

typedef struct
{
   tU16 u16Gyro;
} trBurninGyroErrorData;

/* Description: Flash checksum error
   State      : Error
   Result     : No
   Data       : structure trBurninChecksumErrorData
*/
   #define U16_ERRMEM_BURNIN_CHECKSUM_ERROR   U16_M_ERRMEM_BURNIN_ERROR(0x03)

/* Structure of error storage */

typedef struct
{
   tU32 u32Checksum;
} trBurninChecksumErrorData;

/* Description: Access time during BurnIn out of limit
   State      : Error
   Result     : No
   Data       : structure trBurninAccessTimeErrorData
*/
   #define U16_ERRMEM_BURNIN_ACCESS_TIME_ERROR      U16_M_ERRMEM_BURNIN_ERROR(0x04)

/* Structure of error storage */

typedef struct
{
   tU32 u32AccessTime;
} trBurninAccessTimeErrorData;

/* Description: CD Read Errors during BurnIn
   State      : Error
   Result     : No
   Data       : structure trBurninReadErrorData
*/

   #define U16_ERRMEM_BURNIN_READ_ERROR      U16_M_ERRMEM_BURNIN_ERROR(0x05)

/* Structure of error storage */
typedef struct
{
   tU32  u32BlockCount;
   tU32  u32ReadErrors;
   tU32  u32Mismatch;
   tU32  u32ReadFail;
   tU32  u32AccessTime;
   tU32  u32LastBlock;
} trBurninReadErrorData;

/* Description: Compare Error during CD read test in BurnIn
   State      : Error
   Result     : No
   Data       : structure trBurninReadErrorData
*/
   #define U16_ERRMEM_BURNIN_COMPARE_ERROR      U16_M_ERRMEM_BURNIN_ERROR(0x06)  // 0x8406

/* Structure of error storage */
/* trBurninReadErrorData */


/*=========================================================================
   Used in Files:
   components\el_ui
===========================================================================*/

   #define U16_M_ERRMEM_UI_ERROR(err_code)  (TR_COMP_UI + (err_code & 0x3FF))

   #define U16_ERRMEM_UI_EL_DIS_ERROR   U16_M_ERRMEM_UI_ERROR(0x01)


/*=========================================================================
   Used in Files:
   components\el_ui\el_dis
===========================================================================*/

   #define U16_M_ERRMEM_DIS_ERROR(err_code)  (TR_COMP_DISPLAY + (err_code & 0x3FF))

   #define U16_ERRMEM_EL_DIS_OFE_ERROR   U16_M_ERRMEM_DIS_ERROR(0x01)


/*=========================================================================
   Used in Files:
   vd_sensor
===========================================================================*/

   #define U16_M_ERRMEM_SENSOR_ERROR(err_code)  (TR_COMP_SENSOR + (err_code & 0x3FF)) /* A400 + x */

   #define VDS_GET_XO_DEFAULTS_FROM_KDS   U16_M_ERRMEM_SENSOR_ERROR(0x01)
   #define VDS_GET_XO_DEFAULTS_FROM_ROM   U16_M_ERRMEM_SENSOR_ERROR(0x02)
   #define VDS_VDSINT1_CREATED            U16_M_ERRMEM_SENSOR_ERROR(0x03)
   #define VDS_ODOMDATA_READ_ERROR        U16_M_ERRMEM_SENSOR_ERROR(0x04)
   #define VDS_GYRODATA_READ_ERROR        U16_M_ERRMEM_SENSOR_ERROR(0x05)
   #define VDS_GPSDATA_READ_ERROR         U16_M_ERRMEM_SENSOR_ERROR(0x06)
   #define VDS_TYREQUADEXPANSION_ERROR    U16_M_ERRMEM_SENSOR_ERROR(0x07)
   #define VDS_INVALID_ODOM_ERROR         U16_M_ERRMEM_SENSOR_ERROR(0x08)
   #define VDS_INVALID_GYRO_ERROR         U16_M_ERRMEM_SENSOR_ERROR(0x09)
   #define VDS_INVALID_GPS_ERROR          U16_M_ERRMEM_SENSOR_ERROR(0x0A)
   #define VDS_ANTENNA_SHORT_ERROR        U16_M_ERRMEM_SENSOR_ERROR(0x0B)
   #define VDS_ANTENNA_OPEN_ERROR         U16_M_ERRMEM_SENSOR_ERROR(0x0C)
   #define VDS_GPS_RESTART_NOFIX          U16_M_ERRMEM_SENSOR_ERROR(0x0D)


/*=========================================================================
This List has to be continued...
===========================================================================*/
#endif

/****************************************************************************
* FILE                      [ $Workfile:   system_errmem_def.h  $ ]
* ---------------------------------------------------------------------------
* GENERAL :
* $Header:   //hi230124/projects/Vasco/swnavi/archives/products/system/system_errmem_def.h-arc   1.21   Apr 22 2004 16:04:38   kos2hi  $
* ---------------------------------------------------------------------------
* HISTORY
* REV.  DATE        TIME                   AUTHOR
* COMMENT
* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
* $Revision:   1.21  $  $Date:   Apr 22 2004 16:04:38  $  $Author:   kos2hi  $
* $Log:   //hi230124/projects/Vasco/swnavi/archives/products/system/system_errmem_def.h-arc  $
 *
 *    Rev 1.21   Apr 22 2004 16:04:38   kos2hi
 * added "U16_ERRMEM_SYSTEMTEST"
 *
 *    Rev 1.20   Mar 23 2004 15:27:00   bef2hi
 * New vdsensor entries
 *
 *    Rev 1.19   Mar 09 2004 16:12:44   pkd2hi
 * add lost defines for errorcodes in vdsensor
 *
 *    Rev 1.18   Mar 08 2004 09:40:52   kos2hi
 * Expand assert item in /dev/errmem with a set of function backtrace pointers.
 *
 *    Rev 1.16   Nov 27 2003 13:10:52   KAN2HI
 * New Errortype for Software Watchdog added
 *
 *    Rev 1.15   17 Nov 2003 13:22:30   GGS2HI
 * Added OSAL_C_ERR_BPCD_READ_ERR
 *
 *    Rev 1.14   Nov 14 2003 11:06:10   kos2hi
 * added defines for memory (de-)allocation errors
 *
 *    Rev 1.13   Nov 13 2003 15:01:30   sia2hi
 * Added defines for BurnIn.
 *
 *    Rev 1.12   Nov 13 2003 09:37:34   KAN2HI
 * New definitions for GPS
 *
 *    Rev 1.11   Nov 07 2003 09:53:22   kos2hi
 * added error code for device ffs
 *
 *    Rev 1.10   Nov 06 2003 10:51:54   KAN2HI
 * New Errorcode for dev_ffs
 *
 *    Rev 1.9   03 Nov 2003 16:58:22   IR62HI
 * TUCC feature variant removed
 *
 *    Rev 1.8   Oct 24 2003 10:16:18   SJC2HI
 * new error defines for TUCC
 *
 *    Rev 1.7   Oct 10 2003 16:28:24   pkd2hi
 * add errorcode for el_dis
 *
 *    Rev 1.6   Oct 10 2003 16:07:28   KAN2HI
 * UI\EL_DIS Error added
 *
 *    Rev 1.5   Sep 29 2003 17:20:08   sia2hi
 * Added missing )
 *
 *    Rev 1.4   Sep 29 2003 16:35:46   KAN2HI
 * New Error emory entries for SPI, BPCD and Diagnosis
 *
 *    Rev 1.3   Sep 25 2003 16:32:38   KAN2HI
 * New defines for SPI-Errmem entries
 *
 *    Rev 1.2   Sep 01 2003 16:29:40   KAN2HI
 * Add new exception handling and error tracing
 *
 *    Rev 1.1   Sep 01 2003 09:57:36   KAN2HI
 * - New Error-Code for SysCtrlError
 * - Error-Structures moved in Header
 *
 *    Rev 1.0   Aug 21 2003 17:02:12   KAN2HI
 * Initial revision.
****************************************************************************/

