/***************************************************************************
 * .EXPORT_ME
 * FILE:         ostime.h
 * PROJECT:      VASCO
 * SW-COMPONENT: OSAL
 *--------------------------------------------------------------------------
 * DESCRIPTION:  This file implements save variants for string functions 
 *                  OSAL_szStringNConcat, 
 *                  OSAL_szStingNCopy,
 *                  OSALUTIL_s32NPrintFormat and
 *                  OSAL_s32VarNPrintFormat
 *--------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      |   Modification                      | Author
 * 16.03.00  |   Initial revision                  | de Vries, EFT22
 * 10.04.00  |   Restructuring                     | Uelschen, EFT42
 * 17.05.00  |   os_rtctimer.h new                 | de Vries, EFT22
 * 08.08.00  |   Linux defines added               | Wunderlich, EFT32
 *           |                                     |
 * 11.08.00  |   Linux uses OSAL_DECL now;         | Wunderlich, EFT32
 *           |   `()' replaced by `( tVoid )'      |
 * 07.02.02  |   OSAL_DECL in class added          | Walkling, EST
 * 18.02.02  |   Nucleus defines added             | Uelschen, ESN2
 * 13.06.02  |   add dynamic-download extension    | Perick, CM-CR/EES4
 *
 **************************************************************************/


#ifndef OSALUTIL_SAVESTRING_HEADER
   #define OSALUTIL_SAVESTRING_HEADER

#ifdef __cplusplus
extern "C" {
#endif

/* -- OSAL_szSaveStringNConcat */
OSAL_DECL tString OSALUTIL_szSaveStringNConcat(tString szDest, tCString coszSource, tU32 u32BufferLength);


/* -- OSAL_szSaveStringNCopy */
OSAL_DECL tString OSALUTIL_szSaveStringNCopy(tString szDest, tCString coszSource, tU32 u32BufferLength);

   
/* -- OSAL_s32SaveNPrintFormat */
OSAL_DECL tS32 OSALUTIL_s32SaveNPrintFormat(tString szDest, tU32 u32BufferLength, tCString coszFormat, ...);


/* -- OSAL_s32SaveVarNPrintFormat */
OSAL_DECL tS32 OSALUTIL_s32SaveVarNPrintFormat(tString szBuffer, tU32 u32BufferLength, tCString szFormat, va_list argptr);

#ifdef __cplusplus
}
#endif

#endif /* OSALUTIL_SAVESTRING_HEADER */  


/* EOF */
