/************************************************************************
 * .EXPORT_ME
 * FILE:         osutilio.h
 * PROJECT:      VASCO
 * SW-COMPONENT: OSAL
 *----------------------------------------------------------------------
 * DESCRIPTION:  This header file contains osal utility io functions
 *                            The prefix of structures and functions is OSALUTIL.
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      |   Modification               | Author
 * 09.08.00  |   Initial revision           | Scherber, EFT43
 * 05.09.00  |   OSALUTIL_OpenDir           | Scherber,EFT43
 * 15.09.00  |   NT -> common OSAL Folder   | Uelschen, EFT42
 * 13.06.02  |   add dynamic-download       | Perick, CM-CR/EES4
 *           |   extension                  |
 *************************************************************************/

#ifndef OSUTILIO_HEADER
#define OSUTILIO_HEADER


/**************************************************************************/
/* defines                                                               */
/**************************************************************************/

#define OSALUTIL_C_U32_MAX_BUFFERSIZE     4096

#if (OSAL_OS==OSAL_NUCLEUS)
  #define OS_TRACE(x) os_trace(__FILE__, __LINE__, (unsigned long)x, FALSE)
#else
  #define OS_TRACE(x)
#endif

/**************************************************************************/
/* typedefs                                                               */
/**************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

#ifndef OSAL_DYNAMIC_DOWNLOAD

/************************************************************************
 *
 * FUNCTION:     OSALUTIL_s32NPrintFormat
 *----------------------------------------------------------------------
 * DESCRIPTION:  writes a formatted string to buffer (aka vsnprintf)
 *----------------------------------------------------------------------
 * PARAMETER:    (I) ps8Buffer: buffer
 * PARAMETER:    (I) u32BufferLength: buffer length
 * PARAMETER:    (I) coszFormat: format string like sprintf
 * PARAMETER:    (I) ...: arguments
 * RETURNVALUE:  number of written bytes or OSAL_ERROR if max buffer size is reached
 * HISTORY:      
 * Date      |   Modification                         | Author
 * 12.07.01  |   Initial revision                     | Uelschen, ENT1
 *
 *************************************************************************/
OSAL_DECL tS32 OSALUTIL_s32NPrintFormat(tPS8 ps8Buffer, tU32 u32BufferLength, tCString coszFormat, ...); 

/************************************************************************
 *
 * FUNCTION:     OSALUTIL_s32FPrintf
 *----------------------------------------------------------------------
 * DESCRIPTION:  writes a string into a file
 *----------------------------------------------------------------------
 * PARAMETER:    (I) fd: file descriptor
 * PARAMETER:    (I) szFormat: format string
 * PARAMETER:    (I) ...: arguments
 * RETURNVALUE:  number of written bytes
 * HISTORY:      
 * Date      |   Modification                         | Author
 * 11.08.00  |   Initial revision                     | Scherber,EFT43
 *
 *************************************************************************/
OSAL_DECL tS32 OSALUTIL_s32FPrintf(OSAL_tIODescriptor fd, tCString szFormat, ...);

/************************************************************************
 *
 * FUNCTION:     OSALUTIL_s32FSeek
 *----------------------------------------------------------------------
 * DESCRIPTION:  set file pointer
 *----------------------------------------------------------------------
 * PARAMETER:    (I) fd: file descriptor
 * PARAMETER:    (I) offset: 
 * PARAMETER:    (I) origin: OSALUTIL_C_S32_{SEEK_SET|SEEK_CUR|SEEK_END}
 * RETURNVALUE:  OSAL_OK or OSAL_ERROR
 * HISTORY:      
 * Date      |   Modification                         | Author
 * 11.08.00  |   Initial revision                     | Scherber,EFT43
 *
 *************************************************************************/
OSAL_DECL tS32 OSALUTIL_s32FSeek(OSAL_tIODescriptor fd, tS32 offset, tS32 origin);

/************************************************************************
 *
 * FUNCTION:     OSALUTIL_s32FTell
 *----------------------------------------------------------------------
 * DESCRIPTION:  returns current file position
 *----------------------------------------------------------------------
 * PARAMETER:    (I) fd: file descriptor
 * RETURNVALUE:  OSAL_ERROR or position
 * HISTORY:      
 * Date      |   Modification                         | Author
 * 11.08.00  |   Initial revision                     | Scherber,EFT43
 *
 *************************************************************************/
OSAL_DECL tS32 OSALUTIL_s32FTell(OSAL_tIODescriptor fd);

/************************************************************************
 *
 * FUNCTION:     OSALUTIL_s32FGetpos
 *----------------------------------------------------------------------
 * DESCRIPTION:  returns current file position
 *----------------------------------------------------------------------
 * PARAMETER:    (I) fd: file descriptor
 * PARAMETER:    (->0) ptr: file position
 * RETURNVALUE:  OSAL_ERROR or OSAL_OK
 * HISTORY:      
 * Date      |   Modification                         | Author
 * 11.08.00  |   Initial revision                     | Scherber,EFT43
 *
 *************************************************************************/
OSAL_DECL tS32 OSALUTIL_s32FGetpos(OSAL_tIODescriptor fd, intptr_t* ptr);
   
/************************************************************************
 *
 * FUNCTION:     OSALUTIL_s32FSetpos
 *----------------------------------------------------------------------
 * DESCRIPTION:  sets current file position
 *----------------------------------------------------------------------
 * PARAMETER:    (I) fd: file descriptor
 * PARAMETER:    (->I) ptr: file position
 * RETURNVALUE:  OSAL_ERROR or OSAL_OK
 * HISTORY:      
 * Date      |   Modification                         | Author
 * 11.08.00  |   Initial revision                     | Scherber,EFT43
 *
 *************************************************************************/
OSAL_DECL tS32 OSALUTIL_s32FSetpos(OSAL_tIODescriptor fd, const intptr_t* ptr);

/************************************************************************
 *
 * FUNCTION:     OSALUTIL_s32FGetSize
 *----------------------------------------------------------------------
 * DESCRIPTION:  returns file size
 *----------------------------------------------------------------------
 * PARAMETER:    (I) fd: file descriptor
 * RETURNVALUE:  OSAL_ERROR or file size
 * HISTORY:      
 * Date      |   Modification                         | Author
 * 11.08.00  |   Initial revision                     | Scherber,EFT43
 *
 *************************************************************************/
OSAL_DECL tS32 OSALUTIL_s32FGetSize(OSAL_tIODescriptor fd);

/************************************************************************
 *
 * FUNCTION:     OSALUTIL_s32CreateDir
 *----------------------------------------------------------------------
 * DESCRIPTION: creates a directory
 *----------------------------------------------------------------------
 * PARAMETER:    (I) fd: file descriptor
 * PARAMETER:    (I) szDirectory: directory name
 * RETURNVALUE:  OSAL_ERROR or OSAL_OK
 * HISTORY:      
 * Date      |   Modification                         | Author
 * 11.08.00  |   Initial revision                     | Scherber,EFT43
 *
 *************************************************************************/
OSAL_DECL tS32 OSALUTIL_s32CreateDir(OSAL_tIODescriptor fd, tCString szDirectory);

/************************************************************************
 *
 * FUNCTION:     OSALUTIL_s32RemoveDir
 *----------------------------------------------------------------------
 * DESCRIPTION: removes a directory
 *----------------------------------------------------------------------
 * PARAMETER:    (I) fd: file descriptor
 * PARAMETER:    (I) szDirectory: directory name
 * RETURNVALUE:  OSAL_ERROR or OSAL_OK
 * HISTORY:      
 * Date      |   Modification                         | Author
 * 11.08.00  |   Initial revision                     | Scherber,EFT43
 *
 *************************************************************************/
OSAL_DECL tS32 OSALUTIL_s32RemoveDir(OSAL_tIODescriptor fd, tCString szDirectory);

/************************************************************************
 *
 * FUNCTION:     OSALUTIL_prOpenDir
 *----------------------------------------------------------------------
 * DESCRIPTION: opens a directory for reading
 *----------------------------------------------------------------------
 * PARAMETER:    (I) szDirectory: directory name
 * RETURNVALUE:  OSAL_tIODir or OSAL_NULL
 * HISTORY:      
 * Date      |   Modification                         | Author
 * 11.08.00  |   Initial revision                     | Scherber,EFT43
 * 05.09.00  |   Parameter change                     | Scherber,EFT43
 *
 *************************************************************************/
OSAL_DECL OSAL_trIOCtrlDir * OSALUTIL_prOpenDir(tCString szDirectory);

/************************************************************************
 *
 * FUNCTION:     OSALUTIL_prReadDir
 *----------------------------------------------------------------------
 * DESCRIPTION: opens a directory for reading
 *----------------------------------------------------------------------
 * PARAMETER:    (I) dir: Directory
 * RETURNVALUE:  OSAL_tIODir or OSAL_NULL
 * HISTORY:      
 * Date      |   Modification                         | Author
 * 11.08.00  |   Initial revision                     | Scherber,EFT43
 *
 *************************************************************************/
OSAL_DECL OSAL_trIOCtrlDirent * OSALUTIL_prReadDir(OSAL_trIOCtrlDir* pDir);

/************************************************************************
 *
 * FUNCTION:     OSALUTIL_CloseDir
 *----------------------------------------------------------------------
 * DESCRIPTION: closes a directory 
 *----------------------------------------------------------------------
 * PARAMETER:    (I) dir: Directory
 * RETURNVALUE:  OSAL_OK or OSAL_ERROR
 * HISTORY:      
 * Date      |   Modification                         | Author
 * 11.08.00  |   Initial revision                     | Scherber,EFT43
 *
 *************************************************************************/
OSAL_DECL tS32 OSALUTIL_s32CloseDir(OSAL_trIOCtrlDir* pDir);

/************************************************************************
 *
 * FUNCTION:     OSALUTIL_s32TraceWrite
 *----------------------------------------------------------------------
 * DESCRIPTION: writes a buffer to the trace device
 *----------------------------------------------------------------------
 * PARAMETER:    (I) io: descriptor of io device
 * PARAMETER:    (I) u32Level: trace or debug level
 * PARAMETER:    (I) u32Class: trace or debug class
 * PARAMETER:    (I) pcos8Buffer: pointer to char buffer
 * PARAMETER:    (I) u32Length: size of buffer
 * RETURNVALUE:  Number of written bytes or OSAL_ERROR
 * HISTORY:      
 * Date      |   Modification                         | Author
 * 05.03.01  |   Initial revision                     | Uelschen, ENT1
 *
 *************************************************************************/
OSAL_DECL tS32 OSALUTIL_s32TraceWrite(OSAL_tIODescriptor io, tU32 u32Level, tU32 u32Class,
							tPCS8 pcos8Buffer, tU32 u32Length);

/************************************************************************
 *
 * FUNCTION:     OSALUTIL_s32TracePrintf
 *----------------------------------------------------------------------
 * DESCRIPTION:  writes a string into the trace device
 *----------------------------------------------------------------------
 * PARAMETER:    (I) fd: file descriptor
 * PARAMETER:    (I) u32Level: trace or debug level
 * PARAMETER:    (I) u32Class: trace or debug class
 * PARAMETER:    (I) szFormat: format string
 * PARAMETER:    (I) ...: arguments
 * RETURNVALUE:  number of written bytes
 * HISTORY:
 * Date      |   Modification                         | Author
 * 27.03.01  |   Initial revision                     | Scherber,ENT1
 *
 *************************************************************************/
OSAL_DECL tS32 OSALUTIL_s32TracePrintf(OSAL_tIODescriptor fd, tU32 u32Level, tU32 u32Class, tCString coszFormat, ...);


OSAL_DECL void os_trace(const char *file, unsigned long line, unsigned long value, tBool write_to_flash);

OSAL_DECL tU32 OSALUTIL_u32GetBaseAPIVersion (tVoid);

#endif // OSAL_DYNAMIC_DOWNLOAD


/**************************************************************************/
/* dynamic-download                                                       */
/**************************************************************************/
#if ( defined OSAL_DYNAMIC_DOWNLOAD || defined OSAL_DYNAMIC_BASE)
typedef tS32 (*tOSALUTIL_s32NPrintFormat)(tPS8 ps8Buffer, tU32 u32BufferLength, tCString coszFormat, ...);
typedef tS32 (*tOSALUTIL_s32FPrintf)(OSAL_tIODescriptor fd, tCString szFormat, ...);
typedef tS32 (*tOSALUTIL_s32FSeek)(OSAL_tIODescriptor fd, tS32 offset, tS32 origin);
typedef tS32 (*tOSALUTIL_s32FTell)(OSAL_tIODescriptor fd);
typedef tS32 (*tOSALUTIL_s32FGetpos)(OSAL_tIODescriptor fd, tPS32 ptr);
typedef tS32 (*tOSALUTIL_s32FSetpos)(OSAL_tIODescriptor fd, const tPS32 ptr);
typedef tS32 (*tOSALUTIL_s32FGetSize)(OSAL_tIODescriptor fd);
typedef tS32 (*tOSALUTIL_s32CreateDir)(OSAL_tIODescriptor fd, tCString szDirectory);
typedef tS32 (*tOSALUTIL_s32RemoveDir)(OSAL_tIODescriptor fd, tCString szDirectory);
typedef OSAL_trIOCtrlDir* (*tOSALUTIL_prOpenDir)(tCString szDirectory);
typedef OSAL_trIOCtrlDirent* (*tOSALUTIL_prReadDir)(OSAL_trIOCtrlDir* pDir);
typedef tS32 (*tOSALUTIL_s32CloseDir)(OSAL_trIOCtrlDir* pDir);
typedef tS32 (*tOSALUTIL_s32TraceWrite)(OSAL_tIODescriptor io, tU32 u32Level, tU32 u32Class, tPCS8 pcos8Buffer, tU32 u32Length);
typedef tS32 (*tOSALUTIL_s32TracePrintf)(OSAL_tIODescriptor fd, tU32 u32Level, tU32 u32Class, tCString coszFormat, ...);
typedef void (*tos_trace) (const char *file, unsigned long line, unsigned long value, tBool write_to_flash);
typedef tU32 (*tOSALUTIL_u32GetBaseAPIVersion) (tVoid);
#endif

#ifdef OSAL_DYNAMIC_DOWNLOAD
extern tOSALUTIL_s32NPrintFormat OSALUTIL_s32NPrintFormat;
extern tOSALUTIL_s32FPrintf      OSALUTIL_s32FPrintf;
extern tOSALUTIL_s32FSeek        OSALUTIL_s32FSeek;
extern tOSALUTIL_s32FTell        OSALUTIL_s32FTell;
extern tOSALUTIL_s32FGetpos      OSALUTIL_s32FGetpos;
extern tOSALUTIL_s32FSetpos      OSALUTIL_s32FSetpos;
extern tOSALUTIL_s32FGetSize     OSALUTIL_s32FGetSize;
extern tOSALUTIL_s32CreateDir    OSALUTIL_s32CreateDir;
extern tOSALUTIL_s32RemoveDir    OSALUTIL_s32RemoveDir;
extern tOSALUTIL_prOpenDir       OSALUTIL_prOpenDir;
extern tOSALUTIL_prReadDir       OSALUTIL_prReadDir;
extern tOSALUTIL_s32CloseDir     OSALUTIL_s32CloseDir;
extern tOSALUTIL_s32TraceWrite   OSALUTIL_s32TraceWrite;
extern tOSALUTIL_s32TracePrintf  OSALUTIL_s32TracePrintf;
extern tos_trace                 os_trace;
extern tOSALUTIL_u32GetBaseAPIVersion   OSALUTIL_u32GetBaseAPIVersion; 
#endif // OSAL_DYNAMIC_DOWNLOAD

#ifdef __cplusplus
}
#endif

#endif

