/***************************************************************************
 * .EXPORT_ME
 * FILE:         ostime.h
 * PROJECT:      VASCO
 * SW-COMPONENT: OSAL
 *--------------------------------------------------------------------------
 * DESCRIPTION:  This is the headerfile for the OS - Abstraction Layer for 
 *               Timer-Functions. This Header has to be included to use the
 *               functions for Timer control
 *--------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      |   Modification                      | Author
 * 16.03.00  |   Initial revision                  | de Vries, EFT22
 * 10.04.00  |   Restructuring                     | Uelschen, EFT42
 * 17.05.00  |   os_rtctimer.h new                 | de Vries, EFT22
 * 08.08.00  |   Linux defines added               | Wunderlich, EFT32
 *           |                                     |
 * 11.08.00  |   Linux uses OSAL_DECL now;         | Wunderlich, EFT32
 *           |   `()' replaced by `( tVoid )'      |
 * 07.02.02  |   OSAL_DECL in class added          | Walkling, EST
 * 18.02.02  |   Nucleus defines added             | Uelschen, ESN2
 * 13.06.02  |   add dynamic-download extension    | Perick, CM-CR/EES4
 *
 **************************************************************************/


#if !defined (OSAL_TIME_HEADER)
   #define OSAL_TIME_HEADER

/**************************************************************************/
/* Includes                                                               */
/**************************************************************************/

/* -- Structure for date / time: */

typedef struct
{
   tS32 s32Second;             /* second               [0...61] 1)    */
   tS32 s32Minute;             /* minute               [0...59]       */
   tS32 s32Hour;               /* hour                 [0...23]       */
   tS32 s32Day;                /* day                  [1...31]       */
   tS32 s32Month;              /* month                [1...12]       */
   tS32 s32Year;               /* year since 1900                     */
   tS32 s32Weekday;            /* day since Sunday     [0...6]        */
   tS32 s32Yearday;            /* day since JAN-01     [0...365]      */
   tS32 s32Daylightsaving;     /* daylight saving time [-1, 0, +1] 2) */
} OSAL_trTimeDate;
/* 1) for 2-sec-tick: 1, 3, 5, ..., 59, 61 */
/* 2) 0: no DST, 1: DST, -1: information not available */


/* -- Typdefinition fuer die Basiszeiteinheit (1 ms): */

typedef tU32 OSAL_tMSecond;

#if OSAL_OS==OSAL_VXWORKS
#include "os_vxworks.h"
typedef timer_t OSAL_tTimerHandle;
#elif (OSAL_OS==OSAL_LINUX) || (OSAL_OS==OSAL_DARWIN)
#ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT
typedef uintptr_t OSAL_tTimerHandle; 
#else
typedef tU32 OSAL_tTimerHandle;
#endif
#else
typedef tU32 OSAL_tTimerHandle;
#endif

#ifdef __cplusplus
extern "C"
{
   #endif
  
#ifndef OSAL_DYNAMIC_DOWNLOAD

   #if OSAL_OS==OSAL_VXWORKS || OSAL_OS==OSAL_WINNT || OSAL_OS==OSAL_LINUX || \
	   (OSAL_OS==OSAL_DARWIN) || OSAL_OS==OSAL_RX732 || OSAL_OS==OSAL_WINCE || \
      OSAL_OS==OSAL_NUCLEUS || OSAL_OS==OSAL_TENGINE
   
   /* --14.2.1 Get the Timer resolution in Hz */
   OSAL_DECL  tU32 OSAL_u32TimerGetResolution( tVoid );
   
   /* --14.2.2 Create a Timer */
   OSAL_DECL tS32 OSAL_s32TimerCreate(OSAL_tpfCallback pCallback, 
    tPVoid pvArg, OSAL_tTimerHandle* phTimer);
   
   /* --14.2.3 Remove a Timer from System */
   OSAL_DECL tS32 OSAL_s32TimerDelete(OSAL_tTimerHandle hTimer);
   
   /* --14.2.4 Get the Remaining Time */
   OSAL_DECL tS32 OSAL_s32TimerGetTime(OSAL_tTimerHandle hTimer, 
    OSAL_tMSecond* pMSec, OSAL_tMSecond* pInterval);
   
   /* --14.2.5 Set a Timer */
   OSAL_DECL tS32 OSAL_s32TimerSetTime(OSAL_tTimerHandle hTimer, 
    OSAL_tMSecond msec, OSAL_tMSecond interval);
   
   /* --14.2.6 Get the Elapsed Time Since System Start */
   OSAL_DECL OSAL_tMSecond OSAL_ClockGetElapsedTime( tVoid );
   
   /* --14.2.7 Get Clock */
   OSAL_DECL tS32 OSAL_s32ClockGetTime(OSAL_trTimeDate* prCurrentTime);
   
   /* -- 14.2.8 Set Clock */
   OSAL_DECL tS32 OSAL_s32ClockSetTime(const OSAL_trTimeDate* pcorSetTime);

   OSAL_DECL tU64 OSAL_u64GetMicroSeconds(tVoid);

   #endif
   
   
   /* --VXWORKS INLINE */
   
   #if OSAL_OS==OSAL_VXWORKS
   
   #include "os_rtctimer.h"
   #include "os_pxtimeradapt.h"
   
   #define OSAL_u32TimerGetResolution() \
           osRtcTimerGetResolution()
   
   #define OSAL_s32TimerCreate(pCallback,pvArg,phTimer) \
       osRtcTimerCreate(pCallback,pvArg,phTimer) 
   
   #define OSAL_s32TimerDelete(hTimer) \
       osRtcTimerDelete(hTimer)
   
   
   #define OSAL_s32TimerGetTime(hTimer,pMSec,pInterval) \
       osRtcTimerGetTime(hTimer,pMSec,pInterval)
   
   
   #define OSAL_s32TimerSetTime(hTimer, msec, interval) \
       osRtcTimerCycStart(hTimer,msec,interval)
   
   
   #define OSAL_ClockGetElapsedTime() \
       osPxClockGetElapsedTime()
   
   
   #define OSAL_s32ClockGetTime(prCurrentTime) \
       osPxClockGetTime(prCurrentTime)
   
   
   #define OSAL_s32ClockSetTime(pcorSetTime) \
       osPxClockSetTime(pcorSetTime)

   #error "OSAL_u64GetMicroSeconds() not defined if OSAL_OS==OSAL_VXWORKS"
   
   #endif
 
#endif // OSAL_DYNAMIC_DOWNLOAD

/**************************************************************************/
/* dynamic-download                                                       */
/**************************************************************************/
#if ( defined OSAL_DYNAMIC_DOWNLOAD || defined OSAL_DYNAMIC_BASE)
typedef tU32 (*tOSAL_u32TimerGetResolution)( tVoid );
typedef tS32 (*tOSAL_s32TimerCreate)(OSAL_tpfCallback pCallback, tPVoid pvArg, 
                                   OSAL_tTimerHandle* phTimer);
typedef tS32 (*tOSAL_s32TimerDelete)(OSAL_tTimerHandle hTimer);
typedef tS32 (*tOSAL_s32TimerGetTime)(OSAL_tTimerHandle hTimer, 
                                    OSAL_tMSecond* pMSec, OSAL_tMSecond* pInterval);
typedef tS32 (*tOSAL_s32TimerSetTime)(OSAL_tTimerHandle hTimer, OSAL_tMSecond msec, 
                                    OSAL_tMSecond interval);
typedef OSAL_tMSecond (*tOSAL_ClockGetElapsedTime)( tVoid );
typedef tS32 (*tOSAL_s32ClockGetTime)(OSAL_trTimeDate* prCurrentTime);
typedef tS32 (*tOSAL_s32ClockSetTime)(const OSAL_trTimeDate* pcorSetTime);
typedef tU64 (*tOSAL_u64GetMicroSeconds)(tVoid);
#endif

#ifdef OSAL_DYNAMIC_DOWNLOAD
extern tOSAL_u32TimerGetResolution OSAL_u32TimerGetResolution;
extern tOSAL_s32TimerCreate        OSAL_s32TimerCreate;
extern tOSAL_s32TimerDelete        OSAL_s32TimerDelete;
extern tOSAL_s32TimerGetTime       OSAL_s32TimerGetTime;
extern tOSAL_s32TimerSetTime       OSAL_s32TimerSetTime;
extern tOSAL_ClockGetElapsedTime   OSAL_ClockGetElapsedTime;
extern tOSAL_s32ClockGetTime       OSAL_s32ClockGetTime;
extern tOSAL_s32ClockSetTime       OSAL_s32ClockSetTime;
extern tOSAL_u64GetMicroSeconds    OSAL_u64GetMicroSeconds;
#endif // OSAL_DYNAMIC_DOWNLOAD
    
   #ifdef __cplusplus
}
#endif

/* --OSAL object oriented C++-Interface.  EXPERIMENTAL !!!*/
#ifdef __cplusplus
class OSAL_DECL OSAL_tclTimer
{
   public:
      OSAL_tclTimer();
      virtual ~OSAL_tclTimer();
      
      virtual tS32 s32Create();
      
      virtual tS32 s32Delete();
      
      virtual tS32 s32GetTime(OSAL_tMSecond* pMSec, OSAL_tMSecond* pInterval);
      
      virtual tS32 s32SetTime(OSAL_tMSecond msec, OSAL_tMSecond interval);
      
      virtual tS32 s32Reset();
      
      virtual tVoid vOnAlarm() =0;
      OSAL_tTimerHandle handle() const
      {
         return hTimer;
      }
   private:
      static tVoid vCallback(tPVoid pvObject);
      
      OSAL_tTimerHandle hTimer;
};
#endif

#endif 


/* EOF */
