/************************************************************************
 * .EXPORT_ME
 * FILE:         osmsg.h
 * PROJECT:      VASCO
 * SW-COMPONENT: OSAL
 *----------------------------------------------------------------------
 * DESCRIPTION:  This is the headerfile for the OS - Abstraction Layer
 *               Message-Functions. This Header has to be included to use
 *               functions for Messages
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      |   Modification                      | Author
 * 12.07.00  |   Initial revision                  | Scherber, EFT43
 * 14.08.00  |   Beautifier                        | Uelschen, EFT42
 * 14.08.00  |   `()' replaced by `( tVoid )'      | Wunderlich, EFT32
 * 18.08.00  |   `OSAL_s32MessageDelete' added     | Wunderlich, EFT32
 * 07.02.02  |   class OSAL_tclMessage added       | Walkling, EST
 * 18.02.02  |   Nucleus defines added             | Uelschen, ESN2
 * 13.06.02  |   add dynamic-download extension    | Perick, CM-CR/EES4
 *
 *************************************************************************/

#if !defined (OSAL_MESSAGE_HEADER)
   #define OSAL_MESSAGE_HEADER

#ifdef __cplusplus
extern "C"
{
   #endif
   
   
   typedef enum
   {
      OSAL_EN_MEMORY_INVALID,
      OSAL_EN_MEMORY_LOCAL,
      OSAL_EN_MEMORY_SHARED
   } OSAL_tenMemoryLocation;
   typedef struct
   {
      OSAL_tenMemoryLocation enLocation;
      uintptr_t u32Offset;
   } OSAL_trMessage;


#ifndef OSAL_DYNAMIC_DOWNLOAD
   
   #if OSAL_OS==OSAL_VXWORKS || OSAL_OS==OSAL_WINNT || OSAL_OS==OSAL_LINUX || (OSAL_OS==OSAL_DARWIN) || OSAL_OS==OSAL_RX732 \
	|| OSAL_OS==OSAL_WINCE || OSAL_OS==OSAL_NUCLEUS || OSAL_OS==OSAL_TENGINE
   
   /* --rx732 does not support shared memory. */
   #if OSAL_OS!=OSAL_RX732
   
   /* --18.2.1 Create the Common Message Pool (size = size of the  pool; return value: OSAL_OK, OSAL_ERROR) */
   OSAL_DECL tS32 OSAL_s32MessagePoolCreate(tU32 size);
   
   /* --18.2.2 Open the Common Message Pool (return value: OSAL_OK, OSAL_ERROR) */
   OSAL_DECL tS32 OSAL_s32MessagePoolOpen( tVoid );
   
   /* --18.2.3 Close the Common Message Pool (return value: OSAL_OK, OSAL_ERROR) */
   OSAL_DECL tS32 OSAL_s32MessagePoolClose( tVoid );
   
   /* --18.2.x Delete the Common Message Pool (return value: OSAL_OK, OSAL_ERROR) */
   OSAL_DECL tS32 OSAL_s32MessagePoolDelete( tVoid );
   
   /* --18.2.4 Get the Absolute Size of the Common Message Pool in Bytes */
   OSAL_DECL tS32 OSAL_s32MessagePoolGetAbsoluteSize( tVoid );
   
   /*--18.2.5  Get the Remaining Size of the Common Message Pool in Bytes */
   OSAL_DECL tS32 OSAL_s32MessagePoolGetCurrentSize( tVoid );
   
   #endif
   
   /* --18.2.6 Create a new Message */
   OSAL_DECL tS32 OSAL_s32MessageCreate(OSAL_trMessage *pHandle, tU32 size, OSAL_tenMemoryLocation type);
   
   /* --18.2.7 Delete a Message */
   OSAL_DECL tS32 OSAL_s32MessageDelete(OSAL_trMessage handle);
   
   /* --18.2.8 Get a Pointer to a Message */
   OSAL_DECL tPU8 OSAL_pu8MessageContentGet(OSAL_trMessage handle,  OSAL_tenAccess rights);
   
   /* --Undocumented Function */
   OSAL_DECL tVoid OSAL_vPrintMessageList(OSAL_tIODescriptor fd);
   OSAL_DECL tS32 OSAL_s32CheckMessagePool(tVoid);
   OSAL_DECL tVoid OSAL_vSetCheck(tBool bCheck);
   OSAL_DECL tU32 OSAL_u32GetMessageSize(OSAL_trMessage handle);
   OSAL_DECL tVoid OSAL_vSetMessageTrace(OSAL_tIODescriptor fd);
	OSAL_DECL tS32 OSAL_s32MessagePoolGetMinimalSize( tVoid );
	OSAL_DECL tU32 OSAL_u32GetMaxMessageSize(tVoid);
   
   #endif /* OSAL_OS */

   
#endif // OSAL_DYNAMIC_DOWNLOAD

/**************************************************************************/
/* dynamic-download                                                       */
/**************************************************************************/
#if( defined OSAL_DYNAMIC_DOWNLOAD || defined OSAL_DYNAMIC_BASE)
typedef tS32 (*tOSAL_s32MessagePoolCreate)(tU32 size);
typedef tS32 (*tOSAL_s32MessagePoolOpen)( tVoid );
typedef tS32 (*tOSAL_s32MessagePoolClose)( tVoid );
typedef tS32 (*tOSAL_s32MessagePoolDelete)( tVoid );
typedef tS32 (*tOSAL_s32MessagePoolGetAbsoluteSize)( tVoid );
typedef tS32 (*tOSAL_s32MessagePoolGetCurrentSize)( tVoid );
typedef tS32 (*tOSAL_s32MessageCreate)(OSAL_trMessage *pHandle, tU32 size, OSAL_tenMemoryLocation type);
typedef tS32 (*tOSAL_s32MessageDelete)(OSAL_trMessage handle);
typedef tPU8 (*tOSAL_pu8MessageContentGet)(OSAL_trMessage handle,  OSAL_tenAccess rights);
/* --Undocumented Functions */
typedef tVoid (*tOSAL_vPrintMessageList)(OSAL_tIODescriptor fd);
typedef tS32 (*tOSAL_s32CheckMessagePool)(tVoid);
typedef tVoid (*tOSAL_vSetCheck)(tBool bCheck);
typedef tU32 (*tOSAL_u32GetMessageSize)(OSAL_trMessage handle);
typedef tVoid (*tOSAL_vSetMessageTrace)(OSAL_tIODescriptor fd);
#endif


#ifdef OSAL_DYNAMIC_DOWNLOAD
extern tOSAL_s32MessagePoolCreate          OSAL_s32MessagePoolCreate;
extern tOSAL_s32MessagePoolOpen            OSAL_s32MessagePoolOpen;
extern tOSAL_s32MessagePoolClose           OSAL_s32MessagePoolClose;
extern tOSAL_s32MessagePoolDelete          OSAL_s32MessagePoolDelete;
extern tOSAL_s32MessagePoolGetAbsoluteSize OSAL_s32MessagePoolGetAbsoluteSize;
extern tOSAL_s32MessagePoolGetCurrentSize  OSAL_s32MessagePoolGetCurrentSize;
extern tOSAL_s32MessageCreate              OSAL_s32MessageCreate;
extern tOSAL_s32MessageDelete              OSAL_s32MessageDelete;
extern tOSAL_pu8MessageContentGet          OSAL_pu8MessageContentGet;
/* --Undocumented Functions */
extern tOSAL_vPrintMessageList             OSAL_vPrintMessageList;
extern tOSAL_s32CheckMessagePool           OSAL_s32CheckMessagePool;
extern tOSAL_vSetCheck                     OSAL_vSetCheck;
extern tOSAL_u32GetMessageSize             OSAL_u32GetMessageSize;
extern tOSAL_vSetMessageTrace              OSAL_vSetMessageTrace;
#endif // OSAL_DYNAMIC_DOWNLOAD

/**************************************************************************/
/* Diese Funktionen duerfen nur von der OSAL-Engine genutzt werden        */
/**************************************************************************/
#if OSAL_OS==OSAL_WINNT 
OSAL_DECL tPU8 OSALWINNT_pu8MessageContentGet(OSAL_trMessage handle);
OSAL_DECL tU32 OSALWINNT_u32GetMessageSize(OSAL_trMessage handle);
OSAL_DECL void OSALWINNT_vClearMessagePoolVariable();
OSAL_DECL tPVoid OSALWINNT_pvGetBasePointer();
OSAL_DECL tVoid OSALWINNT_vReleaseBasePointer();
#endif
   
   #ifdef __cplusplus
}
#endif

#ifdef __cplusplus
class OSAL_DECL OSAL_tclMessage
{
   public:
      /* The following methods are according to the OSAL specification. */
      /* Constructor of this class. */
      OSAL_tclMessage();
      /* Constructor of this class to open a existing message. */
      OSAL_tclMessage( OSAL_trMessage& rfMessage );
      /* Destructor of this class. */
      virtual ~OSAL_tclMessage();
      /*
         This methode creates a message in the spezified location.
         (For more details see OSAL Refernzhandbuch Kapitel Nachrichtenverwaltung.)
      */
      tS32 s32Create( tU32                    u32Size,      /* (I) */
                      OSAL_tenMemoryLocation  enLocation ); /* (I) */
      /*
         This methode deletes a message.
         (For more details see OSAL Refernzhandbuch Kapitel Nachrichtenverwaltung.)
      */
      tS32 s32Delete();
      /*
         This methode returns a pointer to the message content.
         (For more details see OSAL Refernzhandbuch Kapitel Nachrichtenverwaltung.)
      */
      tPU8 pu8ContentGet( OSAL_tenAccess Right ); /* (I) */
   private:
      //
      /*
         This member stores the descriptor of the message.
      */
      OSAL_trMessage MessageDescriptor;
};
#endif

#endif


/* EOF */
