/***************************************************************************
 * .EXPORT_ME
 * FILE:         osmqueue.h
 * PROJECT:      VASCO
 * SW-COMPONENT: OSAL
 *--------------------------------------------------------------------------
 * DESCRIPTION:  This is the headerfile for the OS - Abstraction Layer for 
 *               Message-Functions. This Header has to be included to use
 *               functions for handling messages
 *--------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      |   Modification                          | Author
 * 28.03.00  |   Initial revision                      | de Vries,EFT22
 * 30.03.00  |   osPx_mq_notify added at vxWorks       | de Vries,EFT22
 * 05.04.00  |   include"os_mqadapt.h" added           | de Vries,EFT22
 * 10.04.00  |   Restructuring                         | Uelschen, EFT42
 * 17.05.00  |   mq_notify():Parameter changed         | de Vries,EFT22
 * 23.05.00  |   MQUEUE_PRIORITY als defines           | Tiemann, EFT42
 * 20.06.00  |   OSAL_MessageCreate/..Delete added     | de Vries, EFT22
 *           |   Parameters changed OSAL_tMessage      | 
 * 26.06.00  |   OSAL_MessageCreate/..Delete removed   | de Vries, EFT22
 *           |   Parameters changed OSAL_tMessage      | 
 * 04.08.00  |   Linux defines added                   | Wunderlich, EFT32
 * 11.08.00  |   Linux uses OSAL_DECL now              | Wunderlich, EFT32
 * 18.02.02  |   Nucleus defines added                 | Uelschen, ESN2
 * 13.06.02  |   add dynamic-download                  | Perick, CM-CR/EES4
 *           |   extension                             |
 *
 **************************************************************************/


#if !defined (OSAL_MQUEUE_HEADER)
   #define OSAL_MQUEUE_HEADER


#ifdef __cplusplus
extern "C"
{
   #endif
   
   /**************************************************************************/
   /* typedefs                                                               */
   /**************************************************************************/
   
   typedef struct
   {
      tCString              coszName;
      OSAL_tEventMask       mask;
      OSAL_tenEventMaskFlag enFlags;
   }trMqEventInf;


   /* -- Minimale und maximale Prioritaeten: */
   
   #define OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST  ((tU32) 0)
   #define OSAL_C_U32_MQUEUE_PRIORITY_LOWEST   ((tU32) 7)
   
   #define OSAL_C_U32_MQUEUE_MAX_MESSAGELENGTH ((tU32)4096)
  
   #if (OSAL_OS==OSAL_VXWORKS)
   typedef mqd_t OSAL_tMQueueHandle;
   #elif (OSAL_OS==OSAL_LINUX) || (OSAL_OS==OSAL_DARWIN)
   #ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT
   typedef uintptr_t OSAL_tMQueueHandle; 
   #else
   typedef tU32 OSAL_tMQueueHandle; 
   #endif
   #elif (OSAL_OS==OSAL_WINNT || OSAL_OS==OSAL_RX732 || OSAL_OS==OSAL_WINCE || OSAL_OS==OSAL_NUCLEUS || OSAL_OS==OSAL_TENGINE)
   typedef tU32 OSAL_tMQueueHandle;
   #endif
   
  
#ifndef OSAL_DYNAMIC_DOWNLOAD
 
   #if OSAL_OS==OSAL_WINNT ||  OSAL_OS==OSAL_RX732 ||  OSAL_OS==OSAL_VXWORKS || OSAL_OS==OSAL_LINUX || (OSAL_OS==OSAL_DARWIN) \
		|| OSAL_OS==OSAL_WINCE || OSAL_OS==OSAL_NUCLEUS || OSAL_OS==OSAL_TENGINE
   
   /* --11.2.1 Create a Message Queue */
   OSAL_DECL tS32 OSAL_s32MessageQueueCreate(tCString coszName, tU32 u32MaxMessages, tU32 u32MaxLength,
    OSAL_tenAccess enAccess, OSAL_tMQueueHandle* phMQ);
   
   /* --11.2.2 Open a Message Queue */ 
   OSAL_DECL tS32 OSAL_s32MessageQueueOpen(tCString coszName, OSAL_tenAccess enAccess, 
    OSAL_tMQueueHandle* phMQ);
   
   /* --11.2.3 Close a Message Queue */
   OSAL_DECL tS32 OSAL_s32MessageQueueClose(OSAL_tMQueueHandle hMQ);
   
   /* --11.2.4 Remove a Message Queue from System */
   OSAL_DECL tS32 OSAL_s32MessageQueueDelete(tCString coszName);
   
   /* --11.2.5 Send a Message */
   OSAL_DECL tS32 OSAL_s32MessageQueuePost(OSAL_tMQueueHandle hMQ, tPCU8 pcou8Msg, tU32 u32Length, 
    tU32 u32Prio);
   
   /* --11.2.6 Receive a Message */
   OSAL_DECL tS32 OSAL_s32MessageQueueWait(OSAL_tMQueueHandle hMQ, tPU8 pu8Buffer, tU32 u32Length, 
    tPU32 pu32Prio, OSAL_tMSecond msec);
   
   /* --11.2.7 Notify a Message */
   OSAL_DECL tS32 OSAL_s32MessageQueueNotify(OSAL_tMQueueHandle hMQ, OSAL_tpfCallback pCallback,           
    tPVoid pvArg);
   
   /* --11.2.9 Abfragen des Status einer Nachrichtenschlange */
   OSAL_DECL tS32 OSAL_s32MessageQueueStatus(OSAL_tMQueueHandle hMQ, tPU32 pu32MaxMessages, tPU32 pu32MaxLength, tPU32 pu32Messages);
   
   
   #endif

#endif // OSAL_DYNAMIC_DOWNLOAD


/**************************************************************************/
/* dynamic-download                                                       */
/**************************************************************************/
#if ( defined OSAL_DYNAMIC_DOWNLOAD || defined OSAL_DYNAMIC_BASE)
typedef tS32 (*tOSAL_s32MessageQueueCreate)(tCString coszName, tU32 u32MaxMessages, tU32 u32MaxLength,
                                            OSAL_tenAccess enAccess, OSAL_tMQueueHandle* phMQ);
typedef tS32 (*tOSAL_s32MessageQueueOpen)(tCString coszName, OSAL_tenAccess enAccess, 
                                          OSAL_tMQueueHandle* phMQ);
typedef tS32 (*tOSAL_s32MessageQueueClose)(OSAL_tMQueueHandle hMQ);
typedef tS32 (*tOSAL_s32MessageQueueDelete)(tCString coszName);
typedef tS32 (*tOSAL_s32MessageQueuePost)(OSAL_tMQueueHandle hMQ, tPCU8 pcou8Msg, tU32 u32Length, 
                                          tU32 u32Prio);
typedef tS32 (*tOSAL_s32MessageQueueWait)(OSAL_tMQueueHandle hMQ, tPU8 pu8Buffer, tU32 u32Length, 
                                          tPU32 pu32Prio, OSAL_tMSecond msec);
typedef tS32 (*tOSAL_s32MessageQueueNotify)(OSAL_tMQueueHandle hMQ, OSAL_tpfCallback pCallback,           
                                            tPVoid pvArg);
typedef tS32 (*tOSAL_s32MessageQueueStatus)(OSAL_tMQueueHandle hMQ, tPU32 pu32MaxMessages, 
                                            tPU32 pu32MaxLength, tPU32 pu32Messages);
#endif


#ifdef OSAL_DYNAMIC_DOWNLOAD
extern tOSAL_s32MessageQueueCreate OSAL_s32MessageQueueCreate;
extern tOSAL_s32MessageQueueOpen   OSAL_s32MessageQueueOpen;
extern tOSAL_s32MessageQueueClose  OSAL_s32MessageQueueClose;
extern tOSAL_s32MessageQueueDelete OSAL_s32MessageQueueDelete;
extern tOSAL_s32MessageQueuePost   OSAL_s32MessageQueuePost;
extern tOSAL_s32MessageQueueWait   OSAL_s32MessageQueueWait;
extern tOSAL_s32MessageQueueNotify OSAL_s32MessageQueueNotify;
extern tOSAL_s32MessageQueueStatus OSAL_s32MessageQueueStatus;
#endif // OSAL_DYNAMIC_DOWNLOAD
   
   
   #ifdef __cplusplus
}
#endif

/* --OSAL object oriented C++-Interface.  EXPERIMENTAL !!!*/
#ifdef __cplusplus
class OSAL_DECL OSAL_tclMessageQueue
{
   public:
      /* --Construction/Destruction. */
      OSAL_tclMessageQueue();
      
      /* --Destructor
              This method closes the queue (see s32Close()). The message queue
              will NOT be deleted. */
      virtual ~OSAL_tclMessageQueue();
      
      /* --The following methods are according to the OSAL specification. */
      
      /* --s32Create (OSAL_s32MessageQueueCreate). */
      virtual tS32 s32Create(tCString coszName, tU32 u32MaxMessages, tU32 u32MaxLength, OSAL_tenAccess enAccess);
      
      /* --s32Open (OSAL_s32MessageQueueOpen). */
      virtual tS32 s32Open(tCString coszName, OSAL_tenAccess enAccess);
      
      /* --s32Close (OSAL_s32MessageQueueClose). */
      virtual tS32 s32Close();
      
      /* --s32Delete (OSAL_s32MessageQueueDelete). */
      virtual tS32 s32Delete();
      
      /* --s32Post (OSAL_s32MessageQueuePost). */
      virtual tS32 s32Post(tPCU8 pcou8Msg, tU32 u32Length, tU32 u32Prio);     
      
      /* --s32Wait (OSAL_s32MessageQueueWait). */             
      virtual tS32 s32Wait(tPU8 pu8Buffer, tU32 u32Length, tPU32 pu32Prio, OSAL_tMSecond msec);
      
      /* --s32Status (OSAL_s32MessageQueueStatus). */
      virtual tS32 s32Status(tPU32 pu32MaxMessages, tPU32 pu32MaxLength, tPU32 pu32Messages);
      
      /* --The following methods are new and/or with modification to the OSAL specification. */
      
      /* --s32Notify
              This methods sets the vOnMessageReceived()-method as the callback function,
              which is executed on arriving (see OSAL_s32MessageQueueNotify). Calling the
              method with parameter FALSE, unsets the notification. */
      virtual tS32 s32Notify(tBool bSetNotification =TRUE);
      
      /* --vOnMessageReceived
              This message will be called if an new message has arrived (notification mechanims). 
              You need to specify this class and define an overloaded method. */
      virtual tVoid vOnMessageReceived();
      /* --handle
              This method returns the handle of the message queue. */
      OSAL_tMQueueHandle handle() const
      {
         return hMQ;
      }
   private:
      /* --hMQ
              This is the handle of the message queue. */
      OSAL_tMQueueHandle hMQ;
      
      /* --szName
              This is the name of the message queue. */
      tString szName;
      
      /* --vCallback
              This method is the callback of the notification and calls the vOnMessageReceived()
              method of the given object (simple trick). */
      static tVoid vCallback(tPVoid pvObject);
      /* --It is not allowed to assign oder copy an instance of the queue. */
      OSAL_tclMessageQueue(const OSAL_tclMessageQueue&);
      OSAL_tclMessageQueue& operator=(const OSAL_tclMessageQueue&);
};
#endif

#endif 


/* EOF */
