/******************************************************************************
 * .EXPORT_ME
 * FILE:         osmemory.h
 * PROJECT:      VASCO
 * SW-COMPONENT: OSAL
 *-----------------------------------------------------------------------------
 * DESCRIPTION:  This is the headerfile for the OS - Abstraction Layer for 
 *               Memory-Functions. This Header has to be included to use the
 *               functions for memory handling
 *-----------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date       |   Modification                   | Author
 * 15.04.2016 |   Initial revision               | Wiedemann
 * 
 *****************************************************************************/
#if !defined (OSAL_MEMORY_HEADER)
#define OSAL_MEMORY_HEADER

#ifdef OSAL_USE_OSMEMORY_LEGACY_CODE
   #include "osmemory_legacy.h"
#else
   #include "osansi.h" // for malloc, free

   #define OSAL_pvMemoryAllocate malloc
   #define OSAL_pvMemoryReAllocate realloc
   #define OSAL_pvMemoryCAllocate calloc
   #define OSAL_pvMemoryAllocate_NonCritical malloc
   #define OSAL_vMemoryFree free
   #define OSAL_pvMemoryCopy memcpy   
   #define OSAL_pvMemoryMove memmove
   #define OSAL_s32MemoryCompare memcmp
   #define OSAL_pvMemorySearchChar memchr
   #define OSAL_pvMemorySet memset

   #ifdef __cplusplus
      
      #include <new>
      struct rOSALNothrowNew
      {
      };

      typedef struct rOSALNothrowNew tOSALNothrowNew;

      static const tOSALNothrowNew cOSALNoThrowNew = {};

      #define OSAL_NEW new(cOSALNoThrowNew)
      #define OSAL_DELETE delete

      inline void* operator new(size_t nSize, const tOSALNothrowNew&) throw()
      {
         void* pMem = operator new(nSize, std::nothrow);
         return (pMem);
      }

      inline void* operator new[](size_t nSize, const tOSALNothrowNew&) throw()
      {
         void* pMem = operator new[](nSize, std::nothrow);
         return (pMem);
      }

      inline void operator delete(void* pMem, const tOSALNothrowNew&)
      {
         ::operator delete(pMem);
      }

      inline void operator delete[](void* pMem, const tOSALNothrowNew&)
      {
         ::operator delete[](pMem);
      }
   #endif // __cplusplus
#endif // OSAL_ENABLE_OSMEMORY_LEGACY_CODE 

#endif // OSAL_MEMORY_HEADER
/* EOF */
