/**
   \par FILE
   osioctrl_vese.h  
   
   \par SW-COMPONENT
   VehicleSensor
   
   \par DESCRIPTION
   \brief This header file defines constants and declares data structures
   used for communication in between the two components of VehicleSensor
   (drv_VeSe and vd_VeSe).

   \details For transferring the data from drv_VeSe to vd_VeSe there is
   used an intermediate data format consisting of a stream of
   atomic pieces of sensor data, called <i>VeSe records</i>.
   Each VeSe records either refers to one element of the properties
   supported by vd_VeSe or contains control characters affecting the
   processing of the subsequent VeSe records.<p>
   \todo{Currently, this file has been written and is maintained manually,
   but it shall be automatically generated from cmb_VehicleSensor_FI
   with the next generation of vd_VeSe's codegenerator.}<p>
   Assure that this file has to be edited manually and is not autogenerated
   before editing this file as manual changes would get lost on regeneration
   if file was autogenerated.

   \par AUTHOR
   \author CM-AI/PJ-CF31 Thilo Fischer (fit4hi)
   
   \par COPYRIGHT
   &copy; 2011, 2012 Robert Bosch Car Multimedia GmbH
   
   \par HISTORY
   <TABLE>
   
   <TR><TH> Date       </TH><TH> Revision </TH><TH> Author </TH>
   <TH> Change Description </TH></TR>
  
   <TR><TD> 2.12.2011 </TD><TD>    0.01  </TD><TD> fit4hi </TD>
   <TD> initial version </TD></TR>
   <TR><TD>31.01.2012 </TD><TD>    0.02  </TD><TD> fit4hi </TD>
   <TD> misc. additional features, bugfixes, code cleanup, documentation </TD></TR>
  
   </TABLE>
*/

// TODO: make list interface more generic by inventing ClearList/EndOfList/ListIndex for every list-associated record class.
// TODO?: replace ClearList by CreateList which has new list size as an argument ..?

#ifndef OSIOCTRL_VESE_HEADER
#define OSIOCTRL_VESE_HEADER


/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/


#define VESE_C_RECORD_MAX_RECORD_SIZE ((tU8) 64)


/* invalidity values match the values defined in cmb_VehicleSensor_FI for the associated property values */

#define VESE_C_RECORD_TIMESTAMP_INVALIDITY_VALUE ((tU32) 0xFFFFFFFF)

#define VESE_C_RECORD__Brake_BrakePedalPressed_INVALIDITY_VALUE ((tU8) 0x00)
#define VESE_C_RECORD__Brake_BrakePressureList_Axle_INVALIDITY_VALUE ((tU8) 0xFF)
#define VESE_C_RECORD__Brake_BrakePressureList_PosOnAxle_INVALIDITY_VALUE ((tU8) 0xFF)
#define VESE_C_RECORD__Brake_BrakePressureList_BrakePressure_INVALIDITY_VALUE ((tS32) 0x80000000)
#define VESE_C_RECORD__Brake_CloseLoopControlStatus_INVALIDITY_VALUE ((tU32) 0xFFFFFFFF /*FIXME!*/)
#define VESE_C_RECORD__Brake_HandBrakeStatus_INVALIDITY_VALUE  ((tU8) 0x00)
#define VESE_C_RECORD__Brake_EMFBrake_INVALIDITY_VALUE ((tU8) 0x00)

#define VESE_C_RECORD__CruiseControl_Type_INVALIDITY_VALUE ((tU8) 0x00)
#define VESE_C_RECORD__CruiseControl_State_INVALIDITY_VALUE ((tU8) 0x00)
#define VESE_C_RECORD__CruiseControl_SetSpeed_INVALIDITY_VALUE ((tS16) 0x8000)
#define VESE_C_RECORD__CruiseControl_CoastingActive_INVALIDITY_VALUE ((tU8) 0x00)
#define VESE_C_RECORD__CruiseControl_CoastingSetSpeed_INVALIDITY_VALUE ((tS16) 0x8000)
#define VESE_C_RECORD__CruiseControl_LockedLeadCar_INVALIDITY_VALUE ((tU8) 0x00)
#define VESE_C_RECORD__CruiseControl_DistanceToLockedLeadCarSufficient_INVALIDITY_VALUE ((tU8) 0x00)
#define VESE_C_RECORD__CruiseControl_LockedLeadCarSpeed_INVALIDITY_VALUE ((tS16) 0x8000)

#define VESE_C_RECORD__EngineParameter_TemperatureEngine_INVALIDITY_VALUE ((tS16) 0x8000)
#define VESE_C_RECORD__EngineParameter_TemperatureEngineOil_INVALIDITY_VALUE ((tS16) 0x8000)
#define VESE_C_RECORD__EngineParameter_StatusEngineRunning_INVALIDITY_VALUE ((tU16) 0x0001)
#define VESE_C_RECORD__EngineParameter_InjectionVolumeFuel_INVALIDITY_VALUE ((tU32) 0xFFFFFFFF)
#define VESE_C_RECORD__EngineParameter_ReductionDownControlRPM_INVALIDITY_VALUE ((tU8) 0x00)
#define VESE_C_RECORD__EngineParameter_StatusRBMZyklus_INVALIDITY_VALUE ((tU8) 0x00)
#define VESE_C_RECORD__EngineParameter_RPMIdlingTarget_INVALIDITY_VALUE ((tU16) 0xFFFF /*fixme*/)

#define VESE_C_RECORD__EnginePerformance_EngineSpeed_INVALIDITY_VALUE ((tU16) 65535)
#define VESE_C_RECORD__EnginePerformance_AccPedal_INVALIDITY_VALUE ((tU8) 255)
#define VESE_C_RECORD__EnginePerformance_WheelMoment_INVALIDITY_VALUE ((tS16) 0x8000)
#define VESE_C_RECORD__EnginePerformance_EngineTorque_INVALIDITY_VALUE ((tS16) 0x8000)
#define VESE_C_RECORD__EnginePerformance_RotationIrregularity_INVALIDITY_VALUE ((tU8) 0x00)
#define VESE_C_RECORD__EnginePerformance_OverRunFuelShutoff_INVALIDITY_VALUE ((tU8) 0x00)
#define VESE_C_RECORD__EnginePerformance_TorqueMinimum_INVALIDITY_VALUE ((tS16) 0x8000)
#define VESE_C_RECORD__EnginePerformance_TorqueDriversChoice_INVALIDITY_VALUE ((tS16) 0x8000)

#define VESE_C_RECORD__GearBox_GearPosition_INVALIDITY_VALUE ((tU8) 0x00)
#define VESE_C_RECORD__GearBox_GearLeverPosition_INVALIDITY_VALUE ((tU8) 0x00)
#define VESE_C_RECORD__GearBox_GearBoxState_INVALIDITY_VALUE ((tU8) 0x00)
#define VESE_C_RECORD__GearBox_TorqueConverterLockupClutch_INVALIDITY_VALUE ((tU8) 0x00)
#define VESE_C_RECORD__GearBox_GearboxSportSwitch_INVALIDITY_VALUE ((tU8) 0x00)
#define VESE_C_RECORD__GearBox_SwitchClutch_INVALIDITY_VALUE ((tU8) 0x00)

#define VESE_C_RECORD__Ignition_Ignition_INVALIDITY_VALUE ((tU8) 0x00)

#define VESE_C_RECORD__Speed_VehicleSpeed_INVALIDITY_VALUE ((tS16) 0x8000)
#define VESE_C_RECORD__Speed_VehicleDrivingCondition_INVALIDITY_VALUE ((tU8) 0x00)

#define VESE_C_RECORD__SteeringWheelAngle_WheelAngle_INVALIDITY_VALUE ((tS32) 0x80000000)
#define VESE_C_RECORD__SteeringWheelAngle_WheelRate_INVALIDITY_VALUE ((tS32) 0x80000000)
#define VESE_C_RECORD__SteeringWheelAngle_WheelAngleSensorOk_INVALIDITY_VALUE ((tU8) 0x00)
#define VESE_C_RECORD__SteeringWheelAngle_WheelRateSensorOk_INVALIDITY_VALUE ((tU8) 0x00)

#define VESE_C_RECORD__VehicleDynamic_OldestTimestamp_INVALIDITY_VALUE VESE_C_U32_TIMESTAMP_INVALIDITY_VALUE
#define VESE_C_RECORD__VehicleDynamic_Yawrate_INVALIDITY_VALUE ((tS16) 0x8000)
#define VESE_C_RECORD__VehicleDynamic_LongitudinalAcceleration_INVALIDITY_VALUE ((tS16) 0x8000)
#define VESE_C_RECORD__VehicleDynamic_LateralAcceleration_INVALIDITY_VALUE ((tS16) 0x8000)

#define VESE_C_RECORD__Seats_SeatList_Row_INVALIDITY_VALUE ((tU8) 0xFF)
#define VESE_C_RECORD__Seats_SeatList_PlaceInRow_INVALIDITY_VALUE ((tU8) 0xFF)
#define VESE_C_RECORD__Seats_SeatList_Occupation_INVALIDITY_VALUE ((tU8) 0x00)
#define VESE_C_RECORD__Seats_SeatList_SeatBeltLock_INVALIDITY_VALUE ((tU8) 0x00)
#define VESE_C_RECORD__Seats_SeatList_SeatClimate_INVALIDITY_VALUE ((tU8) 255)
#define VESE_C_RECORD__Seats_SeatList_RealTemperature_INVALIDITY_VALUE ((tS16) 0x8000)
#define VESE_C_RECORD__Seats_SeatList_SeatHeater_INVALIDITY_VALUE ((tU8) 255)
#define VESE_C_RECORD__Seats_SeatList_NeckHeater_INVALIDITY_VALUE ((tU8) 255)
#define VESE_C_RECORD__Seats_SeatList_StratSeatHeater_INVALIDITY_VALUE ((tS16) 0x8000)

#define VESE_C_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_NumberOfSigns_INVALIDITY_VALUE ((tU16) 0xFFFF)
#define VESE_C_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_ListIndex_INVALIDITY_VALUE ((tU16) 0xFFFF)
#define VESE_C_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSignID_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_IDOfTrafficSignAbove_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_DynamicTrafficSign_INVALIDITY_VALUE FALSE
#define VESE_C_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_VirtualTrafficSign_INVALIDITY_VALUE FALSE
#define VESE_C_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_BaseSignUnion_TYPE_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_BaseSignUnion_DATA_T_e8_SpeedSign_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_BaseSignUnion_DATA_T_e8_WarningSign_INVALIDITY_VALUE ((tU16) 0)
#define VESE_C_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_BaseSignUnion_DATA_T_e8_RegulatorySign_INVALIDITY_VALUE ((tU16) 0)
#define VESE_C_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_QuantifierOfBaseSign_TYPE_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_QuantifierOfBaseSign_DATA_XXXXX_INVALIDITY_VALUE ((tU8) 0) // TODO: this is a eumeration union type
#define VESE_C_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_AdditionalSignList_AdditionalSign_INVALIDITY_VALUE ((tU16) 0)
#define VESE_C_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_AdditionalSignList_QuantifierOfAddSign_INVALIDITY_VALUE ((tU8) 0) // TODO: this is a eumeration union type
#define VESE_C_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TSLongitudinalDistance_INVALIDITY_VALUE ((tS32) 0x80000000)
#define VESE_C_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TSLateralOffset_INVALIDITY_VALUE ((tS32) 0x80000000)
#define VESE_C_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TSHeight_INVALIDITY_VALUE ((tS32) 0x80000000)
#define VESE_C_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TSQuality_TSQuality_TSQuality_INVALIDITY_VALUE ((tU8) 255)
#define VESE_C_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TSQuality_TSQuality_TSQuantifierQuality_INVALIDITY_VALUE ((tU8) 255)
#define VESE_C_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TSQuality_AdditionalTSQualityList_TSQuality_INVALIDITY_VALUE ((tU8) 255)
#define VESE_C_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TSQuality_AdditionalTSQualityList_TSQuantifierQuality_INVALIDITY_VALUE ((tU8) 255)

// Prio B & C

#define VESE_C_RECORD__Doors_CentralLockingState_INVALIDITY_VALUE ((tU16) 0x0001)
#define VESE_C_RECORD__Doors_DoorStatusList_XPosition_INVALIDITY_VALUE ((tU8) 255)
#define VESE_C_RECORD__Doors_DoorStatusList_YPosition_INVALIDITY_VALUE ((tU8) 255)
#define VESE_C_RECORD__Doors_DoorStatusList_Closed_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__Doors_DoorStatusList_DoorType_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__HybridOperation_SOCStatus_INVALIDITY_VALUE ((tS16) FIXME)
#define VESE_C_RECORD__HybridOperation_SOCSet_INVALIDITY_VALUE ((tS16) FIXME)
#define VESE_C_RECORD__HybridOperation_FuelConsumptionHybrid_INVALIDITY_VALUE ((tU32) FIXME)
#define VESE_C_RECORD__HybridOperation_FuelSaving_INVALIDITY_VALUE ((tS16) FIXME)
#define VESE_C_RECORD__Lights_HeadLights_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__Lights_DaytimeRunningLight_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__Lights_FrontFogLight_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__Lights_RearFogLight_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__Lights_DirectionIndication_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__Rain_IntensityRain_INVALIDITY_VALUE ((tU8) 255)
#define VESE_C_RECORD__Rain_WiperSpeed_INVALIDITY_VALUE ((tU16) 65535)
#define VESE_C_RECORD__Rain_RainSensorInNormalMode_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__Defroster_RearDefroster_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__Defroster_RearViewDefroster_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__Defroster_FrontDefroster_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__StaticVehicleParameters_ChassisNumber_INVALIDITY_VALUE {0} /* value only used within intializer -- TODO: concept for string records */
#define VESE_C_RECORD__StaticVehicleParameters_LowerCriticalVelocity_INVALIDITY_VALUE ((tS16) 0x8000)
#define VESE_C_RECORD__StaticVehicleParameters_Drive_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__StaticVehicleParameters_NumberOfSeats_INVALIDITY_VALUE ((tU8) 0xFF)
#define VESE_C_RECORD__StaticVehicleParameters_NumberOfDoors_INVALIDITY_VALUE ((tU8) 0xFF)
#define VESE_C_RECORD__KeyStatus_KeyValid_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__KeyStatus_KeyNumber_INVALIDITY_VALUE ((tU8) 0xFF)
#define VESE_C_RECORD__KeyStatus_KeyTyp_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__KeyStatus_KeyLocation_INVALIDITY_VALUE ((tU16) 0x0001)
#define VESE_C_RECORD__ClimateControl_ACCompressorStatus_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__ClimateControl_ACStatus_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__ClimateControl_DefrosterStatus_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__Windows_WindowPositionList_XPosition_INVALIDITY_VALUE ((tU8) 255)
#define VESE_C_RECORD__Windows_WindowPositionList_YPosition_INVALIDITY_VALUE ((tU8) 255)
#define VESE_C_RECORD__Windows_WindowPositionList_OpeningLevel_INVALIDITY_VALUE ((tU8) 255)
#define VESE_C_RECORD__Windows_WindowPositionList_WindowType_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__Environment_OutsideTemperature_INVALIDITY_VALUE ((tS16) 0x8000)
#define VESE_C_RECORD__Environment_AmbienceBrightness_INVALIDITY_VALUE ((tU32) 0xFFFFFFFF)
#define VESE_C_RECORD__Environment_AirPressure_INVALIDITY_VALUE ((tS32) 0x80000000)
#define VESE_C_RECORD__Wheels_TirePressureList_AirPressure_INVALIDITY_VALUE ((tS32) 0x80000000)
#define VESE_C_RECORD__Wheels_TirePressureList_Axle_INVALIDITY_VALUE ((tU8) 0xFF)
#define VESE_C_RECORD__Wheels_TirePressureList_PosOnAxle_INVALIDITY_VALUE ((tU8) 0xFF)
#define VESE_C_RECORD__VehicleLoad_VehicleTilt_INVALIDITY_VALUE ((tS16) 0x8000)
#define VESE_C_RECORD__VehicleLoad_TrailerAttached_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__LDW_LDWSideIndicator_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__LDW_DistanceToLine_INVALIDITY_VALUE ((tS32) 0x80000000)
#define VESE_C_RECORD__LDW_TimeToLine_INVALIDITY_VALUE ((tU16) 0xFFFF)
#define VESE_C_RECORD__LaneDetection_DetectedLineList_LineID_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__LaneDetection_DetectedLineList_Probability_INVALIDITY_VALUE ((tS16) 0x8000)
#define VESE_C_RECORD__LaneDetection_DetectedLineList_Linecolor_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__LaneDetection_DetectedLineList_LateralDistance_INVALIDITY_VALUE ((tS32) 0x80000000)
#define VESE_C_RECORD__LaneDetection_DetectedLineList_AngleToBegin_INVALIDITY_VALUE ((tS16) 0x8000)
#define VESE_C_RECORD__LaneDetection_DetectedLineList_HorCurvature_INVALIDITY_VALUE ((tS16) 0x8000)
#define VESE_C_RECORD__LaneDetection_DetectedLineList_HorCurvatureChange_INVALIDITY_VALUE ((tS32) 0x80000000)
#define VESE_C_RECORD__DetectedObjects_DetectedObjectList_ObjectID_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__DetectedObjects_DetectedObjectList_ObjectType_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__DetectedObjects_DetectedObjectList_ObjectMeasured_INVALIDITY_VALUE ((tU8) 0)
#define VESE_C_RECORD__DetectedObjects_DetectedObjectList_ExistProbability_INVALIDITY_VALUE ((tS16) 0x8000)
#define VESE_C_RECORD__DetectedObjects_DetectedObjectList_LongitudinalDistance_INVALIDITY_VALUE ((tS32) 0x80000000)
#define VESE_C_RECORD__DetectedObjects_DetectedObjectList_LateralOffset_INVALIDITY_VALUE ((tS32) 0x80000000)
#define VESE_C_RECORD__DetectedObjects_DetectedObjectList_ObjectWidth_INVALIDITY_VALUE ((tS32) 0x80000000)
#define VESE_C_RECORD__DetectedObjects_DetectedObjectList_DeviationLongitudinalDistance_INVALIDITY_VALUE ((tS32) 0x80000000)
#define VESE_C_RECORD__DetectedObjects_DetectedObjectList_DeviationLateralOffset_INVALIDITY_VALUE ((tS32) 0x80000000)
#define VESE_C_RECORD__DetectedObjects_DetectedObjectList_DeviationWidth_INVALIDITY_VALUE ((tS32) 0x80000000)


/* IMPORTANT: sequence of array elements must match the order of symbols in enum vese_tenRecordType */
/* the array which is defined by this macro will be used in drv_VeSe
   AND vd_VeSe, this is why we use a macro: to write down the array definition
   only once and use the same program code form the same file
   within both VeSe components. */
/* had to split up this long macro to satisfy lint ... */
#define VESE_M_DEFINE_vese_au8RecordSizes()                                     \
   VESE_M_DEFINE_vese_au8RecordSizes_MACRO_PART1                                \
   VESE_M_DEFINE_vese_au8RecordSizes_MACRO_PART2                                \
   VESE_M_DEFINE_vese_au8RecordSizes_MACRO_PART3                                \
   VESE_M_DEFINE_vese_au8RecordSizes_MACRO_PART4

#define VESE_M_DEFINE_vese_au8RecordSizes_MACRO_PART1                           \
   const tU8 vese_au8RecordSizes[VESE_EN_RECORD_ENUM_LAST] = {                  \
      (tU8) sizeof(vese_tRecord_Invalid),                                       \
      (tU8) sizeof(vese_tRecord_Timestamp),                                     \
      (tU8) sizeof(vese_tRecord_Termination),                                   \
      (tU8) sizeof(vese_tRecord_OverflowNote),                                  \
                                                                                \
      (tU8) sizeof(vese_tRecord__Brake_BrakePedalPressed),                      \
      (tU8) sizeof(vese_tRecord__Brake_BrakePressureList_Axle),                 \
      (tU8) sizeof(vese_tRecord__Brake_BrakePressureList_PosOnAxle),            \
      (tU8) sizeof(vese_tRecord__Brake_BrakePressureList_BrakePressure),        \
      (tU8) sizeof(vese_tRecord__Brake_CloseLoopControlStatus),                 \
      (tU8) sizeof(vese_tRecord__Brake_HandBrakeStatus),                        \
      (tU8) sizeof(vese_tRecord__Brake_EMFBrake),                               \
                                                                                \
      (tU8) sizeof(vese_tRecord__CruiseControl_Type),                           \
      (tU8) sizeof(vese_tRecord__CruiseControl_State),                          \
      (tU8) sizeof(vese_tRecord__CruiseControl_SetSpeed),                       \
      (tU8) sizeof(vese_tRecord__CruiseControl_CoastingActive),                 \
      (tU8) sizeof(vese_tRecord__CruiseControl_CoastingSetSpeed),               \
      (tU8) sizeof(vese_tRecord__CruiseControl_LockedLeadCar),                  \
      (tU8) sizeof(vese_tRecord__CruiseControl_DistanceToLockedLeadCarSufficient), \
      (tU8) sizeof(vese_tRecord__CruiseControl_LockedLeadCarSpeed),             \
                                                                                \
      (tU8) sizeof(vese_tRecord__EngineParameter_TemperatureEngine),            \
      (tU8) sizeof(vese_tRecord__EngineParameter_TemperatureEngineOil),         \
      (tU8) sizeof(vese_tRecord__EngineParameter_StatusEngineRunning),          \
      (tU8) sizeof(vese_tRecord__EngineParameter_InjectionVolumeFuel),          \
      (tU8) sizeof(vese_tRecord__EngineParameter_ReductionDownControlRPM),      \
      (tU8) sizeof(vese_tRecord__EngineParameter_StatusRBMZyklus),              \
      (tU8) sizeof(vese_tRecord__EngineParameter_RPMIdlingTarget),              \
                                                                                \
      (tU8) sizeof(vese_tRecord__EnginePerformance_EngineSpeed),                \
      (tU8) sizeof(vese_tRecord__EnginePerformance_AccPedal),                   \
      (tU8) sizeof(vese_tRecord__EnginePerformance_WheelMoment),                \
      (tU8) sizeof(vese_tRecord__EnginePerformance_EngineTorque),               \
      (tU8) sizeof(vese_tRecord__EnginePerformance_RotationIrregularity),       \
      (tU8) sizeof(vese_tRecord__EnginePerformance_OverRunFuelShutoff),         \
      (tU8) sizeof(vese_tRecord__EnginePerformance_TorqueMinimum),              \
      (tU8) sizeof(vese_tRecord__EnginePerformance_TorqueDriversChoice),        \
                                                                                \
      (tU8) sizeof(vese_tRecord__GearBox_GearPosition),                         \
      (tU8) sizeof(vese_tRecord__GearBox_GearLeverPosition),                    \
      (tU8) sizeof(vese_tRecord__GearBox_GearBoxState),                         \
      (tU8) sizeof(vese_tRecord__GearBox_TorqueConverterLockupClutch),          \
      (tU8) sizeof(vese_tRecord__GearBox_GearboxSportSwitch),                   \
      (tU8) sizeof(vese_tRecord__GearBox_SwitchClutch),                         \
                                                                                \
      (tU8) sizeof(vese_tRecord__Ignition_Ignition),

#define VESE_M_DEFINE_vese_au8RecordSizes_MACRO_PART2                           \
      (tU8) sizeof(vese_tRecord__Speed_VehicleSpeed),                           \
      (tU8) sizeof(vese_tRecord__Speed_VehicleDrivingCondition),                \
                                                                                \
      (tU8) sizeof(vese_tRecord__SteeringWheelAngle_WheelAngle),                \
      (tU8) sizeof(vese_tRecord__SteeringWheelAngle_WheelRate),                 \
      (tU8) sizeof(vese_tRecord__SteeringWheelAngle_WheelAngleSensorOk),        \
      (tU8) sizeof(vese_tRecord__SteeringWheelAngle_WheelRateSensorOk),         \
                                                                                \
      (tU8) sizeof(vese_tRecord__VehicleDynamic_OldestTimestamp),               \
      (tU8) sizeof(vese_tRecord__VehicleDynamic_Yawrate),                       \
      (tU8) sizeof(vese_tRecord__VehicleDynamic_LongitudinalAcceleration),      \
      (tU8) sizeof(vese_tRecord__VehicleDynamic_LateralAcceleration),           \
                                                                                \
      (tU8) sizeof(vese_tRecord__Seats_SeatList_Row),                           \
      (tU8) sizeof(vese_tRecord__Seats_SeatList_PlaceInRow),                    \
      (tU8) sizeof(vese_tRecord__Seats_SeatList_Occupation),                    \
      (tU8) sizeof(vese_tRecord__Seats_SeatList_SeatBeltLock),                  \
      (tU8) sizeof(vese_tRecord__Seats_SeatList_SeatClimate),                   \
      (tU8) sizeof(vese_tRecord__Seats_SeatList_RealTemperature),               \
      (tU8) sizeof(vese_tRecord__Seats_SeatList_SeatHeater),                    \
      (tU8) sizeof(vese_tRecord__Seats_SeatList_NeckHeater),                    \
      (tU8) sizeof(vese_tRecord__Seats_SeatList_StratSeatHeater),               \
                                                                                \
      (tU8) sizeof(vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_NumberOfSigns), \
      (tU8) sizeof(vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_ClearList), \
      (tU8) sizeof(vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_EndOfList), \
      (tU8) sizeof(vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_ListIndex), \
      (tU8) sizeof(vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSignID), \
      (tU8) sizeof(vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_IDOfTrafficSignAbove), \
      (tU8) sizeof(vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_DynamicTrafficSign), \
      (tU8) sizeof(vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_VirtualTrafficSign), \
      (tU8) sizeof(vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_BaseSignUnion), \
      (tU8) sizeof(vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_QuantifierOfBaseSign), \
      (tU8) sizeof(vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_AdditionalSignList_AdditionalSign), \
      (tU8) sizeof(vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_AdditionalSignList_QuantifierOfAddSign), \
      (tU8) sizeof(vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TSLongitudinalDistance), \
      (tU8) sizeof(vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TSLateralOffset), \
      (tU8) sizeof(vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TSHeight), \
      (tU8) sizeof(vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TSQuality_TSQuality_TSQuality), \
      (tU8) sizeof(vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TSQuality_TSQuality_TSQuantifierQuality), \
      (tU8) sizeof(vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TSQuality_AdditionalTSQualityList_TSQuality), \
      (tU8) sizeof(vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TSQuality_AdditionalTSQualityList_TSQuantifierQuality),

#define VESE_M_DEFINE_vese_au8RecordSizes_MACRO_PART3                           \
      (tU8) sizeof(vese_tRecord__Doors_CentralLockingState),                    \
      (tU8) sizeof(vese_tRecord__Doors_DoorStatusList_XPosition),               \
      (tU8) sizeof(vese_tRecord__Doors_DoorStatusList_YPosition),               \
      (tU8) sizeof(vese_tRecord__Doors_DoorStatusList_Closed),                  \
      (tU8) sizeof(vese_tRecord__Doors_DoorStatusList_DoorType),                \
      (tU8) sizeof(vese_tRecord__HybridOperation_SOCStatus),                    \
      (tU8) sizeof(vese_tRecord__HybridOperation_SOCSet),                       \
      (tU8) sizeof(vese_tRecord__HybridOperation_FuelConsumptionHybrid),        \
      (tU8) sizeof(vese_tRecord__HybridOperation_FuelSaving),                   \
      (tU8) sizeof(vese_tRecord__Lights_HeadLights),                            \
      (tU8) sizeof(vese_tRecord__Lights_DaytimeRunningLight),                   \
      (tU8) sizeof(vese_tRecord__Lights_FrontFogLight),                         \
      (tU8) sizeof(vese_tRecord__Lights_RearFogLight),                          \
      (tU8) sizeof(vese_tRecord__Lights_DirectionIndication),                   \
      (tU8) sizeof(vese_tRecord__Rain_IntensityRain),                           \
      (tU8) sizeof(vese_tRecord__Rain_WiperSpeed),                              \
      (tU8) sizeof(vese_tRecord__Rain_RainSensorInNormalMode),                  \
      (tU8) sizeof(vese_tRecord__Defroster_RearDefroster),                      \
      (tU8) sizeof(vese_tRecord__Defroster_RearViewDefroster),                  \
      (tU8) sizeof(vese_tRecord__Defroster_FrontDefroster),                     \
      (tU8) sizeof(vese_tRecord__StaticVehicleParameters_ChassisNumber),        \
      (tU8) sizeof(vese_tRecord__StaticVehicleParameters_LowerCriticalVelocity), \
      (tU8) sizeof(vese_tRecord__StaticVehicleParameters_Drive),                \
      (tU8) sizeof(vese_tRecord__StaticVehicleParameters_NumberOfSeats),        \
      (tU8) sizeof(vese_tRecord__StaticVehicleParameters_NumberOfDoors),        \
      (tU8) sizeof(vese_tRecord__KeyStatus_KeyValid),                           \
      (tU8) sizeof(vese_tRecord__KeyStatus_KeyNumber),                          \
      (tU8) sizeof(vese_tRecord__KeyStatus_KeyTyp),                             \
      (tU8) sizeof(vese_tRecord__KeyStatus_KeyLocation),                        \
      (tU8) sizeof(vese_tRecord__ClimateControl_ACCompressorStatus),            \
      (tU8) sizeof(vese_tRecord__ClimateControl_ACStatus),                      \
      (tU8) sizeof(vese_tRecord__ClimateControl_DefrosterStatus),               \
      (tU8) sizeof(vese_tRecord__Windows_WindowPositionList_XPosition),         \
      (tU8) sizeof(vese_tRecord__Windows_WindowPositionList_YPosition),         \
      (tU8) sizeof(vese_tRecord__Windows_WindowPositionList_OpeningLevel),      \
      (tU8) sizeof(vese_tRecord__Windows_WindowPositionList_WindowType),        \
      (tU8) sizeof(vese_tRecord__Environment_OutsideTemperature),               \
      (tU8) sizeof(vese_tRecord__Environment_AmbienceBrightness),               \
      (tU8) sizeof(vese_tRecord__Environment_AirPressure),                      \
      (tU8) sizeof(vese_tRecord__Wheels_TirePressureList_AirPressure),          \
      (tU8) sizeof(vese_tRecord__Wheels_TirePressureList_Axle),                 \
      (tU8) sizeof(vese_tRecord__Wheels_TirePressureList_PosOnAxle),            \
      (tU8) sizeof(vese_tRecord__VehicleLoad_VehicleTilt),                      \
      (tU8) sizeof(vese_tRecord__VehicleLoad_TrailerAttached),                  \
      (tU8) sizeof(vese_tRecord__LDW_LDWSideIndicator),                         \
      (tU8) sizeof(vese_tRecord__LDW_DistanceToLine),                           \
      (tU8) sizeof(vese_tRecord__LDW_TimeToLine),

#define VESE_M_DEFINE_vese_au8RecordSizes_MACRO_PART4                           \
      (tU8) sizeof(vese_tRecord__LaneDetection_DetectedLineList_LineID),        \
      (tU8) sizeof(vese_tRecord__LaneDetection_DetectedLineList_LateralDistance), \
      (tU8) sizeof(vese_tRecord__LaneDetection_DetectedLineList_Probability),   \
      (tU8) sizeof(vese_tRecord__LaneDetection_DetectedLineList_Linecolor),     \
      (tU8) sizeof(vese_tRecord__LaneDetection_DetectedLineList_AngleToBegin),  \
      (tU8) sizeof(vese_tRecord__LaneDetection_DetectedLineList_HorCurvatureChange), \
      (tU8) sizeof(vese_tRecord__LaneDetection_DetectedLineList_HorCurvature),  \
      (tU8) sizeof(vese_tRecord__DetectedObjects_DetectedObjectList_ExistProbability), \
      (tU8) sizeof(vese_tRecord__DetectedObjects_DetectedObjectList_ObjectID),  \
      (tU8) sizeof(vese_tRecord__DetectedObjects_DetectedObjectList_ObjectMeasured), \
      (tU8) sizeof(vese_tRecord__DetectedObjects_DetectedObjectList_LongitudinalDistance), \
      (tU8) sizeof(vese_tRecord__DetectedObjects_DetectedObjectList_ObjectType), \
      (tU8) sizeof(vese_tRecord__DetectedObjects_DetectedObjectList_DeviationWidth), \
      (tU8) sizeof(vese_tRecord__DetectedObjects_DetectedObjectList_ObjectWidth), \
      (tU8) sizeof(vese_tRecord__DetectedObjects_DetectedObjectList_LateralOffset), \
      (tU8) sizeof(vese_tRecord__DetectedObjects_DetectedObjectList_DeviationLateralOffset), \
      (tU8) sizeof(vese_tRecord__DetectedObjects_DetectedObjectList_DeviationLongitudinalDistance) \
   };



/*****************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------*/

typedef enum
{
   /* 00 */ VESE_EN_RECORD_INVALID,
   /* 01 */ VESE_EN_RECORD_TIMESTAMP,
   /* 02 */ VESE_EN_RECORD_TERMINATION,
   /* 03 */ VESE_EN_RECORD_OVERFLOW_NOTE,
      
   /* 04 */ VESE_EN_RECORD__Brake_BrakePedalPressed,
   /* 05 */ VESE_EN_RECORD__Brake_BrakePressureList_Axle,
   /* 06 */ VESE_EN_RECORD__Brake_BrakePressureList_PosOnAxle,
   /* 07 */ VESE_EN_RECORD__Brake_BrakePressureList_BrakePressure,
   /* 08 */ VESE_EN_RECORD__Brake_CloseLoopControlStatus,
   /* 09 */ VESE_EN_RECORD__Brake_HandBrakeStatus,
   /* 10 */ VESE_EN_RECORD__Brake_EMFBrake,
      
   /* 11 */ VESE_EN_RECORD__CruiseControl_Type,
   /* 12 */ VESE_EN_RECORD__CruiseControl_State,
   /* 13 */ VESE_EN_RECORD__CruiseControl_SetSpeed,
   /* 14 */ VESE_EN_RECORD__CruiseControl_CoastingActive,
   /* 15 */ VESE_EN_RECORD__CruiseControl_CoastingSetSpeed,
   /* 16 */ VESE_EN_RECORD__CruiseControl_LockedLeadCar,
   /* 17 */ VESE_EN_RECORD__CruiseControl_DistanceToLockedLeadCarSufficient,
   /* 18 */ VESE_EN_RECORD__CruiseControl_LockedLeadCarSpeed,
      
   /* 19 */ VESE_EN_RECORD__EngineParameter_TemperatureEngine,
   /* 20 */ VESE_EN_RECORD__EngineParameter_TemperatureEngineOil,
   /* 21 */ VESE_EN_RECORD__EngineParameter_StatusEngineRunning,
   /* 22 */ VESE_EN_RECORD__EngineParameter_InjectionVolumeFuel,
   /* 23 */ VESE_EN_RECORD__EngineParameter_ReductionDownControlRPM,
   /* 24 */ VESE_EN_RECORD__EngineParameter_StatusRBMZyklus,
   /* 25 */ VESE_EN_RECORD__EngineParameter_RPMIdlingTarget,
      
   /* 26 */ VESE_EN_RECORD__EnginePerformance_EngineSpeed,
   /* 27 */ VESE_EN_RECORD__EnginePerformance_AccPedal,
   /* 28 */ VESE_EN_RECORD__EnginePerformance_WheelMoment,
   /* 29 */ VESE_EN_RECORD__EnginePerformance_EngineTorque,
   /* 30 */ VESE_EN_RECORD__EnginePerformance_RotationIrregularity,
   /* 31 */ VESE_EN_RECORD__EnginePerformance_OverRunFuelShutoff,
   /* 32 */ VESE_EN_RECORD__EnginePerformance_TorqueMinimum,
   /* 33 */ VESE_EN_RECORD__EnginePerformance_TorqueDriversChoice,
      
   /* 34 */ VESE_EN_RECORD__GearBox_GearPosition,
   /* 35 */ VESE_EN_RECORD__GearBox_GearLeverPosition,
   /* 36 */ VESE_EN_RECORD__GearBox_GearBoxState,
   /* 37 */ VESE_EN_RECORD__GearBox_TorqueConverterLockupClutch,
   /* 38 */ VESE_EN_RECORD__GearBox_GearboxSportSwitch,
   /* 39 */ VESE_EN_RECORD__GearBox_SwitchClutch,
      
   /* 40 */ VESE_EN_RECORD__Ignition_Ignition,

   /* 41 */ VESE_EN_RECORD__Speed_VehicleSpeed,
   /* 42 */ VESE_EN_RECORD__Speed_VehicleDrivingCondition,

   /* 43 */ VESE_EN_RECORD__SteeringWheelAngle_WheelAngle,
   /* 44 */ VESE_EN_RECORD__SteeringWheelAngle_WheelRate,
   /* 45 */ VESE_EN_RECORD__SteeringWheelAngle_WheelAngleSensorOk,
   /* 46 */ VESE_EN_RECORD__SteeringWheelAngle_WheelRateSensorOk,

   /* 47 */ VESE_EN_RECORD__VehicleDynamic_OldestTimestamp, // FIXME: we do not need this record
   /* 48 */ VESE_EN_RECORD__VehicleDynamic_Yawrate,
   /* 49 */ VESE_EN_RECORD__VehicleDynamic_LongitudinalAcceleration,
   /* 50 */ VESE_EN_RECORD__VehicleDynamic_LateralAcceleration,
      
   /* 51 */ VESE_EN_RECORD__Seats_SeatList_Row,
   /* 52 */ VESE_EN_RECORD__Seats_SeatList_PlaceInRow,
   /* 53 */ VESE_EN_RECORD__Seats_SeatList_Occupation,
   /* 54 */ VESE_EN_RECORD__Seats_SeatList_SeatBeltLock,
   /* 55 */ VESE_EN_RECORD__Seats_SeatList_SeatClimate,
   /* 56 */ VESE_EN_RECORD__Seats_SeatList_RealTemperature,
   /* 57 */ VESE_EN_RECORD__Seats_SeatList_SeatHeater,
   /* 58 */ VESE_EN_RECORD__Seats_SeatList_NeckHeater,
   /* 59 */ VESE_EN_RECORD__Seats_SeatList_StratSeatHeater,
      
   /*3c*/ VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_NumberOfSigns,
   /*3d*/ VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_ClearList,
   /*3e*/ VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_EndOfList,
   /*3f*/ VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_ListIndex,
   /*40*/ VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSignID,
   /*41*/ VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_IDOfTrafficSignAbove,
   /*42*/ VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_DynamicTrafficSign,
   /*43*/ VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_VirtualTrafficSign,
   /*44*/ VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_BaseSignUnion,
   /*45*/ VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_QuantifierOfBaseSign,
   /*46*/ VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_AdditionalSignList_AdditionalSign,
   /*47*/ VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_AdditionalSignList_QuantifierOfAddSign,
   /*48*/ VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TSLongitudinalDistance,
   /*49*/ VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TSLateralOffset,
   /*4A*/ VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TSHeight,
   /*4B*/ VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TSQuality_TSQuality_TSQuality,
   /*4C*/ VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TSQuality_TSQuality_TSQuantifierQuality,
   /*4D*/ VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TSQuality_AdditionalTSQualityList_TSQuality,
   /*4E*/ VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TSQuality_AdditionalTSQualityList_TSQuantifierQuality,
      
      
   // Prio B & C
   /*4F*/ VESE_EN_RECORD__Doors_CentralLockingState,
   /*50*/ VESE_EN_RECORD__Doors_DoorStatusList_XPosition,
   /*51*/ VESE_EN_RECORD__Doors_DoorStatusList_YPosition,
   /*52*/ VESE_EN_RECORD__Doors_DoorStatusList_Closed,
   /*53*/ VESE_EN_RECORD__Doors_DoorStatusList_DoorType,
   /*54*/ VESE_EN_RECORD__HybridOperation_SOCStatus,
   /*55*/ VESE_EN_RECORD__HybridOperation_SOCSet,
   /*56*/ VESE_EN_RECORD__HybridOperation_FuelConsumptionHybrid,
   /*57*/ VESE_EN_RECORD__HybridOperation_FuelSaving,
   /*58*/ VESE_EN_RECORD__Lights_HeadLights,
   /*59*/ VESE_EN_RECORD__Lights_DaytimeRunningLight,
   /*5A*/ VESE_EN_RECORD__Lights_FrontFogLight,
   /*5B*/ VESE_EN_RECORD__Lights_RearFogLight,
   /*5C*/ VESE_EN_RECORD__Lights_DirectionIndication,
   /*5D*/ VESE_EN_RECORD__Rain_IntensityRain,
   /*5E*/ VESE_EN_RECORD__Rain_WiperSpeed,
   /*5F*/ VESE_EN_RECORD__Rain_RainSensorInNormalMode,
   /*60*/ VESE_EN_RECORD__Defroster_RearDefroster,
   /*61*/ VESE_EN_RECORD__Defroster_RearViewDefroster,
   /*62*/ VESE_EN_RECORD__Defroster_FrontDefroster,
   /*63*/ VESE_EN_RECORD__StaticVehicleParameters_ChassisNumber,
   /*64*/ VESE_EN_RECORD__StaticVehicleParameters_LowerCriticalVelocity,
   /*65*/ VESE_EN_RECORD__StaticVehicleParameters_Drive,
   /*66*/ VESE_EN_RECORD__StaticVehicleParameters_NumberOfSeats,
   /*67*/ VESE_EN_RECORD__StaticVehicleParameters_NumberOfDoors,
   /*68*/ VESE_EN_RECORD__KeyStatus_KeyValid,
   /*69*/ VESE_EN_RECORD__KeyStatus_KeyNumber,
   /*6A*/ VESE_EN_RECORD__KeyStatus_KeyTyp,
   /*6B*/ VESE_EN_RECORD__KeyStatus_KeyLocation,
   /*6C*/ VESE_EN_RECORD__ClimateControl_ACCompressorStatus,
   /*6D*/ VESE_EN_RECORD__ClimateControl_ACStatus,
   /*6E*/ VESE_EN_RECORD__ClimateControl_DefrosterStatus,
   /*6F*/ VESE_EN_RECORD__Windows_WindowPositionList_XPosition,
   /*70*/ VESE_EN_RECORD__Windows_WindowPositionList_YPosition,
   /*71*/ VESE_EN_RECORD__Windows_WindowPositionList_OpeningLevel,
   /*72*/ VESE_EN_RECORD__Windows_WindowPositionList_WindowType,
   /*73*/ VESE_EN_RECORD__Environment_OutsideTemperature,
   /*74*/ VESE_EN_RECORD__Environment_AmbienceBrightness,
   /*75*/ VESE_EN_RECORD__Environment_AirPressure,
   /*76*/ VESE_EN_RECORD__Wheels_TirePressureList_AirPressure,
   /*77*/ VESE_EN_RECORD__Wheels_TirePressureList_Axle,
   /*78*/ VESE_EN_RECORD__Wheels_TirePressureList_PosOnAxle,
   /*79*/ VESE_EN_RECORD__VehicleLoad_VehicleTilt,
   /*7A*/ VESE_EN_RECORD__VehicleLoad_TrailerAttached,
   /*7B*/ VESE_EN_RECORD__LDW_LDWSideIndicator,
   /*7C*/ VESE_EN_RECORD__LDW_DistanceToLine,
   /*7D*/ VESE_EN_RECORD__LDW_TimeToLine,
   /*7E*/ VESE_EN_RECORD__LaneDetection_DetectedLineList_LineID,
   /*7F*/ VESE_EN_RECORD__LaneDetection_DetectedLineList_LateralDistance,
   /*80*/ VESE_EN_RECORD__LaneDetection_DetectedLineList_Probability,
   /*81*/ VESE_EN_RECORD__LaneDetection_DetectedLineList_Linecolor,
   /*82*/ VESE_EN_RECORD__LaneDetection_DetectedLineList_AngleToBegin,
   /*83*/ VESE_EN_RECORD__LaneDetection_DetectedLineList_HorCurvatureChange,
   /*84*/ VESE_EN_RECORD__LaneDetection_DetectedLineList_HorCurvature,
   /*85*/ VESE_EN_RECORD__DetectedObjects_DetectedObjectList_ExistProbability,
   /*86*/ VESE_EN_RECORD__DetectedObjects_DetectedObjectList_ObjectID,
   /*87*/ VESE_EN_RECORD__DetectedObjects_DetectedObjectList_ObjectMeasured,
   /*88*/ VESE_EN_RECORD__DetectedObjects_DetectedObjectList_LongitudinalDistance,
   /*89*/ VESE_EN_RECORD__DetectedObjects_DetectedObjectList_ObjectType,
   /*8A*/ VESE_EN_RECORD__DetectedObjects_DetectedObjectList_DeviationWidth,
   /*8B*/ VESE_EN_RECORD__DetectedObjects_DetectedObjectList_ObjectWidth,
   /*8C*/ VESE_EN_RECORD__DetectedObjects_DetectedObjectList_LateralOffset,
   /*8D*/ VESE_EN_RECORD__DetectedObjects_DetectedObjectList_DeviationLateralOffset,
   /*8E*/ VESE_EN_RECORD__DetectedObjects_DetectedObjectList_DeviationLongitudinalDistance,

   VESE_EN_RECORD_ENUM_LAST
} vese_tenRecordType;


typedef enum
{
   VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_BaseTrafficSignCategory__T_Reserved = 0,
   VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_BaseTrafficSignCategory__T_e8_SpeedSign = 1,
   VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_BaseTrafficSignCategory__T_e16_WarningSign = 2,
   VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_BaseTrafficSignCategory__T_e16_RegulatorySign = 3
} vese_tenRecord__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_BaseTrafficSignCategory__EnumerationUnionType;


typedef enum
{
   VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_TrafficSignQuantifier__T_Reserved = 0,
   VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_TrafficSignQuantifier__T_s16_KmPerHour = 1,
   VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_TrafficSignQuantifier__T_s16_MilesPerHour = 2,
   VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_TrafficSignQuantifier__T_String = 3,
   VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_TrafficSignQuantifier__T_u8_Percent = 4,
   VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_TrafficSignQuantifier__T_b8_LaneDependentValidity = 5,
   VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_TrafficSignQuantifier__T_TimeDependentString = 6,
   VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_TrafficSignQuantifier__T_s32_Meter = 7,
   VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_TrafficSignQuantifier__T_s32_Yards = 8,
   VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_TrafficSignQuantifier__T_MultiLanguageString = 9,
   VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_TrafficSignQuantifier__T_s32_Centimeter = 10,
   VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_TrafficSignQuantifier__T_s32_Inch = 11,
   VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_TrafficSignQuantifier__T_s32_Kilogram = 12,
   VESE_EN_RECORD__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_TrafficSignQuantifier__T_s32_Pound = 13
} vese_tenRecord__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_TrafficSignQuantifier__EnumerationUnionType;


/* Metadata, Timestamp */
typedef struct
{
   vese_tenRecordType enType;
} vese_tRecord_Invalid;
typedef struct
{
   vese_tenRecordType enType;
   tU32 value;
} vese_tRecord_Timestamp;
typedef struct
{
   vese_tenRecordType enType;
} vese_tRecord_Termination;
typedef struct
{
   vese_tenRecordType enType;
   tU32 value;
} vese_tRecord_OverflowNote;

/* Brake */
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Brake_BrakePedalPressed;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Brake_BrakePressureList_Axle;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Brake_BrakePressureList_PosOnAxle;
typedef struct
{
   vese_tenRecordType enType;
   tS32 value;
} vese_tRecord__Brake_BrakePressureList_BrakePressure;
typedef struct
{
   vese_tenRecordType enType;
   tU32 value;
} vese_tRecord__Brake_CloseLoopControlStatus;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Brake_HandBrakeStatus;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Brake_EMFBrake;

/* CruiseControl */
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__CruiseControl_Type;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__CruiseControl_State;
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__CruiseControl_SetSpeed;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__CruiseControl_CoastingActive;
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__CruiseControl_CoastingSetSpeed;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__CruiseControl_LockedLeadCar;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__CruiseControl_DistanceToLockedLeadCarSufficient;
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__CruiseControl_LockedLeadCarSpeed;

/* EngineParameter */
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__EngineParameter_TemperatureEngine;
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__EngineParameter_TemperatureEngineOil;
typedef struct
{
   vese_tenRecordType enType;
   tU16 value;
} vese_tRecord__EngineParameter_StatusEngineRunning;
typedef struct
{
   vese_tenRecordType enType;
   tU32 value;
} vese_tRecord__EngineParameter_InjectionVolumeFuel;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__EngineParameter_ReductionDownControlRPM;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__EngineParameter_StatusRBMZyklus;
typedef struct
{
   vese_tenRecordType enType;
   tU16 value;
} vese_tRecord__EngineParameter_RPMIdlingTarget;

/* EnginePerformance */
typedef struct
{
   vese_tenRecordType enType;
   tU16 value;
} vese_tRecord__EnginePerformance_EngineSpeed;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__EnginePerformance_AccPedal;
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__EnginePerformance_WheelMoment;
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__EnginePerformance_EngineTorque;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__EnginePerformance_RotationIrregularity;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__EnginePerformance_OverRunFuelShutoff;
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__EnginePerformance_TorqueMinimum;
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__EnginePerformance_TorqueDriversChoice;

/* GearBox */
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__GearBox_GearPosition;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__GearBox_GearLeverPosition;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__GearBox_GearBoxState;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__GearBox_TorqueConverterLockupClutch;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__GearBox_GearboxSportSwitch;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__GearBox_SwitchClutch;

/* Ignition */
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Ignition_Ignition;

/* Speed */
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__Speed_VehicleSpeed;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Speed_VehicleDrivingCondition;

/* SteeringWheelAngle */
typedef struct
{
   vese_tenRecordType enType;
   tS32 value;
} vese_tRecord__SteeringWheelAngle_WheelAngle;
typedef struct
{
   vese_tenRecordType enType;
   tS32 value;
} vese_tRecord__SteeringWheelAngle_WheelRate;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__SteeringWheelAngle_WheelAngleSensorOk;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__SteeringWheelAngle_WheelRateSensorOk;

/* VehicleDynamic */
typedef struct
{
   vese_tenRecordType enType;
   tU32 value;
} vese_tRecord__VehicleDynamic_OldestTimestamp;
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__VehicleDynamic_Yawrate;
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__VehicleDynamic_LongitudinalAcceleration;
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__VehicleDynamic_LateralAcceleration;

/* Seats */
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Seats_SeatList_Row;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Seats_SeatList_PlaceInRow;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Seats_SeatList_Occupation;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Seats_SeatList_SeatBeltLock;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Seats_SeatList_SeatClimate;
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__Seats_SeatList_RealTemperature;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Seats_SeatList_SeatHeater;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Seats_SeatList_NeckHeater;
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__Seats_SeatList_StratSeatHeater;

/* DetectedTrafficSigns */
typedef struct
{
   vese_tenRecordType enType;
   tU16 value;
} vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_NumberOfSigns;
typedef struct
{
   vese_tenRecordType enType;
} vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_ClearList;
typedef struct
{
   vese_tenRecordType enType;
} vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_EndOfList;
typedef struct
{
   vese_tenRecordType enType;
   tU16 value;
} vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_ListIndex;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSignID;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_IDOfTrafficSignAbove;
typedef struct
{
   vese_tenRecordType enType;
   tBool value;
} vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_DynamicTrafficSign;
typedef struct
{
   vese_tenRecordType enType;
   tBool value;
} vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_VirtualTrafficSign;
typedef struct
{
   vese_tenRecordType enType;
   tU8 type;
   union
   {
      tU8  u8Value;
      tU16 u16Value;
   } data;
} vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_BaseSignUnion;
typedef struct
{
   vese_tenRecordType enType;
   tU8 type;
   union
   {
      tU8  u8Value;
      tS16 s16Value;
      tS32 s32Value;
   } data;
} vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_QuantifierOfBaseSign;
typedef struct
{
   vese_tenRecordType enType;
   tU16 value;
} vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_AdditionalSignList_AdditionalSign;
typedef struct
{
   vese_tenRecordType enType;
   tU8 type;
   union
   {
      tU8  u8Value;
      tS16 s16Value;
      tS32 s32Value;
   } data;
} vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TrafficSign_AdditionalSignList_QuantifierOfAddSign;
typedef struct
{
   vese_tenRecordType enType;
   tS32 value;
} vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TSLongitudinalDistance;
typedef struct
{
   vese_tenRecordType enType;
   tS32 value;
} vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TSLateralOffset;
typedef struct
{
   vese_tenRecordType enType;
   tS32 value;
} vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TSHeight;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TSQuality_TSQuality_TSQuality;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TSQuality_TSQuality_TSQuantifierQuality;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TSQuality_AdditionalTSQualityList_TSQuality;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__DetectedTrafficSigns_DetectedTrafficSignList_TSQuality_AdditionalTSQualityList_TSQuantifierQuality;


// Prio B & C
 
typedef struct
{
   vese_tenRecordType enType;
   tU16 value;
} vese_tRecord__Doors_CentralLockingState;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Doors_DoorStatusList_XPosition;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Doors_DoorStatusList_YPosition;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Doors_DoorStatusList_Closed;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Doors_DoorStatusList_DoorType;
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__HybridOperation_SOCStatus;
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__HybridOperation_SOCSet;
typedef struct
{
   vese_tenRecordType enType;
   tU32 value;
} vese_tRecord__HybridOperation_FuelConsumptionHybrid;
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__HybridOperation_FuelSaving;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Lights_HeadLights;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Lights_DaytimeRunningLight;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Lights_FrontFogLight;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Lights_RearFogLight;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Lights_DirectionIndication;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Rain_IntensityRain;
typedef struct
{
   vese_tenRecordType enType;
   tU16 value;
} vese_tRecord__Rain_WiperSpeed;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Rain_RainSensorInNormalMode;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Defroster_RearDefroster;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Defroster_RearViewDefroster;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Defroster_FrontDefroster;
typedef struct
{
   vese_tenRecordType enType;
   tChar value[8] /* FIXME */;
} vese_tRecord__StaticVehicleParameters_ChassisNumber;
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__StaticVehicleParameters_LowerCriticalVelocity;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__StaticVehicleParameters_Drive;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__StaticVehicleParameters_NumberOfSeats;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__StaticVehicleParameters_NumberOfDoors;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__KeyStatus_KeyValid;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__KeyStatus_KeyNumber;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__KeyStatus_KeyTyp;
typedef struct
{
   vese_tenRecordType enType;
   tU16 value;
} vese_tRecord__KeyStatus_KeyLocation;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__ClimateControl_ACCompressorStatus;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__ClimateControl_ACStatus;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__ClimateControl_DefrosterStatus;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Windows_WindowPositionList_XPosition;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Windows_WindowPositionList_YPosition;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Windows_WindowPositionList_OpeningLevel;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Windows_WindowPositionList_WindowType;
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__Environment_OutsideTemperature;
typedef struct
{
   vese_tenRecordType enType;
   tU32 value;
} vese_tRecord__Environment_AmbienceBrightness;
typedef struct
{
   vese_tenRecordType enType;
   tS32 value;
} vese_tRecord__Environment_AirPressure;
typedef struct
{
   vese_tenRecordType enType;
   tS32 value;
} vese_tRecord__Wheels_TirePressureList_AirPressure;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Wheels_TirePressureList_Axle;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__Wheels_TirePressureList_PosOnAxle;
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__VehicleLoad_VehicleTilt;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__VehicleLoad_TrailerAttached;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__LDW_LDWSideIndicator;
typedef struct
{
   vese_tenRecordType enType;
   tS32 value;
} vese_tRecord__LDW_DistanceToLine;
typedef struct
{
   vese_tenRecordType enType;
   tU16 value;
} vese_tRecord__LDW_TimeToLine;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__LaneDetection_DetectedLineList_LineID;
typedef struct
{
   vese_tenRecordType enType;
   tS32 value;
} vese_tRecord__LaneDetection_DetectedLineList_LateralDistance;
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__LaneDetection_DetectedLineList_Probability;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__LaneDetection_DetectedLineList_Linecolor;
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__LaneDetection_DetectedLineList_AngleToBegin;
typedef struct
{
   vese_tenRecordType enType;
   tS32 value;
} vese_tRecord__LaneDetection_DetectedLineList_HorCurvatureChange;
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__LaneDetection_DetectedLineList_HorCurvature;
typedef struct
{
   vese_tenRecordType enType;
   tS16 value;
} vese_tRecord__DetectedObjects_DetectedObjectList_ExistProbability;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__DetectedObjects_DetectedObjectList_ObjectID;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__DetectedObjects_DetectedObjectList_ObjectMeasured;
typedef struct
{
   vese_tenRecordType enType;
   tS32 value;
} vese_tRecord__DetectedObjects_DetectedObjectList_LongitudinalDistance;
typedef struct
{
   vese_tenRecordType enType;
   tU8 value;
} vese_tRecord__DetectedObjects_DetectedObjectList_ObjectType;
typedef struct
{
   vese_tenRecordType enType;
   tS32 value;
} vese_tRecord__DetectedObjects_DetectedObjectList_DeviationWidth;
typedef struct
{
   vese_tenRecordType enType;
   tS32 value;
} vese_tRecord__DetectedObjects_DetectedObjectList_ObjectWidth;
typedef struct
{
   vese_tenRecordType enType;
   tS32 value;
} vese_tRecord__DetectedObjects_DetectedObjectList_LateralOffset;
typedef struct
{
   vese_tenRecordType enType;
   tS32 value;
} vese_tRecord__DetectedObjects_DetectedObjectList_DeviationLateralOffset;
typedef struct
{
   vese_tenRecordType enType;
   tS32 value;
} vese_tRecord__DetectedObjects_DetectedObjectList_DeviationLongitudinalDistance;


#else /* OSIOCTRL_VESE_HEADER */
#error osioctrl_vese.h included several times
#endif /* OSIOCTRL_VESE_HEADER */
