/***********************************************************************
 *                                                                     *
 *                 SiRF Technology, Inc. GPS Software                  *
 *                                                                     *
 *  SiRF Technology, Inc. CONFIDENTIAL AND PROPRIETARY.  This source   *
 *  is the sole property of SiRF Technology, Inc.  Reproduction or     *
 *  utilization of this source in whole or in part is forbidden        *
 *  without the written consent of SiRF Technology, Inc.               *
 *                                                                     *
 ***********************************************************************
 *                                                                     *
 *        (c) SiRF Technology, Inc. 2002 -- All Rights Reserved        *
 *                                                                     *
 *---------------------------------------------------------------------*
 *                                                                     *
 * File: osal_gps.h                                                    *
 *                                                                     *
 ***********************************************************************/

/* \date oej2hi 2005-05-10 Adaptations to Paramount platform */

#ifndef __OSAL_GPS_H__
#define __OSAL_GPS_H__

// This is highly system specific, adapt this according to the maximum
// element width used in the GPS data structures.
// Choosing this too high will not be harmful (apart from wasting some RAM),
// however, when choosing it too low, alignment errors will happen.
#define OSAL_C_U32_GPS_MAX_ELEMSIZE    ((tU32)8)

// (1) Macros defining IOControl functions supported:

#define OSAL_C_S32_IOCTL_GPS_START_DEVICE             ((tS32)1)
#define OSAL_C_S32_IOCTL_GPS_STOP_DEVICE              ((tS32)2)
#define OSAL_C_S32_IOCTL_GPS_SET_RECORD_FIELDS			((tS32)3)
#define OSAL_C_S32_IOCTL_GPS_GET_RECORD_FIELDS			((tS32)4)
#define OSAL_C_S32_IOCTL_GPS_GET_NO_RECORDS_AVAILABLE ((tS32)5)
#define OSAL_C_S32_IOCTL_GPS_REMOVE_RECORDS           ((tS32)6)
#define OSAL_C_S32_IOCTL_GPS_READ_RECORD              ((tS32)7)
#define OSAL_C_S32_IOCTL_GPS_GET_INTERNAL_DATA			((tS32)8)
#define OSAL_C_S32_IOCTL_GPS_SET_INTERNAL_DATA			((tS32)9)
#define OSAL_C_S32_IOCTL_GPS_GET_CLOCK_BIAS           ((tS32)10)
#define OSAL_C_S32_IOCTL_GPS_GET_CLOCK_DRIFT          ((tS32)11)
#define OSAL_C_S32_IOCTL_GPS_SET_DEFAULT_CLOCK_DRIFT  ((tS32)12)
#define OSAL_C_S32_IOCTL_GPS_GET_POWER_MASK           ((tS32)13)
#define OSAL_C_S32_IOCTL_GPS_SET_POWER_MASK           ((tS32)14)
#define OSAL_C_S32_IOCTL_GPS_GET_DATUM                ((tS32)15)
#define OSAL_C_S32_IOCTL_GPS_SET_DATUM                ((tS32)16)
#define OSAL_C_S32_IOCTL_GPS_GET_DOP_MASK             ((tS32)17)
#define OSAL_C_S32_IOCTL_GPS_SET_DOP_MASK             ((tS32)18)
#define OSAL_C_S32_IOCTL_GPS_GET_ELEVATION_MASK			((tS32)19)
#define OSAL_C_S32_IOCTL_GPS_SET_ELEVATION_MASK			((tS32)20)
#define OSAL_C_S32_IOCTL_GPS_GET_ALMANAC              ((tS32)21)
#define OSAL_C_S32_IOCTL_GPS_SET_ALMANAC              ((tS32)22)
#define OSAL_C_S32_IOCTL_GPS_GET_EPHEMERIS            ((tS32)23)
#define OSAL_C_S32_IOCTL_GPS_SET_EPHEMERIS            ((tS32)24)
#define OSAL_C_S32_IOCTL_GPS_SET_STARTUP_POSITION		((tS32)25)
#define OSAL_C_S32_IOCTL_GPS_SET_STARTUP_TIME			((tS32)26)
#define OSAL_C_S32_IOCTL_GPS_SET_STARTUP_MODE			((tS32)27)
#define OSAL_C_S32_IOCTL_GPS_SET_POSITIONING_MODE		((tS32)28)
#define OSAL_C_S32_IOCTL_GPS_GET_POSITIONING_MODE		((tS32)29)
#define OSAL_C_S32_IOCTL_GPS_GET_WAIT_TIMEOUT			((tS32)30)
#define OSAL_C_S32_IOCTL_GPS_SET_WAIT_TIMEOUT			((tS32)31)
#define OSAL_C_S32_IOCTL_GPS_GET_DEBUG_OUTPUT_STATUS  ((tS32)32)
#define OSAL_C_S32_IOCTL_GPS_SET_DEBUG_OUTPUT_STATUS  ((tS32)33)
#define OSAL_C_S32_IOCTL_GPS_GET_DGPS_SOURCE          ((tS32)34)
#define OSAL_C_S32_IOCTL_GPS_SET_DGPS_SOURCE          ((tS32)35)
#define OSAL_C_S32_IOCTL_GPS_GET_DGPS_MODE            ((tS32)36)
#define OSAL_C_S32_IOCTL_GPS_SET_DGPS_MODE            ((tS32)37)
#define OSAL_C_S32_IOCTL_GPS_SET_RTCM_DATA            ((tS32)38)
#define OSAL_C_S32_IOCTL_GPS_SET_CURRENT_CLOCK_DRIFT  ((tS32)39)

/* oej2hi: added for Paramount */
#define OSAL_C_S32_IOCTL_GPS_SET_DATA_SOURCE        ((tS32)40)
#define OSAL_C_S32_IOCTL_GPS_FORCE_DATA             ((tS32)41)
#define OSAL_C_S32_IOCTL_GPS_SET_ANTENNA            ((tS32)42)
#define OSAL_C_S32_IOCTL_GPS_GET_ANTENNA            ((tS32)43)
#define OSAL_C_S32_IOCTL_GPS_GET_INTERNAL_DATA_SIZE ((tS32)44)
#define OSAL_C_S32_IOCTL_GPS_SET_TEMPERATURE        ((tS32)45)
#define OSAL_C_S32_IOCTL_GPS_SET_HINTS              ((tS32)46)
#define OSAL_C_S32_IOCTL_GPS_SET_CONF               ((tS32)47)

/* KOP2HI: To adjust the time with the content os external clock */
#define OSAL_C_S32_IOCTL_GPS_SET_CURRENT_TIME        ((tS32)48)
#define OSAL_C_S32_IOCTL_GPS_FRONT_END_TEST          ((tS32)49)

#define OSAL_C_S32_IOCTL_GPS_SET_CLOCK_ESTIMATION_PRECISION ((tS32)50)

#define OSAL_C_S32_IOCTL_GPS_SET_CVM_STATE           ((tS32)51)
#define OSAL_C_S32_IOCTL_GPS_GET_CVM_STATE           ((tS32)52)

#define OSAL_C_S32_IOCTL_GPS_SET_KDS_XO_COEFF	     ((tS32)53)
#define OSAL_C_S32_IOCTL_GPS_SET_XO_COEFF            ((tS32)54)
#define OSAL_C_S32_IOCTL_GPS_GET_XO_COEFF            ((tS32)55)
#define OSAL_C_S32_IOCTL_GPS_SET_SETUP_EXTTESTMODE   ((tS32)56)
#define OSAL_C_S32_IOCTL_GPS_GET_EXTTESTMODE_RESULTS ((tS32)57)
#define OSAL_C_S32_IOCTL_GPS_SET_TRACE_COMMAND       ((tS32)58)
/* added for trition GNSS HW and switching to GLONASS/GPS */
#define OSAL_C_S32_IOCTL_GET_SAT_SYS                 ((tS32)59)
#define OSAL_C_S32_IOCTL_SET_SAT_SYS                 ((tS32)60)

#define OSAL_C_S32_IOCTL_GPS_SET_WN_EPOCH_START      ((tS32)61)

/*To get the Antenna Status, Temperature, Voltage */
#define OSAL_C_S32_IOCTL_GPS_GET_ANTENNA_STATUS      ((tS32)62)
#define OSAL_C_S32_IOCTL_GPS_GET_GPS_TEMPERATURE     ((tS32)63)
#define OSAL_C_S32_IOCTL_GPS_GET_CURRENT_TIME        ((tS32)64)

/*To Disable And Enable External Power To GPS Antenna */
#define OSAL_C_S32_IOCTL_GPS_ANT_DISABLE_EXT_PWR_SUPPLY  ((tS32)65)
#define OSAL_C_S32_IOCTL_GPS_ANT_ENABLE_EXT_PWR_SUPPLY   ((tS32)66)

// (2) Macros defining types of record fields available through OSAL_IORead service and field specifiers:

#define OSAL_C_S32_GPS_FIELD_TYPE_TRACKING_DATA	     ((tS32)0x1)
#define OSAL_C_S32_GPS_FIELD_TYPE_50BPS_DATA         ((tS32)0x2)
#define OSAL_C_S32_GPS_FIELD_TYPE_VISIBLE_LIST	     ((tS32)0x4)
#define OSAL_C_S32_GPS_FIELD_TYPE_MEASURED_POSITION  ((tS32)0x8)
#define OSAL_C_S32_GPS_FIELD_TYPE_SATELLITE_HEALTH   ((tS32)0x10)
#define OSAL_C_S32_GPS_FIELD_TYPE_MEASUREMENT_DATA   ((tS32)0x20)
#define OSAL_C_S32_GPS_FIELD_TYPE_SV_STATE_DATA	     ((tS32)0x40)
#define OSAL_C_S32_GPS_FIELD_TYPE_TEST_MODE_DATA     ((tS32)0x80)
#define OSAL_C_S32_GPS_FIELD_TYPE_EXT_DATA           ((tS32)0x100)
#define OSAL_C_S32_GPS_FIELD_TYPE_NORMAL_TEST_DATA   ((tS32)0x200)
#define OSAL_C_S32_GPS_FIELD_TYPE_TC_DATA            ((tS32)0x400)

#define OSAL_C_S32_GPS_FIELD_SPEC_TIME_GPS            ((tS32)0)
#define OSAL_C_S32_GPS_FIELD_SPEC_TIME_UTC            ((tS32)1)
#define OSAL_C_S32_GPS_FIELD_SPEC_POS_ECEF            ((tS32)0)
#define OSAL_C_S32_GPS_FIELD_SPEC_POS_LLA             ((tS32)2)
#define OSAL_C_S32_GPS_FIELD_SPEC_VEL_ECEF            ((tS32)0)
#define OSAL_C_S32_GPS_FIELD_SPEC_VEL_NED             ((tS32)4)

#define OSAL_C_S32_GPS_MAX_NO_FIELDS         ((tS32)8)

// (3) Macro defining the capacity of  /dev/gps record pipe:

#define OSAL_C_S32_GPS_MAX_NO_PIPE_RECORDS   ((tS32)10)

// (4) Macro defining the size of /dev/gps internal data:

#define OSAL_C_S32_GPS_INTERNAL_DATA_SIZE    ((tS32)2048)

// (5) Basic types for describing time:

typedef enum {
	GPS_TIME_GPS = 0,
	GPS_TIME_UTC = 1
} OSAL_tenGPSTimeFormat;

typedef enum {
   GPS_TIME_VALID_NOT = 0,
   GPS_TIME_VALID     = 1     // Time becomes a valid when there is at least 5 SVs in the solution
 } OSAL_tenGPSTimeValidity;

typedef struct {
	tU16	u16WeekNo;
	tU32	u32TimeOfWeek;
} OSAL_trGPSTimeGPS;

typedef struct {
	tU16	u16Year;
	tU16	u16Month;
	tU16	u16Day;
	tU16	u16Hour;
	tU16	u16Minute;
	tU16	u16Second;
	tU16	u16Millisecond;
} OSAL_trGPSTimeUTC;

typedef struct {
	OSAL_tenGPSTimeFormat	enTimeFormat;
   OSAL_tenGPSTimeValidity enTimeValidity;
	union {
		OSAL_trGPSTimeGPS	trGPSTime;
		OSAL_trGPSTimeUTC	trUTCTime;
	} uTime;
} OSAL_trGPSTime;

// (6) Types defining the structure of a record header:

typedef struct {
	tS32				s32Type;
	tS32				s32Offset;
	tS32				s32Size;
} OSAL_trGPSFieldInfo;

typedef struct {
	tU32			u32TimeStamp;
	tU32			u32RecordId;
	tS32			s32Size;
	tS32			s32NoFields;
	OSAL_trGPSFieldInfo	trFieldInfo[OSAL_C_S32_GPS_MAX_NO_FIELDS];
} OSAL_trGPSRecordHeader;

// (7) Type defining which fields (with specifiers) should be output by the device:

typedef struct {
	tU32		u32FieldTypes;
	tU32		u32FieldSpecifiers;
} OSAL_trGPSRecordFields;

// (8) Basic types for describing position:

typedef enum {
	GPS_POS_ECEF = 0,
	GPS_POS_LLA = 1
} OSAL_tenGPSPositionFormat;

typedef struct {
	tDouble		dX;
	tDouble		dY;
	tDouble		dZ;
} OSAL_trGPSPositionECEF;

typedef enum {
GPS_DATUM_WGS84 =   0,

	/* AFRICA */

GPS_DATUM_ADI_M =   1, GPS_DATUM_ADI_E =   2, GPS_DATUM_ADI_F =   3,
GPS_DATUM_ADI_A =   4, GPS_DATUM_ADI_C =   5, GPS_DATUM_ADI_D =   6,
GPS_DATUM_ADI_B =   7, GPS_DATUM_AFG   =   8, GPS_DATUM_ARF_M =   9,
GPS_DATUM_ARF_A =  10, GPS_DATUM_ARF_H =  11, GPS_DATUM_ARF_B =  12,
GPS_DATUM_ARD_C =  13, GPS_DATUM_ARF_D =  14, GPS_DATUM_ARF_E =  15,
GPS_DATUM_ARF_F =  16, GPS_DATUM_ARF_G =  17, GPS_DATUM_ARS_M =  18,
GPS_DATUM_ARS_A =  19, GPS_DATUM_ARS_B =  20, GPS_DATUM_PHA   =  21,
GPS_DATUM_BID   =  22, GPS_DATUM_CAP   =  23, GPS_DATUM_CGE   =  24,
GPS_DATUM_DAL   =  25, GPS_DATUM_EUR_F =  26, GPS_DATUM_EUR_T =  27,
GPS_DATUM_LEH   =  28, GPS_DATUM_LIB   =  29, GPS_DATUM_MAS   =  30,
GPS_DATUM_MER   =  31, GPS_DATUM_MIN_A =  32, GPS_DATUM_MIN_B =  33,
GPS_DATUM_MPO   =  34, GPS_DATUM_NSD   =  35, GPS_DATUM_OEG   =  36,
GPS_DATUM_PTB   =  37, GPS_DATUM_PTN   =  38, GPS_DATUM_SCK   =  39,
GPS_DATUM_SRL   =  40, GPS_DATUM_VOR   =  41,

	/* ASIA */

GPS_DATUM_AIN_A =  42, GPS_DATUM_AIN_B =  43, GPS_DATUM_BAT   =  44,
GPS_DATUM_EUR_H =  45, GPS_DATUM_HKD   =  46, GPS_DATUM_HTN   =  47,
GPS_DATUM_IND_B =  48, GPS_DATUM_IND_I =  49, GPS_DATUM_INF_A =  50,
GPS_DATUM_ING_A =  51, GPS_DATUM_ING_B =  52, GPS_DATUM_INH_A =  53,
GPS_DATUM_INH_A1=  54, GPS_DATUM_IDN   =  55, GPS_DATUM_KAN   =  56,
GPS_DATUM_KEA   =  57, GPS_DATUM_KGS   =  58, GPS_DATUM_NAH_A =  59,
GPS_DATUM_NAH_B =  60, GPS_DATUM_NAH_C =  61, GPS_DATUM_FAH   =  62,
GPS_DATUM_QAT   =  63, GPS_DATUM_SOA   =  64, GPS_DATUM_TIL   =  65,
GPS_DATUM_TOY_M =  66, GPS_DATUM_TOY_A =  67, GPS_DATUM_TOY_C =  68,
GPS_DATUM_TOY_B =  69, GPS_DATUM_TOY_B1=  70,

	/* AUSTRALIA */

GPS_DATUM_AUA   =  71, GPS_DATUM_AUG   =  72,

	/* EUROPE */

GPS_DATUM_EST   =  73, GPS_DATUM_EUR_M =  74, GPS_DATUM_EUR_A =  75,
GPS_DATUM_EUR_E =  76, GPS_DATUM_EUR_G =  77, GPS_DATUM_EUR_K =  78,
GPS_DATUM_EUR_B =  79, GPS_DATUM_EUR_I =  80, GPS_DATUM_EUR_J =  81,
GPS_DATUM_EUR_L =  82, GPS_DATUM_EUR_C =  83, GPS_DATUM_EUR_D =  84,
GPS_DATUM_EUS   =  85, GPS_DATUM_HJO   =  86, GPS_DATUM_IRL   =  87,
GPS_DATUM_OGB_M =  88, GPS_DATUM_OGB_A =  89, GPS_DATUM_OGB_B =  90,
GPS_DATUM_OGB_C =  91, GPS_DATUM_OGB_D =  92, GPS_DATUM_MOD   =  93,
GPS_DATUM_SPK_A =  94, GPS_DATUM_SPK_B =  95, GPS_DATUM_SPK_C =  96,
GPS_DATUM_SPK_D =  97, GPS_DATUM_SPK_E =  98, GPS_DATUM_SPK_F =  99,
GPS_DATUM_SPK_G = 100, GPS_DATUM_CCD   = 101,

/* NORTH AMERICA */

GPS_DATUM_CAC   = 102, GPS_DATUM_NAS_C = 103, GPS_DATUM_NAS_B = 104,
GPS_DATUM_NAS_A = 105, GPS_DATUM_NAS_D = 106, GPS_DATUM_NAS_V = 107,
GPS_DATUM_NAS_W = 108, GPS_DATUM_NAS_Q = 109, GPS_DATUM_NAS_R = 110,
GPS_DATUM_NAS_E = 111, GPS_DATUM_NAS_F = 112, GPS_DATUM_NAS_G = 113,
GPS_DATUM_NAS_H = 114, GPS_DATUM_NAS_I = 115, GPS_DATUM_NAS_J = 116,
GPS_DATUM_NAS_O = 117, GPS_DATUM_NAS_P = 118, GPS_DATUM_NAS_N = 119,
GPS_DATUM_NAS_T = 120, GPS_DATUM_NAS_U = 121, GPS_DATUM_NAS_L = 122,
GPS_DATUM_NAR_A = 123, GPS_DATUM_NAR_E = 124, GPS_DATUM_NAR_B = 125,
GPS_DATUM_NAR_C = 126, GPS_DATUM_NAR_H = 127, GPS_DATUM_NAR_D = 128,

/* SOUTH AMERICA */

GPS_DATUM_BOO   = 129, GPS_DATUM_CAI   = 130, GPS_DATUM_CHU   = 131,
GPS_DATUM_COA   = 132, GPS_DATUM_PRP_M = 133, GPS_DATUM_PRP_A = 134,
GPS_DATUM_PRP_B = 135, GPS_DATUM_PRP_C = 136, GPS_DATUM_PRP_D = 137,
GPS_DATUM_PRP_E = 138, GPS_DATUM_PRP_F = 139, GPS_DATUM_PRP_G = 140,
GPS_DATUM_PRP_H = 141, GPS_DATUM_HIT   = 142, GPS_DATUM_SAN_M = 143,
GPS_DATUM_SAN_A = 144, GPS_DATUM_SAN_B = 145, GPS_DATUM_SAN_C = 146,
GPS_DATUM_SAN_D = 147, GPS_DATUM_SAN_E = 148, GPS_DATUM_SAN_F = 149,
GPS_DATUM_SAN_J = 150, GPS_DATUM_SAN_G = 151, GPS_DATUM_SAN_H = 152,
GPS_DATUM_SAN_I = 153, GPS_DATUM_SAN_K = 154, GPS_DATUM_SAN_L = 155,
GPS_DATUM_SIR   = 156, GPS_DATUM_ZAN   = 157,

/* ATLANTIC OCEAN */

GPS_DATUM_AIA   = 158, GPS_DATUM_ASC   = 159, GPS_DATUM_SHB   = 160,
GPS_DATUM_BER   = 161, GPS_DATUM_DID   = 162, GPS_DATUM_FOT   = 163,
GPS_DATUM_GRA   = 164, GPS_DATUM_ISG   = 165, GPS_DATUM_LCF   = 166,
GPS_DATUM_ASM   = 167, GPS_DATUM_NAP   = 168, GPS_DATUM_FLO   = 169,
GPS_DATUM_PLN   = 170, GPS_DATUM_POS   = 171, GPS_DATUM_PUR   = 172,
GPS_DATUM_QUO   = 173, GPS_DATUM_SAO   = 174, GPS_DATUM_SAP   = 175,
GPS_DATUM_SGM   = 176, GPS_DATUM_TDC   = 177,

/* INDIAN OCEAN */

GPS_DATUM_ANO   = 178, GPS_DATUM_GAA   = 179, GPS_DATUM_IST   = 180,
GPS_DATUM_KEG   = 181, GPS_DATUM_MIK   = 182, GPS_DATUM_REU   = 183,

/* PACIFIC_OCEAN */

GPS_DATUM_AMA   = 184, GPS_DATUM_ATF   = 185, GPS_DATUM_TRN   = 186,
GPS_DATUM_ASQ   = 187, GPS_DATUM_IBE   = 188, GPS_DATUM_CAO   = 189,
GPS_DATUM_CHI   = 190, GPS_DATUM_GIZ   = 191, GPS_DATUM_EAS   = 192,
GPS_DATUM_GEO   = 193, GPS_DATUM_GUA   = 194, GPS_DATUM_DOB   = 195,
GPS_DATUM_JOH   = 196, GPS_DATUM_KUS   = 197, GPS_DATUM_LUZ_A = 198,
GPS_DATUM_LUZ_B = 199, GPS_DATUM_MID   = 200, GPS_DATUM_OHA_M = 201,
GPS_DATUM_OHA_A = 202, GPS_DATUM_OHA_B = 203, GPS_DATUM_OHA_C = 204,
GPS_DATUM_OHA_D = 205, GPS_DATUM_OHI_M = 206, GPS_DATUM_OHI_A = 207,
GPS_DATUM_OHI_B = 208, GPS_DATUM_OHI_C = 209, GPS_DATUM_OHI_D = 210,
GPS_DATUM_PIT   = 211, GPS_DATUM_SAE   = 212, GPS_DATUM_MVS   = 213,
GPS_DATUM_ENW   = 214, GPS_DATUM_WAK   = 215
} OSAL_tenGPSDatum;

// (*) May be extended if needed; codes based on NIMA TR 8350.2 3rd ed. Jan 2000

typedef struct {
	OSAL_tenGPSDatum	enDatum;
	tDouble			dLat;
	tDouble			dLon;
	tDouble			dAlt;
   tDouble        dAltMSL;
} OSAL_trGPSPositionLLA;

typedef struct {
	OSAL_tenGPSPositionFormat	enPositionFormat;
	union {
		OSAL_trGPSPositionECEF	trPositionECEF;
		OSAL_trGPSPositionLLA	trPositionLLA;
	} uPosition;
} OSAL_trGPSPosition;

// (9) Basic types for describing position accuracy:

typedef enum {
	GPS_ACCURACY_VALID = 0,
	GPS_ACCURACY_INVALID = 1
} OSAL_tenGPSPositionAccuracyMode;

typedef struct {
	OSAL_tenGPSPositionAccuracyMode	enAccuracyMode;
	tDouble				dHorizontalAccuracy;
	tDouble				dVerticalAccuracy;
} OSAL_trGPSPositionAccuracy;

// (10) Basic types for describing velocity:

typedef enum {
	GPS_VEL_ECEF = 0,
	GPS_VEL_NED = 1
} OSAL_tenGPSVelocityFormat;

typedef struct {
	tDouble		dVx;
	tDouble		dVy;
	tDouble		dVz;
} OSAL_trGPSVelocityECEF;

typedef struct {
	tDouble		dVn;
	tDouble		dVe;
	tDouble		dVd;
} OSAL_trGPSVelocityNED;

typedef struct {
	OSAL_tenGPSVelocityFormat	enVelocityFormat;
	union {
		OSAL_trGPSVelocityECEF	trVelocityECEF;
		OSAL_trGPSVelocityNED	trVelocityNED;
	} uVelocity;
} OSAL_trGPSVelocity;

// (11) Aditional macros and types used to describe the structure of tracking data field/message:
#if defined(GEN3ARM) || defined(GEN3X86)
#define OSAL_C_S32_GPS_NO_CHANNELS		((tS32)32)
#else
#define OSAL_C_S32_GPS_NO_CHANNELS		((tS32)14)
#endif

#define OSAL_C_S32_GPS_NO_SATELLITES			((tS32)32)
#define OSAL_C_S32_GPS_SAMPLES_PER_SEC		((tS32)10)

typedef enum {
   GPS_CHANSTATE_ACQ_SUCCESS           = 0x01,
   GPS_CHANSTATE_DELTA_CARPHASE_VALID  = 0x02,
   GPS_CHANSTATE_BIT_SYNC_DONE         = 0x04,
   GPS_CHANSTATE_SUBFRAME_SYNC_DONE    = 0x08,
   GPS_CHANSTATE_CARRIER_PULLIN_DONE   = 0x10,
   GPS_CHANSTATE_CODE_LOCKED           = 0x20,
   GPS_CHANSTATE_ACQ_FAILED            = 0x40,
   GPS_CHANSTATE_GOT_EPHEMERIS         = 0x80,
	GPS_CHANSTATE_LOCKED_AND_DATA_VALID = 0xbf
} OSAL_tenGPSChanState;

typedef struct {
	tU8			u8SvId;
	tDouble			dAzimuth;
	tDouble			dElevation;
} OSAL_trGPSSvDir;

typedef struct {
	OSAL_tenGPSChanState	enChanState;
	OSAL_trGPSSvDir		trSvDir;
	tU8			u8AverageCNo;
	tU8			u8CNo[OSAL_C_S32_GPS_SAMPLES_PER_SEC];
} OSAL_trGPSChanTrackData;

typedef struct {
	OSAL_trGPSTime		trTime;
	tU8			u8NoChans;
	OSAL_trGPSChanTrackData	trChanTrackData[OSAL_C_S32_GPS_NO_CHANNELS];
} OSAL_trGPSTrackData;


// (12) Types describing the structure of 50bps data field/message:

typedef struct {
	tU8				u8SvId;
	tU8				u8ChanNo;
	tU32				u32DataBits[10];
} OSAL_trGPSChan50BpsData;

typedef struct {
	tU8				u8NoChans;
	OSAL_trGPSChan50BpsData		trChan50BpsData[OSAL_C_S32_GPS_NO_CHANNELS];
} OSAL_trGPS50BpsData;

// (13) Additional macros and types describing the structure of visible list field/message:


typedef struct {
	tU8				u8NoVisibleSvs;
	OSAL_trGPSSvDir			trSvDir[OSAL_C_S32_GPS_NO_CHANNELS];
} OSAL_trGPSVisibleList;

// (14)  Additional types describing the structure of position measurement field/message:

typedef enum {
   GPS_SOLTYPE_NO_SOLUTION       = 0,
   GPS_SOLTYPE_ONE_SAT           = 1,
   GPS_SOLTYPE_TWO_SATS          = 2,
   GPS_SOLTYPE_THREE_SATS        = 3,
	GPS_SOLTYPE_FOUR_OR_MORE_SATS = 4,
   GPS_SOLTYPE_LSQ_2D            = 5,
   GPS_SOLTYPE_LSQ_3D            = 6,
   GPS_SOLTYPE_GPS_DR            = 7
} OSAL_tenGPSNAVSolutionType;

typedef struct {
	OSAL_tenGPSNAVSolutionType	enSolutionType;
   tBool                      bDOPMaskExceeded;
   tBool                      bDGPSPosition;
   tBool                      bDRSensorData;
   tBool                      bFixIsValidated;
   tBool                      bVelocityIsValid;
} OSAL_trGPSPOSSolutionMode;

typedef struct {
	tDouble	dGDOP;
	tDouble	dHDOP;
	tDouble	dPDOP;
	tDouble	dTDOP;
	tDouble	dVDOP;
} OSAL_trGPSDOPS;

typedef struct
{
  tU32  u32Timestamp;   // GPS Timestamp
  tBool bTsValid;       // true if timestamp is valid
} OSAL_trGPSTimeStamp;

typedef struct {
	OSAL_trGPSPOSSolutionMode	trSolutionMode;
   OSAL_trGPSPosition         trPosition;
   OSAL_trGPSVelocity         trVelocity;
   OSAL_trGPSTime             trTime;
   OSAL_trGPSDOPS             trDOPS;
	OSAL_trGPSPositionAccuracy	trPositionAccuracy;
   tU8                        u8NoSatellitesInFix;
   tU8                        u8SvIds[OSAL_C_S32_GPS_NO_CHANNELS];
   tU32                       u32AlmanacCollectionStatus;
   OSAL_trGPSTimeStamp        trTimeStamp;
} OSAL_trGPSMeasuredPosition;


// (15) Type and macro describing almanac data:

#define OSAL_C_S32_GPS_ALMANAC_DATA_SIZE		((tS32)448)

typedef struct {
	tU16		u16AlmanacData[OSAL_C_S32_GPS_ALMANAC_DATA_SIZE];
} OSAL_trGPSAlmanac;


// (16) Type describing ephemeris data:

#define OSAL_C_S32_GPS_EPHEMERIS_DATA_SIZE		((tS32)45)

typedef struct {
	tU16	u16EphemerisData[OSAL_C_S32_GPS_EPHEMERIS_DATA_SIZE];
} OSAL_trGPSEphemeris;

// (17) Type describing elevation mask:

typedef struct {
	tDouble	dTrackingElevationMask;
	tDouble	dPositioningElevationMask;
} OSAL_trGPSElevationMask;

// (18) Type describing power mask:

typedef struct {
	tU8		u8TrackingPowerMask;
	tU8		u8PositioningPowerMask;
} OSAL_trGPSPowerMask;

// (19) Types describing DOP mask:

typedef enum {
   GPS_DOP_MASK_AUTO = 0,
   GPS_DOP_MASK_PDOP = 1,
   GPS_DOP_MASK_HDOP = 2,
   GPS_DOP_MASK_GDOP = 3,
   GPS_DOP_MASK_DISABLED = 4
} OSAL_tenGPSDOPMaskMode;

typedef struct {
	OSAL_tenGPSDOPMaskMode	tenMode;
	tU8			u8GDOPThreshold;
	tU8			u8PDOPThreshold;
	tU8			u8HDOPThreshold;
} OSAL_trGPSDOPMask;

// (20) Type describing startup mode:

typedef enum {
   GPS_STARTUP_COLD     = 0,
   GPS_STARTUP_WARM     = 1,
   GPS_STARTUP_HOT      = 2,
   GPS_STARTUP_TEST     = 3,
   GPS_STARTUP_FACTORY  = 4,
   GPS_STARTUP_CODE_GEN = 5
} OSAL_tenGPSStartupMode;

// (21) Types describing positioning mode:

typedef enum {
	GPS_DEGRADED_MODE_DIRECTION_THEN_TIME = 0,
	GPS_DEGRADED_MODE_TIME_THEN_DIRECTION = 1,
   GPS_DEGRADED_MODE_DIRECTION_ONLY      = 2,
   GPS_DEGRADED_MODE_TIME_ONLY           = 3,
   GPS_DEGRADED_MODE_DISABLED            = 4
} OSAL_tenGPSDegradedMode;

typedef struct {
   OSAL_tenGPSDegradedMode tenDegradedMode;
   tU8                     u8DegradedTimeout;
   tBool                   bGPSDREnabled;
   tU8                     u8GPSDRTimeout;
   tBool                   bTrackSmoothEnabled;
} OSAL_trGPSPositioningMode;

// (22) Type defining source of differential GPS corrections:

typedef enum {
	GPS_SOURCE_DGPS_NONE = 0,
   GPS_SOURCE_DGPS_SBAS = 1,
   GPS_SOURCE_DGPS_RTCM = 4
} OSAL_tenGPSSourceDGPS;

// (23) Types defining mode of differential GPS corrections:

typedef enum {
   GPS_MODE_DGPS_AUTO      = 0,
	GPS_MODE_DGPS_EXCLUSIVE = 1,
   GPS_MODE_DGPS_NEVER     = 2
} OSAL_tenGPSModeDGPS;

typedef struct {
	OSAL_tenGPSModeDGPS	tenMode;
	tU8			u8Timeout;
} OSAL_trGPSModeDGPS;

// (24) Types related to RTCM data:
typedef struct {
   tS32        s32MessageSize;         // up to 500 bytes can be delivered at once
   tPU8        pu8MessageData;
} OSAL_trGPSMessageRTCM;


// (25) Types and macros related to satellite health:

#define OSAL_C_S32_GPS_MIN_SATELLITE_ID			((tS32)1)
#define OSAL_C_S32_GPS_MAX_SATELLITE_ID			((tS32)32)

typedef enum {
	GPS_HEALTH_OK = 1,
	GPS_HEALTH_CA_ONLY = 2,
	GPS_HEALTH_L1_ONLY = 3,
	GPS_HEALTH_BAD = 4
} OSAL_tenGPSSatelliteHealth;

/* Note: The following mapping between satellite health codes, as described  in
   ICD-GPS-200C document (table 20-VIII), and enumerated type defined above, is
   established:

00000 - All Signals OK ................................... GPS_HEALTH_OK
00001 - All Signals Weak ................................. GPS_HEALTH_OK
00010 - All Signals Dead ................................. GPS_HEALTH_BAD
00011 - All Signals Have No Data Modulation .............. GPS_HEALTH_BAD
00100 - L1 P Signal Weak ................................. GPS_HEALTH_OK
00101 - L1 P Signal Dead ................................. GPS_HEALTH_CA_ONLY
00110 - L1 P Signal Has No Data Modulation ............... GPS_HEALTH_CA_ONLY
00111 - L2 P Signal Weak ................................. GPS_HEALTH_OK
01000 - L2 P Signal Dead ................................. GPS_HEALTH_L1_ONLY
01001 - L2 P Signal Has No Data Modulation ............... GPS_HEALTH_OK
01010 - L1 C Signal Weak ................................. GPS_HEALTH_OK
01011 - L1 C Signal Dead ................................. GPS_HEALTH_BAD
01100 - L1 C Signal Has No Data Modulation ............... GPS_HEALTH_BAD
01101 - L2 C Signal Weak ................................. GPS_HEALTH_OK
01110 - L2 C Signal Dead ................................. GPS_HEALTH_OK
01111 - L2 C Signal Has No Data Modulation ............... GPS_HEALTH_OK
10000 - L1 & L2 P Signal Weak ............................ GPS_HEALTH_OK
10001 - L1 & L2 P Signal Dead ............................ GPS_HEALTH_CA_ONLY
10010 - L1 & L2 P Signal Has No Data Modulation .......... GPS_HEALTH_CA_ONLY
10011 - L1 & L2 C Signal Weak ............................ GPS_HEALTH_OK
10100 - L1 & L2 C Signal Dead ............................ GPS_HEALTH_BAD
10101 - L1 & L2 C Signal Has No Data Modulation .......... GPS_HEALTH_BAD
10110 - L1 Signal Weak ................................... GPS_HEALTH_OK
10111 - L1 Signal Dead ................................... GPS_HEALTH_BAD
11000 - L1 Signal Has No Data Modulation ................. GPS_HEALTH_BAD
11001 - L2 Signal Weak ................................... GPS_HEALTH_OK
11010 - L2 Signal Dead ................................... GPS_HEALTH_L1_ONLY
11011 - L2 Signal Has No Data Modulation ................. GPS_HEALTH_OK
11100 - SV Is Temporarily Out ............................ GPS_HEALTH_BAD
11101 - SV Will Be Temporarily Out ....................... GPS_HEALTH_BAD
11110 - Spare ............................................ GPS_HEALTH_BAD
11111 - More Than One Combination Necessary To
        Describe Anomalies ............................... GPS_HEALTH_BAD
*/

typedef struct {
	OSAL_tenGPSSatelliteHealth enSatelliteHealth[OSAL_C_S32_GPS_NO_SATELLITES];
} OSAL_trGPSSatelliteHealth;


// (26) Types and macros related to measurement data:

typedef enum {
	GPS_SYNC_STATE_NOT_ALIGNED = 0,
	GPS_SYNC_STATE_CONSISTENT_CODE_EPOCH_ALIGNMENT = 1,
	GPS_SYNC_STATE_CONSISTENT_DATA_BIT_ALIGNMENT = 2,
	GPS_SYNC_STATE_NO_MILLISECOND_ERRORS = 3
} OSAL_tenGPSSyncState;

typedef enum {
	GPS_AUTOCORR_STATE_NOT_AN_AUTOCORR = 0,
	GPS_AUTOCORR_STATE_TEST_IN_PROGRESS = 1,
	GPS_AUTOCORR_STRONG_SINGNAL = 2
} OSAL_tenGPSAutocorrDetectionState;

typedef struct {
	tU8					u8SvId;
	tU8					u8ChanNo;
	tU8					u8CoherentIntegrationTime;
	OSAL_tenGPSSyncState			enSyncState;
	OSAL_tenGPSAutocorrDetectionState	enAutocorrDetectionState;
	tU32					u32TimeTag;
	tDouble					dGPSSWTime;
	tDouble					dPseudorange;
	tDouble					dCarrierFreq;
	tDouble					dCarrierPhase;
	tU16 					u16TimeInTrack;
	tU8					u8CNo[OSAL_C_S32_GPS_SAMPLES_PER_SEC];
	tU16					u16DeltaRangeInterval;
	tU16					u16MeanDeltaRangeTime;
	tS16					s16ExtrapolationTime;
	tU8					u8PhaseErrorCount;
	tU8					u8LowPowerCount;
} OSAL_trGPSChanMeasData;

typedef struct {
	tU8					u8NoChans;
	OSAL_trGPSChanMeasData			trChanMeasData[OSAL_C_S32_GPS_NO_CHANNELS];
} OSAL_trGPSMeasData;

// (27) Types and macros related to satellite vehicle state data:

typedef enum {
	GPS_SV_POSITION_BASE_NONE = 0,
	GPS_SV_POSITION_BASE_EPHEMERIS = 1,
	GPS_SV_POSITION_BASE_ALMANAC = 2
} OSAL_tenGPSSVPositionBase;

typedef struct {
	tU8					u8SvId;
	tU8					u8ChanNo;
	OSAL_tenGPSSVPositionBase		enSVPositionBase;
	OSAL_trGPSTimeGPS			trTimeGPS;
	OSAL_trGPSPositionECEF			trPositionECEF;
	OSAL_trGPSVelocityECEF			trVelocityECEF;
	tDouble					dClockBias;
	tDouble					dClockDrift;
	tDouble					dIonosphericDelay;
} OSAL_trGPSChanSVStateData;

typedef struct {
	tU8					u8NoChans;
	OSAL_trGPSChanSVStateData		trChanSVStateData[OSAL_C_S32_GPS_NO_CHANNELS];
} OSAL_trGPSSVStateData;

// (28) Types related to test mode data:

typedef struct {
	tDouble		dCNoMean;
	tDouble		dCNoSigma;
	tDouble		dClockOffset;
	tDouble		dClockSigmaSquare;
	tDouble		dBitSyncTime;
	tS32		s32PoorStatusCount;
	tS32		s32BadBitCount;
	tS32		s32I;
	tS32		s32Q;
	tU8			u8SvId;
} OSAL_trGPSTestModeData;

// (29) Type related to OSAL_C_S32_IOCTL_GPS_READ_RECORD control function

typedef struct {
	tU32	*pBuffer;
	tU32	u32RecordId;
} OSAL_trGPSReadRecordHeaderArgs;

// (oej2hi - added for Paramount) data structure for BP-GPS specific
// information

typedef struct
{
   // Only useful and non-redundant fields are used.
   tF32 f32Elem0, f32Elem4, f32Elem8, f32Elem5, f32Elem9, f32Elem10;
} OSAL_trCovarianceMatrix;


typedef struct
{
   tF32 f32Elem11;
   tF32 f32Elem22;
   tF32 f32Elem33;
} OSAL_trGPSCovarianceMatrixDiag;

#define OSAL_C_U32_GPS_HINTS_MAPM_TUNNEL_VALID 0x01
#define OSAL_C_U32_GPS_HINTS_MAPM_TUNNEL_FLAG  0x02
#define OSAL_C_U32_GPS_HINTS_MAPM_GARAGE_VALID 0x04
#define OSAL_C_U32_GPS_HINTS_MAPM_GARAGE_FLAG  0x08
#define OSAL_C_U32_GPS_HINTS_MAPM_CITY_VALID   0x10
#define OSAL_C_U32_GPS_HINTS_MAPM_CITY_FLAG    0x20
#define OSAL_C_U32_GPS_HINTS_FORW_POS_VALID    0x10000000
#define OSAL_C_U32_GPS_HINTS_BACKW_POS_VALID   0x20000000
#define OSAL_C_U32_GPS_HINTS_FORW_VEL_VALID    0x40000000
#define OSAL_C_U32_GPS_HINTS_BACKW_VEL_VALID   0x80000000

typedef struct
{
   OSAL_trGPSPositionLLA rForwardPosition;
   OSAL_trGPSPositionLLA rBackwardPosition;
   OSAL_trGPSVelocityNED rForwardVelocity;
   OSAL_trGPSVelocityNED rBackwardVelocity;
   OSAL_trGPSCovarianceMatrixDiag rForwardPositionCovariances;
   OSAL_trGPSCovarianceMatrixDiag rBackwardPositionCovariances;
   OSAL_trGPSCovarianceMatrixDiag rForwardVelocityCovariances;
   OSAL_trGPSCovarianceMatrixDiag rBackwardVelocityCovariances;
   tU32 u32MapMatchingHints;
   tU16 u16Year;
   tU8  u8Month;
   tU8  u8Day;
   tU8  u8Hour;
   tU8  u8Minute;
   tU8  u8Second;
   tU8  u8HundredthSecond;
} OSAL_trGPSHints;


// (30) Maximum number of pending asynchronous requests

#define OSAL_C_S32_GPS_MAX_PENDING_READ_REQUESTS	((tS32)10)

// (31) Wait timeout tick in milliseconds

#define OSAL_C_S32_GPS_WAIT_TIMEOUT_TICK_IN_MILLISECONDS	((tS32)20)


// (32) Maximum size of data record

#define OSAL_C_S32_GPS_MAX_RECORD_DATA_SIZE (           \
      ((sizeof(OSAL_trGPSTrackData) + OSAL_C_U32_GPS_MAX_ELEMSIZE-1) & ~(OSAL_C_U32_GPS_MAX_ELEMSIZE-1)) +        \
      ((sizeof(OSAL_trGPS50BpsData) + OSAL_C_U32_GPS_MAX_ELEMSIZE-1) & ~(OSAL_C_U32_GPS_MAX_ELEMSIZE-1)) +        \
      ((sizeof(OSAL_trGPSVisibleList) + OSAL_C_U32_GPS_MAX_ELEMSIZE-1) & ~(OSAL_C_U32_GPS_MAX_ELEMSIZE-1)) +      \
      ((sizeof(OSAL_trGPSMeasuredPosition) + OSAL_C_U32_GPS_MAX_ELEMSIZE-1) & ~(OSAL_C_U32_GPS_MAX_ELEMSIZE-1)) + \
      ((sizeof(OSAL_trGPSSatelliteHealth) + OSAL_C_U32_GPS_MAX_ELEMSIZE-1) & ~(OSAL_C_U32_GPS_MAX_ELEMSIZE-1)) +  \
      ((sizeof(OSAL_trGPSMeasData) + OSAL_C_U32_GPS_MAX_ELEMSIZE-1) & ~(OSAL_C_U32_GPS_MAX_ELEMSIZE-1)) +         \
      ((sizeof(OSAL_trGPSSVStateData) + OSAL_C_U32_GPS_MAX_ELEMSIZE-1) & ~(OSAL_C_U32_GPS_MAX_ELEMSIZE-1)) +      \
      ((sizeof(OSAL_trGPSExtData) + OSAL_C_U32_GPS_MAX_ELEMSIZE-1) & ~(OSAL_C_U32_GPS_MAX_ELEMSIZE-1)) +          \
      ((sizeof(OSAL_trGPSTestModeData) + OSAL_C_U32_GPS_MAX_ELEMSIZE-1) & ~(OSAL_C_U32_GPS_MAX_ELEMSIZE-1))+     \
      ((sizeof(OSAL_trGPSTightCouplingData) + OSAL_C_U32_GPS_MAX_ELEMSIZE-1) & ~(OSAL_C_U32_GPS_MAX_ELEMSIZE-1)) +     \
      ((sizeof(OSAL_trGPSNormalTestData) + OSAL_C_U32_GPS_MAX_ELEMSIZE-1) & ~(OSAL_C_U32_GPS_MAX_ELEMSIZE-1)))


typedef struct 
{
   OSAL_trGPSPositionLLA rFilteredPosition;
   tBool bFilteredPositionValid;
   tBool bUnfilteredPositionValid;
   tBool bVelocityValid;
   OSAL_trCovarianceMatrix rPositionCovarianceMatrix;
   tF32 f32PositionRangeResidualMax;
   OSAL_trCovarianceMatrix rVelocityCovarianceMatrix;
   tF32 f32VelocityRangeResidualMax;
   OSAL_trGPSVelocityNED rFilteredVelocity;
   tBool bFilteredVelocityValid;
   tU32 u32ReceivedEphemeris;
   tBool bRaimAlarmPosition;
   tBool bRaimAlarmVelocity;
} OSAL_trGPSExtData;

#define GPS_CHANNEL_STATUS_ACTIVE   0x01
#define GPS_CHANNEL_STATUS_TRACKING 0x02
#define GPS_CHANNEL_STATUS_BIT_SYNC 0x04
#define GPS_CHANNEL_STATUS_CHAN_SEL 0x08
#define GPS_CHANNEL_STATUS_SYNC     0x10
#define GPS_CHANNEL_STATUS_SYNC_2   0x20
#define GPS_CHANNEL_STATUS_SYNC_3   0x40
#define GPS_CHANNEL_STATUS_SYNC_4   0x80

typedef struct
{
   tU32 u32PinToggle;           /* HW pin toggle register */
   tF32 f32NoiseLevel;          /* calculated noise level */
   tU32 u32TimePosValid;        /* bit mask for time and position validity */
   tF32 f32OscFreq;             /* oscillator frequency */
   tF32 f32OscFreqOffset;       /* oscillator frequency offset */
   tF32 f32CalcFreqOffset;      /* calculated frequency offset */
   tF32 f32IFOffset;            /* IF offset */
   tU8  au8ChannelStatus[OSAL_C_S32_GPS_NO_CHANNELS];
                                /* Channel status, bit field defined
                                   by GPS_CHANNEL_STATUS_* */
   tU8  au8ExtChanStatus[OSAL_C_S32_GPS_NO_CHANNELS];
                                /* Extra channel status bits */

} OSAL_trGPSNormalTestData;


typedef struct
{
   /* ECEF satellite position */
   tF64 f64SatPosX;
   tF64 f64SatPosY;
   tF64 f64SatPosZ;

   /* ECEF satellite velocity */
   tF64 f64SatVelX;
   tF64 f64SatVelY;
   tF64 f64SatVelZ;

   /* ECEF satellite acceleration */
   tF64 f64SatAccX;
   tF64 f64SatAccY;
   tF64 f64SatAccZ;

   /* corrected data transmission time */
   tF64 f64TimeSentCorr;

   /* uncorrected data transmission time */
   tF64 f64TimeSentUncorr;

   /* carrier phase difference */
   tF64 f64CarrierPhaseDiff;

   /* pseudo range */
   tF64 f64PseudoRange;

   /* delta pseudo range */
   tF64 f64DeltaPseudoRange;

   /* variance of pseudo range measurements */
   tF32 f32VarPseudoRange;

   /* variance of delta pseudo range measurements */
   tF32 f32VarDeltaPseudoRange;

   /* iono/tropo correction of propagation time */
   tF32 f32PropTimeCorrection;

   /* usable for calculation */
   tU32 u32ChannelStatus;
} OSAL_trGPSTightCouplingChannelData;

typedef struct 
{
   /* /dev/auxclock time stamp */
   tU32 u32TimeStamp;

   /* hardware sample rate */
   tU32 u32SampleRate;

   /* GPS time at interrupt */
   tF64 f64TimeOfWeek;

   /* current oscillator frequency */
   tF64 f64OscFreq;

   /* default frequency mix factor */
   tF32 f32FreqMixFactor;

   /* calculation interval */
   tU32 u32CalcInterval;
} OSAL_trGPSTightCouplingCommonData;

typedef struct
{
   /* channel-independent data */
   OSAL_trGPSTightCouplingCommonData rCommon;

   /* per-channel data */
   OSAL_trGPSTightCouplingChannelData arChannel[OSAL_C_S32_GPS_NO_CHANNELS];
} OSAL_trGPSTightCouplingData;





typedef struct {
    OSAL_trGPSTrackData    trTrackData;
    OSAL_trGPSVisibleList     trVisibleList;
    OSAL_trGPSMeasuredPosition   trMeasuredPosition;
    OSAL_trGPSSatelliteHealth    trSatHealth;
    OSAL_trGPSExtData          trExtData;
    OSAL_trGPSNormalTestData    trNormalTestData;
    OSAL_trGPSTightCouplingData trTCData;
} OSAL_trGPSFullRecord;


// (oej2hi - added for Paramount) Parameter type for internal data ioctls
typedef struct {
   tU8 *pau8Buf;
   tU32 u32BufSize;
} OSAL_trGPSInternalData;

// Parameter for OSAL_C_S32_IOCTL_GPS_FRONT_END_TEST
typedef struct 
{
   tU32 u32PinToggle;
   tU8  u8DataPattern;
} OSAL_trGPSFrontEndTest;

// KOP2HI - new type for set / get initial position
typedef struct {
    tS16 s16LatDeg;
    tS16 s16LatMin;
    tS16 s16LatSec;
    tS16 s16LonDeg;
    tS16 s16LonMin;
    tS16 s16LonSec;
    tS16 s16Alt;
} OSAL_trGPSIntitialPositionInDegLLA;


// KOP2HI - setup for production diagnostics application
typedef struct 
{
   tU8       u8Satellite;
   tU16     u16GpsSearchMask;
} OSAL_trGPSExtTestmodeStartupParams;


// KOP2HI - testmode results for production diagnostics application
typedef struct{
  tS16           arGpsActualChannelSNR[13];      /* 13 channels @ Satellie 20, Act, SNR */
  tS16           s16GpsActualChannelPower;        /* 1 channel @ Satellie 02, Act, Pwr */
  tS16           s16GpsAverageChannelSNR;      /* The avergage of SNR  */
  tS32           s32GpsCurrentClockOffset;        /* The cuurent clock offset [Hz]  */
  tU32           u32GpsCurrentClockValue;         /* The cuurent clock value [Hz]         */
  tU8             u8GpsCalcTestResult;               /* GPS result from calculation     */
  tU32           u32GpsDebugChanStatusA;       /* @: Debug Buffer A for GPS Channel Status */
  tU32           u32GpsDebugChanStatusB;       /* @: Debug Buffer B for GPS Channel Status */
  tU32           u32GpsDebugChanStatusC;       /* @: Debug Buffer C for GPS Channel Status */
  tU32           u32GpsDebugChanStatusD;       /* @: Debug Buffer D for GPS Channel Status */
  tU8             u8GpsTestResult;               /* Overall Test Result */
} OSAL_trGPSExtTestmodeResults;




// Structure for XO compensation 
typedef struct {
    tU32        ulTow;               // Time of week of last parameter change
    tF32        fltTemperature;      // Measured Temperature [K]
    tF32        fltC0;               // 1. Coefficient of polynomial [ppm]
    tF32        fltC1;               // 2. Coefficient of polynomial [ppm/K]
    tF32        fltC2;               // 3. Coefficient of polynomial [ppm/K/K]
    tF32        fltC3;               // 4. Coefficient of polynomial [ppm/K/K/K]
    tU16        usWeek;              // GPS week of last parameter change
} OSAL_trGPSXoCompensationData;    

typedef enum
{
   enGpsAntennaNormal = 0,
   enGpsAntennaOpen = 1,
   enGpsAntennaShort = 2,
   enGpsAntennaBurning = 3,
   enGpsAntennaBatteryShort = 4,
   enGpsAntennaUnknown = 5
}OSAL_tenGPSAntennaStatus;

typedef struct
{
	OSAL_tenGPSAntennaStatus enGPSAntennaStatus;
	tF32 f32Antennacurrent;
}OSAL_trGPSAntennastatus;   


// GPS DEVICE SPECIFIC ERROR CODES - TO BY SYNCED WITH OTHER ERROR CODES

#define OSAL_E_GPS_STARTED                   ((tS32)9000)
#define OSAL_E_GPS_NOT_STARTED               ((tS32)9001)
#define OSAL_E_GPS_INVALID_DATUM             ((tS32)9002)
#define OSAL_E_GPS_TOO_MANY_ASYNC_READS      ((tS32)9003)
#define OSAL_E_GPS_INVALID_FIELD_TYPE        ((tS32)9004)
#define OSAL_E_GPS_INVALID_FIELD_POINTER     ((tS32)9005)
#define OSAL_E_GPS_INVALID_HEADER_POINTER    ((tS32)9006)
#define OSAL_E_GPS_INVALID_POWER_MASK        ((tS32)9007)
#define OSAL_E_GPS_INVALID_ELEVATION_MASK    ((tS32)9008)
#define OSAL_E_GPS_INVALID_DOP_MASK          ((tS32)9009)
#define OSAL_E_GPS_INVALID_STARTUP_MODE      ((tS32)9010)
#define OSAL_E_GPS_DATA_NOT_AVAILABLE        ((tS32)9011)
#define OSAL_E_GPS_INVALID_POSITION          ((tS32)9012)
#define OSAL_E_GPS_INVALID_DGPS_SOURCE       ((tS32)9013)
#define OSAL_E_GPS_INVALID_DGPS_MODE         ((tS32)9014)
#define OSAL_E_GPS_RTCM_BUFFER_FULL          ((tS32)9015)
#define OSAL_E_GPS_INVALID_POSITIONING_MODE  ((tS32)9016)


// GPS tasks ------------------------------------------------------------------
#define GPS_HISR                    0
#define GPS_TASK_100MS              1
#define GPS_TASK_ONE_SECOND_UPDATE  2
#define GPS_TASK_AUTO_COOR          3
#define GPS_TASK_RXM_CONTROL        4
#define GPS_TASK_BACKGROUND         5
#define GPS_TASK_READ_ASYNC         6
#define GPS_TASK_IDLE               7


// System clocks --------------------------------------------------------------
#define SYS_CLK_SAPB                0
#define SYS_CLK_AAPB                1


// Prototypes -----------------------------------------------------------------

void INT_vGPS_100ms( void );
void INT_vGPS_1ms  ( void );
void INT_vGPS_Sleep( void );
void INT_vGPS_UART1( void );

void GPS_Set_TaskPriority( unsigned char task, unsigned char priority );

void GPS_Set_Clock_Info( int clock_type, unsigned int clock );

void GPS_Tasks_Initialize( int enable_gps_uart, int enable_gps_trace );

OSAL_DECL tS32 GPS_IOOpen        ( OSAL_tenAccess enAccess );

OSAL_DECL tS32 GPS_s32IOClose    ( tVoid );

OSAL_DECL tS32 GPS_s32IOControl  ( tS32 fun, tS32 arg );

OSAL_DECL tS32 GPS_s32IORead     ( tPS8 pBuffer, tU32 maxbytes );

OSAL_DECL tS32 GPS_s32IOReadAsync( OSAL_trAsyncControl* prAIO );


#endif // __OSAL_GPS_H__
