/***************************************************************************
 * .EXPORT_ME
 * FILE:         os_io.h
 * PROJECT:      VASCO
 * SW-COMPONENT: OSAL
 *--------------------------------------------------------------------------
 * DESCRIPTION:  This is the headerfile for the OS - Abstraction Layer for 
 *               I/O-Functions. This Header has to be included to use
 *               functions for I/O-Control
 *--------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      |   Modification                       | Author
 * 17.03.00  |   Initial revision                   | de Vries, EFT22
 * 10.04.00  |   Restructuring                      | Uelschen, EFT42
 * 06.07.00  |   asyncIO added, OSAL_tAsyncCtrl changed | de Vries, EFT22
 * 03.08.00  |   Linux definitions added            | Wunderlich, EFT32
 * 11.08.00  |   Linux uses OSAL_DECL now           | Wunderlich, EFT32
 * 13.09.00  |   OSAL_s32ReturnAsync, not..u32      | de Vries, EFT22
 * 07.02.02  |   OSAL_DECL added in class definition| Walkling, EST
 * 18.02.02  |   Nucleus defines added              | Uelschen, ESN2
 * 13.06.02  |   add dynamic-download               | Perick, CM-CR/EES4
 *           |   extension                          |
 **************************************************************************/

#if !defined (OSAL_IO_HEADER)
   #define OSAL_IO_HEADER


#ifdef __cplusplus
extern "C"
{
   #endif
   
   /**************************************************************************/
   /* typedefs                                                               */
   /**************************************************************************/
   /* -- Optionen fuer Dateizugriff */
   
   #define OSAL_C_S32_AIO_CANCELED        ((tS32) 2) 
   #define OSAL_C_S32_AIO_NOTCANCELED     ((tS32) 3)
   #define OSAL_C_S32_AIO_ALLDONE         ((tS32) 4)
   
   #ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT
   typedef intptr_t   OSAL_tIODescriptor; 
   #else
   typedef tS32 OSAL_tIODescriptor;
   #endif

   /* --Kontrollstruktur fuer asynchronen Dateizugriff */

      typedef struct
   {
          OSAL_tIODescriptor  id;         /* ID */
          tS32        s32Offset;          /* Offset fuer Seek Operation */
          tPVoid      pvBuffer;           /* Ein-/Ausgabepuffer */
          tU32        u32Length;          /* Puffergre */
          OSAL_tpfCallback  pCallBack;    /* Pointer to Callback function */    
          tPVoid        pvArg;             /* argument of callback fct */
      /* only for system management, not for users: */
          tU32        u32ErrorCode;       /* errorcode if aio failed */
          tS32        s32Status;          /* status of aio */ 
          tS32        s32CallerThreadId;  /* calling Thread ID */
   } OSAL_trAsyncControl;

#ifndef OSAL_IO_GEN2
#ifndef OSAL_DYNAMIC_DOWNLOAD
   #if OSAL_OS==OSAL_WINNT || OSAL_OS==OSAL_LINUX || OSAL_OS==OSAL_DARWIN || OSAL_OS==OSAL_RX732 || \
                OSAL_OS==OSAL_WINCE || OSAL_OS==OSAL_NUCLEUS || OSAL_OS==OSAL_TENGINE
   
   /* --15.2.1 Open a File */
   OSAL_DECL OSAL_tIODescriptor OSAL_IOOpen(tCString szName, OSAL_tenAccess enAccess);
   
   /* --15.2.2 Close a File */
   OSAL_DECL tS32 OSAL_s32IOClose(OSAL_tIODescriptor fd);
   
   /* --15.2.3 Create a File  */
   OSAL_DECL OSAL_tIODescriptor OSAL_IOCreate(tCString coszName,
    OSAL_tenAccess enAccess);
   
   /* --15.2.4 Remove a file */
   OSAL_DECL tS32 OSAL_s32IORemove(tCString coszName);
   
   /* --15.2.5 Call a Control Function */
   OSAL_DECL tS32 OSAL_s32IOControl(OSAL_tIODescriptor fd, tS32 fun, intptr_t arg);

   /* --15.2.6 Write to a File */
   OSAL_DECL tS32 OSAL_s32IOWrite(OSAL_tIODescriptor fd, tPCS8 pBuffer, tU32 nbytes);
   
   /* --15.2.7 Read From a File */
   OSAL_DECL tS32 OSAL_s32IORead(OSAL_tIODescriptor fd, tPS8 pBuffer, tU32 maxbytes);
   
   /* --15.2.8 Asynchronous Write to a File */
   OSAL_DECL tS32 OSAL_s32IOWriteAsync(OSAL_trAsyncControl* prAIO);
   
   /* --15.2.9 Asynchronous Read From a File */
   OSAL_DECL tS32 OSAL_s32IOReadAsync(OSAL_trAsyncControl* prAIO);
   
   /* --15.2.10 Cancel an Asynchronous Operation */
   OSAL_DECL tS32 OSAL_s32IOCancelAsync(OSAL_tIODescriptor fd, OSAL_trAsyncControl* prAIO);
   
   /* --15.2.11 Get Error Code */
   OSAL_DECL tU32 OSAL_u32IOErrorAsync(OSAL_trAsyncControl* prAIO);
   
   /* --15.2.12 Get Return Value */
   OSAL_DECL tS32 OSAL_s32IOReturnAsync(OSAL_trAsyncControl* prAIO);
   
   #endif 
   
   
   /* --VXWORKS INLINE */
   
   #if (OSAL_OS==OSAL_VXWORKS)
   
   
   #define OSAL_IOOpen(coszName,enAccess) \
        open(coszName,enAccess,0)
   
   
   #define OSAL_s32IOClose(fd) \
        close(fd)
   
   
   #define OSAL_IOCreate(coszName,enAccess) \
        creat(coszName,enAccess)
   
   
   #define OSAL_s32IORemove(coszName) \
         remove(coszName)
   
   
   #define OSAL_s32IOControl(fd,fun,arg) \
        ioctl(fd,fun,arg)
   
   
   #define OSAL_s32IOWrite(fd,pBuffer,nbytes) \
        write(fd,pBuffer,nbytes)
   
   
   #define OSAL_s32IORead(fd,pBuffer,maxbytes) \
        read(fd,pBuffer,maxbytes)
   
   /* --15.2.8 Asynchronous Write to a File */
   OSAL_DECL tS32 OSAL_s32IOWriteAsync(OSAL_trAsyncControl* prAIO);
   
   /* --15.2.9 Asynchronous Read From a File */
   OSAL_DECL tS32 OSAL_s32IOReadAsync(OSAL_trAsyncControl* prAIO);
   
   /* --15.2.10 Cancel an Asynchronous Operation */
   OSAL_DECL tS32 OSAL_s32IOCancelAsync(OSAL_tIODescriptor fd, OSAL_trAsyncControl* prAIO);
   
   /* --15.2.11 Get Error Code */
   OSAL_DECL tS32 OSAL_s32IOErrorAsync(OSAL_trAsyncControl* prAIO);
   
   /* --15.2.12 Get Return Value */
   OSAL_DECL tS32 OSAL_s32IOReturnAsync(OSAL_trAsyncControl* prAIO);
   
   
   #endif

   #endif // OSAL_DYNAMIC_DOWNLOAD
#endif //OSAL_IO_GEN2

/**************************************************************************/
/* dynamic-download                                                       */
/**************************************************************************/
#if ( defined OSAL_DYNAMIC_DOWNLOAD || defined OSAL_DYNAMIC_BASE || defined OSAL_IO_GEN2)
typedef OSAL_tIODescriptor (*tOSAL_IOOpen)(tCString szName, OSAL_tenAccess enAccess);
typedef tS32 (*tOSAL_s32IOClose)(OSAL_tIODescriptor fd);
typedef OSAL_tIODescriptor (*tOSAL_IOCreate)(tCString coszName, OSAL_tenAccess enAccess);
typedef tS32 (*tOSAL_s32IORemove)(tCString coszName);
typedef tS32 (*tOSAL_s32IOControl)(OSAL_tIODescriptor fd, tS32 fun, intptr_t arg);
typedef tS32 (*tOSAL_s32IOWrite)(OSAL_tIODescriptor fd, tPCS8 pBuffer, tU32 nbytes);
typedef tS32 (*tOSAL_s32IORead)(OSAL_tIODescriptor fd, tPS8 pBuffer, tU32 maxbytes);
typedef tS32 (*tOSAL_s32IOWriteAsync)(OSAL_trAsyncControl* prAIO);
typedef tS32 (*tOSAL_s32IOReadAsync)(OSAL_trAsyncControl* prAIO);
typedef tS32 (*tOSAL_s32IOCancelAsync)(OSAL_tIODescriptor fd, OSAL_trAsyncControl* prAIO);
typedef tU32 (*tOSAL_u32IOErrorAsync)(OSAL_trAsyncControl* prAIO);
typedef tS32 (*tOSAL_s32IOReturnAsync)(OSAL_trAsyncControl* prAIO);
#endif


#if (defined OSAL_DYNAMIC_DOWNLOAD || defined OSAL_IO_GEN2)
extern tOSAL_IOOpen           OSAL_IOOpen;
extern tOSAL_s32IOClose       OSAL_s32IOClose;
extern tOSAL_IOCreate         OSAL_IOCreate;
extern tOSAL_s32IORemove      OSAL_s32IORemove;
extern tOSAL_s32IOControl     OSAL_s32IOControl;
extern tOSAL_s32IOWrite       OSAL_s32IOWrite;
extern tOSAL_s32IORead        OSAL_s32IORead;
extern tOSAL_s32IOWriteAsync  OSAL_s32IOWriteAsync;
extern tOSAL_s32IOReadAsync   OSAL_s32IOReadAsync; 
extern tOSAL_s32IOCancelAsync OSAL_s32IOCancelAsync;
extern tOSAL_u32IOErrorAsync  OSAL_u32IOErrorAsync;
extern tOSAL_s32IOReturnAsync OSAL_s32IOReturnAsync;
#endif // OSAL_DYNAMIC_DOWNLOAD
   
   
   #ifdef __cplusplus
}
#endif

#ifdef __cplusplus
class OSAL_DECL OSAL_tclFile : public OSAL_tclBase
{
   public:
            //--constructor
         OSAL_tclFile();
            //--destructor
         virtual ~OSAL_tclFile();
            
            //--creates a new file, object gets a handle for access
         OSAL_tIODescriptor s32Create(tCString coszName, OSAL_tenAccess enAccess);
         
            //--opens a existing file; object gets a handle for access; existing name will be overwritten
         tS32 s32Open(tCString coszName, OSAL_tenAccess enAccess);
         
            //--opens a existing file, object gets a handle for access
         tS32 s32Open(OSAL_tenAccess enAccess);
         
            //--close the open file; handle will be deleted; name still exists
         tS32 s32Close();
         
            //--removes a file; handle and name will be deleted
         tS32 s32Remove();
         
            //--calls a control function of a device
         tS32 s32Control(tS32 s32Fun, intptr_t s32Arg);
         
            //--writes a number of bytes into a data file
         tS32 s32Write(tPCS8 pcos8Buffer, tU32 u32Length);
         
            //--reads a number of bytes from a data file
         tS32 s32Read(tPS8 ps8Buffer, tU32 u32MaxLength);
         
      
            //--gets the name of the current file 
         tCString coszGetName() const;
         
         
      /*
           --async functions will be implemented later
         tS32 s32IOWriteAsync(OSAL_trAsyncControl* prAIO);
         tS32 s32IOReadAsync(OSAL_trAsyncControl* prAIO);
         tS32 s32IOCancelAsync(OSAL_trAsyncControl* prAIO);
         tS32 s32IOErrorAsync(OSAL_trAsyncControl* prAIO);
         tS32 s32IOReturnAsync(OSAL_trAsyncControl* prAIO);
      */
   private:
         //--name of the file
      tCString szFileName;
      
         //--handle for access
      OSAL_tIODescriptor hFileID;
};

#include<string>

namespace osutilio
{
   /************************************************************************
   *
   * FUNCTION:     getRealPath
   *-----------------------------------------------------------------------
   * DESCRIPTION:  writes a string into the trace device
   *-----------------------------------------------------------------------
   * PARAMETER:    (I) osalFileOrDir: osal based file or directory name
   *                                  including path
   * PARAMETER:    (I) realFileOrDir: real file or directory name
   * RETURNVALUE:  success
   * HISTORY:
   * Date      |   Modification                         | Author
   * 08.03.18  |   Initial revision                     | Andres,ESN2
   *
   *************************************************************************/
   OSAL_DECL bool getRealPath( const std::string& osalFileOrDir
                             , std::string& realFileOrDir );
}

#endif

#endif 


/* EOF */
