/***************************************************************************
 * .EXPORT_ME
 * FILE:         os_error.h
 * PROJECT:      VASCO
 * SW-COMPONENT: OSAL
 *--------------------------------------------------------------------------
 * DESCRIPTION:  This is the headerfile for the OS - Abstraction Layer for 
 *               Error-Functions. This Header has to be included to use
 *               functions for Error-Handling
 *--------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      |   Modification               | Author
 * 17.03.00  |   Initial revision           | de Vries,EFT22
 * 10.04.00  |   Update, OSAL_tError        | Uelschen,EFT42
 * 02.08.00  |   Linux defines added        | Wunderlich, EFT32
 *           |                              |
 * 11.08.00  |   Linux uses OSAL_DECL now;  | Wunderlich, EFT32
 *           |   `tVoid' added in
 *           |   `OSAL_u32ErrorCode'.
 * 17.01.01  |   OSAL_ErrorCodeEx added for WinCE  | de Vries, EFG32
 * 13.02.01  |   OSA__E_CANCELLED added            | de Vries, EFG32
 * 29.11.01  |   OSAL_E_MQINUSE added              | Vorpeil, 3Soft
 * 18.02.02  |   Nucleus defines added             | Uelschen, ESN2
 * 13.06.02  |   add dynamic-download       | Perick, CM-CR/EES4
 *           |   extension                  |
 * 08.10.08  |   OSAL_E_I2C_NO_ACK_FROM_SLAVE |	hka2kor, ECM1/RBEI
 *			 |   OSAL_E_I2C_BUS_BUSY          |
 *
 **************************************************************************/

#if !defined (OSAL_ERROR_HEADER)
   #define OSAL_ERROR_HEADER


#ifdef __cplusplus
extern "C" {
#endif

/**************************************************************************/
/* typedefs                                                               */
/**************************************************************************/

typedef tVoid (*OSAL_tpfErrorHook)(tU32);

#define OSAL_C_COMPONENT	(0x07<<16)
#define OSAL_C_ERROR_TYPE    (0x02<<12)

/* not error */
#define OSAL_E_NOERROR		     ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|0)
/* function call not allowed */
#define OSAL_E_NOPERMISSION	     ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|1)
/* wrong parameter */
#define OSAL_E_INVALIDVALUE          ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|2)
/* no more ressources(memory) */
#define OSAL_E_NOSPACE               ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|3)
/* ressource is in use */
#define OSAL_E_BUSY                  ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|4)
/* interrupt during wait */
#define OSAL_E_INTERRUPT             ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|5)
/* no acces rights  */
#define OSAL_E_NOACCESS              ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|6)
/* ressource already exists */
#define OSAL_E_ALREADYEXISTS         ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|7)
/* ressource doesn't exist */
#define OSAL_E_DOESNOTEXIST          ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|8)
/* to much descriptors in use */
#define OSAL_E_MAXFILES              ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|9)
/* no more resources(filedescr.) */
#define OSAL_E_NOFILEDESCRIPTOR      ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|10)
/* name for file or descr. too long */
#define OSAL_E_NAMETOOLONG           ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|11)
/* not existing filedescriptor */
#define OSAL_E_BADFILEDESCRIPTOR     ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|12)
/* message is to long */
#define OSAL_E_MSGTOOLONG            ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|13)
/* message queue is full */
#define OSAL_E_QUEUEFULL             ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|14)
/* thread doesn't exist */
#define OSAL_E_WRONGTHREAD           ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|15)
/* a task is already waiting for event */
#define OSAL_E_EVENTINUSE            ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|16)
/* function doesn't exist */
#define OSAL_E_WRONGFUNC             ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|17)
/* function call is not allowed */
#define OSAL_E_NOTINTERRUPTCALLABLE  ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|18)
/* function is not ready */
#define OSAL_E_INPROGRESS            ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|19)
/* function abort because of timeout */
#define OSAL_E_TIMEOUT               ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|20)
/* service not supported */
#define OSAL_E_NOTSUPPORTED          ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|21)
/* unknown error */
#define OSAL_E_UNKNOWN               ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|22)
/* thread creation failed */
#define OSAL_E_THREAD_CREATE_FAILED  ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|23)

#define OSAL_E_WRONGPROCESS 	     ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|24)
/* Operation was canceled  (e.g. AIO)*/
#define OSAL_E_CANCELED              ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|25)
/* a thread is waiting for MQ*/
#define OSAL_E_MQINUSE               ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|26)

/* --C++-Interface. */
#define OSAL_E_ALREADYOPENED	     ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|27)

/* Application in low priority level */
#define OSAL_E_LOW_PRIORITY          ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|28)
/* Resource in Exclusive access */
#define OSAL_E_IN_EXCL_ACCESS        ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|29)
/* Resource temporarily not available */
#define OSAL_E_TEMP_NOT_AVAILABLE    ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|30)
/* No media in the drive */
#define OSAL_E_MEDIA_NOT_AVAILABLE   ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|31)
/* Cannot eject the disc because the drive is locked */
#define OSAL_E_EJECT_LOCKED          ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|32)
/* If device is not initialised */
#define OSAL_E_NOTINITIALIZED        ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|33)
/* physical error of device */
#define OSAL_E_IOERROR               ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|34)

#define OSAL_E_NOT_MOUNTED           ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|35)
#define OSAL_E_ACCESS_FAILED         ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|36)

#define OSAL_E_WRITE_PROTECTED       ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|37)
#define OSAL_E_DECRYPTION_FAILED     ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|38)

/* These defines are required to inform exact error to FC_IPOD */
#define OSAL_E_I2C_NO_ACK_FROM_SLAVE       ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|39)
#define OSAL_E_I2C_BUS_BUSY                ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|40)

/* last Error */
#define OSAL_E_LASTERROR             ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|39)


/* These defines must be deleted, after all applications use the above defines! */

#define OSAL_C_S32_IOCTRL_CARD_NOT_MOUNTED     ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|35)
#define OSAL_C_S32_IOCTRL_CARD_ACCESS_FAILED   ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|36)

#define OSAL_C_S32_IOCTRL_CARD_WRITE_PROTECTED ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|37)
#define OSAL_C_S32_IOCTRL_CARD_DECRYPTION_FAILED ((tU32)OSAL_C_COMPONENT|OSAL_C_ERROR_TYPE|38)


/**************************************************************************/
/* defines                                                                */
/**************************************************************************/
#ifndef OSAL_DYNAMIC_DOWNLOAD

#if OSAL_OS==OSAL_WINNT || OSAL_OS==OSAL_RX732 || OSAL_OS==OSAL_LINUX || OSAL_OS==OSAL_DARWIN \
	|| OSAL_OS==OSAL_WINCE || OSAL_OS==OSAL_NUCLEUS || OSAL_OS==OSAL_TENGINE

/* --7.3.1 Get the Last Error Code (this is thread dependent). */
OSAL_DECL tU32 OSAL_u32ErrorCode( tVoid );

/* --7.3.2 Set the Error Code (this is thread dependent). */
OSAL_DECL tVoid OSAL_vSetErrorCode(tU32 u32ErrorCode);
OSAL_DECL tVoid OSAL_vSetErrorCodeEx(tU32 u32ErrorCode, tCString szFilename, tS32 s32LineNumber);

/* --7.3.3 Get a textual Description of the Error */
OSAL_DECL tCString OSAL_coszErrorText(tU32 u32Ecode);

/* --7.3.4 Determine the Error Hook Function, Get the Old One Back. */
OSAL_DECL tVoid OSAL_vErrorHook( const OSAL_tpfErrorHook NewHook,
                                 OSAL_tpfErrorHook*      pOldHook );

/* --7.3.5 Execute the Error Hook Funktion */
OSAL_DECL tS32 OSAL_s32CallErrorHook(tU32 u32ErrorCode);

#endif


/* --VXWORKS INLINE */
#if OSAL_OS==OSAL_VXWORKS

/* --7.3.1 Get the Last Error Code (this is thread dependent). */
#define OSAL_u32ErrorCode() errnoGet()

/* --7.3.2 Get a textual Description of the Error */
#define OSAL_coszErrorText(u32Ecode) strerror(u32Ecode)

/* --7.3.3 Determine the Error Hook Function, Get the Old One Back. */
OSAL_DECL tVoid OSAL_vErrorHook( const OSAL_tpfErrorHook NewHook,
                                 OSAL_tpfErrorHook*      pOldHook );


/* --is used by VxWorks-OSAL to report errors, do not use in application-SW */
tVoid OSAL_vErrorReport(tU32 errorNr,tCString szFilename,tS32 s32LineNumber);


#endif    

#endif  // OSAL_DYNAMIC_DOWNLOAD


/**************************************************************************/
/* dynamic-download                                                       */
/**************************************************************************/

#if( defined OSAL_DYNAMIC_DOWNLOAD || defined OSAL_DYNAMIC_BASE)
typedef tU32 (*tOSAL_u32ErrorCode)( tVoid );
typedef tVoid (*tOSAL_vSetErrorCode)(tU32 u32ErrorCode);
typedef tVoid (*tOSAL_vSetErrorCodeEx)(tU32 u32ErrorCode, tCString szFilename, tS32 s32LineNumber);
typedef tCString (*tOSAL_coszErrorText)(tU32 u32Ecode);
typedef tVoid (*tOSAL_vErrorHook)( const OSAL_tpfErrorHook NewHook,
                                   OSAL_tpfErrorHook*      pOldHook );
typedef tS32 (*tOSAL_s32CallErrorHook)(tU32 u32ErrorCode);
#endif


#ifdef OSAL_DYNAMIC_DOWNLOAD
extern tOSAL_u32ErrorCode     OSAL_u32ErrorCode;
extern tOSAL_vSetErrorCode    OSAL_vSetErrorCode;
extern tOSAL_vSetErrorCodeEx  OSAL_vSetErrorCodeEx;
extern tOSAL_coszErrorText    OSAL_coszErrorText;
extern tOSAL_vErrorHook       OSAL_vErrorHook;
extern tOSAL_s32CallErrorHook OSAL_s32CallErrorHook;
#endif // OSAL_DYNAMIC_DOWNLOAD

#ifdef __cplusplus
}
#endif

#endif 


/* EOF */

