/* .EXPORT_ME */
#ifndef OSDEVICE_HEADER
#define OSDEVICE_HEADER

/* --In this file the names of the various devices are declared. */

#define OSAL_C_STRING_DEVICE_SQL               "/dev/sql"   /* Matthias Hessling */

#define OSAL_C_STRING_DEVICE_REMOTE_FS         "/dev/rfs"   /* @@@@ 20.09.2010 Resch */
#define OSAL_C_STRING_DEVICE_REMOTE_SHELL      "/dev/rsh"   /* @@@@ 20.09.2010 Resch */

#define OSAL_C_STRING_DEVICE_ADC               "/dev/adc"   /* @@@@ 21.08.2002 Ka */
#define OSAL_C_STRING_DEVICE_ANALOG_SPEECH     "/dev/analogspeech" /* @@@@ 21.08.2002 Ka */
#define OSAL_C_STRING_DEVICE_AUXILIARY_CLOCK   "/dev/auxclock"
#define OSAL_C_STRING_DEVICE_BFLASH            "/dev/bflash"
#define OSAL_C_STRING_DEVICE_CACHEDCDFS        "/dev/cachedcdfs"
#define OSAL_C_STRING_DEVICE_CARD1             "/dev/card1"
#define OSAL_C_STRING_DEVICE_CARD2             "/dev/card2"
#define OSAL_C_STRING_DEVICE_CARD3             "/dev/card3"
#define OSAL_C_STRING_DEVICE_CARDX             "/dev/card%d"
#define OSAL_C_STRING_DEVICE_CDAUDIO           "/dev/cdaudio"  /* @@@@ 21.08.2002 Ka */
#define OSAL_C_STRING_DEVICE_CDCTRL            "/dev/cdctrl"
#define OSAL_C_STRING_DEVICE_CDROM             "/dev/cdrom"

#define OSAL_C_STRING_DEVICE_CDAUDIO0          "/dev/cdaudio0"
#define OSAL_C_STRING_DEVICE_CDAUDIO1          "/dev/cdaudio1"
#define OSAL_C_STRING_DEVICE_CDAUDIO2          "/dev/cdaudio2"
#define OSAL_C_STRING_DEVICE_CDAUDIO3          "/dev/cdaudio3"
#define OSAL_C_STRING_DEVICE_CDCTRL0           "/dev/cdctrl0"
#define OSAL_C_STRING_DEVICE_CDCTRL1           "/dev/cdctrl1"
#define OSAL_C_STRING_DEVICE_CDCTRL2           "/dev/cdctrl2"
#define OSAL_C_STRING_DEVICE_CDCTRL3           "/dev/cdctrl3"
#define OSAL_C_STRING_DEVICE_CD0               "/dev/cd0"
#define OSAL_C_STRING_DEVICE_CD1               "/dev/cd1"
#define OSAL_C_STRING_DEVICE_CD2               "/dev/cd2"
#define OSAL_C_STRING_DEVICE_CD3               "/dev/cd3"
#define OSAL_C_STRING_DEVICE_CACHEDCD0         "/dev/cachedcd0"
#define OSAL_C_STRING_DEVICE_CACHEDCD1         "/dev/cachedcd1"
#define OSAL_C_STRING_DEVICE_CACHEDCD2         "/dev/cachedcd2"
#define OSAL_C_STRING_DEVICE_CACHEDCD3         "/dev/cachedcd3"

#define OSAL_C_STRING_DEVICE_COM1              "/dev/com1"
#define OSAL_C_STRING_DEVICE_COM2              "/dev/com2"  /* @@@@ 21.08.2002 Ka */
#define OSAL_C_STRING_DEVICE_DEBUG             "/dev/debug"
#define OSAL_C_STRING_DEVICE_DIGITAL_AUDIO     "/dev/digitalaudio" /* @@@@ 21.08.2002 Ka */
#define OSAL_C_STRING_DEVICE_DIGITAL_SPEECH    "/dev/digitalspeech" /* @@@@ 21.08.2002 Ka */

#ifdef VARIANT_S_FTR_ENABLE_FFS_3_4_5
 #define OSAL_C_STRING_DEVICE_FFS3             "/dev/ffs3"  /* @@@@ 17.06.2003 Storre */
 #define OSAL_C_STRING_DEVICE_FFS4             "/dev/ffs4"  /* @@@@ 20.09.2003 MRK */
 #define OSAL_C_STRING_DEVICE_FFS5             "/dev/ffs5"  /* @@@@ 20.09.2003 MRK */
#elif defined VARIANT_S_FTR_ENABLE_FFS_3_4
 #define OSAL_C_STRING_DEVICE_FFS3             "/dev/ffs3"  /* @@@@ 17.06.2003 Storre */
 #define OSAL_C_STRING_DEVICE_FFS4             "/dev/ffs4"  /* @@@@ 20.09.2003 MRK */
#else
#if defined VARIANT_S_FTR_ENABLE_FFS_4
 #define OSAL_C_STRING_DEVICE_FFS4             "/dev/ffs4"  /* @@@@ 20.09.2003 MRK */
#endif
#endif


#ifdef VARIANT_S_FTR_ENABLE_TFFS
 #define OSAL_C_STRING_DEVICE_TFFS             "/dev/tffs"  /* @@@@ 20.09.2003 MRK */
#endif // #ifdef VARIANT_S_FTR_ENABLE_TFFS
#define OSAL_C_STRING_DEVICE_FLASH             "/dev/flash" /* @@@@ 21.08.2002 Ka */
#define OSAL_C_STRING_DEVICE_GYRO              "/dev/gyro"
#define OSAL_C_STRING_DEVICE_ACC              "/dev/acc"
#define OSAL_C_STRING_DEVICE_ABS              "/dev/abs"
#define OSAL_C_STRING_DEVICE_ADR3CTRL         "/dev/adr3ctrl"

#define OSAL_C_STRING_DEVICE_HWID              "/dev/hwid"  /* @@@@ 21.08.2002 Ka */
#define OSAL_C_STRING_DEVICE_MP3               "/dev/mp3"
#define OSAL_C_STRING_DEVICE_ODOMETER          "/dev/odometer"
#define OSAL_C_STRING_DEVICE_OVC               "/dev/ovc_drv" //#Ma
#define OSAL_C_STRING_DEVICE_FFD               "/dev/ffd"     /* 1. 12, 2005 gRh */
#define OSAL_C_STRING_DEVICE_CGI               "/dev/cgi"

#define OSAL_C_STRING_DEVICE_HOST              "/dev/host"  /* @@@@ 20.2.2005 MRK */
#define OSAL_C_STRING_DEVICE_FFS               "/dev/ffs"
#define OSAL_C_STRING_DEVICE_FFS1              "/dev/ffs"     /* @@@@ kos2hi */
#define OSAL_C_STRING_DEVICE_FFS2              "/dev/ffs2"  /* @@@@ 21.08.2002 Ka */
#define OSAL_C_STRING_DEVICE_FFS3              "/dev/ffs3"  /* @@@@ 05.01.2010 HUW */
#define OSAL_C_STRING_DEVICE_RAMDISK           "/dev/ramdisk"  /* @@@@ 21.08.2002 Ka */
#define OSAL_C_STRING_DEVICE_CARD              "/dev/card"
#define OSAL_C_STRING_DEVICE_MMCARD            "/dev/mmcard"
#define OSAL_C_STRING_DEVICE_CARD1             "/dev/card1"
#define OSAL_C_STRING_DEVICE_CARD2             "/dev/card2"
#define OSAL_C_STRING_DEVICE_CARD3             "/dev/card3"
#define OSAL_C_STRING_DEVICE_CARDX             "/dev/card%d"


#define OSAL_C_STRING_DEVICE_CRYPTCARD         "/dev/cryptcard"
#define OSAL_C_STRING_DEVICE_CRYPTNAVROOT      "/dev/cryptnavroot"
#define OSAL_C_STRING_DEVICE_CRYPTNAV          "/dev/cryptnav"

#define OSAL_C_STRING_DEVICE_REGISTRY          "/dev/registry" /* @@@@ 21.08.2002 Ka */
#define OSAL_C_STRING_DEVICE_RPM               "/dev/rpm"
#define OSAL_C_STRING_DEVICE_SFLASH            "/dev/sflash"
#define OSAL_C_STRING_DEVICE_SPEECH            "/dev/speech"
#define OSAL_C_STRING_DEVICE_SPI               "/dev/spi"
#define OSAL_C_STRING_DEVICE_SPI1              "/dev/spi1"   /* @@@@ 021031 kos2hi */ //c.k. 180505 see  'OSAL_C_STRING_DEVICE_SPI1_DCR4'- this file!
#define OSAL_C_STRING_DEVICE_SPI2              "/dev/spi2"   /* @@@@ 021031 kos2hi */
#define OSAL_C_STRING_DEVICE_TRACE             "/dev/trace"
#define OSAL_C_STRING_DEVICE_GPS               "/dev/gps"
#define OSAL_C_STRING_DEVICE_GNSS               "/dev/gnss"
#define OSAL_C_STRING_DEVICE_AUDIO_IN          "/dev/audioin"
#define OSAL_C_STRING_DEVICE_USB_DNL           "/dev/usb_dnl"

#define OSAL_C_STRING_DEVICE_PRM               "/dev/prm"

#define OSAL_C_STRING_DEVICE_ACOUSTIC_IF_SRC       "/dev/acoustic/src" /* 08.10.2012 RBEI/ECF5 Niyatha */
#define OSAL_C_STRING_DEVICE_ACOUSTICOUT_IF_DATA       "/dev/acousticout/data" /* 11.08.2010 RBEI/ECF1 Badarivishal*/
#define OSAL_C_STRING_DEVICE_ACOUSTICOUT_IF_DATA_TEST  "/dev/acousticout/datatest" /* 11.08.2010 RBEI/ECF1 Badarivishal*/
#define OSAL_C_STRING_DEVICE_ACOUSTICOUT_IF_SPEECH       "/dev/acousticout/speech" /* 24.11.2005 RBIN/EDI4 Vinod*/
#define OSAL_C_STRING_DEVICE_ACOUSTICOUT_IF_MUSIC        "/dev/acousticout/music"  /* 24.11.2005 RBIN/EDI4 Vinod*/
#define OSAL_C_STRING_DEVICE_ACOUSTICIN_IF_SPEECHRECO    "/dev/acousticin/speech" /*25.01.2006 RBIN/EDI4 Vinod*/
#define OSAL_C_STRING_DEVICE_ACOUSTICIN_IF_DATA    		"/dev/acousticin/data" /*12.08.2010 RBEI/ECF1 Badarivishal*/
#define OSAL_C_STRING_DEVICE_ACOUSTICIN_IF_DATA_TEST    "/dev/acousticin/datatest" /*12.08.2010 RBEI/ECF1 Badarivishal*/
#define OSAL_C_STRING_DEVICE_ACOUSTICECNR_IF_SPEECHRECO    "/dev/acousticecnr/speech" /*04.01.2014 RBEI/ECF5 Suryachand*/

#define OSAL_C_STRING_DEVICE_AUDIO_OUT         "/dev/audioout"
#define OSAL_C_STRING_DEVICE_KDS               "/dev/kds"    /* @@@@ 26.03.2003 Ka */
#define OSAL_C_STRING_DEVICE_ERRMEM            "/dev/errmem" /* @@@@ 12.05.2003 Ka */
#define OSAL_C_STRING_DEVICE_SPEECHDATA        "/dev/speechdata" /* 21.05.2003 GGS2HI */
#define OSAL_C_STRING_DEVICE_PERF              "/dev/perf"       /* 12.08.2003 SBV2HI */
#define OSAL_C_STRING_DEVICE_RS422             "/dev/rs422"      /* 11.12.2003 SEL2HI */
#define OSAL_C_STRING_DEVICE_RS422MP           "/dev/mapposition"      /* MRK2HI */
#define OSAL_C_STRING_DEVICE_RTC               "/dev/rtc"         /* MRK2HI */
#define OSAL_C_STRING_DEVICE_GPIO			   "/dev/gpio"	/* FZ82LR */
//#define OSAL_C_STRING_DEVICE_IIC               "/dev/i2c"         /* MRK2HI */
#define OSAL_C_STRING_DEVICE_I2C_CPLD_WUP      "/dev/i2c/CPLD_WUP"  /* RWW2HI */
#define OSAL_C_STRING_DEVICE_I2C_CPLD_GPIO     "/dev/i2c/CPLD_GPIO" /* RWW2HI */
#define OSAL_C_STRING_DEVICE_I2C_M24C64        "/dev/i2c/M24C64"  /* DN82LR */
#define OSAL_C_STRING_DEVICE_I2C_TDA7564       "/dev/i2c/tda7564" /* DN82LR */
#define OSAL_C_STRING_DEVICE_I2C_DVS8000       "/dev/i2c/dvs8000"   /* feo2hi */
//@TODO: Add other I2C Devices
#define OSAL_C_STRING_DEVICE_DIAG_CUSTOM       "/dev/diag_custom"      /* MRK2HI */
#define OSAL_C_STRING_DEVICE_DIAG_PROD         "/dev/diag_prod"    /* MRK2HI */
#define OSAL_C_STRING_DEVICE_DIAG_EOL          "/dev/diag/eol"    /* MRK2HI */
#define OSAL_C_STRING_DEVICE_XM_CTRL           "/dev/xm_ctrl"      /* MRK2HI */
#define OSAL_C_STRING_DEVICE_XM_DATA           "/dev/xm_data"      /* MRK2HI */
#define OSAL_C_STRING_DEVICE_UART_0           "/dev/uart/0"      /* hbs2kor */
#define OSAL_C_STRING_DEVICE_UART_1           "/dev/uart/1"      /* hbs2kor */
#define OSAL_C_STRING_DEVICE_UART_2           "/dev/uart/2"      /* hbs2kor */
#define OSAL_C_STRING_DEVICE_UART_3           "/dev/uart/3"      /* hbs2kor */

// Those devices are needed for "former Aftermarket HMI Software":
#define OSAL_C_STRING_DEVICE_MAP_HIGH         "/dev/map_high"    /* @@@@ 21.05.07 kos2hi */
#define OSAL_C_STRING_DEVICE_MAP_CARSOR       "/dev/map_carsor"  /* @@@@ 21.05.07 kos2hi */
#define OSAL_C_STRING_DEVICE_FFSBASE          "/dev/ffsbase"     /* @@@@ 29.06.07 kos2hi */
#define OSAL_C_STRING_DEVICE_SYSCTRL          "/dev/sysctrl"     /* @@@@ 21.05.07 kos2hi */
#define OSAL_C_STRING_DEVICE_TMC               "/dev/tmc"         /* @@@@ 21.05.07 kos2hi */
#define OSAL_C_STRING_DEVICE_TSD               "/dev/tsd"         /* @@@@ 14.02.08 kos2hi */
#define OSAL_C_STRING_DEVICE_VESE              "/dev/vese"        /* 31.01.2012, fit4hi */
#define OSAL_C_STRING_DEVICE_VNV               "/dev/vnv"         /* @@@@ 14.02.08 kos2hi */


#ifdef VARIANT_S_FTR_ENABLE_DIAGLOG_DEVICE
   #define OSAL_C_STRING_DEVICE_DIAGLOG        "/dev/diaglog"
#endif

#define OSAL_C_STRING_DEVICE_SPEECHRECO        "/dev/speechreco"
#define OSAL_C_STRING_DEVICE_AUDIOROUTER       "/dev/audiorouter"

#define OSAL_C_STRING_DEVICE_ACOUSTICOUT_IF_DATA       "/dev/acousticout/data"
#define OSAL_C_STRING_DEVICE_ACOUSTICOUT_IF_SPEECH       "/dev/acousticout/speech"
#define OSAL_C_STRING_DEVICE_ACOUSTICOUT_IF_MUSIC        "/dev/acousticout/music"

#define OSAL_C_STRING_DEVICE_CGI_DEV_KEY                          "/dev/cgi_key"
#define OSAL_C_STRING_DEVICE_CGI_DEV_SPM                          "/dev/cgi_spm"
#define OSAL_C_STRING_DEVICE_CGI_DEV_DIMMING                      "/dev/cgi_dimming"
#define OSAL_C_STRING_DEVICE_CGI_DEV_DIAG                         "/dev/cgi_diag"
#define OSAL_C_STRING_DEVICE_CGI_DEV_KEY_FTD                      "/dev/cgi_key_ftd"
#define OSAL_C_STRING_DEVICE_CGI_DEV_DIMMING_FTD                  "/dev/cgi_dimming_ftd"

#ifdef VARIANT_S_FTR_ENABLE_DRV_CSM
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_CDCHANGER           "/dev/csm/cdchanger"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_EXTERNAL_DISPLAY    "/dev/csm/ext_display"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_EXTERNAL_KEYBOARD   "/dev/csm/ext_keyboard"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_HEADUNIT            "/dev/csm/headunit"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_TELEPHONE           "/dev/csm/telephone"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_CLIMATE_CONTROL     "/dev/csm/climate_control"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_DIMMING             "/dev/csm/dimming"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_SECURITY            "/dev/csm/security"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_AUDIO               "/dev/csm/audio"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_HMI1                "/dev/csm/hmi1"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_HMI2                "/dev/csm/hmi2"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_HMI3                "/dev/csm/hmi3"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_HMI4                "/dev/csm/hmi4"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_HMI5                "/dev/csm/hmi5"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_BAP_KLIMA           "/dev/csm/bap_klima"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_BAP_OPS             "/dev/csm/bap_ops"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_BAP_REARVIEWCAMERA  "/dev/csm/bap_rearviewcamera"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_BAP_TEL             "/dev/csm/bap_tel"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_BAP_PB              "/dev/csm/bap_pb"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_BAP_AMPLIFIER       "/dev/csm/bap_amplifier"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_BAP_MDI             "/dev/csm/bap_mdi"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_BAP_AUDIO           "/dev/csm/bap_audio"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_BAP_NAV_SD          "/dev/csm/bap_nav_sd"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_SPM                 "/dev/csm/spm"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_DIAGLOG             "/dev/csm/diaglog"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_EXTVR               "/dev/csm/extvr"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_AUXCTRL             "/dev/csm/auxctrl"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_DAB                 "/dev/csm/dab"
#define OSAL_C_STRING_DEVICE_CSM_CAN_IF_BAP_OCU             "/dev/csm/bap_ocu"
#endif

#ifdef VARIANT_S_FTR_ENABLE_FGS_FLEXIBLEGRAPHICSYSTEM
#define OSAL_C_STRING_DEVICE_FLEXIBLEGRAPHICSYSTEM_IF_SYSTEM       "/dev/fgs/system"
#define OSAL_C_STRING_DEVICE_FLEXIBLEGRAPHICSYSTEM_IF_MAP          "/dev/fgs/map"
#define OSAL_C_STRING_DEVICE_FLEXIBLEGRAPHICSYSTEM_IF_HMI          "/dev/fgs/hmi"
#define OSAL_C_STRING_DEVICE_FLEXIBLEGRAPHICSYSTEM_IF_TRACE        "/dev/fgs/trace"
#define OSAL_C_STRING_DEVICE_FLEXIBLEGRAPHICSYSTEM_IF_KEYBOARD     "/dev/fgs/keyboard"
#define OSAL_C_STRING_DEVICE_FLEXIBLEGRAPHICSYSTEM_IF_DOWNLOAD     "/dev/fgs/download"
#define OSAL_C_STRING_DEVICE_FLEXIBLEGRAPHICSYSTEM_IF_DIAGNOSIS    "/dev/fgs/diagnosis"
#define OSAL_C_STRING_DEVICE_FLEXIBLEGRAPHICSYSTEM_IF_DIM          "/dev/fgs/dim"
#define OSAL_C_STRING_DEVICE_FLEXIBLEGRAPHICSYSTEM_IF_TEMPERATURE  "/dev/fgs/temperature"
#define OSAL_C_STRING_DEVICE_FLEXIBLEGRAPHICSYSTEM_IF_SHOWALERT    "/dev/fgs/showalert"
#define OSAL_C_STRING_DEVICE_FLEXIBLEGRAPHICSYSTEM_IF_MAP_CARSOR   "/dev/fgs/map_carsor"
#define OSAL_C_STRING_DEVICE_FLEXIBLEGRAPHICSYSTEM_IF_MAP_CTRL     "/dev/fgs/map_ctrl"
#define OSAL_C_STRING_DEVICE_FLEXIBLEGRAPHICSYSTEM_IF_MAP_HIGH     "/dev/fgs/map_high"
#define OSAL_C_STRING_DEVICE_FLEXIBLEGRAPHICSYSTEM_IF_HMI_HIGH     "/dev/fgs/hmi_high"
#define OSAL_C_STRING_DEVICE_FLEXIBLEGRAPHICSYSTEM_IF_BMP_HIGH     "/dev/fgs/bmp_high"
#define OSAL_C_STRING_DEVICE_FLEXIBLEGRAPHICSYSTEM_IF_TESTMANAGER  "/dev/fgs/testmanager"
#endif

/**
device for audio chimes, feature for JLR HLFDF
*/
#define OSAL_C_STRING_DEVICE_FPGA_PCM_PLAYER                     "/dev/fpga/pcm_player"


#ifdef VARIANT_S_FTR_ENABLE_RADIOUNIT_PROXY
#define OSAL_C_STRING_DEVICE_RADIOPROCESSOR_IF_POWER             "/dev/rp_if/power"
#define OSAL_C_STRING_DEVICE_RADIOPROCESSOR_IF_AUDIO             "/dev/rp_if/audio"
#define OSAL_C_STRING_DEVICE_RADIOPROCESSOR_IF_TUNER             "/dev/rp_if/tuner"
#define OSAL_C_STRING_DEVICE_RADIOPROCESSOR_IF_DIAGNOSIS         "/dev/rp_if/diagnosis"
#define OSAL_C_STRING_DEVICE_RADIOPROCESSOR_IF_DIAGNOSIS_INTERN  "/dev/rp_if/diagnosis_int"
#define OSAL_C_STRING_DEVICE_RADIOPROCESSOR_IF_DIAGNOSIS_EXTERN  "/dev/rp_if/diagnosis_ext"
#define OSAL_C_STRING_DEVICE_RADIOPROCESSOR_IF_DOWNLOAD          "/dev/rp_if/download"
#define OSAL_C_STRING_DEVICE_RADIOPROCESSOR_IF_REALTIMECLOCK     "/dev/rp_if/rtc"
#define OSAL_C_STRING_DEVICE_RADIOPROCESSOR_IF_DEBUG             "/dev/rp_if/debug"
#define OSAL_C_STRING_DEVICE_RADIOPROCESSOR_IF_PER               "/dev/rp_if/per"
#define OSAL_C_STRING_DEVICE_RADIOPROCESSOR_IF_DIM               "/dev/rp_if/dim"
#endif

#define OSAL_C_STRING_DEVICE_SPI_CAP       "/dev/spi/cap"       /*21.04.09 feo2hi*/

#ifdef VARIANT_S_FTR_ENABLE_RADIOUNIT_EMBEDDED //c.k. 180505  tbd. adjust feature switches
#define OSAL_C_STRING_DEVICE_SPI1_DCR4     "/dev/spi1/dcr4"      /*01.02.2005 koe2hi*/
#define OSAL_C_STRING_DEVICE_SPI1_DCR3A    "/dev/spi1/dcr3a"     /*01.02.2005 koe2hi*/  //not in use yet
#define OSAL_C_STRING_DEVICE_SPI1_DCR3B    "/dev/spi1/dcr3b"     /*01.02.2005 koe2hi*/  //not in use yet
#define OSAL_C_STRING_DEVICE_SPI1_ADR      "/dev/spi1/adr"       /*01.02.2005 koe2hi*/  //not in use yet
#define OSAL_C_STRING_DEVICE_SPI_HIT       "/dev/spi/hit"

#define OSAL_C_STRING_DEVICE_SPI1_TUNER1   "/dev/spi1/tuner1"     /*01.02.2005 koe2hi*/
#define OSAL_C_STRING_DEVICE_SPI1_TUNER2   "/dev/spi1/tuner2"     /*01.02.2005 koe2hi*/  //not in use yet
#define OSAL_C_STRING_DEVICE_SPI1_TUNER3   "/dev/spi1/tuner3"     /*01.02.2005 koe2hi*/  //not in use yet

#define OSAL_C_STRING_DEVICE_I2C_TDA7564   "/dev/i2c/tda7564"     /*16.03.2005 abr*/


#define OSAL_C_STRING_DEVICE_RADIOPROCESSOR_IF_POWER            "/dev/rp_if/power"
#define OSAL_C_STRING_DEVICE_RADIOPROCESSOR_IF_AUDIO            "/dev/rp_if/audio"
#define OSAL_C_STRING_DEVICE_RADIOPROCESSOR_IF_TUNER            "/dev/rp_if/tuner"
#define OSAL_C_STRING_DEVICE_RADIOPROCESSOR_IF_AUDIO4AMFM_AUD   "/dev/rp_if/audcrlib"
#define OSAL_C_STRING_DEVICE_RADIOPROCESSOR_IF_TUNER4AMFM_AUD   "/dev/rp_if/tuncrlib"

#endif
#define OSAL_C_STRING_DEVICE_SPM           "/dev/spm"
#define OSAL_C_STRING_DEVICE_VOLT          "/dev/volt"
#define OSAL_C_STRING_DEVICE_WUP           "/dev/wup"
#define OSAL_C_STRING_DEVICE_WDG           "/dev/wdg"
#define OSAL_C_STRING_DEVICE_DEVINFO       "/dev/devinfo"
#define OSAL_C_STRING_DEVICE_SUPERVISION   "/dev/supervision"
#define OSAL_C_STRING_DEVICE_I2C_TPS65010  "/dev/i2c/tps65010"    /*16.03.2005 abr*/ /*just for I2C Test using OSK not relevant for radio_unit embedded*/
#define OSAL_C_STRING_DEVICE_I2C_ISP1301   "/dev/i2c/isp1301"    /*18.07.2005 abr*/ /*just for I2C Test using APEP not relevant for radio_unit embedded*/
#define OSAL_C_STRING_DEVICE_I2C_IPOD_ACP  "/dev/i2c/ipod_acp"   /* hka2kor: Apple Chip i.e. Authentication co-porcessor */

#define OSAL_C_STRING_DEVICE_I2C_ADV1          "/dev/i2c/adv1" /* hbs2kor */
#define OSAL_C_STRING_DEVICE_I2C_ADV2          "/dev/i2c/adv2" /* hbs2kor */
#define OSAL_C_STRING_DEVICE_I2C_FPGA          "/dev/i2c/fpga" /* hbs2kor */

#define OSAL_C_STRING_DEVICE_DAB           "/dev/dab"        /* 24.01.2005 PN82HI */
#define OSAL_C_STRING_DEVICE_DAB2          "/dev/dab2"       /* 05.04.2005 SBV2HI */
#define OSAL_C_STRING_DEVICE_DAB3          "/dev/dab3"       /* 05.04.2005 SBV2HI */

#define OSAL_C_STRING_DEVICE_DIAG_PROD_PROXY          "/dev/diag_prod_proxy"  /* 07.09.2005 tst */
#define OSAL_C_STRING_DEVICE_DIAG_CUSTOM_PROXY        "/dev/diag_custom_proxy"  /* 05.10.2005 tst */
#define OSAL_C_STRING_DEVICE_DIAG_CUSTOM_VAG          "/dev/diag_custom_vag"  /* 05.06.2007 gib2hi */
#define OSAL_C_STRING_DEVICE_DIAG_PROD_USB            "/dev/diag_prod_usb"  /* 14.12.2005 tst */

#define OSAL_C_STRING_DEVICE_GPIO          "/dev/gpio"
#define OSAL_C_STRING_DEVICE_STEERING_WHEEL           "/dev/steering_wheel"
/* --to be continued ... */

#define OSAL_C_STRING_DEVICE_USBH          "/dev/usbh"
#define OSAL_C_STRING_DEVICE_IPOD          "/dev/ipod"
#define OSAL_C_STRING_DEVICE_USBMS         "/dev/usbms"
#define OSAL_C_STRING_DEVICE_USB          OSAL_C_STRING_DEVICE_USBMS

#define OSAL_C_STRING_DEVICE_RTC           "/dev/rtc"        /* oej2hi 2005-06-18 */
#define OSAL_C_STRING_DEVICE_CHENC         "/dev/chenc"      /* oej2hi 2005-09-06 */

/* oej2hi 2005-11-21 */
#define OSAL_C_STRING_DEVICE_ADC_CONFIG "/dev/adc/config"
#define OSAL_C_STRING_DEVICE_ADC_0      "/dev/adc/0"
#define OSAL_C_STRING_DEVICE_ADC_1      "/dev/adc/1"
#define OSAL_C_STRING_DEVICE_ADC_2      "/dev/adc/2"
#define OSAL_C_STRING_DEVICE_ADC_3      "/dev/adc/3"
#define OSAL_C_STRING_DEVICE_ADC_4      "/dev/adc/4"
#define OSAL_C_STRING_DEVICE_ADC_5      "/dev/adc/5"
#define OSAL_C_STRING_DEVICE_ADC_6      "/dev/adc/6"
#define OSAL_C_STRING_DEVICE_ADC_7      "/dev/adc/7"
#define OSAL_C_STRING_DEVICE_ADC_8      "/dev/adc/8"
#define OSAL_C_STRING_DEVICE_ADC_9      "/dev/adc/9"
#define OSAL_C_STRING_DEVICE_ADC_10     "/dev/adc/10"
#define OSAL_C_STRING_DEVICE_ADC_11     "/dev/adc/11"
#define OSAL_C_STRING_DEVICE_ADC_12     "/dev/adc/12"
#define OSAL_C_STRING_DEVICE_ADC_13     "/dev/adc/13"
#define OSAL_C_STRING_DEVICE_ADC_14     "/dev/adc/14"
#define OSAL_C_STRING_DEVICE_ADC_15     "/dev/adc/15"
#define OSAL_C_STRING_DEVICE_ADC_16      "/dev/adc/16"
#define OSAL_C_STRING_DEVICE_ADC_17     "/dev/adc/17"
#define OSAL_C_STRING_DEVICE_ADC_18     "/dev/adc/18"
#define OSAL_C_STRING_DEVICE_ADC_19     "/dev/adc/19"
#define OSAL_C_STRING_DEVICE_ADC_20     "/dev/adc/20"
#define OSAL_C_STRING_DEVICE_ADC_21     "/dev/adc/21"
#define OSAL_C_STRING_DEVICE_ADC_22     "/dev/adc/22"
#define OSAL_C_STRING_DEVICE_ADC_23     "/dev/adc/23"

/*** ADC alias device names *****************************************/
#define OSAL_C_STRING_DEVICE_ADC_GYRO_R       "/dev/adc/gyro_r"
#define OSAL_C_STRING_DEVICE_ADC_GYRO_S     "/dev/adc/gyro_s"
#define OSAL_C_STRING_DEVICE_ADC_GYRO_T      "/dev/adc/gyro_t"
#define OSAL_C_STRING_DEVICE_ADC_GPS_UANT       "/dev/adc/gps_uant"
#define OSAL_C_STRING_DEVICE_ADC_GPS_UTMP       "/dev/adc/gps_utmp"
#define OSAL_C_STRING_DEVICE_ADC_GPS_VOLTAGE_SENSE "/dev/adc/gps_voltage_sense"
#define OSAL_C_STRING_DEVICE_ADC_UBAT_DROP_DET  "/dev/adc/ubat_drop_det"
#define OSAL_C_STRING_DEVICE_ADC_AMP_CLIP       "/dev/adc/amp_clip"
#define OSAL_C_STRING_DEVICE_ADC_DIAG_DAB_PHANTOM_ANT "/dev/adc/diag_dab_phantom_ant"
#define OSAL_C_STRING_DEVICE_ADC_DIAG_PHANTOM1_ANT    "/dev/adc/diag_phantom1_ant"
#define OSAL_C_STRING_DEVICE_ADC_DIAG_PHANTOM2_ANT    "/dev/adc/diag_phantom2_ant"
#define OSAL_C_STRING_DEVICE_ADC_CRADLE_KEY           "/dev/adc/cradle_key"
#define OSAL_C_STRING_DEVICE_ADC_CRADLE_DIAG          "/dev/adc/cradle_diag"
#define OSAL_C_STRING_DEVICE_ADC_MIC_DIAG             "/dev/adc/mic_diag"
#define OSAL_C_STRING_DEVICE_ADC_MIC_DIAG_2           "/dev/adc/mic_diag_2"
#define OSAL_C_STRING_DEVICE_ADC_TEMP_SENSE           "/dev/adc/temp_sense"
#define OSAL_C_STRING_DEVICE_ADC_DIAG_AUX_R			  "/dev/adc/diag_aux_r"
#define OSAL_C_STRING_DEVICE_ADC_DIAG_AUX_L			  "/dev/adc/diag_aux_l"
#define OSAL_C_STRING_DEVICE_ADC_TEMP_SENSOR_1		  "/dev/adc/temp_sensor_1"
#define OSAL_C_STRING_DEVICE_ADC_TEMP_SENSOR_2		  "/dev/adc/temp_sensor_2"
#define OSAL_C_STRING_DEVICE_ADC_DIAG_PHANTOM_ANT	  "/dev/adc/diag_phantom_ant"
#define OSAL_C_STRING_DEVICE_ADC_PWM_AMP_DIAG		  "/dev/adc/pwm_amp_diag"
#define OSAL_C_STRING_DEVICE_ADC_PWM_DISPLAY_DIAG	  "/dev/adc/pwm_display_diag"
#define OSAL_C_STRING_DEVICE_ADC_STEERING_WHEEL	      "/dev/adc/steering_wheel"
#define OSAL_C_STRING_DEVICE_ADC_U33S_CPU_SWC		  "/dev/adc/swc_cpu_u33s"
#define OSAL_C_STRING_DEVICE_ADC_FAN_DIAG         "/dev/adc/fan_diag"
#define OSAL_C_STRING_DEVICE_ADC_TEMP_GPS         "/dev/adc/temp_gps"   /*rai5cob*///new inputmux channel
#define OSAL_C_STRING_DEVICE_ADC_HALFCLASS_1         "/dev/adc/halfclass_1" /*rai5cob*///new inputmux channel
#define OSAL_C_STRING_DEVICE_ADC_HALFCLASS_2         "/dev/adc/halfclass_2" /*rai5cob*///new inputmux channel
#define OSAL_C_STRING_DEVICE_ADC_DIAG_PHANTOM_FM_ANT "/dev/adc/diag__phantom_fm_ant" /*rai5cob*///new inputmux channel
#define OSAL_C_STRING_DEVICE_ADC_DISP_TEMP_SENSE           "/dev/adc/disp_temp_sense" /*rai5cob*///new inputmux channel
#define OSAL_C_STRING_DEVICE_ADC_GER_VAR       			"/dev/adc/ger_var" /*rai5cob*///new inputmux channel
#define OSAL_C_STRING_DEVICE_ADC_GPS_PHANTOM_DIAG     "/dev/adc/gps_phantom_diag"/*rai5cob*/
#define OSAL_C_STRING_DEVICE_ADC_PHANTOM_2_DIAG	      "/dev/adc/phantom_2_diag"/*rai5cob*/
#define OSAL_C_STRING_DEVICE_ADC_MAX16946_SENS        "/dev/adc/max16946_sens"
#define OSAL_C_STRING_DEVICE_ADC_TLF4277_CSO          "/dev/adc/tlf4277_cso"
#define OSAL_C_STRING_DEVICE_ADC_JACK_DETECT          "/dev/adc/jack_detect"
#define OSAL_C_STRING_DEVICE_ADC_TLF4277_CSO_2          "/dev/adc/tlf4277_cso_2"

#define OSAL_C_STRING_DEVICE_ADC_SWC_A				      "/dev/adc/swc_a"/*rai5cob*/
#define OSAL_C_STRING_DEVICE_ADC_SWC_B			 	      "/dev/adc/swc_b"/*rai5cob*/
#define OSAL_C_STRING_DEVICE_ADC_TOUCH_X_CO 		      "/dev/adc/touch_x"/*rai5cob*/
#define OSAL_C_STRING_DEVICE_ADC_TOUCH_Y_CO 		      "/dev/adc/touch_y"/*rai5cob*/
#define OSAL_C_STRING_DEVICE_ADC_XM_DAB_ANT_I_SENSE   "/dev/adc/xm_dab_ant_i_sense"/*rai5cob*/
#define OSAL_C_STRING_DEVICE_ADC_CAMERA_VCC_DIAG      "/dev/adc/camera_vcc_diag"/*rai5cob*/
#define OSAL_C_STRING_DEVICE_ADC_MIC_VCC_DIAG         "/dev/adc/mic_vcc_diag"/*rai5cob*/
#define OSAL_C_STRING_DEVICE_ADC_GYRO_VDD_REF         "/dev/adc/gyro_vdd_ref" /*sga5kor*/
#define OSAL_C_STRING_DEVICE_ADC_TPS7B7702_1_SENS1  "/dev/adc/tps7b7702_1_sens1" /*knk9kor*/ 
#define OSAL_C_STRING_DEVICE_ADC_TPS7B7702_1_SENS2  "/dev/adc/tps7b7702_1_sens2" /*knk9kor*/

//ADDED FOR GEN3 TESTING PURPOSE
#define OSAL_C_STRING_DEVICE_ADC_TEST_1         "/dev/adc/test1" /*rab3cob*/
#define OSAL_C_STRING_DEVICE_ADC_TEST_2         "/dev/adc/test2" /*rab3cob*/
#define OSAL_C_STRING_DEVICE_ADC_TEST_3         "/dev/adc/test3" /*rab3cob*/
#define OSAL_C_STRING_DEVICE_ADC_TEST_4         "/dev/adc/test4" /*rab3cob*/
#define OSAL_C_STRING_DEVICE_ADC_TEST_5         "/dev/adc/test5" /*rab3cob*/


#define OSAL_C_STRING_DEVICE_PRAM                     "/dev/pram"
#define OSAL_C_STRING_DEVICE_PRAM_ERRMEM              "/dev/pram/errmem"

//added by hk72hi on 21/01/08
/* Note: there are 3 more signals missing. i.e. UBAT_SENSE, GYRO_RATE_OUT and GYRO_VDD_REF.
     These 3 are a little different. They are used by internal drivers (gyro and cvm) and must not be accessed by applications.
     Therefore better keep them invisible. */
#define OSAL_C_STRING_DEVICE_ADC_AUX_IN_DIAG           "/dev/adc/aux_in_diag"
//added by hka2kor on 28/10/2008. Application: fc_heatcontrol.
#define OSAL_C_STRING_DEVICE_ADC_DISPLAY_TEMP           "/dev/adc/display_temp"

#define OSAL_C_STRING_DEVICE_ADC_UBAT_SENSE             "/dev/adc/ubat_sense"

/********************************************************************/

#define OSAL_C_STRING_DEVICE_BLUETOOTH "/dev/bluetooth"	/*vij7kor*/
#define OSAL_C_STRING_DEVICE_COM "/dev/com" 		/*vij7kor*/

#define OSAL_C_STRING_DEVICE_PWM0 "/dev/pwm0"
#define OSAL_C_STRING_DEVICE_PWM1 "/dev/pwm1"
#define OSAL_C_STRING_DEVICE_PWM2 "/dev/pwm2"
#define OSAL_C_STRING_DEVICE_PWM3 "/dev/pwm3"
#define OSAL_C_STRING_DEVICE_PWM4 "/dev/pwm4"
#define OSAL_C_STRING_DEVICE_PWM5 "/dev/pwm5"
#define OSAL_C_STRING_DEVICE_PWM6 "/dev/pwm6"
#define OSAL_C_STRING_DEVICE_PWM7 "/dev/pwm7"
#define OSAL_C_STRING_DEVICE_PWM8 "/dev/pwm8"
#define OSAL_C_STRING_DEVICE_PWM9 "/dev/pwm9"
#define OSAL_C_STRING_DEVICE_PWM10 "/dev/pwm10"
#define OSAL_C_STRING_DEVICE_PWM11 "/dev/pwm11"
#define OSAL_C_STRING_DEVICE_PWM12 "/dev/pwm12"

/*---- Alias name for PWM start---- */ //anc3kor

#define OSAL_C_STRING_DEVICE_PWM_TEST_LED1 	"/dev/pwm/test_led1"
#define OSAL_C_STRING_DEVICE_PWM_TEST_LED2 	"/dev/pwm/test_led2"

#define OSAL_C_STRING_DEVICE_PWM_SNT_SYNC_FREQ  "/dev/pwm/snt_sync_freq"
#define OSAL_C_STRING_DEVICE_PWM_AMP_CONTROL 	"/dev/pwm/amp_control"

#define OSAL_C_STRING_DEVICE_PWM_FLICKER "/dev/pwm/flicker"
#define OSAL_C_STRING_DEVICE_PWM_MICADC_CLOCK  "/dev/pwm/micadc"
/*---- Alias name for PWM End---- */

/*-----PWM_IN Device--------------------*/
#define OSAL_C_STRING_DEVICE_PWM_IN "/dev/pwm_in" /*rai5cob*/

#define OSAL_C_STRING_DEVICE_TIMER0 "/dev/timer0"
#define OSAL_C_STRING_DEVICE_TIMER1 "/dev/timer1"
#define OSAL_C_STRING_DEVICE_TIMER2 "/dev/timer2"
#define OSAL_C_STRING_DEVICE_TIMER3 "/dev/timer3"

#define OSAL_C_STRING_DEVICE_ILLUMINATION "/dev/illumination"
#define OSAL_C_STRING_DEVICE_TIMER_FAN  "/dev/timer/fan"
#define OSAL_C_STRING_DEVICE_PANACDC         "/dev/panacdc"
#define OSAL_C_STRING_DEVICE_TIMER_RADIOUNIT_MICSEC_DELAY    "/dev/timer/radiotimer_us"
#define OSAL_C_STRING_DEVICE_FREQ_ANALYSE "/dev/timer/freq_analyse" /*mmu2kor*/
#define OSAL_C_STRING_DEVICE_MATRIX_KEYPAD  "/dev/matrix_keypad"
#define OSAL_C_STRING_DEVICE_ROTARY_ENCODER  "/dev/rotencoder"   /*LCN2KAI . 15.2.2012 . asa5cob*/
#define OSAL_C_STRING_DEVICE_TOUCHSCREEN  "/dev/touchscreen"
#define OSAL_C_STRING_DEVICE_SWC            "/dev/swc"

#define OSAL_C_STRING_DEVICE_CRADLE_KEYS  "/dev/cradle/keys"
#define OSAL_C_STRING_DEVICE_CRADLE_PHONE "/dev/cradle/phone"


/*** Feature alias devices ****************************************************************/
/* From application view, a feature alias device is used to test if a feature is available on
   the current HW sample and to access the related device it it is available.
   The application tests the result to "open" to detect if the feature is available.

   From platform view, a feature alias device is used to configure if a feature is available on
   the current HW sample. An alias device must be mapped to a real device in the alias table, otherwise "open" fails.
 */

/* feature alias devices that are available on VW DXYplus only:
   Bluetooth, Cradle, RVC, DAB */
#define OSAL_C_STRING_DEVICE_ALIAS_BLUETOOTH     "/dev/alias/bluetooth"
#define OSAL_C_STRING_DEVICE_ALIAS_CRADLE_KEYS   "/dev/alias/cradle/keys"
#define OSAL_C_STRING_DEVICE_ALIAS_CRADLE_PHONE  "/dev/alias/cradle/phone"
#define OSAL_C_STRING_DEVICE_ALIAS_RVC           "/dev/alias/rvc"
#define OSAL_C_STRING_DEVICE_ALIAS_DAB           "/dev/alias/dab"

/* feature alias devices for NISSAN:
   FmTwinTuner is europe only, SubWoofer is NA only*/
#define OSAL_C_STRING_DEVICE_ALIAS_FM_TWINTUNER     "/dev/alias/fm_twintuner"
#define OSAL_C_STRING_DEVICE_ALIAS_SUBWOOFER        "/dev/alias/subwoofer"

/*** alias stub device *****************************************/
/* Even if no real driver is required to support a feature, a feature alias device may be used to configure if
   a feature is available on a HW sample.
   In this case the feature alias device is mapped to the alias device stub if the feature is available.
*/

#define OSAL_C_STRING_DEVICE_ALIAS_STUB               "/dev/zero"
#define OSAL_C_STRING_DEVICE_RMS "/dev/rms"

/*===========================================================================*/
/* Devices on ADR3 chip, connected by SSI32 interface (IPN driver)           */
/*---------------------------------------------------------------------------*/
#define OSAL_C_STRING_DEVICE_ADR3_DAB_TUNER "/dev/adr3/dab_tuner"
#define OSAL_C_STRING_DEVICE_ADR3_FMAM_TUNER  "/dev/adr3/fmam_tuner"
#define OSAL_C_STRING_DEVICE_ADR3_DOWNLOAD  "/dev/adr3/download"
/*===========================================================================*/

#endif
/*** END OF FILE *************************************************************/
