/***************************************************************************
 * .EXPORT_ME
 * FILE:         osdefine.h
 * PROJECT:      VASCO
 * SW-COMPONENT: OSAL
 *--------------------------------------------------------------------------
 * DESCRIPTION:  This is the headerfile for the OS - Abstraction Layer for
 *               defines and constants
 *--------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      |   Modification                   | Author
 * 16.03.00  |   Initial revision               | de Vries,EFT22
 * 10.04.00  |   os_vxworks included            | de Vries, EFT22
 *           |                                  |
 * 17.05.00  |   tasks deleted, Threads         | de Vries, EFT22
 *           |   and Processes added            |
 *           |                                  |
 * 23.05.00  |   os_values->osdefines new       | Tiemann, EFT42
 * 02.08.00  |   Linux defines added            | Wunderlich, EFT32
 *           |                                  |
 * 14.08.00  |   `L', `U', and `LU' added;      | Wunderlich, EFT32
 *           |   special OSAL_C_U32_INFINITE-   |
 *           |   construct removed for VxWorks  |
 *           |   (look for `>>>')               |
 * 17.01.01  |   changes for WinCE added        | de Vries, EFG32
 * 18.02.02  |   Nucleus defines added          | Uelschen, ESN2
 * 11.04.03  |   increase number of OSAL thread | Kropp, CM-CR/EES4
 *           |   priorities from 64 to 256      |
 *
 **************************************************************************/

#if !defined (OSAL_DEFINE_HEADER)
#define OSAL_DEFINE_HEADER
#define OSAL_OSAL_HEADER


#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************/
/* defines and constants                                                  */
/**************************************************************************/

/* -- OSAL version, corresponding to "Referenzhandbuch": */

#define OSAL_API_V0100 ((tU32)0x0100)
#define OSAL_API_V0200 ((tU32)0x0200)

#define OSAL_VERSION         OSAL_API_V0200

/* -- LINT: Use if paramter should be neglected without LINT objection */
#define OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(x) (void)(x);

/* -- Maximum and minimum values of a data type: */
#define OSAL_C_S8_MAX        ((tS8)   127)
#define OSAL_C_S8_MIN        ((tS8)  -OSAL_C_S8_MAX-1)
#define OSAL_C_S16_MAX       ((tS16)  32767)
#define OSAL_C_S16_MIN       ((tS16) -OSAL_C_S16_MAX-1)
#define OSAL_C_S32_MAX       ((tS32)  2147483647)
#define OSAL_C_S32_MIN       ((tS32) -OSAL_C_S32_MAX-1)

#define OSAL_C_U8_MAX        ((tU8)  255U)
#define OSAL_C_U16_MAX       ((tU16) 65535U)
#define OSAL_C_U32_MAX       ((tU32) 4294967295U)
#define OSAL_C_U64_MAX       ((tU64) 0xFFFFFFFFFFFFFFFFULL)

#include "float.h"
#define OSAL_C_FLOAT_MIN      ((tFloat)FLT_MIN)
#define OSAL_C_FLOAT_MAX      ((tFloat)FLT_MAX)
#define OSAL_C_DOUBLE_MIN     ((tDouble)DBL_MIN)
#define OSAL_C_DOUBLE_MAX     ((tDouble)DBL_MAX)

/* -- Kleinster Wert x mit 1.0+x != x (Epsilonumgebung). */

#define OSAL_C_FLOAT_EPSILON
#define OSAL_C_DOUBLE_EPSILON

/* --Mathematische Konstanten. */
#define OSAL_C_DOUBLE_PI      (3.14159265358979323846)

/* -- Minimale und maximale Prioritaeten von Threads */
#define OSAL_C_U32_THREAD_PRIORITIES   ((tU32) 255)


#if OSAL_OS==OSAL_TENGINE

#define OSAL_C_U32_THREAD_PRIORITY_HIGHEST ((tU32) 1)
#define OSAL_C_U32_THREAD_PRIORITY_NORMAL  ((tU32) 70)
#define OSAL_C_U32_THREAD_PRIORITY_LOWEST  ((tU32) 140)

#elif OSAL_OS == OSAL_LINUX

#define OSAL_C_U32_THREAD_PRIORITY_HIGHEST ((tU32) 99)
#define OSAL_C_U32_THREAD_PRIORITY_NORMAL  ((tU32) 60)
#define OSAL_C_U32_THREAD_PRIORITY_LOWEST  ((tU32) 20)
   
#elif OSAL_OS == OSAL_DARWIN

#define OSAL_C_U32_THREAD_PRIORITY_HIGHEST ((tU32) 40)
#define OSAL_C_U32_THREAD_PRIORITY_NORMAL  ((tU32) 30)
#define OSAL_C_U32_THREAD_PRIORITY_LOWEST  ((tU32) 20)

#elif OSAL_OS == OSAL_WINCE

#define OSAL_C_U32_THREAD_PRIORITY_HIGHEST ((tU32) 250)
#define OSAL_C_U32_THREAD_PRIORITY_NORMAL  ((tU32) 252)
#define OSAL_C_U32_THREAD_PRIORITY_LOWEST  ((tU32) 255)

#else

#define OSAL_C_U32_THREAD_PRIORITY_HIGHEST ((tU32) 0)
#define OSAL_C_U32_THREAD_PRIORITY_NORMAL  ((tU32) 127)
#define OSAL_C_U32_THREAD_PRIORITY_LOWEST  ((tU32) 255)

#endif


#if OSAL_OS==OSAL_WINCE
/* -- Minimale und maximale Prioritaeten von Prozessen */
#define OSAL_C_U32_PROCESS_PRIORITY_HIGHEST ((tU32) 0)
#define OSAL_C_U32_PROCESS_PRIORITY_NORMAL  ((tU32) 1)
#define OSAL_C_U32_PROCESS_PRIORITY_LOWEST  ((tU32) 2)
#endif

#define OSAL_NULL                (0)
#define OSAL_C_U32_INFINITE      OSAL_C_U32_MAX
#define OSAL_C_INVALID_HANDLE    ((tU32)0xFFFFFFFF)

#define OSAL_C_TIMEOUT_FOREVER			OSAL_C_U32_INFINITE
#define OSAL_C_TIMEOUT_NOBLOCKING   OSAL_NULL

/* --Eigene, nicht reale, Prozess bzw. Threadid. */

#define OSAL_C_PROCESS_ID_SELF			OSAL_NULL
#define OSAL_C_THREAD_ID_SELF			OSAL_NULL

/* --Maximale Lnge eines Namens (tString) fr Ressourcen (Semaphore, Messagequeues, ...) */

#define OSAL_C_U32_MAX_NAMELENGTH		((tU32)32)

/* --Maximale Lnge eines Dateinamens (z.Zt. Annahme 8.3, Pfad mit / am Ende) . */

#define OSAL_C_U32_MAX_FILENAMELENGTH     ((tU32)14)


/* --Standardeingabe, -ausgabe und -fehler */
#define OSAL_C_FD_STANDARDIN		(0)
#define OSAL_C_FD_STANDARDOUT		(1)
#define OSAL_C_FD_STANDARDERROR		(2)

/* --OS Dependent Definitions */

/**************************************************************************/
/* VXWORKS                                                                */
/**************************************************************************/
#if (OSAL_OS==OSAL_VXWORKS)

#include "os_vxworks.h"

#define OSAL_OK    ((tS32) OK)
#define OSAL_ERROR ((tS32) ERROR)

/* The following special construct should not be necessary anymore,
   because of `UL' at OSAL_C_U32_MAX.
   >>> To be checked for VxWorks.
   If it is still necessary, re-activate it.
   And no hard feelings in this case, Hermann! */
#if 0
#undef  OSAL_C_U32_INFINITE
#define OSAL_C_U32_INFINITE 0xffffffff /* I don't know why, compiler warning */
#endif

/**************************************************************************/
/* RX732                                                                  */
/**************************************************************************/
#elif (OSAL_OS==OSAL_RX732)

#define OSAL_OK     ((tS32)  0)
#define OSAL_ERROR  ((tS32) -1)

/**************************************************************************/
/* WIN NT/CE                                                              */
/**************************************************************************/
#elif (OSAL_OS==OSAL_WINNT || OSAL_OS==OSAL_WINCE || OSAL_OS==OSAL_NUCLEUS || OSAL_OS==OSAL_TENGINE)

#define OSAL_OK     ((tS32)  0)
#define OSAL_ERROR  ((tS32) -1)


/**************************************************************************/
/* Linux                                                                  */
/**************************************************************************/
#elif (OSAL_OS==OSAL_LINUX)

#define OSAL_OK     ((tS32)  0)
#define OSAL_ERROR  ((tS32) -1)

/**************************************************************************/
/* Darwin                                                                 */
/**************************************************************************/
#elif (OSAL_OS==OSAL_DARWIN)
   
#define OSAL_OK     ((tS32)  0)
#define OSAL_ERROR  ((tS32) -1)

#else
#error wrong OSAL_OS :-(
#endif


#ifdef __cplusplus
}
#endif


#endif


/* EOF */

