/************************************************************************
 * .EXPORT_ME
 * FILE:         osconfig.h
 * PROJECT:      VASCO
 * SW-COMPONENT: OSAL
 *----------------------------------------------------------------------
 * DESCRIPTION:  This file defines the various switches to configure 
 *               the osal sources. See beyond for more details.               
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      | Modification               | Author
 * 04.04.00  | Initial revision           | Uelschen,EFT42
 * 18.02.02  | Nucleus defines added      | Uelschen, ESN2
 * 11.10.05  | Added OSAL_ARMV4 for WinCE | Soj, RBIN
 * 
 *************************************************************************/

#ifndef OSAL_OSCONFIG_HEADER
#define OSAL_OSCONFIG_HEADER


/* HOW TO CONFIGURE THE OPERATING SYSTEM ABSTRACTION LAYER (OSAL)

 To configure the OSAL you have to specify 3-4 compiler switches
 outside this file. It is not a good idea to edit this file. The
 correct way is to call the compiler with the command

 CC [...] -DOSAL_OS=OSAL_VXWORKS -DOSAL_HOST=OSAL_NECVR4100 \
     -DOSAL_ENVIRONMENT=OSAL_GNU [...]

 or something like this. If you are working with MS Visual Studio
 you have to select Project->Settings->C/C++ and edit the preprocessor
 definitions entry like this
 
 [...], OSAL_OS=OSAL_WINNT, OSAL_HOST=OSAL_INTELX86, 
             OSAL_ENVIRONMENT=OSAL_MICROSOFT  
	 
 The following list shows the possible values 
 for the different preprocessor defines. The OSAL_OSVERSION variable 
 is optional and no value is predefined.

 OSAL_OS (mandatory):					OSAL_VXWORKS
							OSAL_WINNT
							OSAL_WINCE
							OSAL_SOLARIS		
							OSAL_LINUX
							OSAL_RX732
							OSAL_NUCLEUS
							OSAL_TENGINE
 
 This variable defines the operating system running OSAL.


				
 OSAL_HOST (mandatory):					OSAL_NECVR4100
							OSAL_NECVR4122
							OSAL_NECV810
							OSAL_INTELX86
							OSAL_ULTRASPARC
							OSAL_ARM720
							OSAL_VR5701
							OSAL_VR5500
							OSAL_CORE2

 This variable defines the cpu of the host running OSAL.



 OSAL_ENVIRONMENT (mandatory):			OSAL_GNU
						OSAL_MICROSOFT
						OSAL_SUN
						OSAL_GREENHILLS
						OSAL_ARMADS

 This variable defines the development environment.
 
  In addition we have to define OSAL_DECL and OSAL_INLINE to get
  smart declarations and definitions for the various plattforms:

   OSAL_DECL using in order to call the functions from a dll (Win NT)
   OSAL_INLINE declares a special inline command for the gcc (vxWorks)

 Have a lot of fun with OSAL!

*/


/**************************************************************************/
/* defines and makros                                                     */
/**************************************************************************/


#define OSAL_VXWORKS		1
#define OSAL_WINNT			2
#define OSAL_WINCE			3
#define OSAL_SOLARIS		4	
#define OSAL_LINUX			5
#define OSAL_RX732			6
#define OSAL_NECVR4100		7
#define OSAL_NECVR4122		8
#define OSAL_NECV810		9
#define OSAL_INTELX86		10
#define OSAL_ULTRASPARC		11
#define OSAL_GNU			12
#define OSAL_MICROSOFT		13
#define OSAL_SUN			14
#define OSAL_GREENHILLS		15
#define OSAL_VXWORKS2		16
#define OSAL_DBENCH			17
#define OSAL_WINCE_PC       18
#define OSAL_NUCLEUS		19
#define OSAL_ARM720       	20
#define OSAL_ARMADS        	21

#define OSAL_TENGINE       	22
#define OSAL_VR5701         23
#define OSAL_EBINDER        24

#define OSAL_ARMV4         25 /* Soj-RBIN */
#define OSAL_DARWIN			26

/* --CONFIGURATION OF VASCO DEFINE */

/* --SET VASCO IF NOT ALREADY DEFINED */
#if OSAL_OS==OSAL_LINUX && !defined(VASCO_OS_LINUX)
#define VASCO_OS_LINUX
#endif

#if OSAL_OS==OSAL_SOLARIS && !defined(VASCO_OS_SOLARIS)
#define VASCO_OS_SOLARIS
#endif

#if OSAL_OS==OSAL_WINNT && !defined(VASCO_OS_WINNT)
#define VASCO_OS_WINNT
#endif

#if OSAL_OS==OSAL_RX732 && !defined(VASCO_OS_RX732)
#define VASCO_OS_RX732
#endif

#if OSAL_OS==OSAL_VXWORKS && !defined(VASCO_OS_VXWORKS)
#define VASCO_OS_VXWORKS
#endif

#if OSAL_OS==OSAL_WINCE && !defined(VASCO_OS_WINCE)
#define VASCO_OS_WINCE
#endif

#if OSAL_OS==OSAL_NUCLEUS && !defined(VASCO_OS_NUCLEUS)
#define VASCO_OS_NUCLEUS
#endif

#if OSAL_OS==OSAL_TENGINE && !defined(VASCO_OS_TENGINE)
#define VASCO_OS_TENGINE
#endif



/* --CHECK IT */

#ifndef OSAL_OS
#error No OSAL_OS defined!
#endif

#ifndef OSAL_ENVIRONMENT
#error No OSAL_ENVIRONMENT defined!
#endif

#ifndef OSAL_HOST
#error No OSAL_HOST defined!
#endif

#if (OSAL_OS!=OSAL_NUCLEUS && OSAL_OS!=OSAL_VXWORKS && OSAL_OS!=OSAL_WINNT && OSAL_OS!=OSAL_WINCE && OSAL_OS!=OSAL_SOLARIS && OSAL_OS!=OSAL_LINUX 	&& OSAL_OS!=OSAL_RX732 && OSAL_OS!=OSAL_TENGINE && OSAL_OS!=OSAL_DARWIN)
#error OSAL_OS should be OSAL_{NUCLEUS|VXWORKS|WINNT|WINCE|SOLARIS|LINUX|RX732|TENGINE|DARWIN}!
#endif

#if (OSAL_ENVIRONMENT!=OSAL_GNU && OSAL_ENVIRONMENT!=OSAL_MICROSOFT && OSAL_ENVIRONMENT!=OSAL_SUN && OSAL_ENVIRONMENT!=OSAL_GREENHILLS && OSAL_ENVIRONMENT!=OSAL_ARMADS && OSAL_ENVIRONMENT!=OSAL_EBINDER)
#error OSAL_ENVIRONMENT should be OSAL_{ARMADS|GNU|MICROSOFT|SUN|GREENHILLS|EBINDER}!
#endif

#if (OSAL_HOST!=OSAL_NECVR4100 && OSAL_HOST!=OSAL_NECVR4122 && OSAL_HOST!=OSAL_NECV810 && OSAL_HOST!=OSAL_INTELX86 && OSAL_HOST!=OSAL_ARMV4 && OSAL_HOST!=OSAL_ULTRASPARC && OSAL_HOST!=OSAL_ARM720 && OSAL_HOST!=OSAL_VR5701)
#error OSAL_HOST should be OSAL_{ARM720|NECVR4100|NECVR4122|NECV810|INTELX86|OSAL_ARMV4|ULTRASPARC|NECVR5701}!
#endif

/* --SET OSAL_INLINE DEFINES */
#if (OSAL_OS==OSAL_VXWORKS)
#define OSAL_INLINE __inline__
#else
#define OSAL_INLINE __inline
#endif

/* --SET OSAL_FORCEINLINE DEFINES */
#if (OSAL_OS==OSAL_VXWORKS)
#define OSAL_FORCEINLINE __inline__
#elif (OSAL_OS==OSAL_TENGINE)
#define OSAL_FORCEINLINE __inline
#elif (OSAL_OS==OSAL_LINUX) || (OSAL_OS==OSAL_DARWIN)
#define OSAL_FORCEINLINE __inline
#else
#define OSAL_FORCEINLINE __forceinline
#endif

/* --SET OSAL_DECL DEFINES */
#if (OSAL_OS==OSAL_WINNT) || (OSAL_OS==OSAL_WINCE) || (OSAL_OS==OSAL_WINCE_PC)
#define OSAL_DECL  __declspec(dllexport)
#elif (OSAL_OS==OSAL_LINUX) || (OSAL_OS==OSAL_DARWIN)
#define OSAL_DECL __attribute__((visibility ("default")))
#else
#define OSAL_DECL
#endif

	
#endif
