/***************************************************************************
 * .EXPORT_ME
 * FILE:         osansi.h
 * PROJECT:      VASCO
 * SW-COMPONENT: OSAL
 *--------------------------------------------------------------------------
 * DESCRIPTION:  This is the headerfile for the OS - Abstraction Layer for 
 *               Ansi-Functions. This Header has to be included to use the
 *               standard ANSI functions.
 *--------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      | Modification               | Author
 * 20.03.00  | Initial revision           | de Vries,EFT22
 * 04.03.00  | osconfig.h added           | Uelschen, EFT42
 * 04.04.00  | correction in OSAL_String..| de Vries,VSH2HI,EFT22
 * 10.04.00  | Restructuring              | Uelschen, EFT42
 * 25.07.00  | Adapt to new conventions   | Scherber, EFT43
 * 11.08.00  | Linux defines added        | Wunderlich, EFT32
 * 21.09.00  | Corrections of some names  | Uelschen, EFT42
 * 17.01.01  | Changes for WinCE added    | de Vries,now EFG32
 * 20.08.01  | #include <stdio.h> fuer CE | Garrelts, ENS1
 * 18.08.03  | add OSAL_vAssertFunction   | Perick, CM-CR/EES4
 * 11.10.05  | Modfied #includes for WinCE| Soj, RBIN 
 * 19.10.07  | Add OSAL_vAssert for Linux | Soj, RBIN 
 * 
 **************************************************************************/


#if !defined (OSAL_ANSI_HEADER)
  #define OSAL_ANSI_HEADER



/**************************************************************************/
/* includes for VxWorks                                                   */
/**************************************************************************/

#if (OSAL_OS==OSAL_VXWORKS)

#include "stdio.h"
#include "ctype.h"
#include "string.h"
#include "stdlib.h"
#include "assert.h"
#include "math.h"

/**************************************************************************/
/* includes for WinNT                                                     */
/**************************************************************************/

#elif OSAL_OS==OSAL_WINNT || OSAL_OS==OSAL_RX732

#include "stdio.h"
#include "ctype.h"
#include "string.h"
#include "stdlib.h"
#include "assert.h"
#include "stdarg.h"
#include "math.h"

/**************************************************************************/
/* includes for TENGINE                                                   */
/**************************************************************************/

#elif (OSAL_OS==OSAL_TENGINE)
#ifdef PMC_ENVIROMENT
#include "/usr/local/te/tool/Cygwin-i686/lib/gcc-lib/mips64el-unknown-tkernel/3.3.2/include/string.h"
#include "/usr/local/te/tool/Cygwin-i686/lib/gcc-lib/mips64el-unknown-tkernel/3.3.2/include/stdlib.h"
#include "/usr/local/te/tool/Cygwin-i686/lib/gcc-lib/mips64el-unknown-tkernel/3.3.2/include/stdarg.h"
#include "/usr/local/te/tool/Cygwin-i686/lib/gcc-lib/mips64el-unknown-tkernel/3.3.2/include/stdio.h"
#include "/usr/local/te/include/assert.h"
#include "/usr/local/te/include/ctype.h"
#include "/usr/local/te/tool/Cygwin-i686/lib/gcc-lib/mips64el-unknown-tkernel/3.3.2/include/math.h"
#else
#include "stdio.h"
#include "ctype.h"
#include "string.h"
#include "stdlib.h"
#include "assert.h"
#include "stdarg.h"
#include "math.h"
#endif

/**************************************************************************/
/* includes for NUCLEUS                                                   */
/**************************************************************************/

#elif (OSAL_OS==OSAL_NUCLEUS)

#include "stdio.h"
#include "ctype.h"
#include "string.h"
#include "stdlib.h"
#include "assert.h"
#include "stdarg.h"
#include "math.h"
/**************************************************************************/
/* includes for Linux                                                     */
/**************************************************************************/

#elif (OSAL_OS==OSAL_LINUX) || (OSAL_OS==OSAL_DARWIN)

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <stdarg.h>
#include <math.h>

/**************************************************************************/
/* includes for WinCE                                                     */
/**************************************************************************/
#elif (OSAL_OS==OSAL_WINCE)

#include "stdio.h" /* Soj, RBIN */
#include "ctype.h"
#include "string.h"
#include "stdlib.h"
#include "stdarg.h"
#include "math.h"

#endif


#ifdef __cplusplus
extern "C"
{
   #endif
   
   
   /******************************************************************************/
   /* typedefs                                                                   */
   /******************************************************************************/
      
   /* none */
   
   
   /******************************************************************************/
   /* defines                                                                    */
   /******************************************************************************/
   
   /******************************************************************************/
   /* all defines for VxWorks, WinNT, Linux, RX732, WinCE                        */
   /******************************************************************************/
   
   #if OSAL_OS==OSAL_VXWORKS || OSAL_OS==OSAL_WINNT || OSAL_OS==OSAL_LINUX || OSAL_OS==OSAL_DARWIN || OSAL_OS==OSAL_RX732 || OSAL_OS==OSAL_WINCE || OSAL_OS==OSAL_NUCLEUS ||OSAL_OS==OSAL_TENGINE
   
   #define OSAL_s32PrintFormat sprintf
	#define OSAL_s32ScanFormat sscanf
   

   /* --This isn't an official OSAL-Function. Please use instead 
           OSAL_s32VarPrintFormat. Thanx (ENT1-Uelschen, 12.07.2001). */
   #define OSAL_s32VPrintFormat vsprintf
   #define OSAL_s32VarPrintFormat          vsprintf
   
   #if OSAL_OS==OSAL_WINNT || OSAL_OS==OSAL_WINCE
   OSAL_DECL tS32 OSAL_s32VarNPrintFormat(tString  szBuffer,
                                tU32     u32BufferLength,
                                tCString coszFormat,
                                va_list  argptr);
      #ifdef TSIM_OSAL
      #define OSAL_s32VarNPrintFormat         vsnprintf
      #endif
   #else
   #define OSAL_s32VarNPrintFormat         vsnprintf
   #endif
   
   /******************************************************************************/
   /* defined in string.h                                                        */
   /******************************************************************************/
   
   #define OSAL_szStringCopy(_DEST_,_SRC_) \
      (tString)strcpy((char*)(_DEST_),(const char*)(_SRC_))
   
   #define OSAL_szStringNCopy(_DEST_,_SRC_,_NCNT_) \
      (tString)strncpy((char*)(_DEST_),(const char*)(_SRC_),(_NCNT_))
   
   #define OSAL_szStringConcat(_DEST_,_SRC_) \
      (tString)strcat((char*)(_DEST_),(const char*)(_SRC_))
   
   #define OSAL_szStringNConcat(_DEST_,_SRC_,_NCNT_) \
      (tString)strncat((char*)(_DEST_),(const char*)(_SRC_),(_NCNT_)) 
   
   #define OSAL_s32StringCompare(_STR1_,_STR2_) \
      (tS32)strcmp((const char*)(_STR1_),(const char*)(_STR2_))
                 
   #define OSAL_s32StringNCompare(_STR1_,_STR2_,_NCNT_) \
      (tS32)strncmp((const char*)(_STR1_),(const char*)(_STR2_),(_NCNT_))
   
   #define OSAL_ps8StringSearchChar(_STR_,_CH_) \
      strchr((_STR_),(_CH_))
   
   #define OSAL_ps8StringRSearchChar(_STR_,_CH_) \
      strrchr((_STR_),(_CH_))
   
   #define OSAL_pu32StringSegment(_STR1_,_STR2_) \
      strspn((const char*)(_STR1_),(const char*)(_STR2_))
   
   #define OSAL_pu32StringNotSegment(_STR1_,_STR2_) \
      strcspn((const char*)(_STR1_),(const char*)(_STR2_))
   
   #define OSAL_ps8StringBreak(_STR1_,_STR2_) \
      strpbrk((_STR1_),(_STR2_))
   
   #define OSAL_ps8StringSubString(_STR1_,_STR2_) \
      strstr((_STR1_),(_STR2_))
   
   #define OSAL_u32StringLength(_STR_) \
      (tU32)strlen((const char*)_STR_)
   
   #define OSAL_ps8StringToken(_STR1_,_STR2_) \
      (tPS8)strtok((char*)(_STR1_),(const char*)(_STR2_))
   
   /******************************************************************************/
   /* character manipulation and test                                            */
   /* defined in ctype.h                                                         */
   /******************************************************************************/
   
   #define OSAL_s32IsAlphaNum(_CH_) \
      (tS32)isalnum(_CH_)
   
   #define OSAL_s32IsAlpha(_CH_) \
      (tS32)isalpha(_CH_)
   
   #define OSAL_s32IsControl(_CH_) \
      (tS32)iscntrl(_CH_)
   
   #define OSAL_s32IsDigit(_CH_) \
      (tS32)isdigit(_CH_)
   
   #define OSAL_s32IsGraphical(_CH_) \
      (tS32)isgraph(_CH_)
   
   #define OSAL_s32IsLower(_CH_) \
      (tS32)islower(_CH_)
   
   #define OSAL_s32IsPrintable(_CH_) \
      (tS32)isprint(_CH_)
   
   #define OSAL_s32IsPunctation(_CH_) \
      (tS32)ispunct(_CH_)
   
   #define OSAL_s32IsSpace(_CH_) \
      (tS32)isspace(_CH_)
   
   #define OSAL_s32IsUpper(_CH_) \
      (tS32)isupper(_CH_)
   
   #define OSAL_s32IsHexDigit(_CH_) \
      (tS32)isxdigit(_CH_)
   
   #define OSAL_s32ToLower(_CH_) \
      (tS32)tolower(_CH_)
   
   #define OSAL_s32ToUpper(_CH_) \
      (tS32)toupper(_CH_)
   
   /******************************************************************************/
   /* mathematic manipulation                                                    */
   /* defined in math.h                                                          */
   /******************************************************************************/
   
   #define OSAL_dSin(_VALUE_) \
     sin(_VALUE_)
   
   #define OSAL_dCos(_VALUE_) \
      cos(_VALUE_)
   
   #define OSAL_dTan(_VALUE_) \
      tan(_VALUE_)
   
   #define OSAL_dArcSin(_VALUE_) \
      asin(_VALUE_)
   
   #define OSAL_dArcCos(_VALUE_) \
      acos(_VALUE_)
   
   #define OSAL_dArcTan(_VALUE_) \
      atan(_VALUE_)
   
   #define OSAL_dArcTan2(_DY_,_DX_) \
      atan2((_DY_),(_DX_))
    
   #define OSAL_dSinHyp(_VALUE_) \
      sinh(_VALUE_)
    
   #define OSAL_dCosHyp(_VALUE_) \
      cosh(_VALUE_)
   
   #define OSAL_dTanHyp(_VALUE_) \
      tanh(_VALUE_)
   
   #define OSAL_dExp(_VALUE_) \
      exp(_VALUE_)
   
   #define OSAL_dLog(_VALUE_) \
      log(_VALUE_)
   
   #define OSAL_dLog10(_VALUE_) \
      log10(_VALUE_)
   
   #define OSAL_dPow(_OPERAND_,_EXPONENT_) \
      pow((_OPERAND_),(_EXPONENT_))
   
   #define OSAL_dSqrt(_VALUE_) \
      sqrt(_VALUE_)
   
   #define OSAL_dCeil(_VALUE_) \
      ceil(_VALUE_)
   
   #define OSAL_dFloor(_VALUE_) \
      floor(_VALUE_)
   
   #define OSAL_dFAbsolute(_VALUE_) \
      fabs(_VALUE_)
   
   #define OSAL_dLDExp(_VALUE_,_NCNT_) \
      ldexp((_VALUE_),(_NCNT_))
   
   #define OSAL_dFRExp(_VALUE_,_PEXPONENT_) \
      frexp((_VALUE_),(_PEXPONENT_))
   
   #define OSAL_dModF(_VALUE_,_PINTPART_) \
      modf((_VALUE_),(_PINTPART_))
   
   #define OSAL_dFMod(_DX_,_DY_) \
      fmod((_DX_),(_DY_))
   
   /******************************************************************************/
   /* additional functions                                                       */
   /******************************************************************************/
   
   #define OSAL_dAsciiToDouble(_STRING_) \
      atof((const char*)_STRING_)
   
   #define OSAL_s32AsciiToS32(_STRING_) \
      atoi((const char*)_STRING_)
   
   #define OSAL_dStringToDouble(_STRING_,_PEND_) \
      strtod((const char*)(_STRING_),(char**)(_PEND_))
   
   #define OSAL_s32StringToS32(_STRING_,_PEND_,_BASE_) \
      strtol((const char*)(_STRING_),(char**)(_PEND_),(_BASE_)) 
   
   #define OSAL_u32StringToU32(_STRING_,_PEND_,_BASE_) \
      strtoul((const char*)(_STRING_),(char**)(_PEND_),(_BASE_)) 
   
   /**************************************************************************/
   /* defined in stdlib.h                                                    */
   /**************************************************************************/
   
   #define OSAL_s32Random() \
      (tS32)rand()
   
   #define OSAL_vRandomSeed(_SEED_) \
      srand(_SEED_)
   
   #if (OSAL_OS != OSAL_WINCE)
   #define OSAL_vBinarySearch(_PKEY_,_PBASE_,_ARRAY_,_SIZE_,_PCMPFUNC_) \
      bsearch((_PKEY_),(_PBASE_),(_ARRAY_),(_SIZE_),(_PCMPFUNC_))
   #else
      /* WinCE-Stdlib does not implement bsearch, so we have to do it
         by our own. */
      OSAL_DECL tPVoid OSAL_vBinarySearch(tPCVoid pvKey, tPCVoid pvBase,  
                                tU32 u32Member, tU32 u32Size, 
                                tS32 (*ps32Cmp)(tPCVoid, tPCVoid));
   
   #endif
   
   
   #define OSAL_vQuickSort(_PBASE_,_NCNT_,_SIZE_,_PSRTFUNC_ ) \
      qsort((_PBASE_),(_NCNT_),(_SIZE_),(_PSRTFUNC_ ))
   

   #if (OSAL_OS==OSAL_TENGINE) && !defined __arm
   #define OSAL_s32Absolute(_VALUE_) \
         abs(_VALUE_)
   #else
      #ifdef __cplusplus
         extern "C"
         {
      #endif
            OSAL_DECL tS32 OSAL_s32Absolute(tS32 s32Value);
      #ifdef __cplusplus
         }
      #endif
   #endif


   #ifndef OSAL_DYNAMIC_DOWNLOAD
   #if OSAL_OS==OSAL_NUCLEUS || OSAL_OS==OSAL_TENGINE || OSAL_OS == OSAL_LINUX || OSAL_OS==OSAL_DARWIN
      OSAL_DECL tVoid OSAL_vAssertFunction(const tChar* exp, const tChar* file, tU32 line);
   #endif
   #endif

   #if (OSAL_OS == OSAL_WINCE) 
      OSAL_DECL tVoid OSAL_vAssertFunction(const char* expr,const char *FileName ,int LineNum);
   #endif

   /**************************************************************************/
   /* debugging support, define in assert.h                                  */
   /**************************************************************************/
   
   #ifdef OSAL_S_NO_DEBUG

      #define OSAL_vAssert(_INT_)
   
      #define FATAL_M_ASSERT(_INT_) 
      #define NORMAL_M_ASSERT(_INT_)

      #define FATAL_M_ASSERT_ALWAYS()
      #define NORMAL_M_ASSERT_ALWAYS()

   #elif (OSAL_OS == OSAL_NUCLEUS || OSAL_OS==OSAL_TENGINE || OSAL_OS == OSAL_LINUX || OSAL_OS==OSAL_DARWIN)

		// Due to massive dependencies in implementation, the flag for NORMAL/FATAL is
		// passed to OSAL_vAssertFunction() as MSB of __LINE__ which should usually not
		// occur to be so large :)
		// b31 = 1  -->  NORMAL (no assert, only trace, in RELEASE compiled version)
		// b31 = 0  -->  FATAL (behaviour as usual)
     #define OSAL_vAssert(_INT_) \
      ((_INT_) ? (tVoid)(0) : (OSAL_vAssertFunction(#_INT_, __FILE__, (__LINE__)&(~0x80000000))) )

     // Use it for FATAL asserts, which should suspend task or system
     // in debug and release version
     // _INT_ == 0 -> Assert
     //       == 1 -> NOP
	  // Handling of error equal in Debug and Release
	  #define FATAL_M_ASSERT(_INT_) \
      (OSAL_vAssert(_INT_))            

     // Use it for NORMAL asserts, which should suspend task or system
     // in debug version but resuming task operation in release version
     // _INT_ == 0 -> Assert
     //       == 1 -> NOP
	  // Handling of error differs in Debug and Release
     #define NORMAL_M_ASSERT(_INT_) \
     ((_INT_) ? (tVoid)(0) : (OSAL_vAssertFunction(#_INT_, __FILE__, (__LINE__)|0x80000000)) )

     // Use it for FATAL asserts, which should occur as an obligation
     #define FATAL_M_ASSERT_ALWAYS() \
     (OSAL_vAssertFunction("ALWAYS", __FILE__, (__LINE__)&(~0x80000000)))

     // Use it for NORMAL asserts, which should occur as an obligation
     #define NORMAL_M_ASSERT_ALWAYS() \
     (OSAL_vAssertFunction("ALWAYS", __FILE__, (__LINE__)|0x80000000))

     // Use it to set Assert to resp. mode
     // Not useable from DDL modules, since not present in DDL interface
     typedef enum {ASSERTMODE_RESET=0x01, ASSERTMODE_SUSPEND, ASSERTMODE_TASKSUSPEND, ASSERTMODE_TASKNOACTION} teAssertMode;
     tVoid OSAL_vSetAssertMode(teAssertMode mode);
	  teAssertMode OSAL_vgetAssertMode(tVoid);

   #elif (OSAL_OS == OSAL_WINNT)
      #ifdef _lint  // Make sure no compiler comes this way
         #define OSAL_vAssert(_INT_) __lint_assert(_INT_)

         //lint -function( __assert, __lint_assert )
         void __lint_assert( int );
      #else
         #define OSAL_vAssert(_INT_) \
            assert(_INT_)
      #endif // _lint


      #define FATAL_M_ASSERT(_INT_) (OSAL_vAssert(_INT_))            
      #define NORMAL_M_ASSERT(_INT_) (OSAL_vAssert(_INT_))            

      #define FATAL_M_ASSERT_ALWAYS() (OSAL_vAssert(0))  
      #define NORMAL_M_ASSERT_ALWAYS() (OSAL_vAssert(0)) 

   #elif (OSAL_OS == OSAL_WINCE)
           
      #define OSAL_vAssert(_INT_) \
      ((_INT_) ? (tVoid)(0) : OSAL_vAssertFunction(#_INT_, __FILE__, __LINE__))

      #define FATAL_M_ASSERT(_INT_) (OSAL_vAssert(_INT_))            
      #define NORMAL_M_ASSERT(_INT_) (OSAL_vAssert(_INT_))            

      #define FATAL_M_ASSERT_ALWAYS() (OSAL_vAssert(0))  
      #define NORMAL_M_ASSERT_ALWAYS() (OSAL_vAssert(0)) 

   #else
      
       #error "Assert is undeclared for this Operating System"
   
   #endif // OSAL_S_NO_DEBUG
   
   /**************************************************************************/
   /* variable arguments                                                     */
   /* defined in stdarg.h                                                    */
   /**************************************************************************/
   
   #define OSAL_tVarArgList va_list

   #define OSAL_VarArgStart(_LIST_,_LASTARG_) \
      va_start((_LIST_),(_LASTARG_))                        
   
   #define OSAL_VarArg(_LIST_,_TYPE_) \
      va_arg((_LIST_),_TYPE_)
   
   #define OSAL_VarArgEnd(_LIST_) \
      va_end(_LIST_)
   
   /**************************************************************************/
   /* end of WinNT, VxWorks, Linux, RX732 and WinCE                                       */
   /**************************************************************************/
   
   
   #endif
   
   /**************************************************************************/
   /* dynamic-download                                                       */
   /**************************************************************************/
#if (OSAL_OS == OSAL_NUCLEUS || OSAL_OS==OSAL_TENGINE) 

#if ( defined OSAL_DYNAMIC_DOWNLOAD || defined OSAL_DYNAMIC_BASE)
   typedef tVoid (*tOSAL_vAssertFunction)(const tChar* exp, const tChar* file, tU32 line);
#endif

#ifdef OSAL_DYNAMIC_DOWNLOAD
   extern tOSAL_vAssertFunction   OSAL_vAssertFunction;
#endif

#endif //(OSAL_OS == OSAL_NUCLEUS) 

#ifdef __cplusplus
}
#endif

#endif 


/* EOF */
