/***************************************************************************
 * .EXPORT_ME    
 * FILE:         osal.h
 * PROJECT:      VASCO
 * SW-COMPONENT: OSAL
 *--------------------------------------------------------------------------
 * DESCRIPTION:  This file is the top header file and the only purpose
 *               is to include the other os*.h files. Include this one
 *               and be happy.
 *--------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      | Modification                        | Author
 * 16.03.00  | Initial revision                    | de Vries, EFT22
 * 03.04.00  | osconfig.h added                    | Uelschen, EFT42 
 * 10.04.00  | New file structure                  | Uelschen, EFT42
 * 17.05.00  | New and removed includes            | de Vries, EFT22
 *             for Processes and Threads
 * 23.05.00  | ostime.h is needed before ossmphr.h | Tiemann,  EFT42
 * 14.08.00  | `osmsg.h' added.                    | Wunderlich, EFT32
 *
 **************************************************************************/


#if !defined (OSAL_OSAL_HEADER)
#define OSAL_OSAL_HEADER


/* 
   !!! THIS INCLUDE FILE IS FOR APPLICATION USE !!!
   
   !!! DO NOT INCLUDE WITHIN THE OSAL COMPONENT !!!

*/


/**************************************************************************/
/* Includes                                                               */
/**************************************************************************/


/* --Basic and Configuration Includes */

#include "osconfig.h"
#include "ostypes.h"
#include "osdefine.h"
#include "oserror.h"

/* ostime.h is needed before ossmphr.h */
#include "ostime.h"     


/* --Specific OSAL Types and Functions */

#include "osansi.h"
#include "osevent.h"
#include "osio.h"
#include "osmemory.h"
#include "osmqueue.h"
#include "osinit.h"

#include "ossmphr.h"

/* new 17.5.00 Processes and Threads */
#include "osproc.h"
#include "osshmem.h"


/* --Message Pool: */
#include "osmsg.h"

/* --IOCTRLs & Device names */
#include "osioctrl.h"
#include "osdevice.h"

#include "osstl.h"

#endif


/* EOF */

