#include <iostream>
#include <fstream>
#include <json/json.h> 
#include <string.h>
#include <stdlib.h>
#include "dlt/dlt.h"
#include "App_MessageHandler.h"


#ifdef __cplusplus
extern "C"
{
#endif
#include "AGW_SPS_DBusHandler.h"
#include "sps_connection.h"
#ifdef __cplusplus
}
#endif
using namespace std;

DLT_IMPORT_CONTEXT(SPS_JMSG);

/******************************************************
* Function:    vParseJSONAppMsg
* Description: This method converts the json msg to
               key value pairs for proccessing
* Parameters:  jsonMsg   
* Returns:     void
*******************************************************/
void vParseJSONAppMsg(gchar* jsonMsg)
{
    DLT_LOG(SPS_JMSG,DLT_LOG_INFO,DLT_STRING("+"),
                  DLT_STRING(__FUNCTION__));   
    if((!jsonMsg) || (!strlen(jsonMsg))) 
    {
        DLT_LOG(SPS_JMSG, DLT_LOG_ERROR, 
          DLT_STRING(__FUNCTION__), DLT_STRING(
             "(): Bad input"));
        return;
    }
    char* key = NULL;
    char* value = NULL; 
    gsize keyLen = 0, valLen = 0;
    //char* text =  "{ \"first\": \"James\", \"last\": \"Bond\" }";
    Json::Reader reader;
    Json::Value jsonVal;

    if(!reader.parse(jsonMsg, jsonVal))
    {
        DLT_LOG(SPS_JMSG, DLT_LOG_ERROR, DLT_STRING(__FUNCTION__),
          DLT_STRING((reader.getFormattedErrorMessages()).c_str()));
        return; 
    }
      
    for(Json::Value::iterator it=jsonVal.begin(); it!=jsonVal.end(); ++it )
    {
        keyLen = 0;
        valLen = 0;
        key = NULL;
        value = NULL;
        keyLen = it.key().asString().length();
        valLen = (*it).asString().length();

        key   = (char *) malloc(keyLen + 1);
        value = (char *) malloc(valLen + 1);

        if( (!key) || (!value))
        {
            DLT_LOG(SPS_JMSG, DLT_LOG_ERROR, DLT_STRING(__FUNCTION__),
               DLT_STRING("(): malloc failed"));
            if(key)
                free(key);
            if(value)
                free(value);

            return;
        }
        try
        {
            strncpy(key, it.key().asString().c_str(), keyLen);
            key[keyLen] = '\0';
 
            strncpy(value, (*it).asString().c_str(), valLen);
            value[valLen] = '\0';
        }
        catch(...)
        {
           free(key);
           free(value);
           return;
        }       
        
        DLT_LOG(SPS_JMSG, DLT_LOG_INFO,
          DLT_STRING(__FUNCTION__), DLT_STRING("(): key is "),
                    DLT_STRING(key));

        DLT_LOG(SPS_JMSG, DLT_LOG_INFO,
          DLT_STRING(__FUNCTION__), DLT_STRING("(): value is "),
                    DLT_STRING(value));

        vHandleMsgFromApp( key, 
                           value );
        free(key);
        free(value);
    }
    DLT_LOG(SPS_JMSG,DLT_LOG_INFO,DLT_STRING("-"),
                  DLT_STRING(__FUNCTION__));
}

#ifdef __cplusplus
extern "C"
{
#endif
/*******************************************************
* Function:    bHandleMsgToAppWrapper
* Description: Wrapper function for bbHandleMsgToApp
* Parameters:  gvariant msg
* Returns:     gboolean
*******************************************************/
gboolean bHandleMsgToAppWrapper( GVariant* message )
{
    DLT_LOG(SPS_JMSG,DLT_LOG_INFO,DLT_STRING("+"),
                         DLT_STRING(__FUNCTION__));
    return  bProccessMsgToApp(message);
    DLT_LOG(SPS_JMSG,DLT_LOG_INFO,DLT_STRING("-"),
                         DLT_STRING(__FUNCTION__));
}
#ifdef __cplusplus
}
#endif
   
/******************************************************
* Function:    bProccessMsgToApp
* Description: This method converts the GVariant msg
               from Midw to JSON format
* Parameters:  gvariant msg
* Returns:     gboolean
*******************************************************/
gboolean bProccessMsgToApp( GVariant* message )
{
     DLT_LOG(SPS_JMSG,DLT_LOG_INFO,DLT_STRING("+"),
                           DLT_STRING(__FUNCTION__));
     if(!message)
     {
         DLT_LOG(SPS_JMSG, DLT_LOG_INFO, DLT_STRING(__FUNCTION__),
            DLT_STRING("(): Null message"));
         return FALSE;
     }
     GVariantIter* iter = NULL;
     g_variant_get (message, "a{ss}", &iter);
     const gchar *key;
     const gchar *value; 
     std::string jsonMsg = "{";
     bool bFirstKVPair = true;

     while (g_variant_iter_loop (iter, "{&ss}", &key, &value))
     {
         DLT_LOG(SPS_JMSG,DLT_LOG_INFO,DLT_STRING(__FUNCTION__),
                 DLT_STRING("(): key - value: "),
                       DLT_STRING(key), DLT_STRING(value));
         if(!bFirstKVPair)
            jsonMsg = jsonMsg + ",";
        //char* text =  "{ \"first\": \"James\", \"last\": \"Bond\" }";
         jsonMsg =  jsonMsg + "\"" + key + "\""
                   + ":" + "\"" + value + "\"";
         bFirstKVPair = false;
     }    

     jsonMsg = jsonMsg + "}";
     return bSendMsgToApp(jsonMsg.c_str());      
}

#ifdef __cplusplus
extern "C"
{
#endif
/******************************************************
* Function:    vHandleMsgFromApp
* Description: This method builds GVariant for
               the key value pair of App msg
* Parameters:  jsonMsg
* Returns:     void
*******************************************************/
void vHandleMsgFromApp( gchar* key, 
                        gchar* value )
{
     DLT_LOG(SPS_JMSG,DLT_LOG_INFO,DLT_STRING("+"),
                  DLT_STRING(__FUNCTION__));
     if((!key) || (!value))
     {
         DLT_LOG(SPS_JMSG, DLT_LOG_ERROR,
           DLT_STRING(__FUNCTION__), DLT_STRING(
               "(): Bad input(s)"));
         return;
     }
     GVariantBuilder builder;
     GVariant *varValue = NULL;
    
     g_variant_builder_init(&builder,G_VARIANT_TYPE("a(y)"));
     size_t i = 0;
     for(i = 0; i  < strlen(value); i++)
     {
        g_variant_builder_add(&builder, "(y)", value[i]);
     }
     varValue = g_variant_builder_end(&builder);

     vForwardMsgFromApp( key, varValue);
     DLT_LOG(SPS_JMSG,DLT_LOG_INFO,DLT_STRING("-"),
                  DLT_STRING(__FUNCTION__));
}

/******************************************************
* Function:    vParseJSONAppMsgWrapper
* Description: Wrapper function for vParseJSONMsg
* Parameters:  jsonMsg
* Returns:     void
*******************************************************/
void vParseJSONAppMsgWrapper(gchar*  msg)   
{
    vParseJSONAppMsg(msg);
}

#ifdef __cplusplus
}
#endif
      
