/******************************************************************************
* \file               JSON_MessageHandler.h
*******************************************************************************
\verbatim
PROJECT:        Seamless pairing
SW-COMPONENT:   Seamless pairing server
DESCRIPTION:    Header JSON_MessageHandler
COPYRIGHT:      &copy; RBEI
HISTORY:
Date       | Author                   | Modifications
01.08.2018 | svs7kor                  | Initial Version
\endverbatim
******************************************************************************/

#ifndef _SPS_JSON_HANDLER_H_
#define _SPS_JSON_HANDLER_H_

/******* INCLUDES ***************/
#include <glib.h>
#include <stdio.h>
#include "dlt/dlt.h"

#include <string.h>
#include <openssl/bio.h>
#include <openssl/err.h>
#include <openssl/pem.h>
#include <openssl/x509.h>
#include <openssl/x509_vfy.h>
#include <errno.h>
#include <openssl/evp.h>
#include <openssl/rand.h>
#include <openssl/buffer.h>
#include <unistd.h>

void vSet_SphoneMQTT_credentials();

int iDeletePasswordEntry();

int iDeletePasswordUserEntry(FILE *arg_pTmpFile, const char *arg_pUsername);

int iCopyFileContents(FILE *arg_pSource, FILE *arg_pDest);

#endif //_SPS_JSON_HANDLER_H_