/******************************************************************************
* \file               sps_connection.h
*******************************************************************************
\verbatim
PROJECT:        Seamless pairing
SW-COMPONENT:   Seamless pairing server
DESCRIPTION:    Header for seamless connection
COPYRIGHT:      &copy; RBEI
HISTORY:
Date       | Author                   | Modifications
15.2.2018  | ipd5kor                  | Initial Version
******************************************************************************/
#include <gio/gio.h>
#include <glib.h>

/*************************************************************
* Function:    bOpenSPConnection
* Description: This method opens the socket for
               communication  with App
* Parameters:  Port number
* Returns:     gboolean
**************************************************************/
gboolean bOpenSPConnection(guint32 port);


/*************************************************************
* Function:    bSendMsgToApp
* Description: This method writes the incoming msg
               to App
* Parameters:  msg
* Returns:     gboolean
**************************************************************/
gboolean bSendMsgToApp(const char* msg);

/*************************************************************
* Function:    vCloseSPConnection
* Description: This method closes the Server connection
                to App
* Parameters:  void
* Returns:     void
 *************************************************************/
void vCloseSPConnection();

