#include <netinet/in.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <arpa/inet.h>
#include <pthread.h>
#include <dlt/dlt.h>
#include <glib.h>
#include "sps_connection.h"
#include "App_MessageHandler.h"
#include "AGW_SPS_DBusHandler.h"

DLT_IMPORT_CONTEXT(SPS_CONN);

static int g_socket_fd = 0;
static int g_connection_fd = 0;
static gboolean g_bRunServer = FALSE;
static GThread *g_connection_thread = NULL;
static pthread_t  g_conn_thread = NULL;

/**************************************************************
 * Function:    bSendMsgToApp
 * Description: This method writes the incoming msg
                to App
 * Parameters:  msg
 * Returns:     gboolean
 **************************************************************/
gboolean bSendMsgToApp(const char* msg)
{
    DLT_LOG(SPS_CONN, DLT_LOG_INFO, DLT_STRING("+"),
                              DLT_STRING(__FUNCTION__));
    DLT_LOG(SPS_CONN, DLT_LOG_INFO, DLT_STRING(__FUNCTION__),
                             DLT_STRING("(): msg is:"),
                              DLT_STRING(msg));
    if((msg == NULL) || (strlen(msg) == 0))
    {
        DLT_LOG(SPS_CONN, DLT_LOG_ERROR, DLT_STRING(__FUNCTION__),
              DLT_STRING("(): Null input"));
        return FALSE;
    }
    if(!g_connection_fd)
    {
        DLT_LOG(SPS_CONN, DLT_LOG_ERROR, DLT_STRING(__FUNCTION__),
               DLT_STRING("(): g_connection_fd not available")); 
        return FALSE;
    }
    if(write(g_connection_fd, msg, strlen(msg)) != strlen(msg) )
    {
        DLT_LOG(SPS_CONN, DLT_LOG_ERROR, DLT_STRING(__FUNCTION__),
              DLT_STRING("(): msg write failed")); 
        return FALSE;
    } 
    DLT_LOG(SPS_CONN, DLT_LOG_INFO, DLT_STRING("-"),
                              DLT_STRING(__FUNCTION__));
    return TRUE;
}
 

static void *
listener_thread(void *data)
{
     DLT_LOG(SPS_CONN, DLT_LOG_INFO, DLT_STRING(__FUNCTION__),
             DLT_STRING("Enetered"));
     char buffer[2048] = { '\0' }; 
     struct sockaddr_in address;
     int addrlen = sizeof(address);
     gboolean clientDisconnected = FALSE;;
     unsigned int numOfBytes = 0;
     gboolean bFirstMsg = TRUE;

     if (listen(g_socket_fd, 1) < 0)
     {
         DLT_LOG(SPS_CONN, DLT_LOG_INFO, DLT_STRING(__FUNCTION__),
            DLT_STRING("(): listen failed"));
         pthread_exit(NULL);
		 return NULL; 
     }

     if ((g_connection_fd = accept(g_socket_fd, (struct sockaddr *)&address, 
                       (socklen_t*)&addrlen)) < 0)
     {
         DLT_LOG(SPS_CONN, DLT_LOG_INFO, DLT_STRING(__FUNCTION__),
             DLT_STRING("(): accept failed"));
         pthread_exit(NULL); 
         return NULL;  
     }
     DLT_LOG(SPS_CONN, DLT_LOG_INFO, DLT_STRING(__FUNCTION__),
            DLT_STRING("(): New connection"));

     while((g_bRunServer) && (!clientDisconnected))
     {
         numOfBytes = 0;
		 memset(buffer, '\0', sizeof(buffer)); 
         numOfBytes = read( g_connection_fd , buffer, sizeof(buffer) );
         DLT_LOG(SPS_CONN, DLT_LOG_INFO, DLT_STRING(__FUNCTION__),
                DLT_STRING("Number of bytes: "), DLT_UINT(numOfBytes));

 	 if(numOfBytes <= 0)
         {
            clientDisconnected = TRUE;
         }
         else if(numOfBytes >= sizeof(buffer))
         {
             DLT_LOG(SPS_CONN, DLT_LOG_INFO, DLT_STRING(__FUNCTION__),
               DLT_STRING("Bytes read greater than buffer size, ignore msg "));
         } 
         else 
         { 
             if(bFirstMsg)
             {
                 vUpdateSPConnectionState(SPS_CLIENT_CONNECTED);
				 bFirstMsg = FALSE; 
             }      
             DLT_LOG(SPS_CONN, DLT_LOG_INFO, DLT_STRING(__FUNCTION__),
                DLT_STRING("():Recieved Message: "), DLT_STRING(buffer));
             buffer[numOfBytes] = '\0'; 
			 vParseJSONAppMsgWrapper(buffer);
         }
     }
     if(clientDisconnected && (g_bRunServer))
     {
         DLT_LOG(SPS_CONN, DLT_LOG_INFO, DLT_STRING(__FUNCTION__),
                            DLT_STRING("():Client disconnected"));

         vUpdateSPConnectionState(SPS_CLIENT_DISCONNECTED);
     } 
       
     if(g_connection_fd)
     {
        close(g_connection_fd);
        g_connection_fd = 0;
     } 
     pthread_exit(NULL); 
     return NULL; 
}

/**************************************************************
 * Function:    bOpenSPConnection
 * Description: This method opens the socket for
                communication  with App
 * Parameters:  Port number
 * Returns:     void
 **************************************************************/
gboolean bOpenSPConnection(guint32 port)
{
     DLT_LOG(SPS_CONN, DLT_LOG_INFO, DLT_STRING("+"),
                      DLT_STRING(__FUNCTION__));
     struct sockaddr_in address ;
     int serverOpt = 1;
 
     if ((g_socket_fd = socket(AF_INET, SOCK_STREAM, 0)) <= 0)
     {
          DLT_LOG(SPS_CONN, DLT_LOG_ERROR, DLT_STRING(__FUNCTION__),
              DLT_STRING("(): socket() failed"));
          return FALSE;
     }
     if (setsockopt(g_socket_fd, SOL_SOCKET, SO_REUSEADDR | SO_REUSEPORT,
                                          &serverOpt, sizeof(serverOpt)))
     {
          DLT_LOG(SPS_CONN, DLT_LOG_ERROR, DLT_STRING(__FUNCTION__),
              DLT_STRING("(): setsockopt failed"));
          return FALSE;
     }
     address.sin_family = AF_INET;
     address.sin_addr.s_addr = INADDR_ANY;
     //address.sin_addr.s_addr =  inet_addr("10.19.229.143");
     address.sin_port = htons( port );
	 memset(address.sin_zero, 0 , sizeof(address.sin_zero));
	 
     if (bind(g_socket_fd, (struct sockaddr *)&address, 
                                 sizeof(address)) < 0)
     {
          DLT_LOG(SPS_CONN,DLT_LOG_ERROR, DLT_STRING(__FUNCTION__),
              DLT_STRING("(): bind() failed"));
          return FALSE;
     }
     DLT_LOG(SPS_CONN, DLT_LOG_INFO, DLT_STRING(__FUNCTION__),
     DLT_STRING("(): bind success"));
     g_bRunServer = TRUE;
     
/*     g_connection_thread = g_thread_new("connection thread", 
                            &listener_thread, NULL);
*/
     pthread_create(&g_conn_thread, NULL, listener_thread, NULL);
     return TRUE;
}    

/**************************************************************
 * Function:    vCloseSPConnection
 * Description: This method closes the Server connection
                to App
 * Parameters:  void
 * Returns:     void
 **************************************************************/
void vCloseSPConnection()
{
    DLT_LOG(SPS_CONN, DLT_LOG_INFO, DLT_STRING("+"),
                           DLT_STRING(__FUNCTION__));

    g_bRunServer = FALSE;

    if(g_conn_thread)
    {
        pthread_cancel(g_conn_thread);
        //g_thread_unref(g_connection_thread);
        g_connection_thread = NULL;
    }
    if(g_connection_fd)
    {
        close(g_connection_fd);
        g_connection_fd = 0;
    }

    if(g_socket_fd)
    {
        close(g_socket_fd);
        g_socket_fd = 0;
    }
 
    DLT_LOG(SPS_CONN, DLT_LOG_INFO, DLT_STRING("-"),
                      DLT_STRING(__FUNCTION__));
}   
                  
