/*!
*******************************************************************************
* \file               seamlessMidw_Service.cpp
*******************************************************************************
\verbatim
PROJECT:        G3G
SW-COMPONENT:   Seamless pairing middleware component.
DESCRIPTION:    CCA Application SEAMLESS_PAIRING_IPCM.
COPYRIGHT:      &copy; RBEI
HISTORY:
Date       | Author                 | Modifications
22.12.2017 | ipd5kor                | Initial Version
\endverbatim
*******************************************************************************/

/******************************************************************************
| includes:
|---------------------------------------------------------------------------*/

#include "seamlessMidw_tclService.h"

//!Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#include "seamlessMidw_tclMainApp.h"

//Dlt
#include "dlt/dlt.h"
DLT_IMPORT_CONTEXT(SPM_framework);

#define SPMW_SERVICE_FI_MAJOR_VERSION        (tU16)1
#define SPMW_SERVICE_FI_MINOR_VERSION        (tU16)0
#define SPMW_SERVICE_FI_PATCH_VERSION        (tU16)0

/******************************************************************************
* FUNCTION : seamlessMidw_Service::seamlessMidw_Service
******************************************************************************/
seamlessMidw_Service::seamlessMidw_Service(
                                     seamlessMidwMainApp* poMainAppl)
                                     : ahl_tclBaseOneThreadService(
              /* Main Appl Pointer*/   (ahl_tclBaseOneThreadApp*)poMainAppl,   
            /* ID of offered Service*/ CCA_C_U16_SRV_SEAMLESS_PAIRING_IPCM, 
  /* MajorVersion of offered Service*/ SPMW_SERVICE_FI_MAJOR_VERSION, 
  /* MinorVersion of offered Service*/ SPMW_SERVICE_FI_MINOR_VERSION,
  /* PatchVersion of offered Service*/ SPMW_SERVICE_FI_PATCH_VERSION),
                                       m_poMainAppl(poMainAppl)
{
   DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(
               "Constructor seamlessMidw_Service() entered"));
   NORMAL_M_ASSERT(OSAL_NULL != poMainAppl);
}

/******************************************************************************
* FUNCTION : seamlessMidw_Service::~seamlessMidw_Service
*****************************************************************************/
seamlessMidw_Service::~seamlessMidw_Service(tVoid)
{
    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(
                "Destructor ~seamlessMidw_Service() entered"));
    m_poMainAppl = OSAL_NULL;
} // end of ~seamlessMidw_Service()

/******************************************************************************
** FUNCTION:  gboolean seamlessMidw_Service::bInitialize();
******************************************************************************/
gboolean seamlessMidw_Service::bInitialize()
{
    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(
                "seamlessMidw_Service::bInitialize entered \n"));

    gboolean bInit = true;

    return bInit;
}//! end of bInitialize()

/******************************************************************************
** FUNCTION:  gboolean seamlessMidw_Service::bUnInitialize();
******************************************************************************/
gboolean seamlessMidw_Service::bUnInitialize()
{
    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(
                "seamlessMidw_Service::bUnInitialize entered \n"));

    gboolean bUnInit = true;

    return bUnInit;
}//! end of bUnInitialize()

/******************************************************************************
** FUNCTION:  void seamlessMidw_Service::vLoadSettings()
******************************************************************************/
void seamlessMidw_Service::vLoadSettings()
{
    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(
                "seamlessMidw_Service::vLoadSettings entered "));
}

/******************************************************************************
** FUNCTION:  void seamlessMidw_Service::vSaveSettings()
******************************************************************************/
void seamlessMidw_Service::vSaveSettings()
{
    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(
                "seamlessMidw_Service::vSaveSettings entered "));
}

/******************************************************************************
* \FUNCTION   : tVoid seamlessMidw_Service::vOnServiceAvailable()
******************************************************************************/
tVoid seamlessMidw_Service::vOnServiceAvailable(tVoid)
{
    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(
                "seamlessMidw_Service::vOnServiceAvailable entered "));

} //!end of vOnServiceAvailable()

/******************************************************************************
* \FUNCTION   : tVoid seamlessMidw_Service::vOnServiceUnavailable()
******************************************************************************/
tVoid seamlessMidw_Service::vOnServiceUnavailable(tVoid)
{
    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(
                "seamlessMidw_Service::vOnServiceUnavailable entered"));

    //!Add your code here

} //!end of vOnServiceUnavailable()

/******************************************************************************
* FUNCTION : tBool seamlessMidw_Service::bStatusMessageFactory
******************************************************************************/
tBool 
seamlessMidw_Service::bStatusMessageFactory(
        tU16 u16FunctionId,
        amt_tclServiceData& roOutMsg,
        amt_tclServiceData* poInMsg)
{
    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(
                "bStatusMessageFactory() entered. FID = "),
            DLT_INT( u16FunctionId));

    tBool bSuccess = TRUE;
    return bSuccess;
} /* end of bStatusMessageFactory()*/

/******************************************************************************
*FUNCTION : tVoid seamlessMidw_Service::vProcessTimer(tU16 u16TimerId)
******************************************************************************/
tVoid seamlessMidw_Service::vProcessTimer(tU16 u16TimerId)
{
    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(
                "vProcessTimer() entered. TimerID = "),DLT_INT( u16TimerId));

    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING("vProcessTimer() left"));
} //! end of vProcessTimer()


/******************************************************************************
*FUNCTION: tVoid seamlessMidw_Service::vOnLoopbackService(amt_tclSer..
******************************************************************************/
/*virtual*/
tVoid 
seamlessMidw_Service::vOnLoopback(tU16 u16ServiceID,
                                           amt_tclServiceData *poMessage)
{
    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(
                "vOnLoopback() entered with service Id = "),
            DLT_INT( u16ServiceID));
}

/******************************************************************************
* FUNCTION:  tBool seamlessMidw_Service::bUpdateClients
******************************************************************************/
tBool seamlessMidw_Service::bUpdateClients(tCU16 cu16FunID)
{
    return true;
}
