/*!
*******************************************************************************
* \file               seamless_midw_main.h
*******************************************************************************
\verbatim
PROJECT:        A-IVI
SW-COMPONENT:   Seamless pairing middleware main
DESCRIPTION:    CCA Application SEAMLESS_PAIRING_IPCM.
COPYRIGHT:      &copy; RBEI
HISTORY:
Date       | Author                   | Modifications
22.12.2017 | ipd5kor                  | Initial Version
******************************************************************************/

/******************************************************************************
| includes:
|----------------------------------------------------------------------------*/
#include <gio/gio.h>
#include "seamlessMidw_tclMainApp.h"
#include "seamlessMidw_tclService.h"

#ifdef __cplusplus
extern "C"
{
#endif
#include "seamlessMidw_DBusHandler.h"
#include "mdns_manager.h"
#include "gmain_source.h"
#ifdef __cplusplus
}
#endif

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

//Dlt
#include "dlt/dlt.h"

#define DLT_APPID_SEAMLESS_MIDW "SPMA"
//Dlt Context
DLT_DECLARE_CONTEXT(SPM_framework);
DLT_DECLARE_CONTEXT(SPM_SPL);
DLT_DECLARE_CONTEXT(SPM_Bluetooth);

/******************************************************************************
| defines
|----------------------------------------------------------------------------*/
/*****************************************************************************/

/******************************************************************************
| INITIALIZATION OF STATIC MEMBER VARIABLES
|----------------------------------------------------------------------------*/
seamlessMidwMainApp* 
seamlessMidwMainApp::m_poMainAppInstance = NULL;

fc_seamless_midw_tcl_bt_clienthandler*
seamlessMidwMainApp::m_poBTInstance = NULL;

/******************************************************************************
| METHODS
|----------------------------------------------------------------------------*/

/******************************************************************************
| Initialization of static variables.
|----------------------------------------------------------------------------*/

//CCA_C_U16_APP_SEAMLESS_PAIRING_IPCM
/******************************************************************************
**FUNCTION   : seamlessMidwMainApp::seamlessMidwMainApp()
******************************************************************************/
seamlessMidwMainApp::seamlessMidwMainApp()
      :ahl_tclBaseOneThreadApp(CCA_C_U16_APP_SEAMLESS_PAIRING_IPCM),
      m_poService(OSAL_NULL)
{
    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(
                "Constructor () entered"));
    seamlessMidwMainApp::m_poMainAppInstance = this;
    m_poService = OSAL_NEW seamlessMidw_Service(this);

    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(
                "Constructor seamlessMidwMainApp() left"));

}  //!end of seamlessMidwMainApp()


/******************************************************************************
* \FUNCTION   : seamlessMidwMainApp::~seamlessMidwMainApp()
******************************************************************************/
seamlessMidwMainApp::~seamlessMidwMainApp()
{
    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(
                "Destructor ~seamlessMidwMainApp() entered"));

    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(
                "Destructor ~seamlessMidwMainApp() left"));

}  //!end of ~seamlessMidwMainApp()

/******************************************************************************
      * \FUNCTION   : tBool seamlessMidwMainApp::bOnInit()
******************************************************************************/
tBool seamlessMidwMainApp::bOnInit()
{

    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(
                "seamlessMidwMainApp::bOnInit() entered"));

    if(m_poService!= NULL)
    {
        m_poService->bInitialize();
    }
    else
    {
        DLT_LOG(SPM_framework,DLT_LOG_ERROR,DLT_STRING(
                    "bad m_poService to start service"));
        return FALSE;
    }
    return TRUE;
} //!  end of bOnInit()


/******************************************************************************
** FUNCTION   : tVoid seamlessMidwMainApp::vOnApplicationClose()
******************************************************************************/
tVoid seamlessMidwMainApp::vOnApplicationClose()
{
    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(
                "seamlessMidwMainApp::vOnApplicationClose()"
                "entered"));

    if (OSAL_NULL != m_poService)
    {
        m_poService->bUnInitialize();
        delete m_poService;
        m_poService = NULL;
    }
    vDestroyCCAClientHandlers(); 
    m_poMainAppInstance = NULL;

    ahl_tclBaseOneThreadApp::vOnApplicationClose();

    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(
                "seamlessMidwMainApp::vOnApplicationClose() left"));
    DLT_UNREGISTER_CONTEXT(SPM_framework);
    DLT_UNREGISTER_CONTEXT(SPM_Bluetooth);
    DLT_UNREGISTER_CONTEXT(SPM_SPL);
    DLT_UNREGISTER_APP();

}  //!  end of vOnApplicationClose()

/******************************************************************************
** FUNCTION   : tVoid seamlessMidwMainApp::vOnLoadSettings()
******************************************************************************/
tVoid seamlessMidwMainApp::vOnLoadSettings()
{
    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(
                "seamlessMidwMainApp::vOnLoadSettings() entered"));

    vCreateCCAClientHandlers();
    vStartSPMWDBusService();
    

    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(
                "seamlessMidwMainApp::vOnLoadSettings() left"));
}   //!  end of vOnLoadSettings()

/******************************************************************************
* \FUNCTION   : tVoid seamlessMidwMainApp::vOnSaveSettings()
******************************************************************************/
tVoid seamlessMidwMainApp::vOnSaveSettings()
{
    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(
                "seamlessMidwMainApp::vOnSaveSettings() entered"));

    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(" deregister mqtt servcie "));
    vStopSPMWDBusService();
    // shutdown() menthod is commented because of reset issue at shutdown time.

    if (OSAL_NULL != m_poService)
    {
        m_poService->vSaveSettings();
    }

    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(
                "seamlessMidwMainApp::vOnSaveSettings() left"));
}  //!  end of vOnSaveSettings()

/******************************************************************************
** FUNCTION   : tVoid seamlessMidwMainApp::vOnTimer(tU16 u16TimerId)
******************************************************************************/
tVoid seamlessMidwMainApp::vOnTimer(tU16 u16TimerId)
{
    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(
                "vOnTimer(): entered for TimerID "),DLT_INT( u16TimerId));

    DLT_LOG(SPM_framework,DLT_LOG_INFO,
            DLT_STRING("vOnTimer() left"));

}   //!   end of vOnTimer()

/*****************************************************************************
** FUNCTION   : tVoid seamlessMidwMainApp::vCreateCCAClientHandlers()
******************************************************************************/
tVoid seamlessMidwMainApp::vCreateCCAClientHandlers()
{
    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING("+"),
                                   DLT_STRING(__FUNCTION__));
    m_poBTInstance = 
      fc_seamless_midw_tcl_bt_clienthandler::getInstance(m_poMainAppInstance); 
      
    if(!m_poBTInstance)
    {
        DLT_LOG(SPM_framework, DLT_LOG_ERROR, DLT_STRING(__FUNCTION__),
            DLT_STRING("(): BT CCA instance creation failed"));
    }
    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING("-"),
                                   DLT_STRING(__FUNCTION__));
} 

/*****************************************************************************
** FUNCTION   : tVoid seamlessMidwMainApp::vDestroyCCAClientHandlers()
******************************************************************************/
tVoid seamlessMidwMainApp::vDestroyCCAClientHandlers()
{
    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING("+"),
                                   DLT_STRING(__FUNCTION__));

    if(m_poBTInstance != OSAL_NULL)
    {
        OSAL_DELETE m_poBTInstance;
        m_poBTInstance = OSAL_NULL;
    } 
    else
        DLT_LOG(SPM_framework, DLT_LOG_ERROR, DLT_STRING(__FUNCTION__),
            DLT_STRING("(): BT CCA instance already NULL"));

    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING("-"),
                                   DLT_STRING(__FUNCTION__));
}



/***************************************************************************
** FUNCTION   : void seamlessMidwMainApp::vSignalHandler()
***************************************************************************/
void seamlessMidwMainApp::vSignalHandler(gint32 s32SigNum, 
                                         siginfo_t *pSiginfo,
                                         void *pContext)
{
    UNUSED(pSiginfo);
    UNUSED(pContext);
    DLT_LOG(SPM_framework,DLT_LOG_INFO,
            DLT_STRING("seamlessMidwMainApp::"
                       "vSignalHandler:: Received signal  "),
            DLT_INT(s32SigNum));
}

/***************************************************************************
** FUNCTION   : seamlessMidwMainApp::poGetInstance()
***************************************************************************/
seamlessMidwMainApp* seamlessMidwMainApp::poGetInstance()
{
    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING(
                "seamlessMidwMainApp::poGetInstance"));
    return m_poMainAppInstance;
}


#ifdef VARIANT_S_FTR_ENABLE_BUILD_AS_PROCESS

#define EVENT_SHUTDOWN_NAME "SHUTDOWN_SEAMLESS_MIDW"
#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"
extern "C" OSAL_DECL tS32 vStartApp(tS32 cPar, tString aPar[])
{
    UNUSED(cPar);
    UNUSED(aPar);
    gboolean bRetVal = OSAL_OK;
    OSAL_tEventHandle  hEvShutdown = 0;
    OSAL_tEventMask    hEvRequest  = 0x00000001;

    DLT_REGISTER_APP(DLT_APPID_SEAMLESS_MIDW,"DLT Logging for seamless midw");
    DLT_REGISTER_CONTEXT(SPM_framework,"SMFW","Seamless midw framework "
                         "context for DLT Logging");

    DLT_REGISTER_CONTEXT(SPM_SPL,"SPML","Seamless pairing core logging");
    DLT_REGISTER_CONTEXT(SPM_Bluetooth,"SPBT","Seamless pairing BT logging");    
    scd_init();
    if (OSAL_s32EventCreate(EVENT_SHUTDOWN_NAME, &hEvShutdown) == OSAL_ERROR)
    {
        DLT_LOG(SPM_framework,DLT_LOG_ERROR,
                DLT_STRING("seamlessMidwMainApp:"
                           " Creation of SPM shutdown event failed!!!"));
        NORMAL_M_ASSERT_ALWAYS();
    }
    DLT_LOG(SPM_framework,DLT_LOG_INFO,
            DLT_STRING("seamlessMidwMainApp::"
                       "vStartApp() OSAL_s32EventCreate"));

    OSAL_tProcessID pId = OSAL_ProcessWhoAmI();
    DLT_LOG(SPM_framework, DLT_LOG_INFO,DLT_STRING("FC_SEAMLESSPAIRING PID:"),
            DLT_INT(pId));



    seamlessMidwMainApp
            *pSeamlessMidwApp = OSAL_NEW seamlessMidwMainApp;

    if(pSeamlessMidwApp != OSAL_NULL)
    {
        if(!pSeamlessMidwApp->bInitInstance(0, 
		                CCA_C_U16_APP_SEAMLESS_PAIRING_IPCM))
        {
            printf("\n pSeamlessMidwApp->bInitInstance() failed!\n");
            DLT_LOG(SPM_framework,DLT_LOG_ERROR,DLT_STRING(
                        "seamlessMidwMainApp: bInitInstance failed"));
        }
        else
        {
            printf("\n pSeamlessMidwApp->bInitInstance() success!\n");
            DLT_LOG(SPM_framework, DLT_LOG_INFO, DLT_STRING(
                        "seamlessMidwMainApp:bInitInstance success"));
        }
    }

   // loop = g_main_loop_new (NULL, FALSE);
    //g_main_loop_run (loop);
	gboolean bInitializeLoop = bInitialize();
	DLT_LOG(SPM_framework, DLT_LOG_INFO, DLT_STRING(
                        "bInitializeLoop"),DLT_BOOL(bInitializeLoop));
	gboolean bStartLoop = bStart();
	
	DLT_LOG(SPM_framework, DLT_LOG_INFO, DLT_STRING(
                        "bStartLoop"),DLT_BOOL(bStartLoop));
    // Wait for Shutdown-Signal
    OSAL_s32EventWait(hEvShutdown, hEvRequest, OSAL_EN_EVENTMASK_OR,
                      OSAL_C_TIMEOUT_FOREVER, &hEvRequest);
    if (pSeamlessMidwApp != OSAL_NULL) //leak here.
    {
        pSeamlessMidwApp->vDeinitInstance();
        delete pSeamlessMidwApp;
        pSeamlessMidwApp = NULL;
    }
   
    OSAL_s32EventClose(hEvShutdown);
    OSAL_s32EventDelete(EVENT_SHUTDOWN_NAME); 
    return bRetVal;
}


#endif
